/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u00a8\u0006\u0006"}, d2={"toProjectRelativePath", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.ml.llm.chat"})
public final class UtilKt {
    @NotNull
    public static final String toProjectRelativePath(@NotNull Project project, @Nullable VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (virtualFile2 == null) {
            return "";
        }
        String projectBasePath = project.getBasePath();
        if (projectBasePath == null) {
            String string = FileUtil.getLocationRelativeToUserHome((String)virtualFile2.getPresentableUrl());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationRelativeToUserHome(...)");
            return string;
        }
        File projectDirectory = new File(projectBasePath).getCanonicalFile();
        File attachedFile = new File(virtualFile2.getPath()).getCanonicalFile();
        if (FileUtil.filesEqual((File)attachedFile.getParentFile(), (File)projectDirectory)) {
            return "";
        }
        String relativePath = FileUtil.isAncestor((File)projectDirectory, (File)attachedFile, (boolean)false) ? FileUtil.getRelativePath((File)projectDirectory, (File)attachedFile) : null;
        String string = relativePath;
        if (string == null) {
            String string2 = FileUtil.getLocationRelativeToUserHome((String)virtualFile2.getPresentableUrl());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocationRelativeToUserHome(...)");
        }
        return string;
    }
}

