/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.input.toggle;

import com.intellij.ide.ui.laf.darcula.DarculaNewUIUtil;
import com.intellij.ml.llm.core.chat.ui.chat.context.ContextAttachmentView;
import com.intellij.ml.llm.core.chat.ui.chat.input.toggle.AIChatToolbarToggleModel;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/toggle/AIChatToolbarToggle;", "Ljavax/swing/JComponent;", "model", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/toggle/AIChatToolbarToggleModel;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/input/toggle/AIChatToolbarToggleModel;)V", "activeBackgroundColor", "Lcom/intellij/ui/JBColor;", "hoverActiveBackgroundColor", "hoverNormalBackgroundColor", "activeContentColor", "disabledContentColor", "hoverActiveContentColor", "normalContentColor", "hoverNormalContentColor", "hovered", "", "paintComponent", "", "g", "Ljava/awt/Graphics;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "onClick", "currentState", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "AccessibleAIChatToolbarToggle", "intellij.ml.llm.chat"})
public final class AIChatToolbarToggle
extends JComponent {
    @NotNull
    private final AIChatToolbarToggleModel model;
    @NotNull
    private final JBColor activeBackgroundColor;
    @NotNull
    private final JBColor hoverActiveBackgroundColor;
    @NotNull
    private final JBColor hoverNormalBackgroundColor;
    @NotNull
    private final JBColor activeContentColor;
    @NotNull
    private final JBColor disabledContentColor;
    @NotNull
    private final JBColor hoverActiveContentColor;
    @NotNull
    private final JBColor normalContentColor;
    @NotNull
    private final JBColor hoverNormalContentColor;
    private boolean hovered;

    public AIChatToolbarToggle(@NotNull AIChatToolbarToggleModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        this.activeBackgroundColor = new JBColor(new Color(194, 214, 252), new Color(37, 50, 77));
        this.hoverActiveBackgroundColor = new JBColor(new Color(136, 173, 247, 255), new Color(55, 95, 173, 255));
        this.hoverNormalBackgroundColor = new JBColor(new Color(235, 236, 240), new Color(43, 45, 48));
        this.activeContentColor = new JBColor(new Color(46, 85, 163), new Color(131, 172, 252));
        this.disabledContentColor = new JBColor(new Color(168, 173, 189), new Color(67, 69, 74));
        this.hoverActiveContentColor = new JBColor(new Color(34, 64, 122), new Color(153, 192, 255));
        this.normalContentColor = new JBColor(new Color(108, 112, 126), new Color(180, 184, 191));
        this.hoverNormalContentColor = new JBColor(new Color(108, 112, 126), new Color(180, 184, 191));
        this.setOpaque(false);
        this.setFocusable(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setFont(ContextAttachmentView.Companion.getLabelFont());
        this.setToolTipText(this.model.getTooltip());
        this.putClientProperty("AIAssistant.DoNotUpdateFont", true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BuildersKt.launch$default((CoroutineScope)model.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ AIChatToolbarToggle this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.this$0.onClick(AIChatToolbarToggle.access$getModel$p(this.this$0).isActive(), (Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                hovered = true;
                this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                hovered = false;
                this.repaint();
            }
        });
        BuildersKt.launch$default((CoroutineScope)this.model.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AIChatToolbarToggle this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.model.getActivatedFlow().collect(new FlowCollector(){

                            public final Object emit(boolean it, Continuation<? super Unit> $completion) {
                                Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                                    int label;
                                    final /* synthetic */ AIChatToolbarToggle this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.this$0.repaint();
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.model.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AIChatToolbarToggle this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.model.isVisible().collect(new FlowCollector(){

                            public final Object emit(boolean it, Continuation<? super Unit> $completion) {
                                Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, it, null){
                                    int label;
                                    final /* synthetic */ AIChatToolbarToggle this$0;
                                    final /* synthetic */ boolean $it;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.this$0.setVisible(this.$it);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        float arc = JBUIScale.scale((float)8.0f);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            JBColor backgroundColor;
            DarculaNewUIUtil.INSTANCE.setupRenderingHints(g2);
            boolean isActive = this.model.isActive();
            boolean isDisabled = (Boolean)this.model.isDisabled().getValue();
            Object object = isDisabled ? null : (isActive && (this.hovered || this.hasFocus()) ? this.hoverActiveBackgroundColor : (isActive ? this.activeBackgroundColor : (backgroundColor = this.hovered || this.hasFocus() ? this.hoverNormalBackgroundColor : null)));
            if (backgroundColor != null) {
                DarculaNewUIUtil.INSTANCE.fillRoundedRectangle((Graphics)g2, rect, (Color)backgroundColor, arc);
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int iconSize = this.model.getIcon().getIconWidth();
            int textWidth = fontMetrics.stringWidth(this.model.getToggleText());
            int totalContentWidth = iconSize + 4 + textWidth;
            int contentX = (this.getWidth() - totalContentWidth) / 2;
            int contentY = (this.getHeight() + JBUIScale.scale((int)2) - fontMetrics.getHeight()) / 2;
            JBColor contentColor = isDisabled ? this.disabledContentColor : (isActive && this.hovered || this.hasFocus() ? this.hoverActiveContentColor : (isActive ? this.activeContentColor : (this.hovered || this.hasFocus() ? this.hoverNormalContentColor : this.normalContentColor)));
            IconUtil.colorize((Icon)this.model.getIcon(), (Color)((Color)contentColor), (boolean)false, (boolean)false).paintIcon(this, g2, contentX, contentY + (fontMetrics.getHeight() - iconSize) / 2);
            g2.setColor((Color)contentColor);
            g2.setFont(this.getFont());
            g2.drawString(this.model.getToggleText(), contentX + iconSize + 4, contentY + fontMetrics.getAscent());
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int iconWidth = this.model.getIcon().getIconWidth();
        int textWidth = fontMetrics.stringWidth(this.model.getToggleText());
        int totalWidth = iconWidth + 4 + textWidth + 12;
        return new Dimension(totalWidth, JBUIScale.scale((int)20));
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAIChatToolbarToggle();
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    @Nullable
    public final Object onClick(boolean currentState, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.model.onClick(currentState, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/toggle/AIChatToolbarToggle$AccessibleAIChatToolbarToggle;", "Ljavax/swing/JComponent$AccessibleJComponent;", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/input/toggle/AIChatToolbarToggle;)V", "getAccessibleName", "", "getAccessibleDescription", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "intellij.ml.llm.chat"})
    private final class AccessibleAIChatToolbarToggle
    extends JComponent.AccessibleJComponent {
        public AccessibleAIChatToolbarToggle() {
            super(AIChatToolbarToggle.this);
        }

        @Override
        @NotNull
        public String getAccessibleName() {
            return AIChatToolbarToggle.this.model.getToggleText();
        }

        @Override
        @Nullable
        public String getAccessibleDescription() {
            return AIChatToolbarToggle.this.model.getTooltip();
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.TOGGLE_BUTTON;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"TOGGLE_BUTTON");
            return accessibleRole;
        }
    }
}

