/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.selection;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageContainerView;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectUtilsKt;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectViewProcessor;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectViewProcessorHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.TimerUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\u0016\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001e\u001a\u00020\u0012J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0016\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u000eJ\u0018\u0010$\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u000eH\u0003J\r\u0010%\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectChatProcessor;", "", "messageContainerView", "Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageContainerView;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageContainerView;)V", "getMessageContainerView", "()Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageContainerView;", "selectedMessages", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectViewProcessor;", "myScrollingTimer", "Ljavax/swing/Timer;", "myDragEvent", "Ljava/awt/event/MouseEvent;", "selectionSize", "", "isExtendedMessageSelectionMode", "", "isOneClickSelectionMode", "isInnerSelectionMode", "dropSelection", "", "dropSelectionInFocused", "selectAll", "updateMouseProcessingRedirection", "setMessageSelection", "source", "selected", "mouseProcessingRedirectedToMessageContainer", "isMouseProcessingRedirectedToMessageContainer", "requestRedirectMouseProcessingToMessageContainer", "redirect", "processMouseDraggedSelection", "sourceMessage", "dragEvent", "scroll", "stopAutoscrolling", "stopAutoscrolling$intellij_ml_llm_chat", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIMessageSelectChatProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIMessageSelectChatProcessor.kt\ncom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectChatProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1869#2,2:199\n*S KotlinDebug\n*F\n+ 1 AIMessageSelectChatProcessor.kt\ncom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectChatProcessor\n*L\n47#1:199,2\n*E\n"})
public final class AIMessageSelectChatProcessor {
    @NotNull
    private final AIMessageContainerView messageContainerView;
    @NotNull
    private final Set<AIMessageSelectViewProcessor> selectedMessages;
    @Nullable
    private Timer myScrollingTimer;
    @Nullable
    private MouseEvent myDragEvent;
    private boolean mouseProcessingRedirectedToMessageContainer;

    public AIMessageSelectChatProcessor(@NotNull AIMessageContainerView messageContainerView) {
        Intrinsics.checkNotNullParameter((Object)messageContainerView, (String)"messageContainerView");
        this.messageContainerView = messageContainerView;
        this.selectedMessages = new LinkedHashSet();
    }

    @NotNull
    public final AIMessageContainerView getMessageContainerView() {
        return this.messageContainerView;
    }

    public final int selectionSize() {
        return this.selectedMessages.size();
    }

    public final boolean isExtendedMessageSelectionMode() {
        return this.isOneClickSelectionMode() || this.isInnerSelectionMode();
    }

    public final boolean isOneClickSelectionMode() {
        return !((Collection)this.selectedMessages).isEmpty() && !this.isInnerSelectionMode();
    }

    public final boolean isInnerSelectionMode() {
        return this.selectedMessages.size() == 1 && ((AIMessageSelectViewProcessor)CollectionsKt.first((Iterable)this.selectedMessages)).isInnerSelected();
    }

    public final void dropSelection(boolean dropSelectionInFocused) {
        Iterable $this$forEach$iv = this.messageContainerView.getMessages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AIMessageSelectViewProcessorHolder it = (AIMessageSelectViewProcessorHolder)element$iv;
            boolean bl = false;
            AIMessageSelectViewProcessor messageSelector = it.getMessageSelector();
            if (messageSelector.isMessageSelected()) {
                this.setMessageSelection(messageSelector, false);
            }
            messageSelector.dropSelectionInAllParts(dropSelectionInFocused);
        }
    }

    public static /* synthetic */ void dropSelection$default(AIMessageSelectChatProcessor aIMessageSelectChatProcessor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        aIMessageSelectChatProcessor.dropSelection(bl);
    }

    public final void selectAll() {
        for (AIMessageSelectViewProcessorHolder message : this.messageContainerView.getMessages()) {
            AIMessageSelectViewProcessor messageSelector = message.getMessageSelector();
            messageSelector.doWithoutScrollChange((Function0<Unit>)((Function0)() -> AIMessageSelectChatProcessor.selectAll$lambda$1(messageSelector)));
        }
        this.updateMouseProcessingRedirection();
    }

    public final void updateMouseProcessingRedirection() {
        this.requestRedirectMouseProcessingToMessageContainer(this.isOneClickSelectionMode());
    }

    public final void setMessageSelection(@NotNull AIMessageSelectViewProcessor source2, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        if (source2.isMessageSelected() == selected) {
            return;
        }
        if (selected) {
            AIMessageSelectViewProcessor theOnlySelection;
            if (this.selectedMessages.size() == 1 && !Intrinsics.areEqual((Object)(theOnlySelection = (AIMessageSelectViewProcessor)CollectionsKt.first((Iterable)this.selectedMessages)), (Object)source2)) {
                theOnlySelection.setMessageInnerSelected(false);
            }
            this.selectedMessages.add(source2);
            source2.setMessageSelected(true);
        } else {
            this.selectedMessages.remove(source2);
            source2.setMessageSelected(false);
            source2.setMessageInnerSelected(false);
            if (this.selectedMessages.isEmpty()) {
                this.updateMouseProcessingRedirection();
            }
        }
    }

    public final boolean isMouseProcessingRedirectedToMessageContainer() {
        return this.mouseProcessingRedirectedToMessageContainer;
    }

    private final void requestRedirectMouseProcessingToMessageContainer(boolean redirect) {
        if (this.mouseProcessingRedirectedToMessageContainer == redirect) {
            return;
        }
        this.mouseProcessingRedirectedToMessageContainer = redirect;
        for (AIMessageSelectViewProcessorHolder message : this.messageContainerView.getMessages()) {
            message.getMessageSelector().redirectMouseProcessingToMessageContainer(redirect);
        }
    }

    public final void processMouseDraggedSelection(@NotNull AIMessageSelectViewProcessor sourceMessage, @NotNull MouseEvent dragEvent) {
        Intrinsics.checkNotNullParameter((Object)sourceMessage, (String)"sourceMessage");
        Intrinsics.checkNotNullParameter((Object)dragEvent, (String)"dragEvent");
        this.scroll(sourceMessage, dragEvent);
        JComponent chatComponent = this.messageContainerView.getMessageContainerComponent();
        Component component = dragEvent.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
        JTextComponent dragSourceEditor = AIMessageSelectUtilsKt.getSourceEditor(component, chatComponent);
        if (dragSourceEditor == null) {
            return;
        }
        for (AIMessageSelectViewProcessorHolder message : this.messageContainerView.getMessages()) {
            AIMessageSelectViewProcessor messageSelector = message.getMessageSelector();
            messageSelector.doWithoutScrollChange((Function0<Unit>)((Function0)() -> AIMessageSelectChatProcessor.processMouseDraggedSelection$lambda$2(messageSelector, dragEvent, dragSourceEditor)));
        }
    }

    @RequiresEdt
    private final void scroll(AIMessageSelectViewProcessor sourceMessage, MouseEvent dragEvent) {
        JComponent message = sourceMessage.getMessageComponent();
        Point mouseRelativeToMessage = SwingUtilities.convertPoint(dragEvent.getComponent(), dragEvent.getPoint(), message);
        Component component = dragEvent.getComponent();
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        boolean bl = jComponent != null ? jComponent.getAutoscrolls() : false;
        if (bl) {
            sourceMessage.doScrollRectToVisible$intellij_ml_llm_chat(new Rectangle(mouseRelativeToMessage, new Dimension(0, 0)));
        } else {
            Timer timer;
            this.myDragEvent = dragEvent;
            if (this.myScrollingTimer != null) {
                return;
            }
            Timer timer2 = TimerUtil.createNamedTimer((String)"AIChatScrolling", (int)Registry.Companion.intValue("editor.scrolling.animation.interval.ms"), arg_0 -> AIMessageSelectChatProcessor.scroll$lambda$3(this, message, sourceMessage, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)timer2, (String)"createNamedTimer(...)");
            this.myScrollingTimer = timer = timer2;
            timer.start();
        }
    }

    @RequiresEdt
    public final void stopAutoscrolling$intellij_ml_llm_chat() {
        Timer timer = this.myScrollingTimer;
        if (timer != null) {
            timer.stop();
        }
        this.myDragEvent = null;
        this.myScrollingTimer = null;
    }

    private static final Unit selectAll$lambda$1(AIMessageSelectViewProcessor $messageSelector) {
        $messageSelector.selectAllText();
        return Unit.INSTANCE;
    }

    private static final Unit processMouseDraggedSelection$lambda$2(AIMessageSelectViewProcessor $messageSelector, MouseEvent $dragEvent, JTextComponent $dragSourceEditor) {
        $messageSelector.processMouseInternalDraggedSelectionAndCheckMouseInsideParts($dragEvent, $dragSourceEditor);
        return Unit.INSTANCE;
    }

    private static final void scroll$lambda$3(AIMessageSelectChatProcessor this$0, JComponent $message, AIMessageSelectViewProcessor $sourceMessage, ActionEvent it) {
        MouseEvent mouseEvent = this$0.myDragEvent;
        if (mouseEvent == null) {
            return;
        }
        MouseEvent event = mouseEvent;
        Point mouseRelativeToMessage = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), $message);
        $sourceMessage.doScrollRectToVisible$intellij_ml_llm_chat(new Rectangle(mouseRelativeToMessage, new Dimension(0, 0)));
        Point eventOnScreen = event.getLocationOnScreen();
        MouseEvent syntheticDragEvent = new MouseEvent(event.getComponent(), event.getID(), event.getWhen(), event.getModifiers(), eventOnScreen.x - event.getComponent().getLocationOnScreen().x, eventOnScreen.y - event.getComponent().getLocationOnScreen().y, eventOnScreen.x, eventOnScreen.y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
        IdeEventQueue.Companion.getInstance().postEvent((AWTEvent)syntheticDragEvent);
    }
}

