/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.selection;

import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.ui.chat.ChatMessageView;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0006\u0010\u0015\u001a\u00020\u0005\u00a8\u0006\u0016"}, d2={"createStackedPopupHandler", "Ljava/awt/event/MouseListener;", "component", "Ljavax/swing/JComponent;", "groupId", "", "place", "installAsListener", "", "getSourceEditor", "Ljavax/swing/text/JTextComponent;", "src", "Ljava/awt/Component;", "root", "installOverBackgroundPopup", "Ljava/awt/event/MouseAdapter;", "messageView", "Lcom/intellij/ml/llm/core/chat/ui/chat/ChatMessageView;", "messageToolbarGroupId", "author", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;", "messagePartPopupGroupId", "intellij.ml.llm.chat"})
public final class AIMessageSelectUtilsKt {
    @NotNull
    public static final MouseListener createStackedPopupHandler(@NotNull JComponent component, @NotNull String groupId, @NotNull String place, boolean installAsListener) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        PopupHandler popupHandler = PopupHandler.installPopupMenu((JComponent)component, (String)groupId, (String)place);
        Intrinsics.checkNotNullExpressionValue((Object)popupHandler, (String)"installPopupMenu(...)");
        PopupHandler orig = popupHandler;
        component.removeMouseListener((MouseListener)orig);
        MouseListener listener2 = new MouseListener(orig){
            final /* synthetic */ PopupHandler $orig;
            {
                this.$orig = $orig;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.isConsumed()) {
                    this.$orig.mouseClicked(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.isConsumed()) {
                    this.$orig.mousePressed(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.isConsumed()) {
                    this.$orig.mouseReleased(e);
                }
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.isConsumed()) {
                    this.$orig.mouseEntered(e);
                }
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.isConsumed()) {
                    this.$orig.mouseExited(e);
                }
            }
        };
        if (installAsListener) {
            component.addMouseListener(listener2);
        }
        return listener2;
    }

    @Nullable
    public static final JTextComponent getSourceEditor(@NotNull Component src, @NotNull Component root) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        for (Component c = src; c != null && !Intrinsics.areEqual((Object)c, (Object)root); c = (Component)c.getParent()) {
            if (!(c instanceof JTextComponent)) continue;
            return (JTextComponent)c;
        }
        return null;
    }

    @NotNull
    public static final MouseAdapter installOverBackgroundPopup(@NotNull ChatMessageView messageView, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)messageView, (String)"messageView");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        MouseAdapter handler2 = new MouseAdapter(messageView, place){
            final /* synthetic */ ChatMessageView $messageView;
            final /* synthetic */ String $place;
            {
                this.$messageView = $messageView;
                this.$place = $place;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.processPopupMouseEvent(e);
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.processPopupMouseEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.processPopupMouseEvent(e);
            }

            public final void processPopupMouseEvent(MouseEvent e) {
                block1: {
                    Container parent;
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (!e.isPopupTrigger()) break block0;
                        Component component = e.getComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
                        if (!this.invokePopupEx(component, e.getX(), e.getY())) break block0;
                        e.consume();
                        break block1;
                    }
                    Container container = parent = e.getComponent().getParent();
                    if (container == null) break block1;
                    container.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, parent));
                }
            }

            public final boolean invokePopupEx(Component comp, int x, int y) {
                ActionManager actionManager;
                AnAction group;
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                if (this.$messageView.getBackgroundRect().contains(x, y) && (group = (actionManager = ActionManager.getInstance()).getAction(AIMessageSelectUtilsKt.messagePartPopupGroupId())) instanceof ActionGroup) {
                    ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu(this.$place, (ActionGroup)group);
                    Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
                    ActionPopupMenu popupMenu = actionPopupMenu;
                    popupMenu.getComponent().show(comp, x, y);
                    return true;
                }
                return false;
            }
        };
        messageView.addMouseListener(handler2);
        return handler2;
    }

    @NotNull
    public static final String messageToolbarGroupId(@NotNull ChatMessageAuthor author) {
        Intrinsics.checkNotNullParameter((Object)((Object)author), (String)"author");
        return author == ChatMessageAuthor.User ? "AIAssistant.ToolWindow.Message.Toolbar.User" : "AIAssistant.ToolWindow.Message.Toolbar.Assistant";
    }

    @NotNull
    public static final String messagePartPopupGroupId() {
        return "AIAssistant.Chat.Message.Editor.ContextActions.Extended";
    }
}

