/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.selection;

import com.intellij.ml.llm.core.chat.services.paste.AIAssistantPasteData;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectChatProcessor;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.richcopy.view.HtmlTransferableData;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a$\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a$\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\nH\u0002\u001a\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0018\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\nH\u0002\u001a\u0018\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a \u0010\"\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\nH\u0002\u001a\u0018\u0010$\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0013H\u0002\u001a\u0012\u0010%\u001a\u0004\u0018\u00010\u001c2\u0006\u0010&\u001a\u00020'H\u0002\u001a\u001a\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020'H\u0002\u001a\u001a\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u001cH\u0002\u001a\"\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000103H\u0002\u001a\u0010\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u0003H\u0002\u001a\u0010\u00107\u001a\u00020\n2\u0006\u00102\u001a\u000208H\u0002\"\u000e\u0010\u001b\u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"safeSetSelectionInEditor", "", "editorPane", "Ljavax/swing/text/JTextComponent;", "fromAnchorOffset", "", "toNewCaretOffset", "safeDropSelectionInEditor", "safeSetCaretVisibleInEditor", "isCaretVisible", "", "moveDot", "caret", "Ljavax/swing/text/Caret;", "dot", "safeHasSelection", "safeHasAllDocumentSelection", "processInternalEditors", "messageComponent", "Ljavax/swing/JComponent;", "action", "Lkotlin/Function1;", "executeRecursiveAction", "component", "Ljava/awt/Component;", "setFakeAllTextSelectionAndSaveRealLocalSelection", "activateFakeAllTextSelection", "aiMessagePartChildPropertyName", "", "aiMessageActionButtonInfoPropertyName", "isMessagePart", "markAsMessagePart", "hasTruePropertyValue", "key", "setPropertyValue", "value", "dropPropertyValue", "getHTMLAsString", "transferable", "Ljava/awt/datatransfer/Transferable;", "getFlavorAsString", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "writeContentWithEndNewLine", "sw", "Ljava/io/StringWriter;", "contentAsString", "transferFocusToMessageOrMessagePartUnderCursorOrRestoreEventSourceEditor", "container", "Lcom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectChatProcessor;", "e", "Ljava/awt/event/MouseEvent;", "lastLeftMousePressedEvent", "transferFocusToEditor", "editor", "isTraversalEvent", "Ljava/awt/event/FocusEvent;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIMessageSelectViewProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIMessageSelectViewProcessor.kt\ncom/intellij/ml/llm/core/chat/ui/chat/selection/AIMessageSelectViewProcessorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,852:1\n1#2:853\n*E\n"})
public final class AIMessageSelectViewProcessorKt {
    @NotNull
    private static final String aiMessagePartChildPropertyName = "aiMessagePartChild";
    @NotNull
    private static final String aiMessageActionButtonInfoPropertyName = "aiMessageActionButtonInfo";

    private static final void safeSetSelectionInEditor(JTextComponent editorPane, int fromAnchorOffset, int toNewCaretOffset) {
        if (editorPane instanceof EditorComponentImpl) {
            ((EditorComponentImpl)editorPane).getEditor().getSelectionModel().setSelection(Math.min(fromAnchorOffset, toNewCaretOffset), Math.max(fromAnchorOffset, toNewCaretOffset));
            ((EditorComponentImpl)editorPane).getEditor().getCaretModel().moveToOffset(toNewCaretOffset);
        } else {
            Caret caret = editorPane.getCaret();
            caret.setDot(fromAnchorOffset);
            Intrinsics.checkNotNull((Object)caret);
            AIMessageSelectViewProcessorKt.moveDot(caret, toNewCaretOffset);
        }
    }

    private static final void safeDropSelectionInEditor(JTextComponent editorPane) {
        if (editorPane instanceof EditorComponentImpl) {
            SelectionModelImpl selectionModelImpl = ((EditorComponentImpl)editorPane).getEditor().getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModelImpl, (String)"getSelectionModel(...)");
            SelectionModelImpl selectionModel = selectionModelImpl;
            if (selectionModel.hasSelection()) {
                selectionModel.removeSelection();
            }
        } else {
            int caretPosition = editorPane.getCaretPosition();
            if (editorPane.getSelectionEnd() != editorPane.getSelectionStart()) {
                editorPane.select(caretPosition, caretPosition);
            }
        }
        AIMessageSelectViewProcessorKt.safeSetCaretVisibleInEditor(editorPane, editorPane.hasFocus());
    }

    private static final void safeSetCaretVisibleInEditor(JTextComponent editorPane, boolean isCaretVisible) {
        if (editorPane instanceof EditorComponentImpl) {
            ((EditorComponentImpl)editorPane).getEditor().setCaretEnabled(isCaretVisible);
            ((EditorComponentImpl)editorPane).getEditor().setCaretVisible(isCaretVisible);
        } else {
            Caret caret = editorPane.getCaret();
            if (editorPane instanceof JEditorPane && caret.getDot() == 0 && caret.getMark() == 0) {
                caret.setDot(1);
                Intrinsics.checkNotNull((Object)caret);
                AIMessageSelectViewProcessorKt.moveDot(caret, 1);
            }
            caret.setVisible(isCaretVisible);
        }
    }

    private static final void moveDot(Caret caret, int dot) {
        try {
            caret.moveDot(dot);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static final boolean safeHasSelection(@NotNull JTextComponent editorPane) {
        Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
        if (editorPane instanceof EditorComponentImpl) {
            return ((EditorComponentImpl)editorPane).getEditor().getSelectionModel().hasSelection();
        }
        return editorPane.getSelectionEnd() != editorPane.getSelectionStart();
    }

    public static final boolean safeHasAllDocumentSelection(@NotNull JTextComponent editorPane) {
        Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
        Document document = editorPane.getDocument();
        if (document == null) {
            return false;
        }
        if (editorPane instanceof EditorComponentImpl) {
            SelectionModelImpl selectionModelImpl = ((EditorComponentImpl)editorPane).getEditor().getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModelImpl, (String)"getSelectionModel(...)");
            SelectionModelImpl selectionModel = selectionModelImpl;
            return selectionModel.getSelectionEnd() == document.getLength() && selectionModel.getSelectionStart() == 0;
        }
        return editorPane.getSelectionEnd() == document.getLength() && editorPane.getSelectionStart() <= 1;
    }

    private static final void processInternalEditors(JComponent messageComponent, Function1<? super JTextComponent, Unit> action2) {
        Iterator iterator = ArrayIteratorKt.iterator((Object[])messageComponent.getComponents());
        while (iterator.hasNext()) {
            Component child = (Component)iterator.next();
            Intrinsics.checkNotNull((Object)child);
            AIMessageSelectViewProcessorKt.executeRecursiveAction(child, (Function1<? super Component, Unit>)((Function1)arg_0 -> AIMessageSelectViewProcessorKt.processInternalEditors$lambda$0(action2, arg_0)));
        }
    }

    private static final void executeRecursiveAction(Component component, Function1<? super Component, Unit> action2) {
        ApplicationManager.getApplication().runReadAction(() -> AIMessageSelectViewProcessorKt.executeRecursiveAction$lambda$2(component, action2));
    }

    private static final void setFakeAllTextSelectionAndSaveRealLocalSelection(Component component, boolean activateFakeAllTextSelection) {
        if (component instanceof EditorComponentImpl) {
            EditorImpl editorImpl = ((EditorComponentImpl)component).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editorImpl, (String)"getEditor(...)");
            EditorImpl editor = editorImpl;
            EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            EditorColorsScheme editorColorsScheme2 = editorColorsScheme;
            if (activateFakeAllTextSelection) {
                EditorColorsScheme editorColorsScheme3;
                Color backgroundColor = editorColorsScheme2.getColor(EditorColors.SELECTION_BACKGROUND_COLOR);
                EditorColorsScheme $this$setFakeAllTextSelectionAndSaveRealLocalSelection_u24lambda_u243 = editorColorsScheme3 = editorColorsScheme2;
                boolean bl = false;
                if (backgroundColor != null) {
                    editor.setBackgroundColor(backgroundColor);
                }
                $this$setFakeAllTextSelectionAndSaveRealLocalSelection_u24lambda_u243.setColor(EditorColors.CARET_ROW_COLOR, backgroundColor);
                $this$setFakeAllTextSelectionAndSaveRealLocalSelection_u24lambda_u243.setColor(EditorColors.CARET_COLOR, backgroundColor);
            } else {
                DelegateColorScheme delegateColorScheme;
                DelegateColorScheme delegateColorScheme2 = editorColorsScheme2 instanceof DelegateColorScheme ? (DelegateColorScheme)editorColorsScheme2 : null;
                if (delegateColorScheme2 != null) {
                    DelegateColorScheme delegateColorScheme3;
                    DelegateColorScheme $this$setFakeAllTextSelectionAndSaveRealLocalSelection_u24lambda_u244 = delegateColorScheme3 = delegateColorScheme2;
                    boolean bl = false;
                    editor.setBackgroundColor($this$setFakeAllTextSelectionAndSaveRealLocalSelection_u24lambda_u244.getDelegate().getDefaultBackground());
                    $this$setFakeAllTextSelectionAndSaveRealLocalSelection_u24lambda_u244.setColor(EditorColors.CARET_ROW_COLOR, $this$setFakeAllTextSelectionAndSaveRealLocalSelection_u24lambda_u244.getDelegate().getColor(EditorColors.CARET_ROW_COLOR));
                    $this$setFakeAllTextSelectionAndSaveRealLocalSelection_u24lambda_u244.setColor(EditorColors.CARET_COLOR, $this$setFakeAllTextSelectionAndSaveRealLocalSelection_u24lambda_u244.getDelegate().getColor(EditorColors.CARET_COLOR));
                    delegateColorScheme = delegateColorScheme3;
                } else {
                    delegateColorScheme = null;
                }
                EditorColorsScheme cfr_ignored_0 = (EditorColorsScheme)delegateColorScheme;
            }
        }
    }

    private static final boolean isMessagePart(Component component) {
        return AIMessageSelectViewProcessorKt.hasTruePropertyValue(aiMessagePartChildPropertyName, component);
    }

    private static final void markAsMessagePart(JComponent component, boolean isMessagePart) {
        AIMessageSelectViewProcessorKt.setPropertyValue(aiMessagePartChildPropertyName, component, isMessagePart);
    }

    private static final boolean hasTruePropertyValue(String key, Component component) {
        return component instanceof JComponent && Intrinsics.areEqual((Object)((JComponent)component).getClientProperty(key), (Object)true);
    }

    private static final void setPropertyValue(String key, JComponent component, boolean value) {
        if (value) {
            component.putClientProperty(key, true);
        } else {
            AIMessageSelectViewProcessorKt.dropPropertyValue(key, component);
        }
    }

    private static final void dropPropertyValue(String key, JComponent component) {
        component.putClientProperty(key, null);
    }

    private static final String getHTMLAsString(Transferable transferable) {
        DataFlavor dataFlavor = DataFlavor.fragmentHtmlFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"fragmentHtmlFlavor");
        String string = AIMessageSelectViewProcessorKt.getFlavorAsString(dataFlavor, transferable);
        if (string == null) {
            DataFlavor dataFlavor2 = DataFlavor.selectionHtmlFlavor;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavor2, (String)"selectionHtmlFlavor");
            string = AIMessageSelectViewProcessorKt.getFlavorAsString(dataFlavor2, transferable);
            if (string == null) {
                DataFlavor dataFlavor3 = HtmlTransferableData.FLAVOR;
                Intrinsics.checkNotNullExpressionValue((Object)dataFlavor3, (String)"FLAVOR");
                string = AIMessageSelectViewProcessorKt.getFlavorAsString(dataFlavor3, transferable);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getFlavorAsString(DataFlavor flavor, Transferable transferable) {
        String string;
        try {
            String string2;
            Object transferData;
            Object object = transferData = transferable.getTransferData(flavor);
            if (object instanceof String) {
                string2 = (String)transferData;
            } else if (object instanceof Reader) {
                Closeable closeable = new BufferedReader((Reader)transferData);
                Throwable throwable = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    String string3 = TextStreamsKt.readText((Reader)it);
                    string2 = string3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                string2 = object instanceof AIAssistantPasteData ? ((AIAssistantPasteData)transferData).getLanguageIdentifier() : null;
            }
            string = string2;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            string = null;
        }
        return string;
    }

    private static final void writeContentWithEndNewLine(StringWriter sw, String contentAsString) {
        if (contentAsString != null) {
            sw.write(contentAsString);
            if (!StringsKt.endsWith$default((String)contentAsString, (String)"\n", (boolean)false, (int)2, null)) {
                sw.write("\n");
            }
        }
    }

    private static final boolean transferFocusToMessageOrMessagePartUnderCursorOrRestoreEventSourceEditor(AIMessageSelectChatProcessor container, MouseEvent e, MouseEvent lastLeftMousePressedEvent) {
        JComponent messageContainerComponent = container.getMessageContainerView().getMessageContainerComponent();
        Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), messageContainerComponent);
        for (Component cur = SwingUtilities.getDeepestComponentAt(messageContainerComponent, point.x, point.y); cur != null; cur = (Component)cur.getParent()) {
            if (cur instanceof JTextComponent) {
                AIMessageSelectViewProcessorKt.transferFocusToEditor((JTextComponent)cur);
                return false;
            }
            if (!(cur instanceof AIMessageView)) continue;
            if (SwingUtilities.isDescendingFrom(e.getComponent(), cur)) break;
            IdeFocusManager.getGlobalInstance().requestFocus(cur, true);
            return false;
        }
        if (lastLeftMousePressedEvent != null) {
            JTextComponent jTextComponent;
            Component component = lastLeftMousePressedEvent.getComponent();
            JTextComponent jTextComponent2 = jTextComponent = component instanceof JTextComponent ? (JTextComponent)component : null;
            if (jTextComponent != null) {
                JTextComponent it = jTextComponent;
                boolean bl = false;
                AIMessageSelectViewProcessorKt.transferFocusToEditor(it);
                return true;
            }
        }
        return false;
    }

    private static final void transferFocusToEditor(JTextComponent editor) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)editor, true);
        AIMessageSelectViewProcessorKt.safeSetCaretVisibleInEditor(editor, true);
    }

    private static final boolean isTraversalEvent(FocusEvent e) {
        FocusEvent.Cause cause = e.getCause();
        return cause == FocusEvent.Cause.TRAVERSAL || cause == FocusEvent.Cause.TRAVERSAL_BACKWARD || cause == FocusEvent.Cause.TRAVERSAL_FORWARD || cause == FocusEvent.Cause.TRAVERSAL_DOWN || cause == FocusEvent.Cause.TRAVERSAL_UP;
    }

    private static final Unit processInternalEditors$lambda$0(Function1 $action, Component pane) {
        Intrinsics.checkNotNullParameter((Object)pane, (String)"pane");
        if (pane instanceof JTextComponent) {
            $action.invoke((Object)pane);
        }
        return Unit.INSTANCE;
    }

    private static final void executeRecursiveAction$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit executeRecursiveAction$lambda$2(Component $component, Function1 $action) {
        UIUtil.forEachComponentInHierarchy((Component)$component, arg_0 -> AIMessageSelectViewProcessorKt.executeRecursiveAction$lambda$2$lambda$1($action, arg_0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isTraversalEvent(FocusEvent e) {
        return AIMessageSelectViewProcessorKt.isTraversalEvent(e);
    }

    public static final /* synthetic */ boolean access$isMessagePart(Component component) {
        return AIMessageSelectViewProcessorKt.isMessagePart(component);
    }

    public static final /* synthetic */ void access$setPropertyValue(String key, JComponent component, boolean value) {
        AIMessageSelectViewProcessorKt.setPropertyValue(key, component, value);
    }

    public static final /* synthetic */ boolean access$hasTruePropertyValue(String key, Component component) {
        return AIMessageSelectViewProcessorKt.hasTruePropertyValue(key, component);
    }

    public static final /* synthetic */ void access$dropPropertyValue(String key, JComponent component) {
        AIMessageSelectViewProcessorKt.dropPropertyValue(key, component);
    }

    public static final /* synthetic */ void access$executeRecursiveAction(Component component, Function1 action2) {
        AIMessageSelectViewProcessorKt.executeRecursiveAction(component, (Function1<? super Component, Unit>)action2);
    }

    public static final /* synthetic */ void access$processInternalEditors(JComponent messageComponent, Function1 action2) {
        AIMessageSelectViewProcessorKt.processInternalEditors(messageComponent, (Function1<? super JTextComponent, Unit>)action2);
    }

    public static final /* synthetic */ void access$safeSetSelectionInEditor(JTextComponent editorPane, int fromAnchorOffset, int toNewCaretOffset) {
        AIMessageSelectViewProcessorKt.safeSetSelectionInEditor(editorPane, fromAnchorOffset, toNewCaretOffset);
    }

    public static final /* synthetic */ void access$safeDropSelectionInEditor(JTextComponent editorPane) {
        AIMessageSelectViewProcessorKt.safeDropSelectionInEditor(editorPane);
    }

    public static final /* synthetic */ void access$safeSetCaretVisibleInEditor(JTextComponent editorPane, boolean isCaretVisible) {
        AIMessageSelectViewProcessorKt.safeSetCaretVisibleInEditor(editorPane, isCaretVisible);
    }

    public static final /* synthetic */ void access$markAsMessagePart(JComponent component, boolean isMessagePart) {
        AIMessageSelectViewProcessorKt.markAsMessagePart(component, isMessagePart);
    }

    public static final /* synthetic */ void access$writeContentWithEndNewLine(StringWriter sw, String contentAsString) {
        AIMessageSelectViewProcessorKt.writeContentWithEndNewLine(sw, contentAsString);
    }

    public static final /* synthetic */ void access$setFakeAllTextSelectionAndSaveRealLocalSelection(Component component, boolean activateFakeAllTextSelection) {
        AIMessageSelectViewProcessorKt.setFakeAllTextSelectionAndSaveRealLocalSelection(component, activateFakeAllTextSelection);
    }

    public static final /* synthetic */ boolean access$transferFocusToMessageOrMessagePartUnderCursorOrRestoreEventSourceEditor(AIMessageSelectChatProcessor container, MouseEvent e, MouseEvent lastLeftMousePressedEvent) {
        return AIMessageSelectViewProcessorKt.transferFocusToMessageOrMessagePartUnderCursorOrRestoreEventSourceEditor(container, e, lastLeftMousePressedEvent);
    }

    public static final /* synthetic */ String access$getFlavorAsString(DataFlavor flavor, Transferable transferable) {
        return AIMessageSelectViewProcessorKt.getFlavorAsString(flavor, transferable);
    }

    public static final /* synthetic */ String access$getHTMLAsString(Transferable transferable) {
        return AIMessageSelectViewProcessorKt.getHTMLAsString(transferable);
    }
}

