/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.errorExplanation;

import com.intellij.lang.Language;
import com.intellij.ml.llm.errorExplanation.PsiUtilsKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001f\u001a\u0004\u0018\u00010 J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\u000bH\u00c6\u0003J;\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010!\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001e\u00a8\u0006-"}, d2={"Lcom/intellij/ml/llm/errorExplanation/ErrorPlace;", "", "hyperlinkText", "", "lineNumber", "", "isProjectFile", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;IZLcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "getHyperlinkText", "()Ljava/lang/String;", "getLineNumber", "()I", "()Z", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "programText", "Lcom/intellij/ml/llm/privacy/PSString;", "getProgramText", "()Lcom/intellij/ml/llm/privacy/PSString;", "findContainingElement", "Lcom/intellij/psi/PsiElement;", "markDownLanguageSlug", "getMarkDownLanguageSlug", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "intellij.ml.llm.chat"})
public final class ErrorPlace {
    @NotNull
    private final String hyperlinkText;
    private final int lineNumber;
    private final boolean isProjectFile;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final Project project;

    public ErrorPlace(@NotNull String hyperlinkText, int lineNumber, boolean isProjectFile, @NotNull VirtualFile virtualFile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkText, (String)"hyperlinkText");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.hyperlinkText = hyperlinkText;
        this.lineNumber = lineNumber;
        this.isProjectFile = isProjectFile;
        this.virtualFile = virtualFile2;
        this.project = project;
    }

    @NotNull
    public final String getHyperlinkText() {
        return this.hyperlinkText;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final boolean isProjectFile() {
        return this.isProjectFile;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return PsiManager.getInstance((Project)this.project).findFile(this.virtualFile);
    }

    @NotNull
    public final PSString getProgramText() {
        return ExtensionsKtKt.privacySafe((VirtualFile)this.virtualFile, (Project)this.project).readText();
    }

    @Nullable
    public final PsiElement findContainingElement() {
        Object object = this.getPsiFile();
        if (object == null || (object = PsiUtilsKt.getLineStartOffset((PsiFile)object, this.lineNumber)) == null) {
            return null;
        }
        int errorPlaceOffset = (Integer)object;
        PsiFile psiFile = this.getPsiFile();
        return psiFile != null ? psiFile.findElementAt(errorPlaceOffset) : null;
    }

    @Nullable
    public final PSString getMarkDownLanguageSlug() {
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null || (psiFile = psiFile.getLanguage()) == null || (psiFile = ExtensionsKtKt.getPrivacySafe((Language)psiFile)) == null || (psiFile = psiFile.getDisplayName()) == null || (psiFile = psiFile.lowercase()) == null) {
            return null;
        }
        PsiFile displayNameLowercased = psiFile;
        String string = (String)displayNameLowercased.unwrap();
        return Intrinsics.areEqual((Object)string, (Object)"c#") ? ConstantsKt.getPrivacyConst((String)"csharp") : (Intrinsics.areEqual((Object)string, (Object)"c++") ? ConstantsKt.getPrivacyConst((String)"cpp") : displayNameLowercased);
    }

    @NotNull
    public final String component1() {
        return this.hyperlinkText;
    }

    public final int component2() {
        return this.lineNumber;
    }

    public final boolean component3() {
        return this.isProjectFile;
    }

    @NotNull
    public final VirtualFile component4() {
        return this.virtualFile;
    }

    @NotNull
    public final Project component5() {
        return this.project;
    }

    @NotNull
    public final ErrorPlace copy(@NotNull String hyperlinkText, int lineNumber, boolean isProjectFile, @NotNull VirtualFile virtualFile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkText, (String)"hyperlinkText");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ErrorPlace(hyperlinkText, lineNumber, isProjectFile, virtualFile2, project);
    }

    public static /* synthetic */ ErrorPlace copy$default(ErrorPlace errorPlace, String string, int n, boolean bl, VirtualFile virtualFile2, Project project, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = errorPlace.hyperlinkText;
        }
        if ((n2 & 2) != 0) {
            n = errorPlace.lineNumber;
        }
        if ((n2 & 4) != 0) {
            bl = errorPlace.isProjectFile;
        }
        if ((n2 & 8) != 0) {
            virtualFile2 = errorPlace.virtualFile;
        }
        if ((n2 & 0x10) != 0) {
            project = errorPlace.project;
        }
        return errorPlace.copy(string, n, bl, virtualFile2, project);
    }

    @NotNull
    public String toString() {
        return "ErrorPlace(hyperlinkText=" + this.hyperlinkText + ", lineNumber=" + this.lineNumber + ", isProjectFile=" + this.isProjectFile + ", virtualFile=" + this.virtualFile + ", project=" + this.project + ")";
    }

    public int hashCode() {
        int result2 = this.hyperlinkText.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.lineNumber);
        result2 = result2 * 31 + Boolean.hashCode(this.isProjectFile);
        result2 = result2 * 31 + this.virtualFile.hashCode();
        result2 = result2 * 31 + this.project.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ErrorPlace)) {
            return false;
        }
        ErrorPlace errorPlace = (ErrorPlace)other;
        if (!Intrinsics.areEqual((Object)this.hyperlinkText, (Object)errorPlace.hyperlinkText)) {
            return false;
        }
        if (this.lineNumber != errorPlace.lineNumber) {
            return false;
        }
        if (this.isProjectFile != errorPlace.isProjectFile) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.virtualFile, (Object)errorPlace.virtualFile)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.project, (Object)errorPlace.project);
    }
}

