/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.errorExplanation.filters;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.ui.inlays.AIInlayButtonPresentationFactory;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRange;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRangePostprocessor;
import com.intellij.ml.llm.errorExplanation.provider.ErrorExplanationProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.project.Project;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u0014H$J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0017\u001a\u00020\u0011R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainButtonItem;", "Lcom/intellij/execution/filters/Filter$ResultItem;", "Lcom/intellij/execution/impl/InlayProvider;", "offset", "", "errorRanges", "", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRange;", "runtimeErrorIndex", "postprocessor", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRangePostprocessor;", "<init>", "(ILjava/util/List;ILcom/intellij/ml/llm/errorExplanation/filters/ExceptionRangePostprocessor;)V", "consoleButtonText", "", "toErrorData", "Lcom/intellij/ml/llm/errorExplanation/provider/ErrorExplanationProvider$ErrorData;", "Lcom/intellij/openapi/editor/Editor;", "errorRange", "getErrorExplainProvider", "Lcom/intellij/ml/llm/errorExplanation/provider/ErrorExplanationProvider;", "createInlayRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "onClick", "Lkotlin/Function0;", "", "intellij.ml.llm.chat"})
public abstract class ErrorExplainButtonItem
extends Filter.ResultItem
implements InlayProvider {
    @NotNull
    private final List<ExceptionRange> errorRanges;
    private final int runtimeErrorIndex;
    @NotNull
    private final ExceptionRangePostprocessor postprocessor;
    @NotNull
    private final String consoleButtonText;

    public ErrorExplainButtonItem(int offset, @NotNull List<ExceptionRange> errorRanges, int runtimeErrorIndex, @NotNull ExceptionRangePostprocessor postprocessor) {
        Intrinsics.checkNotNullParameter(errorRanges, (String)"errorRanges");
        Intrinsics.checkNotNullParameter((Object)postprocessor, (String)"postprocessor");
        super(offset, offset, null);
        this.errorRanges = errorRanges;
        this.runtimeErrorIndex = runtimeErrorIndex;
        this.postprocessor = postprocessor;
        this.consoleButtonText = LLMBundle.message((String)"runtimeExplanation.filters.ExplainButtonItem.consoleButtonText", (Object[])new Object[0]);
    }

    private final ErrorExplanationProvider.ErrorData toErrorData(Editor $this$toErrorData, ExceptionRange errorRange) {
        Integer n = errorRange.getEndOffset();
        return new ErrorExplanationProvider.ErrorData($this$toErrorData.getDocument().getLineNumber(errorRange.getStartOffset()), $this$toErrorData.getDocument().getLineNumber(n != null ? n : $this$toErrorData.getDocument().getTextLength() - 1), $this$toErrorData, null, 8, null);
    }

    @NotNull
    protected abstract ErrorExplanationProvider getErrorExplainProvider();

    @NotNull
    public EditorCustomElementRenderer createInlayRenderer(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PresentationFactory factory = new PresentationFactory(editor);
        AIInlayButtonPresentationFactory inlayButtonPresentationFactory = new AIInlayButtonPresentationFactory(editor, factory);
        InlayPresentation basePresentation = inlayButtonPresentationFactory.iconAndText(AIAssistantBranding.Logo16Colored, this.consoleButtonText).onClick((arg_0, arg_1) -> ErrorExplainButtonItem.createInlayRenderer$lambda$0(this, editor, arg_0, arg_1)).build();
        Cursor cursor = Cursor.getPredefinedCursor(12);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
        InlayPresentation presentation = factory.withCursorOnHover(basePresentation, cursor);
        return (EditorCustomElementRenderer)new PresentationRenderer(presentation);
    }

    @NotNull
    public final Function0<Unit> onClick(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return () -> ErrorExplainButtonItem.onClick$lambda$1(editor, this);
    }

    private static final void createInlayRenderer$lambda$0(ErrorExplainButtonItem this$0, Editor $editor, MouseEvent mouseEvent, Point point) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
        this$0.onClick($editor).invoke();
    }

    private static final Unit onClick$lambda$1(Editor $editor, ErrorExplainButtonItem this$0) {
        Project project = $editor.getProject();
        ExceptionRangePostprocessor exceptionRangePostprocessor = this$0.postprocessor;
        Document document = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        ExceptionRange errorRange = exceptionRangePostprocessor.postprocess(document, this$0.errorRanges.get(this$0.runtimeErrorIndex));
        if (project != null) {
            if (!AIAssistantUIUtil.INSTANCE.isAssistantActive(project)) {
                AIAContentFacade.Companion.getInstance(project).activateAction();
                return Unit.INSTANCE;
            }
            ErrorExplanationProvider.run$default(this$0.getErrorExplainProvider(), project, this$0.toErrorData($editor, errorRange), false, null, 12, null);
        }
        return Unit.INSTANCE;
    }
}

