/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.chat;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.AdvertisementAction;
import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.AIAssistantActionManager;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.AIFirstUseKt;
import com.intellij.ml.llm.core.chat.promptLibrary.settings.OpenAiAssistantPromptLibrarySettingsKt;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.intentions.AiaCustomIntention;
import com.intellij.ml.llm.intentions.IntentionsUtilsKt;
import com.intellij.ml.llm.intentions.chat.AIAssistantIntention;
import com.intellij.ml.llm.intentions.chat.IntentionActionPopupItem;
import com.intellij.ml.llm.intentions.chat.PopupItem;
import com.intellij.ml.llm.intentions.chat.Renderer;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.codeFloatingToolbar.CodeFloatingToolbar;
import com.intellij.ui.dsl.builder.components.DslLabel;
import com.intellij.ui.dsl.builder.components.DslLabelType;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/intentions/chat/AIAssistantIntention;", "Lcom/intellij/codeInsight/intention/CustomizableIntentionAction;", "Lcom/intellij/codeInsight/intention/AdvertisementAction;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "startInWriteAction", "", "isShowLightBulb", "getText", "", "getFamilyName", "getIcon", "Ljavax/swing/Icon;", "flags", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantIntention.kt\ncom/intellij/ml/llm/intentions/chat/AIAssistantIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1374#2:255\n1460#2,2:256\n1573#2:258\n1604#2,3:259\n1607#2:264\n1462#2,3:265\n19#3:262\n1#4:263\n*S KotlinDebug\n*F\n+ 1 AIAssistantIntention.kt\ncom/intellij/ml/llm/intentions/chat/AIAssistantIntention\n*L\n94#1:255\n94#1:256,2\n95#1:258\n95#1:259,3\n95#1:264\n94#1:265,3\n97#1:262\n*E\n"})
public final class AIAssistantIntention
implements CustomizableIntentionAction,
AdvertisementAction,
Iconable {
    public boolean startInWriteAction() {
        return false;
    }

    public boolean isShowLightBulb() {
        return false;
    }

    @NotNull
    public String getText() {
        return LLMBundle.message((String)"intentions.ai.assistant.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return LLMBundle.message((String)"intentions.ai.assistant.name", (Object[])new Object[0]);
    }

    @NotNull
    public Icon getIcon(int flags) {
        return AIAssistantBranding.Logo16Colored;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)psiFile);
        VirtualFile virtualFile2 = psiFile2 != null ? psiFile2.getVirtualFile() : null;
        if (virtualFile2 instanceof LightVirtualFile) return false;
        if (virtualFile2 != null) {
            if (PrivacyPathCheckerKt.isAiIgnoreBlocked((Project)project, (VirtualFile)virtualFile2)) return false;
        }
        CodeFloatingToolbar codeFloatingToolbar = CodeFloatingToolbar.Companion.getToolbar(editor);
        if (codeFloatingToolbar != null) {
            if (codeFloatingToolbar.canBeShownAtCurrentSelection()) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        if (!AIAssistantUIUtil.INSTANCE.isAuthedAndAllowed(project)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!AIFirstUseKt.prepareAiForUse((Project)project) && !AIAssistantActionManager.Companion.checkIsAllowedWithDelegation(project)) {
            return;
        }
        List<Pair<String, List<IntentionAction>>> intentions = IntentionsUtilsKt.getGroupedAiAssistantIntentions(project, editor, psiFile);
        if (intentions.isEmpty()) {
            if (editor != null) {
                HintManager.getInstance().showErrorHint(editor, LLMBundle.message((String)"intentions.ai.assistant.no.intentions", (Object[])new Object[0]));
            }
            return;
        }
        boolean isAssistantActive = AIAssistantUIUtil.INSTANCE.isAssistantActive(project) || AIAssistantActionManager.Companion.checkIsAllowedWithDelegation(project);
        Iterable $this$flatMap$iv = intentions;
        boolean $i$f$flatMap22 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            List intentionsGroup = (List)pair.component2();
            Iterable $this$mapIndexed$iv = intentionsGroup;
            boolean $i$f$mapIndexed = false;
            Iterable iterable2 = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                boolean bl2;
                PsiFile psiFile2;
                boolean isBeta;
                void intentionAction;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IntentionAction intentionAction2 = (IntentionAction)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                IntentionAction $this$asSafely$iv = IntentionsUtilsKt.getDelegateChainRoot((IntentionAction)intentionAction);
                boolean $i$f$asSafely = false;
                IntentionAction intentionAction3 = $this$asSafely$iv;
                if (!(intentionAction3 instanceof AiaCustomIntention)) {
                    intentionAction3 = null;
                }
                AiaCustomIntention aiaIntentionAction = (AiaCustomIntention)intentionAction3;
                PsiFile psiFile3 = psiFile;
                if (psiFile3 != null && (psiFile3 = psiFile3.getLanguage()) != null) {
                    PsiFile it = psiFile3;
                    boolean bl4 = false;
                    AiaCustomIntention aiaCustomIntention = aiaIntentionAction;
                    v3 = Intrinsics.areEqual((Object)(aiaCustomIntention != null ? Boolean.valueOf(aiaCustomIntention.isBetaFor((Language)it)) : null), (Object)true);
                } else {
                    v3 = isBeta = false;
                }
                if ((psiFile2 = psiFile) != null && (psiFile2 = psiFile2.getLanguage()) != null) {
                    PsiFile it = psiFile2;
                    boolean bl5 = false;
                    AiaCustomIntention aiaCustomIntention = aiaIntentionAction;
                    bl2 = Intrinsics.areEqual((Object)(aiaCustomIntention != null ? Boolean.valueOf(aiaCustomIntention.isNewFor((Language)it)) : null), (Object)true);
                } else {
                    bl2 = false;
                }
                boolean isNew = bl2;
                AiaCustomIntention aiaCustomIntention = aiaIntentionAction;
                ShortcutSet shortcutSet = aiaCustomIntention != null && (aiaCustomIntention = aiaCustomIntention.getAction()) != null ? aiaCustomIntention.getShortcutSet() : null;
                collection.add(new IntentionActionPopupItem(index == false, isAssistantActive, (IntentionAction)intentionAction, isBeta, isNew, shortcutSet, project, editor, psiFile));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List values = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (!isAssistantActive) {
            values.add(0, new PopupItem(false, true, LLMBundle.message((String)"action.AIAssistant.Activate.text", (Object[])new Object[0]), false, false, null, () -> AIAssistantIntention.invoke$lambda$4(project), 56, null));
        }
        String $i$f$flatMap22 = LLMBundle.message((String)"intentions.ai.assistant.popup.title", (Object[])new Object[0]);
        BaseListPopupStep<PopupItem> popupStep2 = new BaseListPopupStep<PopupItem>((List<PopupItem>)values, $i$f$flatMap22){

            public String getTextFor(PopupItem value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return StringsKt.replace$default((String)value.getText(), (String)"__", (String)"_", (boolean)false, (int)4, null);
            }

            public ListSeparator getSeparatorAbove(PopupItem value) {
                PopupItem popupItem = value;
                return (popupItem != null ? popupItem.isSeparatorAbove() : false) ? new ListSeparator() : null;
            }

            public PopupStep<?> onChosen(PopupItem selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> invoke.popupStep.1.onChosen$lambda$0(selectedValue));
            }

            public boolean isSelectable(PopupItem value) {
                PopupItem popupItem = value;
                return popupItem != null ? popupItem.isSelectable() : false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            private static final void onChosen$lambda$0(PopupItem $selectedValue) {
                block0: {
                    Function0<Unit> function0 = $selectedValue;
                    if (function0 == null || (function0 = function0.getOnClick()) == null) break block0;
                    function0.invoke();
                }
            }
        };
        ListPopupImpl popup2 = new ListPopupImpl(project, popupStep2, isAssistantActive){
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $isAssistantActive;
            {
                this.$project = $project;
                this.$isAssistantActive = $isAssistantActive;
                super($project, (ListPopupStep)$popupStep);
            }

            protected ListCellRenderer<?> getListElementRenderer() {
                return (ListCellRenderer)((Object)new Renderer(this));
            }

            /*
             * WARNING - void declaration
             */
            protected void setFooterComponent(JComponent c) {
                void $this$setFooterComponent_u24lambda_u241;
                if (!this.$isAssistantActive) {
                    super.setFooterComponent(c);
                    return;
                }
                invoke.popup.1 thePopup = this;
                DslLabel dslLabel = new DslLabel(DslLabelType.LABEL);
                Project project = this.$project;
                DslLabel dslLabel2 = dslLabel;
                invoke.popup.1 var8_6 = this;
                boolean bl = false;
                String msg = LLMBundle.message((String)"promptlibrary.actions.addCustomPrompts.link", (Object[])new Object[0]);
                $this$setFooterComponent_u24lambda_u241.setText("<a>" + msg + "</a>");
                $this$setFooterComponent_u24lambda_u241.addHyperlinkListener(arg_0 -> invoke.popup.1.setFooterComponent$lambda$1$lambda$0(thePopup, project, arg_0));
                $this$setFooterComponent_u24lambda_u241.setForeground(JBUI.CurrentTheme.Advertiser.foreground());
                $this$setFooterComponent_u24lambda_u241.setBackground(JBUI.CurrentTheme.Advertiser.background());
                $this$setFooterComponent_u24lambda_u241.setOpaque(true);
                $this$setFooterComponent_u24lambda_u241.setFont(RelativeFont.NORMAL.scale(JBUI.CurrentTheme.Advertiser.FONT_SIZE_OFFSET.get(), JBUIScale.scale((float)11.0f)).derive(StartupUiUtil.getLabelFont()));
                $this$setFooterComponent_u24lambda_u241.setBorder(JBUI.CurrentTheme.Advertiser.border());
                super.setFooterComponent((JComponent)dslLabel);
            }

            private static final void setFooterComponent$lambda$1$lambda$0(invoke.popup.1 $thePopup, Project $project, HyperlinkEvent it) {
                if (Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    $thePopup.cancel();
                    OpenAiAssistantPromptLibrarySettingsKt.openAiAssistantPromptLibrarySettings$default($project, null, 2, null);
                }
            }
        };
        popup2.setAdText("");
        if (editor != null) {
            popup2.showInBestPositionFor(editor);
        } else {
            iterable = DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> AIAssistantIntention.invoke$lambda$6(arg_0 -> AIAssistantIntention.invoke$lambda$5(popup2, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)iterable);
        }
    }

    private static final Unit invoke$lambda$4(Project $project) {
        AIAContentFacade.Companion.getInstance($project).activateAction();
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$5(invoke.popup.1 $popup, DataContext it) {
        $popup.showInBestPositionFor(it);
        return Unit.INSTANCE;
    }

    private static final void invoke$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

