/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.persistenceBasedMetrics.services;

import com.intellij.ml.llm.persistenceBasedMetrics.AiGeneratedCodeSnippet;
import com.intellij.ml.llm.persistenceBasedMetrics.AiGeneratedCodeSnippetKt;
import com.intellij.ml.llm.persistenceBasedMetrics.AiGeneratedSnippet;
import com.intellij.ml.llm.persistenceBasedMetrics.AiGeneratedSnippetCreationContext;
import com.intellij.ml.llm.persistenceBasedMetrics.AiGeneratedVcsState;
import com.intellij.ml.llm.persistenceBasedMetrics.AiGeneratedVcsStateKt;
import com.intellij.ml.llm.persistenceBasedMetrics.PersistenceMetricsCalculationSettings;
import com.intellij.ml.llm.persistenceBasedMetrics.SnippetWithItsSnapshot;
import com.intellij.ml.llm.persistenceBasedMetrics.TrackableDocumentSegment;
import com.intellij.ml.llm.persistenceBasedMetrics.trackers.AiGeneratedCodeSnippetCommitTracker;
import com.intellij.ml.llm.persistenceBasedMetrics.trackers.AiGeneratedSnippetDelayTracker;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.UrlFilePath;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0082@\u00a2\u0006\u0002\u0010\u001fJ?\u0010 \u001a\u00020\u001b*\u00020\u00032\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u001c\u0010$\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100&\u0012\u0006\u0012\u0004\u0018\u00010\u00010%H\u0002\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/ml/llm/persistenceBasedMetrics/services/PersistenceMetricsCalculationService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "snippetCommitTracker", "Lcom/intellij/ml/llm/persistenceBasedMetrics/trackers/AiGeneratedCodeSnippetCommitTracker;", "snippetDelayTracker", "Lcom/intellij/ml/llm/persistenceBasedMetrics/trackers/AiGeneratedSnippetDelayTracker;", "aiGeneratedVcsState", "Lcom/intellij/ml/llm/persistenceBasedMetrics/AiGeneratedVcsState;", "trackingCommitsSemaphore", "Lkotlinx/coroutines/sync/Semaphore;", "trackingDurationsSemaphore", "notifyFileCommitted", "", "fileUrl", "Lcom/intellij/openapi/vcs/UrlFilePath;", "trackOnSnippetPaste", "trackableDocumentSegment", "Lcom/intellij/ml/llm/persistenceBasedMetrics/TrackableDocumentSegment;", "persistenceMetricsCalculationSettings", "Lcom/intellij/ml/llm/persistenceBasedMetrics/PersistenceMetricsCalculationSettings;", "aiGeneratedSnippetCreationContext", "Lcom/intellij/ml/llm/persistenceBasedMetrics/AiGeneratedSnippetCreationContext;", "launchTrackersAndWait", "Lkotlinx/coroutines/Job;", "codeSnippet", "Lcom/intellij/ml/llm/persistenceBasedMetrics/AiGeneratedCodeSnippet;", "persistenceSettings", "(Lcom/intellij/ml/llm/persistenceBasedMetrics/AiGeneratedCodeSnippet;Lcom/intellij/ml/llm/persistenceBasedMetrics/PersistenceMetricsCalculationSettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "launchRejectIfTooMany", "semaphore", "messageWithFailedLaunchAttempt", "", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/sync/Semaphore;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/Job;", "makeTrackableCodeSnippet", "segment", "Companion", "intellij.ml.llm.chat"})
public final class PersistenceMetricsCalculationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final AiGeneratedCodeSnippetCommitTracker snippetCommitTracker;
    @NotNull
    private final AiGeneratedSnippetDelayTracker snippetDelayTracker;
    @NotNull
    private final AiGeneratedVcsState aiGeneratedVcsState;
    @NotNull
    private final Semaphore trackingCommitsSemaphore;
    @NotNull
    private final Semaphore trackingDurationsSemaphore;
    @NotNull
    private static final Logger logger;
    private static final int MAX_SIMULTANEOUS_TRACKER_COMMIT = 100;
    private static final int MAX_SIMULTANEOUS_TRACKERS_DURATION = 100;

    public PersistenceMetricsCalculationService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.snippetCommitTracker = new AiGeneratedCodeSnippetCommitTracker();
        this.snippetDelayTracker = new AiGeneratedSnippetDelayTracker();
        this.aiGeneratedVcsState = AiGeneratedVcsStateKt.createAiGeneratedVcsState();
        this.trackingCommitsSemaphore = SemaphoreKt.Semaphore$default((int)100, (int)0, (int)2, null);
        this.trackingDurationsSemaphore = SemaphoreKt.Semaphore$default((int)100, (int)0, (int)2, null);
    }

    public final void notifyFileCommitted(@NotNull UrlFilePath fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        this.aiGeneratedVcsState.notifyFileCommitted(fileUrl);
    }

    public final void trackOnSnippetPaste(@NotNull TrackableDocumentSegment trackableDocumentSegment, @NotNull PersistenceMetricsCalculationSettings persistenceMetricsCalculationSettings, @NotNull AiGeneratedSnippetCreationContext aiGeneratedSnippetCreationContext) {
        AiGeneratedCodeSnippet aiGeneratedCodeSnippet;
        Intrinsics.checkNotNullParameter((Object)trackableDocumentSegment, (String)"trackableDocumentSegment");
        Intrinsics.checkNotNullParameter((Object)persistenceMetricsCalculationSettings, (String)"persistenceMetricsCalculationSettings");
        Intrinsics.checkNotNullParameter((Object)aiGeneratedSnippetCreationContext, (String)"aiGeneratedSnippetCreationContext");
        try {
            aiGeneratedCodeSnippet = this.makeTrackableCodeSnippet(trackableDocumentSegment, aiGeneratedSnippetCreationContext);
        }
        catch (IllegalArgumentException e) {
            logger.error("Error creating trackable code snippet: " + e.getMessage());
            return;
        }
        AiGeneratedCodeSnippet codeSnippet = aiGeneratedCodeSnippet;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, codeSnippet, persistenceMetricsCalculationSettings, null){
            int label;
            final /* synthetic */ PersistenceMetricsCalculationService this$0;
            final /* synthetic */ AiGeneratedCodeSnippet $codeSnippet;
            final /* synthetic */ PersistenceMetricsCalculationSettings $persistenceMetricsCalculationSettings;
            {
                this.this$0 = $receiver;
                this.$codeSnippet = $codeSnippet;
                this.$persistenceMetricsCalculationSettings = $persistenceMetricsCalculationSettings;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = PersistenceMetricsCalculationService.access$launchTrackersAndWait(this.this$0, this.$codeSnippet, this.$persistenceMetricsCalculationSettings, (Continuation)this);
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            (Job)v0;
                        }
                        catch (Throwable var2_3) {
                            throw var2_3;
                        }
                        finally {
                            this.$codeSnippet.dispose();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object launchTrackersAndWait(AiGeneratedCodeSnippet codeSnippet, PersistenceMetricsCalculationSettings persistenceSettings, Continuation<? super Job> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(codeSnippet, persistenceSettings, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AiGeneratedCodeSnippet $codeSnippet;
            final /* synthetic */ PersistenceMetricsCalculationSettings $persistenceSettings;
            final /* synthetic */ PersistenceMetricsCalculationService this$0;
            {
                this.$codeSnippet = $codeSnippet;
                this.$persistenceSettings = $persistenceSettings;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$coroutineScope;
                        this.label = 1;
                        v0 = SnippetWithItsSnapshot.Companion.makeSnapshotAndAttach((AiGeneratedSnippet)this.$codeSnippet, (Continuation)this);
                        if (v0 == var4_3) {
                            return var4_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        snippetWithItsSnapshot = (SnippetWithItsSnapshot)v0;
                        if (this.$persistenceSettings.getOnCommit()) {
                            PersistenceMetricsCalculationService.access$launchRejectIfTooMany(this.this$0, (CoroutineScope)$this$coroutineScope, PersistenceMetricsCalculationService.access$getTrackingCommitsSemaphore$p(this.this$0), "Rejected persistence till commit metric calculation: too many requests", (Function1)new Function1<Continuation<? super Unit>, Object>(this.$persistenceSettings, this.this$0, (SnippetWithItsSnapshot<? extends AiGeneratedCodeSnippet>)snippetWithItsSnapshot, null){
                                int label;
                                final /* synthetic */ PersistenceMetricsCalculationSettings $persistenceSettings;
                                final /* synthetic */ PersistenceMetricsCalculationService this$0;
                                final /* synthetic */ SnippetWithItsSnapshot<AiGeneratedCodeSnippet> $snippetWithItsSnapshot;
                                {
                                    this.$persistenceSettings = $persistenceSettings;
                                    this.this$0 = $receiver;
                                    this.$snippetWithItsSnapshot = $snippetWithItsSnapshot;
                                    super(1, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = TimeoutKt.withTimeout-KLykuaI((long)this.$persistenceSettings.getTimeWaitingForCommit-UwyO8pc(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$snippetWithItsSnapshot, this.$persistenceSettings, null){
                                                int label;
                                                final /* synthetic */ PersistenceMetricsCalculationService this$0;
                                                final /* synthetic */ SnippetWithItsSnapshot<AiGeneratedCodeSnippet> $snippetWithItsSnapshot;
                                                final /* synthetic */ PersistenceMetricsCalculationSettings $persistenceSettings;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$snippetWithItsSnapshot = $snippetWithItsSnapshot;
                                                    this.$persistenceSettings = $persistenceSettings;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            this.label = 1;
                                                            Object object2 = PersistenceMetricsCalculationService.access$getSnippetCommitTracker$p(this.this$0).trackCommit(this.$snippetWithItsSnapshot, this.$persistenceSettings.getMetricsToCalculate(), (Continuation<? super Unit>)((Continuation)this));
                                                            if (object2 != object) return Unit.INSTANCE;
                                                            return object;
                                                        }
                                                        case 1: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object2 = $result;
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Continuation<? super Unit> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            });
                        }
                        return PersistenceMetricsCalculationService.access$launchRejectIfTooMany(this.this$0, (CoroutineScope)$this$coroutineScope, PersistenceMetricsCalculationService.access$getTrackingDurationsSemaphore$p(this.this$0), "Rejected persistence till duration metric calculation: too many requests", (Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, (SnippetWithItsSnapshot<? extends AiGeneratedCodeSnippet>)snippetWithItsSnapshot, this.$persistenceSettings, null){
                            int label;
                            final /* synthetic */ PersistenceMetricsCalculationService this$0;
                            final /* synthetic */ SnippetWithItsSnapshot<AiGeneratedCodeSnippet> $snippetWithItsSnapshot;
                            final /* synthetic */ PersistenceMetricsCalculationSettings $persistenceSettings;
                            {
                                this.this$0 = $receiver;
                                this.$snippetWithItsSnapshot = $snippetWithItsSnapshot;
                                this.$persistenceSettings = $persistenceSettings;
                                super(1, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = PersistenceMetricsCalculationService.access$getSnippetDelayTracker$p(this.this$0).trackWithDelays(this.$snippetWithItsSnapshot, this.$persistenceSettings.getMetricsToCalculate(), this.$persistenceSettings.getDelays(), (Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        });
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Job launchRejectIfTooMany(CoroutineScope $this$launchRejectIfTooMany, Semaphore semaphore, String messageWithFailedLaunchAttempt, Function1<? super Continuation<? super Unit>, ? extends Object> block) {
        return BuildersKt.launch$default((CoroutineScope)$this$launchRejectIfTooMany, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(semaphore, block, messageWithFailedLaunchAttempt, null){
            int label;
            final /* synthetic */ Semaphore $semaphore;
            final /* synthetic */ Function1<Continuation<? super Unit>, Object> $block;
            final /* synthetic */ String $messageWithFailedLaunchAttempt;
            {
                this.$semaphore = $semaphore;
                this.$block = $block;
                this.$messageWithFailedLaunchAttempt = $messageWithFailedLaunchAttempt;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.$semaphore.tryAcquire()) break;
                        this.label = 1;
                        Object object2 = this.$block.invoke((Object)((Object)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.$semaphore.release();
                        }
                    }
                }
                PersistenceMetricsCalculationService.access$getLogger$cp().warn(this.$messageWithFailedLaunchAttempt);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final AiGeneratedCodeSnippet makeTrackableCodeSnippet(TrackableDocumentSegment segment, AiGeneratedSnippetCreationContext aiGeneratedSnippetCreationContext) {
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(segment.getDocument());
        if (virtualFile2 == null) {
            throw new IllegalArgumentException("No file associated with the given document: " + segment + ".document");
        }
        VirtualFile virtualFile3 = virtualFile2;
        UrlFilePath fileUrl = new UrlFilePath(virtualFile3);
        return AiGeneratedCodeSnippetKt.createAiGeneratedCodeSnippet(this.aiGeneratedVcsState, fileUrl, segment.getDocument(), segment.getStartOffset(), segment.getEndOffset(), aiGeneratedSnippetCreationContext);
    }

    public static final /* synthetic */ Object access$launchTrackersAndWait(PersistenceMetricsCalculationService $this, AiGeneratedCodeSnippet codeSnippet, PersistenceMetricsCalculationSettings persistenceSettings, Continuation $completion) {
        return $this.launchTrackersAndWait(codeSnippet, persistenceSettings, (Continuation<? super Job>)$completion);
    }

    public static final /* synthetic */ Job access$launchRejectIfTooMany(PersistenceMetricsCalculationService $this, CoroutineScope $receiver, Semaphore semaphore, String messageWithFailedLaunchAttempt, Function1 block) {
        return $this.launchRejectIfTooMany($receiver, semaphore, messageWithFailedLaunchAttempt, (Function1<? super Continuation<? super Unit>, ? extends Object>)block);
    }

    public static final /* synthetic */ Semaphore access$getTrackingCommitsSemaphore$p(PersistenceMetricsCalculationService $this) {
        return $this.trackingCommitsSemaphore;
    }

    public static final /* synthetic */ AiGeneratedCodeSnippetCommitTracker access$getSnippetCommitTracker$p(PersistenceMetricsCalculationService $this) {
        return $this.snippetCommitTracker;
    }

    public static final /* synthetic */ Semaphore access$getTrackingDurationsSemaphore$p(PersistenceMetricsCalculationService $this) {
        return $this.trackingDurationsSemaphore;
    }

    public static final /* synthetic */ AiGeneratedSnippetDelayTracker access$getSnippetDelayTracker$p(PersistenceMetricsCalculationService $this) {
        return $this.snippetDelayTracker;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        Logger logger = Logger.getInstance(PersistenceMetricsCalculationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PersistenceMetricsCalculationService.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/persistenceBasedMetrics/services/PersistenceMetricsCalculationService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAX_SIMULTANEOUS_TRACKER_COMMIT", "", "MAX_SIMULTANEOUS_TRACKERS_DURATION", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

