/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.smartChat.endpoints.search;

import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.messages.UserMessage;
import com.intellij.ml.llm.core.chat.messages.impl.FunctionCallResult;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.smartChat.endpoints.EndpointDescriptorBuilder;
import com.intellij.ml.llm.smartChat.endpoints.EndpointType;
import com.intellij.ml.llm.smartChat.endpoints.LlmFunctionDescriptor;
import com.intellij.ml.llm.smartChat.endpoints.LlmParametersBuilder;
import com.intellij.ml.llm.smartChat.endpoints.PropertyDescriptorBuilder;
import com.intellij.ml.llm.smartChat.endpoints.SmartChatEndpoint;
import com.intellij.ml.llm.smartChat.endpoints.search.AIAssistantSearchService;
import com.intellij.ml.llm.smartChat.endpoints.search.SearchArguments;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u001e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/smartChat/endpoints/search/ExactSearchEndpoint;", "Lcom/intellij/ml/llm/smartChat/endpoints/SmartChatEndpoint;", "<init>", "()V", "isActionsSearchEnabledInRegistry", "", "descriptionActionsSegment", "", "getDescriptionActionsSegment", "()Ljava/lang/String;", "searchTypeEnum", "", "getSearchTypeEnum", "()[Ljava/lang/String;", "llmFunction", "Lcom/intellij/ml/llm/smartChat/endpoints/LlmFunctionDescriptor;", "getLlmFunction", "()Lcom/intellij/ml/llm/smartChat/endpoints/LlmFunctionDescriptor;", "call", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "serializedArguments", "project", "Lcom/intellij/openapi/project/Project;", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPresentationString", "isAvailable", "userMessage", "Lcom/intellij/ml/llm/core/chat/messages/UserMessage;", "(Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lcom/intellij/ml/llm/core/chat/messages/UserMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nExactSearchEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExactSearchEndpoint.kt\ncom/intellij/ml/llm/smartChat/endpoints/search/ExactSearchEndpoint\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,77:1\n222#2:78\n30#3,2:79\n*S KotlinDebug\n*F\n+ 1 ExactSearchEndpoint.kt\ncom/intellij/ml/llm/smartChat/endpoints/search/ExactSearchEndpoint\n*L\n67#1:78\n68#1:79,2\n*E\n"})
public final class ExactSearchEndpoint
implements SmartChatEndpoint {
    private final boolean isActionsSearchEnabledInRegistry() {
        return Registry.Companion.is("llm.smartChat.endpointEnabled.ExactSearchEndpoint.actions");
    }

    private final String getDescriptionActionsSegment() {
        return this.isActionsSearchEnabledInRegistry() ? " IDE actions (like \"save file\", \"open file\")," : "";
    }

    private final String[] getSearchTypeEnum() {
        String[] stringArray;
        if (this.isActionsSearchEnabledInRegistry()) {
            String[] stringArray2 = new String[]{"actions", "symbols", "classes", "files", "methods"};
            stringArray = stringArray2;
        } else {
            String[] stringArray3 = new String[]{"symbols", "classes", "files", "methods"};
            stringArray = stringArray3;
        }
        return stringArray;
    }

    @Override
    @NotNull
    public LlmFunctionDescriptor getLlmFunction() {
        return LlmFunctionDescriptor.Companion.invoke(arg_0 -> ExactSearchEndpoint._get_llmFunction_$lambda$3(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object call(@NotNull String serializedArguments, @NotNull Project project, @NotNull ChatSession chat, @NotNull Continuation<? super FunctionCallResult> $completion) {
        void this_$iv;
        Json json = (Json)Json.Default;
        String string$iv = serializedArguments;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        SearchArguments arguments2 = (SearchArguments)this_$iv.decodeFromString((DeserializationStrategy)SearchArguments.Companion.serializer(), string$iv);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AIAssistantSearchService> serviceClass$iv = AIAssistantSearchService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return AIAssistantSearchService.search$default((AIAssistantSearchService)object, arguments2, project, null, $completion, 4, null);
    }

    @Override
    @NotNull
    public String getPresentationString() {
        return LLMBundle.message((String)"function.search.for.actions.files.classes.symbols.status", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public Object isAvailable(@NotNull ChatSession chat, @NotNull UserMessage userMessage, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)true);
    }

    private static final Unit _get_llmFunction_$lambda$3$lambda$2$lambda$0(ExactSearchEndpoint this$0, PropertyDescriptorBuilder $this$property) {
        Intrinsics.checkNotNullParameter((Object)$this$property, (String)"$this$property");
        $this$property.setType(EndpointType.STRING);
        $this$property.setEnum(this$0.getSearchTypeEnum());
        return Unit.INSTANCE;
    }

    private static final Unit _get_llmFunction_$lambda$3$lambda$2$lambda$1(PropertyDescriptorBuilder $this$property) {
        Intrinsics.checkNotNullParameter((Object)$this$property, (String)"$this$property");
        $this$property.setType(EndpointType.STRING);
        $this$property.setDescription("Query in textual form for searching by entity names or patterns within the names.");
        return Unit.INSTANCE;
    }

    private static final Unit _get_llmFunction_$lambda$3$lambda$2(ExactSearchEndpoint this$0, LlmParametersBuilder $this$parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$parameters, (String)"$this$parameters");
        $this$parameters.setType(EndpointType.OBJECT);
        $this$parameters.property("searchType", arg_0 -> ExactSearchEndpoint._get_llmFunction_$lambda$3$lambda$2$lambda$0(this$0, arg_0));
        $this$parameters.property("query", ExactSearchEndpoint::_get_llmFunction_$lambda$3$lambda$2$lambda$1);
        String[] stringArray = new String[]{"searchType", "query"};
        $this$parameters.required(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit _get_llmFunction_$lambda$3(ExactSearchEndpoint this$0, EndpointDescriptorBuilder $this$LlmFunctionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$LlmFunctionDescriptor, (String)"$this$LlmFunctionDescriptor");
        $this$LlmFunctionDescriptor.setName("exact_search");
        $this$LlmFunctionDescriptor.setDescription(StringsKt.trimIndent((String)("\n        This is a robust search tool to find " + this$0.getDescriptionActionsSegment() + " code entities (symbols, methods, classes) or files within the project.\n        Use this tool if you know the name or a part of the name of the entities or files you are looking for.\n        For example, if you want to find all files with a given name or to find all classes that include a given string in their name.\n        The search is based on the name of these entities or files, not their content.\n        Do NOT use this tool to search for a strings within the content of the files, use find_text instead.\n        This tool returns a list of search results, including the file path and even the content for short results. Avoid mentioning IDs of the results in the response.\n        If you are also interested in the content of the files or code entities, use this tool first and then read_file with the file paths returned by this tool.\n        ")));
        $this$LlmFunctionDescriptor.parameters(arg_0 -> ExactSearchEndpoint._get_llmFunction_$lambda$3$lambda$2(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

