/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.model.llm.definitions;

import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.chat.function.LLMFunction;
import ai.grazie.model.llm.chat.tool.LLMTool;
import ai.grazie.model.llm.parameters.LLMParameters;
import ai.grazie.model.llm.profile.LLMProfile;
import ai.grazie.model.llm.profile.LLMProfileMetadata;
import ai.grazie.model.llm.utils.AttributesExtensionKt;
import ai.grazie.utils.attributes.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fJ \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lai/grazie/model/llm/definitions/ParameterDefinition;", "", "supportedParameters", "", "Lai/grazie/utils/attributes/Attributes$Key;", "getSupportedParameters", "()Ljava/util/Set;", "validateParameters", "", "name", "", "parameters", "Lai/grazie/utils/attributes/Attributes;", "profile", "Lai/grazie/model/llm/profile/LLMProfile;", "Companion", "model-llm"})
@SourceDebugExtension(value={"SMAP\nParameterDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParameterDefinition.kt\nai/grazie/model/llm/definitions/ParameterDefinition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1557#2:68\n1628#2,3:69\n1557#2:72\n1628#2,3:73\n*S KotlinDebug\n*F\n+ 1 ParameterDefinition.kt\nai/grazie/model/llm/definitions/ParameterDefinition\n*L\n56#1:68\n56#1:69,3\n17#1:72\n17#1:73,3\n*E\n"})
public interface ParameterDefinition {
    @NotNull
    public static final Companion Companion = ai.grazie.model.llm.definitions.ParameterDefinition$Companion.$$INSTANCE;

    @NotNull
    public Set<Attributes.Key> getSupportedParameters();

    /*
     * WARNING - void declaration
     */
    default public void validateParameters(@NotNull String name, @NotNull Attributes parameters, @NotNull LLMProfile profile) {
        block8: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            Set unsupportedParameters = ArraysKt.subtract((Object[])parameters.getKeys(), (Iterable)this.getSupportedParameters());
            ExtensionsKt.requireOrBadRequest(unsupportedParameters.isEmpty(), (Function0<String>)((Function0)() -> ParameterDefinition.validateParameters$lambda$1(unsupportedParameters, name)));
            Long l = AttributesExtensionKt.getLength(parameters);
            if (l != null) {
                long length = ((Number)l).longValue();
                boolean bl = false;
                Object object = profile.getMetadata();
                if (object == null || (object = ((LLMProfileMetadata)object).getMaxOutputTokens()) == null) {
                } else {
                    int modelMaxOutputTokens = (Integer)object;
                    ExtensionsKt.requireOrBadRequest(length <= (long)modelMaxOutputTokens, (Function0<String>)((Function0)() -> ParameterDefinition.validateParameters$lambda$3$lambda$2(profile, modelMaxOutputTokens)));
                }
            }
            Long l2 = AttributesExtensionKt.getNumberOfChoices(parameters);
            if (l2 != null) {
                long number = ((Number)l2).longValue();
                boolean bl = false;
                ExtensionsKt.requireOrBadRequest(number >= 1L, (Function0<String>)((Function0)ParameterDefinition::validateParameters$lambda$5$lambda$4));
            }
            List<LLMTool> list = AttributesExtensionKt.getTools(parameters);
            if (list != null) {
                List<LLMTool> tools = list;
                boolean bl = false;
                ExtensionsKt.requireOrBadRequest(!((Collection)tools).isEmpty(), (Function0<String>)((Function0)ParameterDefinition::validateParameters$lambda$9$lambda$6));
                ExtensionsKt.requireOrBadRequest(AttributesExtensionKt.getFunctions(parameters) == null, (Function0<String>)((Function0)ParameterDefinition::validateParameters$lambda$9$lambda$7));
                ExtensionsKt.requireOrBadRequest(AttributesExtensionKt.getFunctionCall(parameters) == null, (Function0<String>)((Function0)ParameterDefinition::validateParameters$lambda$9$lambda$8));
            }
            List<LLMFunction> list2 = AttributesExtensionKt.getFunctions(parameters);
            if (list2 != null) {
                List<LLMFunction> it = list2;
                boolean bl = false;
                ExtensionsKt.requireOrBadRequest(AttributesExtensionKt.getTools(parameters) == null, (Function0<String>)((Function0)ParameterDefinition::validateParameters$lambda$11$lambda$10));
            }
            Object[] objectArray = new Object[]{AttributesExtensionKt.getToolChoiceAuto(parameters), AttributesExtensionKt.getToolChoiceNone(parameters), AttributesExtensionKt.getToolChoiceNamed(parameters), AttributesExtensionKt.getToolChoiceRequired(parameters)};
            ExtensionsKt.requireOrBadRequest(CollectionsKt.listOfNotNull((Object[])objectArray).size() <= 1, (Function0<String>)((Function0)ParameterDefinition::validateParameters$lambda$12));
            Boolean bl = AttributesExtensionKt.getToolChoiceRequired(parameters);
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                ExtensionsKt.requireOrBadRequest(AttributesExtensionKt.getTools(parameters) != null, (Function0<String>)((Function0)ParameterDefinition::validateParameters$lambda$14$lambda$13));
            }
            String string = AttributesExtensionKt.getToolChoiceNamed(parameters);
            if (string == null) break block8;
            String name2 = string;
            boolean bl3 = false;
            ExtensionsKt.requireOrBadRequest(AttributesExtensionKt.getTools(parameters) != null, (Function0<String>)((Function0)ParameterDefinition::validateParameters$lambda$18$lambda$15));
            List<LLMTool> list3 = AttributesExtensionKt.getTools(parameters);
            Intrinsics.checkNotNull(list3);
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LLMTool lLMTool = (LLMTool)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getName());
            }
            ExtensionsKt.requireOrBadRequest(((List)destination$iv$iv).contains(name2), (Function0<String>)((Function0)() -> ParameterDefinition.validateParameters$lambda$18$lambda$17(name2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String validateParameters$lambda$1(Set $unsupportedParameters, String $name) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $unsupportedParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Attributes.Key key = (Attributes.Key)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFqdn());
        }
        return "Parameters " + (List)destination$iv$iv + " are not supported for chat " + $name + " provider";
    }

    private static String validateParameters$lambda$3$lambda$2(LLMProfile $profile, int $modelMaxOutputTokens) {
        return "Parameter " + LLMParameters.INSTANCE.getLength() + " is bigger than " + $profile.getId() + " maximum output tokens limits: " + $modelMaxOutputTokens;
    }

    private static String validateParameters$lambda$5$lambda$4() {
        return "Parameter " + LLMParameters.INSTANCE.getNumberOfChoices() + " mustn't be smaller than 1";
    }

    private static String validateParameters$lambda$9$lambda$6() {
        return "Parameter " + LLMParameters.INSTANCE.getTools() + " must be null or not empty list";
    }

    private static String validateParameters$lambda$9$lambda$7() {
        return "Parameter " + LLMParameters.INSTANCE.getTools() + " must not be used together with " + LLMParameters.INSTANCE.getFunctions();
    }

    private static String validateParameters$lambda$9$lambda$8() {
        return "Parameter " + LLMParameters.INSTANCE.getTools() + " must not be used together with " + LLMParameters.INSTANCE.getFunctionCall();
    }

    private static String validateParameters$lambda$11$lambda$10() {
        return "Parameter " + LLMParameters.INSTANCE.getFunctions() + " must not be used together with " + LLMParameters.INSTANCE.getTools();
    }

    private static String validateParameters$lambda$12() {
        return "Only one 'tool-choice' is allowed";
    }

    private static String validateParameters$lambda$14$lambda$13() {
        return "'tool-choice-required' is only allowed when 'tools' are specified.";
    }

    private static String validateParameters$lambda$18$lambda$15() {
        return "'tool-choice-required' is only allowed when 'tools' are specified.";
    }

    private static String validateParameters$lambda$18$lambda$17(String $name) {
        return "No tool named '" + $name + "' for 'tool-choice-named' was specified in the 'tools' parameter.";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/grazie/model/llm/definitions/ParameterDefinition$Companion;", "", "<init>", "()V", "EMPTY", "Lai/grazie/model/llm/definitions/ParameterDefinition;", "getEMPTY", "()Lai/grazie/model/llm/definitions/ParameterDefinition;", "model-llm"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ParameterDefinition EMPTY;

        private Companion() {
        }

        @NotNull
        public final ParameterDefinition getEMPTY() {
            return EMPTY;
        }

        static {
            $$INSTANCE = new Companion();
            EMPTY = new ParameterDefinition(){
                private final Set<Attributes.Key> supportedParameters;
                {
                    this.supportedParameters = SetsKt.emptySet();
                }

                public Set<Attributes.Key> getSupportedParameters() {
                    return this.supportedParameters;
                }
            };
        }
    }
}

