/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.Severity;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

public abstract class Rule {
    public static final String GRAZIE_RULE_ENGINE_ID_PREFIX = "Grazie.RuleEngine.";
    public final String id;
    public final String displayName;
    private final String description;
    private final List<Example> examples;
    @Nullable
    public final URL url;
    @Nullable
    private StyleFlavor styleFlavor = null;
    private boolean isEnabled = true;
    private Language language;

    public Rule(String id, String displayName, String description, @Nullable String url, Example ... examples) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.url = Rule.toURL(url);
        this.examples = List.of(examples);
    }

    private static URL toURL(@Nullable String url) {
        try {
            return url == null ? null : new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Language language() {
        return this.language;
    }

    @ApiStatus.Internal
    public void setLanguage(@NotNull Language language) {
        if (this.language != null) {
            throw new AssertionError((Object)("Language is already set to " + this.language));
        }
        this.language = language;
    }

    @NotNull
    public static String globalIdPrefix(Language language) {
        return GRAZIE_RULE_ENGINE_ID_PREFIX + StringTools.uppercaseFirstChar((String)language.getIso().toString()) + ".";
    }

    public String globalId() {
        return Rule.globalIdPrefix(this.language) + this.id;
    }

    public String toString() {
        return this.id;
    }

    @NotNull
    public abstract MatchingResult match(Tree var1);

    @NotNull
    public final MatchingResult match(List<Tree> sentences2) {
        return MatchingResult.concat((Stream<MatchingResult>)StreamEx.of(sentences2).map(this::match));
    }

    public boolean isRuleEnabledByDefault(TextStyle style, RuleClient client) {
        return style.isRuleEnabled(this.globalId(), () -> this.isEnabledByDefault(client));
    }

    @ApiStatus.Internal
    public final boolean isRuleEnabledByDefaultAnywhere() {
        return TextStyle.styles(RuleClient.FullyCapable).stream().anyMatch(s -> this.isRuleEnabledByDefault((TextStyle)s, RuleClient.FullyCapable));
    }

    public boolean isEnabledByDefault(RuleClient client) {
        return this.isEnabled;
    }

    public boolean needsCloud() {
        return false;
    }

    public boolean shouldSuppressInCodeLikeFragments() {
        return true;
    }

    public Rule disableByDefault() {
        this.isEnabled = false;
        return this;
    }

    @ApiStatus.Internal
    public Rule styleFlavor(StyleFlavor flavor) {
        this.styleFlavor = flavor;
        return this;
    }

    public Severity getSeverity() {
        return this.isStyleLike() ? Severity.STYLE_SUGGESTION : Severity.GRAMMAR_ERROR;
    }

    public String getDescription(RuleClient client) {
        return this.description;
    }

    public List<Example> getExamples(RuleClient client) {
        return this.examples;
    }

    @Nullable
    public StyleFlavor getStyleFlavor() {
        return this.styleFlavor;
    }

    public boolean supportsFlatTrees() {
        return false;
    }

    public boolean isStyleLike() {
        return this.id.startsWith("Style.") || this.id.startsWith("Typography.");
    }

    public static class PatternRule
    extends Rule {
        private final NodePattern pattern;
        private boolean honorCrazyParses = false;
        private boolean supportsFlatTrees = false;

        public PatternRule(String id, String displayName, String description, @Nullable String url, NodePattern pattern, Example ... examples) {
            super(id, displayName, description, url, examples);
            this.pattern = pattern.costCenter(id);
        }

        @ApiStatus.Internal
        public PatternRule honorCrazyParses() {
            this.honorCrazyParses = true;
            return this;
        }

        @NotNull
        public NodePattern pattern() {
            return this.honorCrazyParses ? this.pattern.nonCrazy() : this.pattern;
        }

        @ApiStatus.Internal
        public PatternRule enableInFlatTrees() {
            this.supportsFlatTrees = true;
            return this;
        }

        @Override
        public final boolean supportsFlatTrees() {
            return this.supportsFlatTrees;
        }

        @Override
        public PatternRule styleFlavor(StyleFlavor flavor) {
            super.styleFlavor(flavor);
            return this;
        }

        @Override
        public PatternRule disableByDefault() {
            super.disableByDefault();
            return this;
        }

        @Override
        @NotNull
        public MatchingResult match(Tree tree) {
            if (tree.nodes().isEmpty() && this.supportsFlatTrees()) {
                tree = tree.getFlatTree();
            }
            return MatchingResult.from(NodeMatch.matchAll(this, tree, this.pattern()));
        }
    }
}

