/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules;

import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.rules.Rule;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import java.util.List;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public abstract class RuleMatch {
    private final Rule rule;
    private final String message;

    protected RuleMatch(Rule rule, String message) {
        this.rule = rule;
        this.message = message;
    }

    public final Rule rule() {
        return this.rule;
    }

    public final String message() {
        return this.message;
    }

    public abstract List<ProblemFix> problemFixes();

    public abstract List<TextRange> reportedRanges();

    public List<TextRange> hoverReportedRanges() {
        return this.reportedRanges();
    }

    public List<ActionSuggestion> actions() {
        return List.of();
    }

    @Nullable
    public NodeMatch.SuppressableKind suppressableKind() {
        return null;
    }

    public boolean autoFixCapable() {
        return false;
    }

    public boolean hasLowConfidence() {
        return false;
    }

    public boolean concedeToOtherGrammarCheckers() {
        return this.rule().id.startsWith("Style.") || this.problemFixes().isEmpty();
    }

    public List<TextChange> correctionChanges() {
        return this.problemFixes().stream().map(fix -> (TextChange)StreamEx.of((Object[])fix.getChanges()).map(c -> TextChange.replace(c.getRange().getStart(), c.getRange().getEndExclusive(), c.getText())).reduce((Object)TextChange.EMPTY, TextChange::and)).toList();
    }

    public Pair<TextRange, List<String>> singleRangeReplacements(String text2) {
        List<TextChange> changes = this.correctionChanges();
        TextRange range = TextRange.spanRanges(changes.isEmpty() ? this.reportedRanges().stream() : changes.stream().map(c -> c.changedRange()));
        return new Pair((Object)range, changes.stream().map(c -> c.performOnRange(text2, range)).distinct().toList());
    }
}

