/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.tree.Node;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public record FeatureRestriction<T extends Enum<T>>(@NotNull String reason, @NotNull Set<T> allowed) {
    public FeatureRestriction(@NotNull String reason, @NotNull Set<T> allowed) {
        assert (allowed instanceof EnumSet || allowed instanceof LinkedHashSet) : "Non-ordered set " + allowed.getClass();
        assert (allowed.size() > 0) : "No features allowed";
    }

    public boolean isRestricted() {
        return this.allowed.size() < ((Enum[])((Enum)this.allowed.iterator().next()).getClass().getEnumConstants()).length;
    }

    @SafeVarargs
    public static <T extends Enum<T>> FeatureRestriction<T> restricted(@NotNull Node reason, T ... allowed) {
        return new FeatureRestriction<T>(reason.quotedPresentableText(), new LinkedHashSet<T>(List.of(allowed)));
    }

    @SafeVarargs
    public static <T extends Enum<T>> FeatureRestriction<T> restricted(@NotNull String reason, T ... allowed) {
        return new FeatureRestriction<T>(reason, new LinkedHashSet<T>(List.of(allowed)));
    }

    public FeatureRestriction<T> derive(Set<T> allowed) {
        return new FeatureRestriction<T>(this.reason, allowed);
    }
}

