/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextRange;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public enum PairedPunctuation {
    Opening,
    Closing;

    static final NodePattern smileyStart;
    public static final NodePattern smileyParen;

    @Nullable
    static PairedPunctuation guessMisformattedQuoteKind(Node quote) {
        boolean closing;
        boolean opening = ((StreamEx)((StreamEx)quote.back().skip(1L)).filter(n -> n.form().equals(quote.form()))).count() % 2L == 0L;
        boolean bl = closing = ((StreamEx)((StreamEx)quote.forward().skip(1L)).filter(n -> n.form().equals(quote.form()))).count() % 2L == 0L;
        if (opening == closing) {
            return null;
        }
        return opening ? Opening : Closing;
    }

    public NodePattern checkSpace(String missingWsMessage, String extraWsMessage) {
        return NodePattern.custom((node, match) -> {
            boolean opening;
            Node prev = node.prevNode();
            Node next = node.nextNode();
            int start = node.startOffset();
            int end = node.endOffset();
            int prevEnd = prev == null ? start : prev.endOffset();
            int nextStart = next == null ? end : next.startOffset();
            boolean bl = opening = this == Opening;
            if ((opening ? prev != null && prevEnd == start : next != null && end == nextStart) && !CommonPatterns.punctOrEmoji.matches(prev) && !CommonPatterns.punctOrEmoji.matches(next)) {
                if (opening && "(".equals(node.form())) {
                    return null;
                }
                if (opening && "(".equals(prev.form())) {
                    return null;
                }
                if (!opening && ")".equals(node.form())) {
                    return null;
                }
                if (!opening && ")".equals(next.form())) {
                    return null;
                }
                if (!opening && next.form().startsWith(".")) {
                    return null;
                }
                TextRange range = TextRange.fromLength(opening ? start : end, 0);
                TextRange reported = new TextRange(prev != null ? prev.startOffset() : start, opening ? end : next.endOffset());
                return match.withMessage(missingWsMessage).withReportedRange(reported, node.tree()).withCorrector(NodeCorrector.rawReplace(range, " "));
            }
            if (opening ? end < nextStart : prevEnd < start) {
                TextRange spaceRange = new TextRange(opening ? end : prevEnd, opening ? nextStart : start);
                TextRange reportedRange = new TextRange(opening ? start : CommonPatterns.withPrevWord(prev).start(), opening ? next.endOffset() : end);
                return match.withMessage(extraWsMessage).withReportedRange(reportedRange, node.tree()).withCorrector(NodeCorrector.rawReplace(spaceRange, ""));
            }
            return null;
        }).andNot(smileyParen);
    }

    static {
        smileyStart = NodePattern.N.form("[:;]").noSpaceAfter();
        smileyParen = NodePattern.or(CommonPatterns.parenthesis.directlyAfter(smileyStart), NodePattern.N.form(":[()]|[()]:"), CommonPatterns.openingParen.noSpaceBefore().directlyAfter(CommonPatterns.openingParen), CommonPatterns.unpairedClosingParen);
    }
}

