/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

public class TreeMigration {
    public static final boolean useEnTreeExp = false;
    private static final Path expectedFailuresPath = Path.of("src/test/java/ai/grazie/rules/en/pending_tree_exp_failures.txt", new String[0]);
    public static final String EXPECT_TEST_FAILURE_COMMENT = "tree-exp differs";
    public static final Set<String> enLtRulesCoveredInTreeExp = Set.of("HE_BE", "DOWN_SIDE", "WHAT_IT_THE", "OUT_COME", "A_TO", "DE_THE", "WHAT_IS_YOU", "WERE_MD", "WHAT_IT_HAPPENING");

    public static <T> T revise(String why, T t) {
        return t;
    }

    public static Map<String, Set<String>> loadExpectedTreeExpFailures() {
        try {
            LinkedHashMap<String, Set<String>> treeExpFailures = new LinkedHashMap<String, Set<String>>();
            List<String> treeExpLines = Files.readAllLines(expectedFailuresPath);
            int i = 0;
            while (i + 1 < treeExpLines.size()) {
                String line = treeExpLines.get(i);
                if (treeExpFailures.containsKey(line)) {
                    throw new AssertionError((Object)("Duplicate line: " + line));
                }
                treeExpFailures.put(line, Set.of(treeExpLines.get(i + 1).split(";")));
                i += 2;
            }
            return treeExpFailures;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void appendTreeExpExpectation(String sentence, Set<String> failedIds) {
    }

    public static synchronized void removeTreeExpExpectation(String sentence, Set<String> disappearedIds) {
    }

    private static void saveTreeExpFailures(Map<String, Set<String>> map2) {
        try {
            Files.writeString(expectedFailuresPath, (CharSequence)EntryStream.of(map2).mapKeyValue(TreeMigration::dumpEntry).joining((CharSequence)"\n"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeOutdatedTreeExpFailures(Set<String> queried) {
        if (queried.isEmpty()) {
            return;
        }
        Map<String, Set<String>> map2 = TreeMigration.loadExpectedTreeExpFailures();
        map2.keySet().retainAll(queried);
        TreeMigration.saveTreeExpFailures(map2);
    }

    private static String dumpEntry(String sentence, Set<String> failedIds) {
        return sentence + "\n" + ((StreamEx)StreamEx.of(failedIds).sorted()).joining((CharSequence)";");
    }

    private static /* synthetic */ boolean lambda$removeTreeExpExpectation$0(Set disappearedIds, String id) {
        return !disappearedIds.contains(id);
    }
}

