/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FormattingIssues;
import ai.grazie.rules.common.PairedPunctuation;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.common.ZeroWidthSpaceRule;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Articles;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.Gender;
import ai.grazie.rules.de.GermanDateChecker;
import ai.grazie.rules.de.GermanParameters;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.de.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.NodeRange;
import ai.grazie.rules.tree.TreeCache;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.text.TextRange;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import one.util.streamex.StreamEx;
import org.languagetool.tools.StringTools;

class PunctuationRules {
    private static final Pattern abbrPattern = AbbreviationPatterns.withPunctCaseSensitive(Language.GERMAN);
    static final NodePattern commaOrStronger = NodePattern.or(CommonPatterns.ellipsis, NodePattern.N.form("[,.;:!?|/]"), NodePattern.PUNCT.form("..+"), CommonPatterns.arrow);
    private static final Quotes deAtQuotes = new Quotes("\u201e\u201c \u201a\u2018 \u00bb\u00ab \u203a\u2039");
    static final Quotes genericQuotes = new Quotes("\u201e\u201c \u201a\u2018 \u2018\u2019 \u00bb\u00ab \u203a\u2039 \u00ab\u00bb \u2039\u203a");
    static final NodePattern insideSingleQuotes = NodePattern.custom(n -> ((StreamEx)n.forward().filter(i -> NodePattern.N.form("[\u2018\u2019]").matches((Node)i))).count() % 2L != 0L);
    private static final NodePattern sentenceBoundary = GermanTreePatterns.closingQuotation.noSpaceBefore().directlyAfter(CommonPatterns.dot);
    private static final String DOT_AFTER_ORDINAL_NUM_MSG = "Ordinalzahlen ben\u00f6tigen einen Punkt";
    static final NodePattern commaOrOpening = NodePattern.or(commaOrStronger, GermanTreePatterns.openingQuotation.noSpaceAfter(), GermanTreePatterns.dashes, NodePattern.N.form("[(<]"), sentenceBoundary).andNot(CommonPatterns.dot.directlyAfter(NodePattern.or(NodePattern.N.pos(".*ABK.*"), NodePattern.N.formCaseSensitive("\\P{Ll}"))).andNot(Articles.zBEnd).andNot(NodePattern.N.directlyBefore(CommonPatterns.capitalizedMiddle)));
    static final NodePattern commaOrClosing = NodePattern.or(commaOrStronger, GermanTreePatterns.closingQuotation.noSpaceBefore(), GermanTreePatterns.dashes, NodePattern.N.form("[)>\\]]"), NodePattern.N.withHeadRelation("cc").noPos("ABK.*").withDependent("punct", NodePattern.N.directlyAfterHead()), sentenceBoundary);
    static final NodePattern noPunctAroundBefore = NodePattern.not(CommonPatterns.punctOrEmoji.andNot(CommonPatterns.dot.directlyAfter(NodePattern.N.pos("ABK.*")))).andNot(NodePattern.N.directlyAfter(CommonPatterns.punctOrEmoji.andNot(CommonPatterns.dot.directlyAfter(NodePattern.N.pos("ABK.*")))));
    private static final NodePattern addCommaBefore = noPunctAroundBefore.correct(NodeCorrector.insertAfterPrevious(","));
    private static final String DOUBLE_PUNCTUATION = "\u00dcberfl\u00fcssiges Satzzeichen?";
    private static final String FIX_SPACES = "Nach einem Satzzeichen sollte genau ein Leerzeichen stehen";
    private static final String MISSING_SPACE_ABBREVIATION = "Nach jedem Teil der Abk\u00fcrzung sollte ein gesch\u00fctztes Leerzeichen stehen";
    private static final String EXTRA_HYPHEN = "\u00dcberfl\u00fcssiger Bindestrich?";
    private static final String MISSING_IN_CLAUSE_COMMA = "Fehlendes Komma zwischen Satzgliedern?";
    private static final String MISSING_COMMA_COORDINATION = "Fehlendes Komma in einer Satzreihe?";
    private static final String MISSING_COMMA_BEFORE_DEPENDENT_CLAUSE = "Fehlendes Komma vor einem Nebensatz?";
    private static final String MISSING_COMMA_AFTER_DEPENDENT_CLAUSE = "Fehlendes Komma nach einem Nebensatz?";
    private static final String MISSING_COMMA_DEPENDENT_CLAUSE = "Fehlende Kommas bei einem Nebensatz?";
    private static final String MISSING_SPACE = "Fehlendes Leerzeichen";
    private static final String MISSING_SPACE_Q = "Fehlendes Leerzeichen?";
    private static final String HYPHEN_VS_DASH_RANGE = "Mit Von-bis-Angaben wird der Gedankenstrich (\u2013) und kein Bindestrich (-) verwendet";
    private static final String MISSING_PUNCTUATION_AFTER_DIRECT_SPEECH = "Fehlendes Satzzeichen nach der direkten Rede?";
    private static final String MISSING_COMMA_AFTER_DIRECT_SPEECH = "Fehlendes Komma nach der direkten Rede?";
    private static final String MISSING_PUNCTUATION_BEFORE_DIRECT_SPEECH = "Fehlendes Satzzeichen vor der direkten Rede?";
    private static final String MISSING_DOT_MSG = "Fehlt der Punkt am Ende des Satzes?";
    private static final String NBSP_PROPER_NAME = "Verwenden Sie gesch\u00fctzte Leerzeichen nach abgek\u00fcrzten Vornamen";
    private static final String NBSP_NUMBER_UNIT = "Verwenden Sie gesch\u00fctzte Leerzeichen zwischen einer Zahl und einer Einheit";
    private static final String NBSP_IBAN = "Teilen Sie die IBAN zur besseren Lesbarkeit nach jedem vierten Zeichen durch gesch\u00fctzte Leerzeichen auf";
    private static final String NBSP_NUMBERS = "Verwenden Sie gesch\u00fctzte Leerzeichen, um die Ziffern bei l\u00e4ngeren Zahlen zu gruppieren";
    private static final String NBSP_MONEY_NUMBERS = "Verwenden Sie gesch\u00fctzte Leerzeichen, um die Ziffern bei l\u00e4ngeren Geldbetr\u00e4gen zu gruppieren";
    private static final String DOT_MONEY_NUMBERS = "Verwenden Sie Punkte, um die Ziffern bei l\u00e4ngeren Geldbetr\u00e4gen zu gruppieren";
    private static final String NO_NBSP_PROPER_NAME = "Verwenden Sie gesch\u00fctzte Leerzeichen nur zwischen abgek\u00fcrzten Vornamen und Nachnamen";
    private static final String MOVE_PUNCTUATION_AFTER_QUOTE = "Sollte das Satzzeichen nach dem Anf\u00fchrungszeichen stehen?";
    private static final String ONE_DOT_ABBREVIATION = "Diese Abk\u00fcrzung sollte nur mit einem Punkt geschrieben werden";
    private static final String EXTRA_COMMA = "Ein Komma wird in der Regel nur zwischen Haupt- und Nebens\u00e4tzen oder bei Zus\u00e4tzen und Einsch\u00fcben gesetzt";
    private static final String COMPARATIVE_NO_COMMA = "Bei Vergleich mit \u201eals\u201c, wenn kein Nebensatz folgt, darf kein Komma gesetzt werden";
    private static final String CONJ_NO_COMMA = "Bei Konjunktionen, die gleichgeordnete Satzteile verbinden, darf kein Komma gesetzt werden";
    private static final String BRAUCHEN_SCHEINEN_PFLEGEN_NO_COMMA = "In Verbindung mit einem Infinitiv mit \u201ezu\u201c wird dieses Verb nicht durch Komma von der Infinitivgruppe abgetrennt";
    private static final String HYPHEN_TO_DASH_MSG = "Meinten Sie den Gedankenstrich?";
    private static final String NO_PUNCTUATION_AFTER_FAREWELL = "Verwenden Sie kein Satzzeichen nach der Schlussformel";
    private static final Set<String> mistakenlyDottedAbbreviations = new HashSet<String>(AbbreviationPatterns.germanMistakenlyDotted);
    private static final String PUNCTUATION_IN_DIPLOMA_DEGREES = "Schreiben Sie diese Abk\u00fcrzung mit Punkten und einem Bindestrich";
    private static final NodePattern pairedCompounds = NodePattern.N.directlyBefore(NodePattern.N.markAs("Conj").withHead("conj", NodePattern.custom((head, match) -> {
        Node conj = match.getMarkedNode("Conj");
        for (int i = head.form().length() - 3; i > 3; --i) {
            String newWord;
            String firstPartInCompound = head.form().substring(0, i);
            String lastPartInCompound = head.form().substring(i);
            TreeSupport support = head.tree().treeSupport();
            if (!support.tagToken(newWord = firstPartInCompound + conj.lowForm()).hasPos(".*") || !support.tagToken(lastPartInCompound).hasPos(".*") && !support.tagToken(StringTools.uppercaseFirstChar((String)lastPartInCompound)).hasPos(".*")) continue;
            return match;
        }
        return null;
    }))).directlyAfter(NodePattern.or(CommonPatterns.comma, CommonPatterns.possiblySkipUp("punct", NodePattern.or(NodePattern.N.pos("ABK.*"), NodePattern.N.form("resp")))));
    private static final NodePattern gerneAuch = NodePattern.N.inFormSequence(0, "gerne", "auch");
    private static final NodePattern relativeOrAdverbialClause = NodePattern.N.withHeadRelation("a(dv)?cl");
    private static final TreeCache<List<CommaLicense>> licenseCache = new TreeCache<List>("licenses", tree -> ((StreamEx)StreamEx.of(tree.nodes()).flatMap(node -> {
        List<CommaLicense> result2 = PunctuationRules.licenseCommasAround(node);
        return result2 != null ? StreamEx.of(result2) : StreamEx.empty();
    }).filter(Objects::nonNull)).toList());
    static final NodePattern unmandatedComma = CommonPatterns.comma.and(node -> {
        List<CommaLicense> licenses = node.tree().getCached(licenseCache);
        return licenses.stream().noneMatch(c -> c.allows((Node)node));
    });
    private static final NodePattern looksLikeSecondPartConj = CommonPatterns.firstChildPhrase.markAs("Conj").withHead("conj|advmod", NodePattern.not(GermanTreePatterns.clause.onlyPos("VER.*")).markAs("Head").withHead(NodePattern.N.withDependent(".*", NodePattern.N.sameWordAs("Conj").before("Head"))));
    private static final NodePattern looksLikeCoordinatedNoun = NodePattern.N.pos("(SUB|EIG).*").withHead("conj", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound")).withOnlyDependents(NodePattern.N.withHeadRelation("det(:poss)?|compound|conj")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withDependent("cc"))).andNot(NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("conj|nsubj(:pass)?|i?obj|obl|nmod|compound").withDependent("cc"))));
    static final NodePattern repeatedAdv = NodePattern.N.form("richtig|sehr|so|wirklich|ziemlich|ganz|viel|super|leider|vielleicht").withHeadRelation("advmod").markAs("Adv").withPrevSibling(NodePattern.N.withHeadRelation("advmod").sameWordAs("Adv"));
    private static final NodePattern amod = NodePattern.N.withHeadRelation("amod");
    private static final NodePattern youKnowWho = NodePattern.N.noSpaceAfter().noSpaceBefore().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE).directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE);
    private static final NodePattern derselbe = NodePattern.N.lemma("derselbe");
    private static final NodePattern noSpaceWithEllipsis = NodePattern.or(NodePattern.custom(node -> !node.tree().treeSupport().isAcceptedBySpellchecker(node.form())).form(".{2,5}").noForm("bla").noLabel(".*"), NodePattern.N.form("."));
    private static final NodePattern hasCompatibleQuote = NodePattern.custom((quote, match) -> {
        String thisQuote = quote.form();
        String otherQuote = match.getMarkedNode("AnotherQuote").form();
        if (otherQuote.equals(genericQuotes.openingToClosing(thisQuote)) || otherQuote.equals(genericQuotes.closingToOpening(thisQuote))) {
            return match;
        }
        return null;
    });
    private static final NodePattern closingQuoteDirectSpeech = GermanTreePatterns.closingQuotation.noSpaceBefore().includeIntoReport().directlyAfter(NodePattern.not(NodePattern.PUNCT).includeIntoReport()).withHead("punct", NodePattern.N.withHead("parataxis|ccomp", SemanticRules.directSpeechVerb));
    static final NodePattern afterIrgend = NodePattern.N.directlyAfter(NodePattern.N.form("irgend"));
    static final NodePattern zusatz = NodePattern.N.pos("PRO:PER.*").directlyAfterHead().withHead("nsubj", NodePattern.N.pos("VER:[1-3].*").andOr(NodePattern.ROOT.withDependent(".*", GermanTreePatterns.whPhrase.beforeHead()).withDependent("ccomp", NodePattern.N.noDependents("mark").noDependents(".*", GermanTreePatterns.whPhrase).andOr(NodePattern.N.pos("VER:[123].*").noDependents(NodePattern.not(NodePattern.PUNCT).beforeHead()), NodePattern.N.withDependent("aux.*|cop", NodePattern.N.markAs("FiniteVerb")).noDependents(NodePattern.not(NodePattern.PUNCT).before("FiniteVerb")).unmark("FiniteVerb"))), NodePattern.N.withHead("parataxis", GermanTreePatterns.whPhrase).afterHead().withNextSibling(NodePattern.N.withHeadRelation("cop"))));
    static final NodePattern notAfterConj = NodePattern.N.directlyAfter(NodePattern.not(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("cc"))));
    static final NodePattern needCoordinationComma = GermanTreePatterns.clause.afterHead().andOr(NodePattern.N.withHead("conj", GermanTreePatterns.clause).withDependent(".*").andNot(NodePattern.N.withOnlyDependents(NodePattern.N.afterHead()).withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).andNot(NodePattern.N.pos(".*INF.*").noDependents("aux(:pass)?").withHead(NodePattern.N.pos(".*(AUX|MOD).*").noDependents("obj")).noDependents("cc", NodePattern.N.form("aber|deshalb|doch"))), NodePattern.N.withHead("parataxis", NodePattern.or(GermanTreePatterns.clause.noLemma("bitte"), AgreementSet.accusativePhrase)).withDependent("nsubj.*|expl|obj", NodePattern.not(zusatz)).noDependents("mark").noDependents("case", CommonPatterns.firstChildPhrase).andOr(NodePattern.N.withDependent("nsubj.*|expl"), NodePattern.N.withHead(NodePattern.N.withDependent("i?obj|obl|cop|aux(:pass)?"))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.form(";")))))).andOr(NodePattern.N.withDependent("cc", NodePattern.N.form("aber|deshalb|nur")), NodePattern.N.noDependents("cc").andNot(NodePattern.N.withHead("conj|parataxis", CommonPatterns.severalDependents("nsubj(:pass)?")))).andNot(NodePattern.N.withDependent("obl", NodePattern.N.beforeHead().withDependent("cc", NodePattern.N.form("und")))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withPhraseEnd(NodePattern.N.form(".*\\.").directlyBefore(CommonPatterns.capitalized)))).andNot(NodePattern.N.withPhraseStart(CommonPatterns.dot.directlyAfter(NodePattern.N.pos("ABK.*")).directlyBefore(CommonPatterns.capitalizedMiddle))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("aux.*").withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound|advmod|punct"))).noDependents("case|aux.*|expl", NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound")).andNot(CommonPatterns.possiblySkipUp("conj", NodePattern.N.withDependent("xcomp", NodePattern.N.withDependent("cc")))).withPhraseStart(notAfterConj.andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("case").afterHead())));
    static final NodePattern eatLeft = NodePattern.or(NodePattern.N.withHeadRelation("cc"), NodePattern.N.form("nur|auch|doch").beforeHead(), NodePattern.N.form("zumindest"));
    static final NodePattern misparsedClauseBegin = NodePattern.or(NodePattern.N.form("mal").withDependent("det", NodePattern.N.form("jedes")), NodePattern.N.inFormSequence(1, "vor", "allem"), NodePattern.N.inFormSequence(1, "unter", "anderem"));
    static final NodePattern misparsedClauseEnd = NodePattern.or(NodePattern.N.form("mal"), NodePattern.N.withHeadRelation("ccomp").noDependents(".*"), NodePattern.N.withHeadRelation("aux").afterHead());
    private static final NodePattern aclWithMisattachedConjAfter = NodePattern.or(NodePattern.N.withHead("acl", NodePattern.not(NodePattern.N.withHeadRelation("appos"))), NodePattern.N.withHeadRelation("ccomp").withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", GermanTreePatterns.firstInPhraseAfterCommasOrConj.pos("ART:DEF.*"))).markAs("Acl").andNot(NodePattern.N.withPhraseEnd(NodePattern.or(CommonPatterns.parenthesis, CommonPatterns.HYPHEN_LIKE_NODE))).noDependents("nsubj(:pass)?|i?obj|obl", NodePattern.N.pos("PRO:RIN.*")).withNextSibling(NodePattern.N.withHeadRelation("conj").andNot(NodePattern.N.pos("SUB.*").withDependent("case", NodePattern.not(NodePattern.N.directlyAfter(NodePattern.N.form("nicht"))))).withPhraseStart(NodePattern.N.withHeadRelation("cc").form("und")).andOr(NodePattern.not(GermanTreePatterns.clause).noDependents("nsubj(:pass)?"), NodePattern.N.noDependents("nsubj(:pass)?|expl").andOr(NodePattern.markedNodeMatches("Acl", NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.N.pos("ART:DEF.*"))), NodePattern.N.noDependents("obj")), NodePattern.N.noDependents("obj").and(NodePattern.markedNodeMatches("Acl", NodePattern.N.withDependent("obj", NodePattern.N.pos("ART:DEF.*"))))).noDependents("acl"));
    private static final NodePattern looksPluralClause = NodePattern.or(NodePattern.N.noDependents("aux(:pass)?|cop").pos(".*PLU.*"), NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.N.pos(".*PLU.*")));
    private static final NodePattern looksSingularClause = NodePattern.or(NodePattern.N.noDependents("aux(:pass)?|cop").pos(".*SIN.*"), NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.N.pos(".*SIN.*")));
    private static final NodePattern looks1PersonClause = NodePattern.or(NodePattern.N.noDependents("aux(:pass)?|cop").pos(".*:1:.*"), NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.N.pos(".*:1:.*")));
    private static final NodePattern looks2PersonClause = NodePattern.or(NodePattern.N.noDependents("aux(:pass)?|cop").pos(".*:2:.*"), NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.N.pos(".*:2:.*")));
    private static final NodePattern looks3PersonClause = NodePattern.or(NodePattern.N.noDependents("aux(:pass)?|cop").pos(".*:3:.*"), NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.N.pos(".*:3:.*")));
    private static final NodePattern ccompAdvclWithMisattachedConjAfter = GermanTreePatterns.clause.withHeadRelation("ccomp|advcl").withDependent("mark", CommonPatterns.firstChildPhrase.form("dass|wenn")).noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").withNextSibling(NodePattern.N.withHeadRelation("conj").withPhraseStart(NodePattern.N.withHeadRelation("cc").form("und")).noDependents("nsubj(:pass)?|expl").markAs("ConjSibling")).andOr(looksPluralClause.and(NodePattern.markedNodeMatches("ConjSibling", looksPluralClause)), looksSingularClause.and(NodePattern.markedNodeMatches("ConjSibling", looksSingularClause))).andOr(NodePattern.N.withDependent("nsubj(:pass)?", CommonPatterns.possiblySkipDown("conj", NodePattern.N.form("ich|wir"))).and(NodePattern.markedNodeMatches("ConjSibling", looks1PersonClause)), NodePattern.N.withDependent("nsubj(:pass)?", CommonPatterns.possiblySkipDown("conj", NodePattern.N.form("du|ihr"))).and(NodePattern.markedNodeMatches("ConjSibling", looks2PersonClause)), looks3PersonClause.and(NodePattern.markedNodeMatches("ConjSibling", looks3PersonClause)));
    static final NodePattern abbreviation = NodePattern.N.form("\\p{L}+\\.");
    static final NodePattern misattachedLeftPhrase = NodePattern.or(NodePattern.N.inFormSequence(1, "erst", "recht"), NodePattern.N.inFormSequence(1, "zum", "Beispiel"));
    static final NodePattern nonClausalConj = NodePattern.N.withHeadRelation("conj").anyPos().noPos("VER:.*").andNot(CommonPatterns.lowercasedHasPos("VER:.*")).noDependents("cop|aux|acl");
    private static final NodePattern nonSentenceFinalAbbreviations = NodePattern.or(NodePattern.N.inFormSequence(1, "d.", "h."), NodePattern.N.inFormSequence(1, "z.", "[BT]."), NodePattern.N.inFormSequence(1, "u.", "a."), NodePattern.N.inFormSequence(2, "i.", "d.", "R."), NodePattern.N.form("ggf.|vgl.|sog.|bzw."));
    static final NodePattern needSubordinationComma = NodePattern.or(GermanTreePatterns.clause, zusatz, NodePattern.N.beforeHead().noPos().withHeadRelation("ccomp")).andOr(zusatz, NodePattern.or(NodePattern.N.withHeadRelation("ccomp").markAs("CcompClause").withDependent(".*").andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("ccomp").andNot(NodePattern.N.directlyAfter(NodePattern.not(GermanTreePatterns.clause).alreadyMarkedAs("CcompClause"))))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("ccomp"))).andNot(NodePattern.N.withHead("ccomp", NodePattern.ROOT.and(CommonPatterns.firstWord).noDependents("nsubj(:pass)?|expl").markAs("Head")).withDependent("mark", CommonPatterns.firstChildPhrase.directlyAfter("Head").directlyBefore(CommonPatterns.skipForward(CommonPatterns.comma, NodePattern.N.withHeadRelation("mark"))))).noDependents("parataxis", NodePattern.N.beforeHead().withPrevSibling(NodePattern.not(NodePattern.PUNCT))).noDependents("advmod|cop|case", CommonPatterns.firstChildPhrase.directlyBefore(GermanTreePatterns.anyQuotation)).andNot(NodePattern.N.withPhraseStart(NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.HYPHEN_NODE))), NodePattern.N.withHeadRelation("advcl").andOr(NodePattern.N.withDependent("nsubj.*"), NodePattern.N.withDependent("mark", NodePattern.N.noForm("wie")), NodePattern.N.withDependent("mark").withHead("advcl", NodePattern.N.noDependents("advmod", NodePattern.N.form("ebenso"))), NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("advmod").directlyAfterHead())).withDependent(".*", NodePattern.not(NodePattern.N.directlyBeforeHead())).andNot(NodePattern.N.withPhraseStart(NodePattern.N.form("wie").directlyAfter(NodePattern.N.withHeadRelation("advmod").form("\u00e4hnlich")))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("obl").afterHead())).noDependents("mark", NodePattern.N.form("als").directlyAfter(NodePattern.N.form("solange?"))).noDependents("advmod", NodePattern.N.withDependent("punct", NodePattern.N.directlyBeforeHead())).noDependents("case", CommonPatterns.firstChildPhrase.directlyBefore(GermanTreePatterns.anyQuotation)).andNot(NodePattern.N.withPhraseStart(NodePattern.N.withHeadRelation("advmod").form("erst").directlyBefore(CommonPatterns.nonWordPunct))).andNot(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.withHeadRelation("mark").directlyBefore(GermanTreePatterns.anyQuotation), NodePattern.PUNCT)))).withPhraseStart(NodePattern.not(NodePattern.N.directlyAfter(misattachedLeftPhrase))), NodePattern.N.withHeadRelation("csubj").andOr(NodePattern.N.withDependent("mark", NodePattern.or(NodePattern.N.form("dass?|da\u00df"), GermanTreePatterns.whPhrase)), NodePattern.N.withDependent(".*", GermanTreePatterns.whPhrase)), NodePattern.N.withHead("csubj", NodePattern.N.withDependent("expl", NodePattern.N.form("es"))).withDependent("mark", NodePattern.N.form("zu").markAs("zuDep")).withDependent(".*", NodePattern.not(NodePattern.or(NodePattern.N.alreadyMarkedAs("zuDep"), NodePattern.N.withHeadRelation("advmod"))).beforeHead()), NodePattern.N.withHeadRelation("parataxis").andOr(NodePattern.N.withDependent("cc|mark", NodePattern.N.form("denn")), NodePattern.N.withDependent("advmod|mark", NodePattern.N.form("weil"))), NodePattern.N.afterHead().withHeadRelation("ob[jl]").withDependent("case", NodePattern.N.form("ohne")), NodePattern.N.withHeadRelation("xcomp").beforeHead().withPhraseStart(NodePattern.or(NodePattern.N.pos("VER:MOD.*"), NodePattern.N.form("je"))).withDependent("nsubj.*"), NodePattern.N.withHead("acl(:relcl)?|appos", NodePattern.not(NodePattern.N.withHeadRelation("acl"))).andOr(NodePattern.N.withDependent("nsubj.*"), NodePattern.N.withDependent(".*", GermanTreePatterns.whPhrase), NodePattern.N.withDependent("obj").withHead(NodePattern.or(NodePattern.N.withHeadRelation("obj|nsubj"), NodePattern.N.pos("ADJ:PRD:KOM")))).andOr(NodePattern.N.noHeadRelation("appos").andNot(NodePattern.N.withPrevSibling(NodePattern.N.pos("ART:DEF.*"))), NodePattern.N.withDependent("nsubj|obj", CommonPatterns.firstChildPhrase.pos("ART:DEF.*"))).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("zu")).noDependents("aux")).andNot(NodePattern.N.withDependent("advmod", NodePattern.N.withDependent("advmod", NodePattern.N.form("so"))).afterHead()).noDependents("obl", NodePattern.N.afterHead().withPrevSibling(CommonPatterns.comma).withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.not(CommonPatterns.comma))).trace("too deep obl attachment")).andNot(NodePattern.N.withDependent("nsubj", NodePattern.N.withDependent("case"))).andNot(NodePattern.N.withDependent("cc").withPrevSibling(NodePattern.N.withHeadRelation("conj").afterHead())).andNot(NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", GermanTreePatterns.firstInPhraseAfterCommasOrConj.and(GermanTreePatterns.whPhrase)).withNextSibling(NodePattern.N.withHeadRelation("conj").withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", GermanTreePatterns.firstInPhraseAfterCommasOrConj.and(GermanTreePatterns.whPhrase)))).andNot(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.PUNCT, CommonPatterns.inParentheses)).withDependent("punct", CommonPatterns.openingParen).withDependent("punct", CommonPatterns.closingParen)).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("wie"))), NodePattern.or(NodePattern.N.withHead("xcomp", NodePattern.N.noPos(".*(AUX|ADV|MOD).*").noLemma("ge(b|lt)en|brauchen|scheinen|pflegen").noDependents("dep").andNot(NodePattern.N.withHeadRelation("obj").withHead(CommonPatterns.severalDependents("obj")))).afterHead().andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.withHead(NodePattern.N.noPos(".*(VER|SUB).*"))))).andOr(CommonPatterns.phraseStartsWithComma, NodePattern.N.withPhraseEnd(CommonPatterns.comma), NodePattern.N.withHead(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound"))), NodePattern.N.withHead("acl", NodePattern.or(NodePattern.N.pos("SUB.*").noDependents("flat|appos"), NodePattern.N.withHead("xcomp", NodePattern.N.withDependent("nsubj|expl", NodePattern.N.form("es"))))), NodePattern.N.withHead("xcomp", NodePattern.or(NodePattern.N.withDependent("nsubj").withDependent("expl").noDependents("obj"), NodePattern.N.withDependent("nsubj", NodePattern.N.form("es")).noPos("VER:MOD.*").withDependent("xcomp", NodePattern.N.withDependent("obj")).noLemma("ge(b|lt)en|scheinen"), NodePattern.N.form(".+s").noPos().and(node -> !node.tree().treeSupport().tagToken(node.form().substring(0, node.form().length() - 1)).posReadings().isEmpty())).noForm("gibts")).noDependents("xcomp"), NodePattern.N.withHeadRelation("xcomp").withPrevSibling(NodePattern.N.pos("ADJ:PRD:(KOM|GRU)").withHead("advmod", NodePattern.N.withDependent("expl")))).andOr(NodePattern.N.pos("VER:EIZ:.*"), NodePattern.N.withDependent("mark", NodePattern.N.form("zu").markAs("Zu"))).andOr(NodePattern.N.withDependent(".*", NodePattern.not(NodePattern.N.alreadyMarkedAs("Zu")).beforeHead()), NodePattern.N.withHeadRelation("xcomp").withDependent("aux(:pass)?", NodePattern.N.directlyAfter("Zu")))).noDependents(CommonPatterns.lastChildPhrase.withHeadRelation("vocative").withDependent("punct", commaOrClosing)).noDependents("punct", GermanTreePatterns.anyQuotation.directlyAfter(CommonPatterns.comma)).andOr(NodePattern.N.noDependents("conj", NodePattern.not(GermanTreePatterns.clause)), NodePattern.N.afterHead()).andOr(NodePattern.N.noDependents("mark", NodePattern.N.form("als")), NodePattern.N.withHead(NodePattern.N.noLemma("bezeichnen|verstehen"))).andOr(NodePattern.N.noPos("(VER:)?PA.*"), NodePattern.N.withDependent("aux.*|nsubj.*|expl:pv")).andNot(NodePattern.N.markAs("Subordinate").withPhraseStart(NodePattern.or(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("acl").withOnlyDependents(NodePattern.PUNCT)), NodePattern.not(NodePattern.N.withHeadRelation("mark")).withNextSibling(CommonPatterns.comma.markAs("InnerPunct").directlyBefore(NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("InnerPunct")))), NodePattern.N.form("wie").anyMatchUntil("Subordinate", GermanTreePatterns.anyQuotation), NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.withHeadRelation("cc").andNot(CommonPatterns.firstWord).andNot(NodePattern.N.inFormSequence(0, "aber", "weil|da|solange")), abbreviation.andNot(nonSentenceFinalAbbreviations))), NodePattern.N.inFormSequence(1, "anders", "als"), eatLeft.directlyBefore(commaOrStronger)))).andNot(NodePattern.N.inPhrase(NodePattern.N.withHeadRelation("ccomp")).andOr(NodePattern.N.withNextSibling(nonClausalConj), NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.inPhrase(nonClausalConj))))).andNot(NodePattern.N.noSpaceAround().directlyAfter(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.not(NodePattern.N.withNextSibling(NodePattern.N)).noDependents("mark", NodePattern.N.form("um")).withHead(NodePattern.N.withHeadRelation("conj").withNextSibling(NodePattern.N.withHeadRelation("conj").noDependents("nsubj(:pass)?|expl")))).andNot(NodePattern.N.withHead("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.noSpaceBefore().noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("dep").noPos("ADV:PRO"))).andNot(NodePattern.N.withHead("acl|ccomp", NodePattern.N.lemma("sein|ich").withDependent("dep", NodePattern.N.pos("(SUB|PRO).*"))).trace("dep instead of nsubj")).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("acl"))).andNot(NodePattern.N.withHead(NodePattern.N.form(".+,.*"))).andNot(NodePattern.N.withPhraseStart(CommonPatterns.capitalized.withHeadRelation("cc").andNot(CommonPatterns.firstToken))).andNot(NodePattern.N.withDependent("mark", NodePattern.N.withDependent(".*", NodePattern.not(NodePattern.N.form("so|besonders|gerade|,").andNot(NodePattern.N.directlyAfter(NodePattern.N.inFormSequence(1, ",", ".*").withHeadRelation("advmod")))))));
    static final NodePattern dipl = NodePattern.N.form("Dipl\\.?");

    PunctuationRules() {
    }

    static List<Rule> priorityRules() {
        return List.of(new ZeroWidthSpaceRule("Breitenlose Leerzeichen", "Unicode-Breitenlose-Leerzeichen in W\u00f6rtern finden und entfernen.", "https://de.wikipedia.org/wiki/Breitenloses_Leerzeichen", "Dieses Wort enth\u00e4lt unsichtbare breitenlose Leerzeichen, entfernen?", "Sehr <b>einfa\u200bch</b>."));
    }

    static List<Rule> rules() {
        return List.of(new Rule.PatternRule("Punctuation.MISSING_DOT", "Fehlender Punkt am Ende des Satzes", "Am Satzende sollte ein Punkt stehen.", null, PunctuationRules.missingDot(), new Example("Sie haben <b>Recht</b> Ich bin daran schuld", MISSING_DOT_MSG, "Sie haben <b>Recht.</b> Ich bin daran schuld"), new Example("Sie ist noch nicht <b>da</b> Ich bin besorgt.", MISSING_DOT_MSG, "Sie ist noch nicht <b>da.</b> Ich bin besorgt.")), new Rule.PatternRule("Punctuation.IN_CLAUSE_COMMA", "Komma zwischen Satzgliedern", "Falsche Kommasetzung innerhalb eines Teilsatzes.", "https://www.korrekturen.de/zeichensetzung/folge09.shtml", NodePattern.or(PunctuationRules.singleInClauseComma(), PunctuationRules.parentheticalComma()), new Example("Ich werde <b>kommen</b> und zwar am Dienstag.", MISSING_IN_CLAUSE_COMMA, "Ich werde <b>kommen,</b> und zwar am Dienstag.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.INTER_CLAUSE_COMMA", "Komma zwischen Teils\u00e4tzen", "Teils\u00e4tze werden grunds\u00e4tzlich durch ein Komma oder andere Satzzeichen getrennt.", "https://www.lernhelfer.de/schuelerlexikon/deutsch/artikel/komma-bei-teilsaetzen/", NodePattern.or(PunctuationRules.coordinationComma(), PunctuationRules.subordinationComma()), new Example("Kommt es <b>vor</b><i> dass Sie im Traum Code schreiben</i>?", MISSING_COMMA_BEFORE_DEPENDENT_CLAUSE, "Kommt es <b>vor</b><i>, dass Sie im Traum Code schreiben</i>?"), new Example("Es ist ein <b>Hamster er</b> hei\u00dft Willy.", MISSING_COMMA_COORDINATION, "Es ist ein <b>Hamster, er</b> hei\u00dft Willy.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.EXCESSIVE_COMMA", "\u00dcberfl\u00fcssiges Komma", "Vermeiden Sie zus\u00e4tzliche Kommas, die nicht durch Regeln bestimmt sind.", "https://www.lernhelfer.de/schuelerlexikon/deutsch/artikel/komma-bei-teilsaetzen/", PunctuationRules.excessiveComma(), new Example("Ich suche eine <b>passende,</b> Wohnung f\u00fcr mich.", EXTRA_COMMA, "Ich suche eine <b>passende</b> Wohnung f\u00fcr mich.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.FORMATTING_ISSUES", "Leerzeichen und Satzzeichen", "Falsche Leerzeichensetzung und unm\u00f6gliche Satzzeichenkombinationen.", null, PunctuationRules.formattingIssues(), new Example("Zum <b>Beispiel,,</b> ein Hund.", DOUBLE_PUNCTUATION, "Zum <b>Beispiel,</b> ein Hund."), new Example("Zum <b>Beispiel ,</b> ein Hund.", FIX_SPACES, "Zum <b>Beispiel,</b> ein Hund."), new Example("Ich habe das <b>ge- macht</b>.", EXTRA_HYPHEN, "Ich habe das <b>gemacht</b>.")), new Rule.PatternRule("Punctuation.DIRECT_SPEECH", "Falsche Zeichensetzung bei direkter Rede", "In direkter Rede werden Anf\u00fchrungszeichen verwendet, um den w\u00f6rtlichen Text des Sprechenden abzugrenzen, w\u00e4hrend Kommas und Doppelpunkt Begleits\u00e4tze kennzeichnen.", "https://www.studienkreis.de/deutsch/woertliche-rede-direkte-rede/", PunctuationRules.directSpeech(), new Example("Sie sagte: \u201eIch habe kein <b>Schweinchen\u201c</b>", MISSING_PUNCTUATION_AFTER_DIRECT_SPEECH, "Sie sagte: \u201eIch habe kein <b>Schweinchen.\u201c</b>", "Sie sagte: \u201eIch habe kein <b>Schweinchen!\u201c</b>", "Sie sagte: \u201eIch habe kein <b>Schweinchen?\u201c</b>"), new Example("Sie <b>sagte</b> \u201eIch habe kein Schweinchen.\u201c", MISSING_PUNCTUATION_BEFORE_DIRECT_SPEECH, "Sie <b>sagte:</b> \u201eIch habe kein Schweinchen.\u201c"), new Example("\u201eIch habe kein <b>Schweinchen\u201c</b> sagte sie.", MISSING_COMMA_AFTER_DIRECT_SPEECH, "\u201eIch habe kein <b>Schweinchen\u201c,</b> sagte sie.")), new Rule.PatternRule("Punctuation.QUOTE_PUNCTUATION", "Anf\u00fchrungszeichen in Kombination mit anderen Satzzeichen", "Bei Verwendung von Anf\u00fchrungszeichen werden andere Satzzeichen entweder vor dem schlie\u00dfenden Anf\u00fchrungszeichen\nplatziert, wenn sie Teil des zitierten Textes nach einem Doppelpunkt sind, oder nach dem schlie\u00dfenden Anf\u00fchrungszeichen,\nwenn sie zum umgebenden Satz geh\u00f6ren.\n", "https://www.duden.de/sprachwissen/sprachratgeber/Anf\u00fchrungszeichen-Kombination-mit-anderen-Satzzeichen", PunctuationRules.quotePunctuation(), new Example("Das Zitat stammt aus dem Film \u201e<b>Casablanca.\u201c</b>", MOVE_PUNCTUATION_AFTER_QUOTE, "Das Zitat stammt aus dem Film \u201e<b>Casablanca\u201c.</b>")), new Rule.PatternRule("Typography.ABBREVIATION_SPACES", "Verwendung von Leerzeichen mit Abk\u00fcrzungen", "Fehlende Leerzeichen mit Abk\u00fcrzungen.", "https://www.uwefreund.com/fraguwe-de/din-5008/abkuerzung-mit-oder-ohne-leerzeichen-z-b-oder-z-b-v-oder-v/", PunctuationRules.missingSpaceWithAbbreviations(), new Example("Ich mag Tiere, <b>z.B.</b> Hunde", MISSING_SPACE_ABBREVIATION, "Ich mag Tiere, <b>z.\u00a0B.</b> Hunde"), new Example("Ich mag Tiere, <b>z.\u00a0B.</b>Hunde", MISSING_SPACE, "Ich mag Tiere, <b>z.\u00a0B.</b> Hunde")), new Rule.PatternRule("Punctuation.ABBREVIATION_PUNCTUATION", "Verwendung von Satzzeichen mit Abk\u00fcrzungen", "Fehlende oder \u00fcberfl\u00fcssige Punkte oder Bindestriche mit Abk\u00fcrzungen.", "https://www.korrekturen.de/zeichensetzung/folge02.shtml", NodePattern.or(PunctuationRules.incorrectAbbreviationSeparation(), PunctuationRules.removeDotAfterAbbreviation(), PunctuationRules.dotAfterDaysOfWeek(), PunctuationRules.dotsAndHyphenInDiplomaDegrees(), PunctuationRules.abbreviationsWithDot()), new Example("Ich mag Katze, Hunde, <b>u.s.w.</b>", ONE_DOT_ABBREVIATION, "Ich mag Katze, Hunde, <b>usw.</b>"), new Example("Unter der Betreuung von Herrn <b>Dipl Ing</b> Thorsten M\u00fcller.", PUNCTUATION_IN_DIPLOMA_DEGREES, "Unter der Betreuung von Herrn <b>Dipl.-Ing.</b> Thorsten M\u00fcller.")), new Rule.PatternRule("Typography.LEADING_HYPHEN_TO_DASH", "Verwechslung von Bindestrich und Gedankenstrich am Anfang des Satzes", "Wie Aufz\u00e4hlungszeichen wird der Gedankenstrich verwendet, nicht der Bindestrich.", "https://www.scribbr.de/wissenschaftliches-schreiben/bindestrich-gedankenstrich/", NodePattern.or(CommonPatterns.firstToken, NodePattern.N.directlyAfter(FormattingIssues.properlySpacedColon.and(CommonPatterns.reportWithPrevWord))).and(PunctuationRules.hyphenToDash()), new Example[]{new Example("<b>- Diagramme</b>", HYPHEN_TO_DASH_MSG, "<b>\u2013 Diagramme</b>")}){

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return client.supportsAutoFixes();
            }
        }, new Rule.PatternRule("Typography.HYPHEN_TO_DASH", "Verwechslung von Bindestrich und Gedankenstrich", "Der Bindestrich (-) vereint W\u00f6rter in Zusammensetzungen, w\u00e4hrend der Gedankenstrich (\u2013) zur Hervorhebung oder Unterbrechung eines Satzes und mit Von-bis-Angaben verwendet wird.", "https://www.duden.de/sprachwissen/rechtschreibregeln/gedankenstrich", PunctuationRules.hyphenToDash().directlyAfter(NodePattern.not(CommonPatterns.colon)), new Example("<b>1-3</b> QA-Fachkr\u00e4fte.", HYPHEN_VS_DASH_RANGE, "<b>1\u20133</b> QA-Fachkr\u00e4fte."), new Example("Er <b>kommt -</b> wie <b>immer -</b> zu sp\u00e4t.", "Meinten Sie den Gedankenstrich?; Meinten Sie den Gedankenstrich?", "Er <b>kommt \u2013</b> wie <b>immer \u2013</b> zu sp\u00e4t.")), new Rule.PatternRule("Typography.SPACES_IN_INITIALS", "Fehlende Leerzeichen in Namen mit Initialen", "Bei mehreren Vornamen werden die Initialen durch gesch\u00fctzte Leerzeichen getrennt. Zwischen dem abgek\u00fcrzten Vornamen und dem Nachnamen sollte auch ein gesch\u00fctztes Leerzeichen stehen.", "https://www.sekretaria.de/bueroorganisation/korrespondenz/din-5008/leerzeichen/", FormattingIssues.spacesWithNameInitials(null, NBSP_PROPER_NAME, NO_NBSP_PROPER_NAME, NodePattern.N.inFormSequence(0, 2, "z", "\\.", "B", "\\.")).noPos("ABK.*"), new Example("Wir haben <b>J.Lennon</b> getroffen.", NBSP_PROPER_NAME, "Wir haben <b>J.\u00a0Lennon</b> getroffen.")), new Rule.PatternRule("Typography.NUMBERS_WITH_UNITS", "Falsches oder Fehlendes Leerzeichen zwischen Zahl und Einheit", "Normalerweise ist ein gesch\u00fctztes Leerzeichen zwischen Zahl und Einheit zu setzen.", "https://www.scribbr.de/wissenschaftliches-schreiben/leerzeichen/", NodePattern.or(FormattingIssues.spacesAfterNumbers(List.of("%", "[$\u00a3\u20ac\u00a5\u20bd]", "EUR", "USD", "RUR", "[Kk][GgMmTt]|[Kk][Ww][Hh]|[Mk]t|[kKmMgGTPEZY]i?[Bb]|g|k?m[\u00b2\u00b3]", "\u00b0\\s?[CF]"), NBSP_NUMBER_UNIT, true), PunctuationRules.noSpaceBetweenNumberAndGrad()), new Example("Die <b>25\u20ac</b> werden ber\u00fccksichtigt", NBSP_NUMBER_UNIT, "Die <b>25\u00a0\u20ac</b> werden ber\u00fccksichtigt")), new Rule.PatternRule("Typography.NUMBER_FORMATTING", "Gruppierung der Ziffern in l\u00e4ngeren Zahlen", "L\u00e4ngere Zahlenfolgen werden zur besseren Lesbarkeit durch gesch\u00fctzte Leerzeichen oder Trennpunkte (bei Geldbetr\u00e4gen) gegliedert.", "https://www.pcs-campus.de/praxis/texten/zahlen_korrekt_schreiben/", NodePattern.or(PunctuationRules.numberFormatting(), FormattingIssues.ibanFormatting(NBSP_IBAN)), new Example("<b>4000</b> CI-Credits pro Monat.", NBSP_NUMBERS, "<b>4\u00a0000</b> CI-Credits pro Monat."), new Example("IBAN <b>DE89123447624758123400</b>", NBSP_IBAN, "IBAN <b>DE89\u00a01234\u00a04762\u00a04758\u00a01234\u00a000</b>")), new Rule.PatternRule("Punctuation.NO_PUNCT_AFTER_FAREWELL", "Satzzeichen nach der Gru\u00dfformel als Abschluss", "Nach der Schlussformel sollte kein Satzzeichen stehen.", "https://www.duden.de/sprachwissen/sprachratgeber/Die-Gru\u00dfformel-in-Brief-und-E-Mail", PunctuationRules.noCommaAfterFarewell(), new Example("<b>Liebe Gr\u00fc\u00dfe,</b> Anna", NO_PUNCTUATION_AFTER_FAREWELL, "Liebe <b>Gr\u00fc\u00dfe</b>\nAnna")), new Rule.PatternRule("Punctuation.DOT_AFTER_ORDINAL_NUMBER", "Punkt bei Ordinalzahlen", "Ordinalzahlen werden mit einem Punkt geschrieben.", "https://deutsch.lingolia.com/de/zeichensetzung/punkt#a-zahlen", NodePattern.or(PunctuationRules.dotAfterOrdinalNumbers(), PunctuationRules.noDotAfterCardinalNumbers(), PunctuationRules.spaceAfterOrdinalNumbers()), new Example("Ich habe am <b>3 </b>Juni Geburtstag.", DOT_AFTER_ORDINAL_NUM_MSG, "Ich habe am <b>3.\u00a0Juni</b> Geburtstag.")));
    }

    @Nullable
    private static List<CommaLicense> licenseCommasAround(Node node) {
        if (relativeOrAdverbialClause.matches(node)) {
            return Collections.singletonList(CommaLicense.forPhrase(node, CommaLicense.NeedCommas.around));
        }
        return null;
    }

    private static NodePattern noSpaceBetweenNumberAndGrad() {
        NodePattern gradWord = NodePattern.N.form("C(el[sc]ius)?|F(ah?renheit)?|K|R[\u00e9e\u00f8a]?|De?");
        NodePattern grad = NodePattern.N.form("[\u00b0\u2033\u2018]");
        return grad.spaceBefore().directlyAfter(NodePattern.N.form("(\\d|\\d[\\d,.\\s]*\\d)")).andNot(NodePattern.N.directlyBefore(gradWord)).andNot(NodePattern.N.withDependent("conj|nmod", grad.directlyBefore(gradWord))).and(CommonPatterns.forceConcatWithPrev).message("Vor dem Gradzeichen ohne Kennzeichnung der Skala ist kein Leerzeichen n\u00f6tig");
    }

    private static NodePattern singleInClauseComma() {
        NodePattern advmod = NodePattern.N.withHeadRelation("advmod");
        NodePattern noCommaAnchor = NodePattern.or(commaOrStronger.andNot(CommonPatterns.dot.directlyAfter(SemanticRules.daysOfWeekAbbr)), GermanTreePatterns.anyQuotation, GermanTreePatterns.dashes, NodePattern.N.form("[(<)>\\]\\[]"));
        NodePattern discourse = NodePattern.N.withHeadRelation("discourse");
        return NodePattern.or(NodePattern.N.form("sondern").noDependents("nsubj(:pass)?|i?obj|obl|nmod|compound"), CommonPatterns.firstChildPhrase.withHead("cc", NodePattern.N.withHeadRelation("conj")).form("aber"), NodePattern.not(commaOrStronger).directlyAfter(NodePattern.N.form("doch").directlyAfter(NodePattern.N.form("wenn|falls")).directlyBefore(NodePattern.or(GermanTreePatterns.finiteVerb, NodePattern.N.form("dann").directlyBefore(GermanTreePatterns.finiteVerb)))), NodePattern.N.form("n\u00e4mlich|insbesondere").beforeHead().and(CommonPatterns.firstChildPhrase).withHead(NodePattern.or(NodePattern.N.withHeadRelation("appos|conj").andOr(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("punct"))), NodePattern.N.withHead(NodePattern.not(NodePattern.ROOT))), amod.withPrevSibling(amod))), NodePattern.N.inFormSequence(0, "und", "zwar").withNeighbor(1, NodePattern.N.withHead(NodePattern.not(NodePattern.N.withNextSibling(NodePattern.not(NodePattern.PUNCT))))), NodePattern.N.inFormSequence(0, "vielleicht", "auch").andOr(CommonPatterns.firstChildPhrase, NodePattern.N.directlyAfter(advmod).withHead(NodePattern.or(NodePattern.N.directlyBefore(NodePattern.PUNCT), NodePattern.N.noDependents(NodePattern.N.afterHead()))), NodePattern.N.afterHead().withHead("advmod", NodePattern.N.withDependent("advmod", NodePattern.N.form("vielleicht").beforeHead())), NodePattern.N.withNeighbor(1, CommonPatterns.firstChildPhrase.withHead("advmod", advmod.afterHead()))), CommonPatterns.firstChildPhrase.inFormSequence(0, "und", "das").withNeighbor(1, NodePattern.N.withHead("conj", NodePattern.N.noPos("SUB.*NEU").withDependent("nsubj(:pass)?", NodePattern.N.noForm("das")))), PunctuationRules.zumBeispiel(), NodePattern.N.form("ander(er?)?seits").andOr(NodePattern.N.withHead(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").withDependent("advmod", NodePattern.N.form("einerseits"))), CommonPatterns.firstChildPhrase), looksLikeSecondPartConj.andOr(NodePattern.N.form("halb|teils"), NodePattern.N.form("so").withHead(NodePattern.N.noDependents("advcl"))), NodePattern.N.pos("ZAL").withDependent("nummod", NodePattern.N.pos("ZAL").directlyBeforeHead()), NodePattern.N.form("[0-9]").withHead("compound", NodePattern.N.withHeadRelation("nummod")).directlyAfterHead().includeIntoReport(), NodePattern.or(CommonPatterns.firstChildPhrase.withHead("det(:poss)?|compound", looksLikeCoordinatedNoun), looksLikeCoordinatedNoun).withOnlyDependents(NodePattern.N.afterHead()), NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.firstToken, NodePattern.N.directlyAfter(CommonPatterns.firstToken.and(NodePattern.PUNCT))).form("(na)?ja|nein")).withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|advmod"), NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("(na)?ja|nein").andOr(discourse, NodePattern.N.directlyAfter(NodePattern.N.form("na").and(discourse))), NodePattern.N.inFormSequence(1, "na", "(ja{1,4}|gut|also|bitte|prima|super|toll|klasse|klar|und|sch\u00f6n)").directlyAfter(NodePattern.or(CommonPatterns.firstToken, NodePattern.N.directlyAfter(CommonPatterns.firstToken.and(NodePattern.PUNCT)))))), NodePattern.or(CommonPatterns.skipUp("det", NodePattern.N.form("(\\d|[12]\\d|3[01])\\.([01]?\\d)\\.\\d{2}?\\d{2}")), CommonPatterns.skipForward(NodePattern.N.withHeadRelation("det"), NodePattern.N.form("\\d|[12]\\d|3[01]").directlyBefore(CommonPatterns.dot.andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceBefore()))))).directlyAfter(NodePattern.or(SemanticRules.dayOfWeek, CommonPatterns.skipBack(CommonPatterns.dot, SemanticRules.daysOfWeekAbbr))), repeatedAdv.correct(NodeCorrector.replace("")), gerneAuch.withNeighbor(1, NodePattern.N.withHead("advmod", NodePattern.or(NodePattern.N.withHeadRelation("obl").after(NodePattern.N.withHeadRelation("obl")), NodePattern.N.withHead("obl", NodePattern.N.withHeadRelation("[xc]comp")).afterHead())))).andNot(NodePattern.N.directlyAfter(NodePattern.or(noCommaAnchor, NodePattern.N.withHeadRelation("cc")))).andNot(noCommaAnchor).directlyAfter(CommonPatterns.reportWithPrevWord).correct(NodeCorrector.insertBefore(", ")).message(MISSING_IN_CLAUSE_COMMA);
    }

    private static NodePattern zumBeispiel() {
        NodePattern comment = NodePattern.or(CommonPatterns.closestDepToHead.withHead("obl", GermanTreePatterns.clause.withHeadRelation("a(dv)?cl|ccomp").withDependent("i?obj", NodePattern.N.beforeHead())).withNextSibling(NodePattern.not(NodePattern.N.withHeadRelation("obj"))), NodePattern.N.withHead("nmod", NodePattern.or(NodePattern.N.afterHead().withHead("ob[jl]", NodePattern.N.withHeadRelation("a(dv)?cl|[xc]comp")), NodePattern.N.afterHead().withHeadRelation("parataxis|obj").noDependents("nsubj(:pass)?"))), NodePattern.N.beforeHead().withHead("nmod", NodePattern.N.withHeadRelation("appos").afterHead()), NodePattern.N.withHead(amod.withPrevSibling(amod)));
        return NodePattern.or(NodePattern.N.inFormSequence(0, "zum", "Beispiel").withNeighbor(1, comment), NodePattern.N.inFormSequence(0, "z", "\\.", "B", "\\.").withNeighbor(2, comment)).and(CommonPatterns.firstChildPhrase).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("wie")));
    }

    private static NodePattern missingDot() {
        NodePattern hasSubjDependent = NodePattern.N.withDependent("nsubj(:pass)?|expl");
        NodePattern capitalizedAfterNoDot = CommonPatterns.capitalizedMiddle.directlyAfter(NodePattern.or(NodePattern.N.form("[.\\d\\p{L}'`\u00b4\u2019]*\\p{L}").noForm("dann"), GermanDateChecker.dottedDateNode).andNot(NodePattern.N.withHeadRelation("a(dv)?cl|ccomp|csubj(:pass)?|parataxis").andOr(NodePattern.N.noDependents(), NodePattern.N.lemma("sein").pos(".*AUX.*"))).markAs("DotAnchor").andNot(NodePattern.N.withHead(youKnowWho)).andNot(CommonPatterns.upperCase.form(".{3,}")).includeIntoReport().andOr(NodePattern.N.withHead(NodePattern.ROOT.withPhraseStart(CommonPatterns.skipForward(NodePattern.PUNCT, GermanTreePatterns.whPhrase.withHeadRelation("advmod")))).correct(NodeCorrector.insertAfter("?")), NodePattern.N.correct(NodeCorrector.insertAfter(".")))).andNot(NodePattern.N.form("weil").withHead(NodePattern.N.afterHead()));
        NodePattern looksLikeSeparateSentence = hasSubjDependent.withHeadRelation("a(dv)?cl|parataxis").andNot(youKnowWho);
        return NodePattern.N.withPhraseStart(capitalizedAfterNoDot).andOr(NodePattern.N.markAs("Parataxis").andOr(hasSubjDependent, NodePattern.N.withDependent("aux(:pass)?|cop", NodePattern.N.noPos("VER.*INF.*")), NodePattern.N.noPos("VER.*INF.*"), NodePattern.N.noDependents("ob[jl]|iobj|advmod")).andOr(NodePattern.N.withHead("parataxis", NodePattern.not(NodePattern.N.withOnlyDependents(NodePattern.N.alreadyMarkedAs("Parataxis")))), GermanTreePatterns.clause.withHead("conj", NodePattern.ROOT).andNot(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.PUNCT, NodePattern.N.withHeadRelation("cc"))))).afterHead().andNot(youKnowWho), NodePattern.N.withPrevSibling(looksLikeSeparateSentence.withPhraseEnd(NodePattern.N.alreadyMarkedAs("DotAnchor"))), hasSubjDependent.andNot(youKnowWho).withDependent(".*", CommonPatterns.closestDepToHead.and(looksLikeSeparateSentence).withPhraseStart(CommonPatterns.firstToken).withPhraseEnd(NodePattern.N.alreadyMarkedAs("DotAnchor"))), looksLikeSeparateSentence.withPhraseEnd(CommonPatterns.lastWord).andOr(NodePattern.N.withPrevSibling(NodePattern.N.withPhraseEnd(NodePattern.N.alreadyMarkedAs("DotAnchor"))), CommonPatterns.closestDepToHead.afterHead().withHead(hasSubjDependent.alreadyMarkedAs("DotAnchor")))).message(MISSING_DOT_MSG);
    }

    private static NodePattern numberFormatting() {
        String separators = "[,.]";
        NodePattern looksLikeTimeOrDate = NodePattern.or(NodePattern.N.form("\\d{1,2}\\.\\d{1,2}"), NodePattern.N.form("\\d{1,2}").directlyBefore(NodePattern.N.form("\\d\\d")));
        NodePattern money = CommonPatterns.skipUp("nummod", NodePattern.or(NodePattern.N.form("EUR|USD|RUR|RM|CHF|[$\u00a3\u20ac\u00a5\u20bd]"), SemanticRules.currencyName, NodePattern.N.inFormSequence(0, "US", "-", "Dollar|\\$")));
        java.util.regex.Pattern numPattern = java.util.regex.Pattern.compile("\\d+([" + separators + "\\s]\\d+)*(?!/?[\\d:-])");
        return NodePattern.N.form("[123456789]\\d*(" + separators + "(\\d{3}|00))*").and(CommonPatterns.skipUp("conj", NodePattern.or(NodePattern.N.withHeadRelation("nummod"), NodePattern.N.withHead("nmod", NodePattern.N.withHeadRelation("nummod")), NodePattern.N.withHeadRelation("nmod").withPrevSibling(NodePattern.N.withHeadRelation("nummod"))).andOr(NodePattern.N.beforeHead(), NodePattern.N.withHead(NodePattern.N.withHeadRelation("nummod"))))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form(".*\\d.*"))).andNot(NodePattern.N.form(".+" + separators + "00").directlyBefore(NodePattern.or(SemanticRules.currencyName, NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]")))).andOr(NodePattern.N.form(".+[" + separators + "\\s].+"), NodePattern.N.withHead(money), NodePattern.N.withHead(CommonPatterns.skipUp("nummod", NodePattern.not(NodePattern.or(NodePattern.N.pos("EIG.*").noDependents("flat"), NodePattern.N.label(".*"))).andNot(NodePattern.not(Case.hasMisparsedFlatHeadDependent).onlyPos(".*SIN.*")).noLemma("Jahr").andOr(CommonPatterns.withNumberLikeForm, NodePattern.N.anyPos(), NodePattern.N.form("%|.+[^\\p{L}].+"), GermanTreePatterns.englishWord, NodePattern.N.form("[Kk][GgMmTt]|[Kk][Ww][Hh]|[Mk]t|[kKmMgGTPEZY]i?[Bb]|g|k?m[\u00b2\u00b3]"), Case.hasMisparsedFlatHeadDependent)))).andNot(looksLikeTimeOrDate).andNot(NodePattern.N.withHead(NodePattern.or(GermanDateChecker.monthName, NodePattern.N.form("ende|beginn|jahr|uhr")))).and((firstNode, match) -> {
            int start = firstNode.startOffset();
            String text2 = firstNode.tree().text().substring(start);
            Matcher matcher = numPattern.matcher(text2);
            if (!matcher.lookingAt()) {
                return null;
            }
            int end = matcher.end();
            String numberText = text2.substring(0, end);
            String numberTextClean = numberText.replaceAll("\\D", "");
            if (numberTextClean.length() > 15) {
                return null;
            }
            long number = Long.parseLong(numberTextClean);
            boolean isMoney = money.matches(firstNode.head());
            if (isMoney && numberText.matches(".+" + separators + "00")) {
                return null;
            }
            String divider = isMoney && !GermanParameters.VARIANT.getValue(firstNode.tree()).equals("CH") ? "." : "\u00a0";
            String replacement = String.format(Locale.GERMAN, "%,d", number).replaceAll("\\.", divider);
            if (replacement.equals(numberText)) {
                return null;
            }
            String message = replacement.equals(numberText.replaceAll("\\s", "")) ? "\u00dcberfl\u00fcssige Leerzeichen in einer Zahl?" : (isMoney ? (divider.equals(".") ? DOT_MONEY_NUMBERS : NBSP_MONEY_NUMBERS) : NBSP_NUMBERS);
            return match.withCorrector(NodeCorrector.rawReplace(start, start + end, replacement)).withMessage(message);
        });
    }

    private static NodePattern formattingIssues() {
        NodePattern pairedPunctuationSpace = FormattingIssues.joinAdjacentFixes(NodePattern.or(CommonPatterns.openingParen, GermanTreePatterns.definitelyOpeningQuotation, NodePattern.or(GermanTreePatterns.ambiguousQuotation, NodePattern.N.form(",")).andOr(NodePattern.N.beforeHead().withHead(NodePattern.N.withDependent("punct", GermanTreePatterns.closingQuotation.afterHead().markAs("AnotherQuote"))), NodePattern.N.afterHead().withHead(NodePattern.N.noDependents(GermanTreePatterns.openingQuotation.beforeHead()).withHead(NodePattern.N.withDependent("punct", GermanTreePatterns.closingQuotation.afterHead().markAs("AnotherQuote"))))).and(hasCompatibleQuote)).and(q -> {
            Optional firstQuoteBehind = ((StreamEx)q.back().skip(1L)).findFirst(n -> GermanTreePatterns.anyQuotation.matches((Node)n));
            return firstQuoteBehind.isEmpty() || !GermanTreePatterns.definitelyOpeningQuotation.matches((Node)firstQuoteBehind.get());
        }).directlyBefore(NodePattern.N.form("\\p{L}+")).andOr(NodePattern.N.spaceBefore(), CommonPatterns.firstToken).andNot(NodePattern.N.form("\u2018").noSpaceBefore().directlyAfter(CommonPatterns.capitalized)).and(PairedPunctuation.Opening.checkSpace(MISSING_SPACE, "\u00dcberfl\u00fcssiges Leerzeichen")), NodePattern.or(CommonPatterns.closingParen, GermanTreePatterns.definitelyClosingQuotation, GermanTreePatterns.ambiguousQuotation.afterHead().withHead(NodePattern.N.withDependent("punct", GermanTreePatterns.closingQuotation.beforeHead().markAs("AnotherQuote"))).and(hasCompatibleQuote)).directlyAfter(NodePattern.N.form("\\p{L}+")).andNot(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.form("\\p{L}+"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\\d\\d"))).and(PairedPunctuation.Closing.checkSpace(MISSING_SPACE, "\u00dcberfl\u00fcssiges Leerzeichen")));
        NodePattern conjunction = NodePattern.N.pos("KON.*");
        NodePattern anyClosingQuote = GermanTreePatterns.anyQuotation.includeIntoReport().markAs("ClosingQuote");
        NodePattern commaAsPartQuotationMark = CommonPatterns.comma.directlyAfter(CommonPatterns.comma).withHead(NodePattern.or(NodePattern.N.directlyBefore(anyClosingQuote), NodePattern.N.withNextSibling(anyClosingQuote), NodePattern.N.withPhraseEnd(anyClosingQuote), NodePattern.N.withDependent("dep", GermanTreePatterns.apos.directlyAfter(GermanTreePatterns.apos).markAs("ClosingQuote"))));
        return NodePattern.or(NodePattern.or(NodePattern.N.form("\\.\\.").andNot(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.form("[?!]"))).andNot(NodePattern.N.noSpaceAfter().directlyAfter(NodePattern.N.noSpaceAfter()).directlyBefore(NodePattern.N)).and(CommonPatterns.reportWithPrevWord).andOr(NodePattern.N.directlyAfter(noSpaceWithEllipsis).correct(NodeCorrector.replace(".", "\u2026")), NodePattern.N.correct(NodeCorrector.replace(".", "\u00a0\u2026"))), FormattingIssues.doublePunctuation.andNot(commaAsPartQuotationMark)).message(DOUBLE_PUNCTUATION), CommonPatterns.dot.directlyAfter(NodePattern.N.withHead("nummod", NodePattern.N.form("Uhr")).noSpaceAfter()).and(CommonPatterns.reportWithPrevWord).message("Nach der Uhrzeit steht kein Punkt").correct(NodeCorrector.replace("")), FormattingIssues.punctWhitespace(m -> FIX_SPACES).andNot(NodePattern.N.directlyBefore(GermanTreePatterns.anyQuotation)).andNot(NodePattern.N.markAs("OpeningQuote").withHead(NodePattern.N.withDependent("punct", GermanTreePatterns.anyQuotation).withPhraseStart(NodePattern.N.alreadyMarkedAs("OpeningQuote")))).andNot(NodePattern.N.directlyBefore(NodePattern.N.withDependent("punct", GermanTreePatterns.anyQuotation.afterHead().noSpaceBefore()))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\\d+")).andOr(CommonPatterns.colon, CommonPatterns.comma.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE))).andNot(CommonPatterns.colon.noSpaceAfter().directlyBefore(NodePattern.N.form("[a-z_-]+"))), FormattingIssues.endWhitespace(m -> "Unpassendes Leerzeichen vor einem Satzzeichen"), FormattingIssues.quoteWhitespace(MISSING_SPACE_Q, "\u00dcberfl\u00fcssiges Leerzeichen?"), NodePattern.or(GermanParameters.deAtGerman.and(deAtQuotes.asymmetricalRule(Set.of("\u201d", "`", "\""))), NodePattern.not(GermanParameters.deAtGerman).and(genericQuotes.asymmetricalRule(Set.of("\u201d", "`", "\""))), CommonPatterns.comma.directlyBefore(commaAsPartQuotationMark).reportRangeTo("ClosingQuote").and((node, match) -> {
            Node closingQuote = match.getMarkedNode("ClosingQuote");
            NodeCorrector openQuote = NodeCorrector.replaceNodes(node, node.neighbor(1), "\u201e");
            if (GermanTreePatterns.apos.matches(closingQuote)) {
                return match.withCorrector(openQuote.join(NodeCorrector.replaceNodes(closingQuote.neighbor(-1), closingQuote, "\u201c")));
            }
            return match.withCorrector(openQuote.join(NodeCorrector.replace(closingQuote, "\u201c")));
        })).message("Diese Anf\u00fchrungszeichen geh\u00f6ren nicht zusammen"), pairedPunctuationSpace, FormattingIssues.multiWhiteSpace("Mehrere Leerzeichen"), FormattingIssues.trailingComma(GermanTreePatterns.clause.withDependent(".*", CommonPatterns.letterWord), "Unvollst\u00e4ndiger Satz?"), FormattingIssues.wordSplittingHyphen(EXTRA_HYPHEN).andNot(NodePattern.N.directlyAfter(GermanTreePatterns.englishWord)).andNot(NodePattern.N.directlyBefore(NodePattern.or(conjunction.andNot(NodePattern.N.withHead(derselbe)), NodePattern.N.withHeadRelation("parataxis")))), CommonPatterns.HYPHEN_NODE.directlyAfter(NodePattern.N.form("ein")).directlyBefore(conjunction.directlyBefore(derselbe).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE))).and(CommonPatterns.reportWithPrevWord).message(EXTRA_HYPHEN).correct(NodeCorrector.replace("")), FormattingIssues.singleHyphenWhitespace("\u00dcberfl\u00fcssiges Leerzeichen?", MISSING_SPACE, NodePattern.or(new NodePattern[0])).directlyBefore(NodePattern.not(NodePattern.N.pos("ZUS|PRP.*|KON.*|ABK.*")).andNot(NodePattern.PUNCT).andNot(NodePattern.N.withHead("conj", NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE.noSpaceAfter())))).directlyAfter(NodePattern.not(NodePattern.N.pos("ZUS|(PRP|KON|ART|ADV).*")).andNot(NodePattern.PUNCT)), FormattingIssues.sentenceStartingPunctuation("Unpassendes Satzzeichen am Satzanfang"), FormattingIssues.wordInternalPunctuation(MISSING_SPACE_Q, "aber|doch|und|oder").andNot(Gender.genderSymbolForm).noFormCaseSensitive("\\p{L}+\\?\\p{Ll}\\p{L}+").andNot(NodePattern.N.withHeadRelation("compound").withDependent("punct", NodePattern.N.directlyAfterHead())), FormattingIssues.joinedNumberWord(MISSING_SPACE_Q, "EIG.*", word -> word.form().length() >= 4 || word.form().length() >= 2 && word.hasPos("KON.*|PRP.*")).noHeadRelation("compound").noForm("\\d+0g?er?n"), PunctuationRules.excessiveEllipsisGerman(), FormattingIssues.noSpaceWithBrackets(MISSING_SPACE_Q), FormattingIssues.leadingHyphen("Unn\u00f6tiger Bindestrich?").andNot(CommonPatterns.lastToken).andNot(insideSingleQuotes).andNot(NodePattern.N.directlyAfter(conjunction)).andNot(NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "Pop", "-", "up"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("(Zeichens?|Taste|Symbol[es]?|Wert(e[sn]?|s)?)"))).andNot(pairedCompounds), PunctuationRules.missingQuestionMark(), PunctuationRules.hyphenSpaceConj(), PunctuationRules.misplacedCurrencySymbol(), FormattingIssues.colonDash("Ein Bindestrich nach einem Doppelpunkt wird normalerweise in eine neue Zeile gesetzt"), PunctuationRules.wrongApostrophe(), PunctuationRules.commaBeforeParenthesis(), PunctuationRules.dotBeforeParenthesis(), PunctuationRules.spaceWithEllipsis());
    }

    private static NodePattern spaceWithEllipsis() {
        return CommonPatterns.ellipsis.andOr(NodePattern.N.directlyAfter(CommonPatterns.letterWord.andNot(noSpaceWithEllipsis).andOptionally(NodePattern.N.spaceAfter().markAs("HasSpace")).and((node, match) -> {
            boolean hasSpace;
            String replacement = node.form() + "\u00a0\u2026";
            boolean bl = hasSpace = match.findMarkedNode("HasSpace") != null;
            if (hasSpace && node.tree().text().substring(node.startOffset(), node.neighbor(1).endOffset()).equals(replacement)) {
                return null;
            }
            String message = "Setzen Sie vor den Auslassungspunkten ein" + (hasSpace ? " gesch\u00fctztes" : "") + " Leerzeichen, wenn diese f\u00fcr ein oder mehrere W\u00f6rter stehen";
            return match.withCorrector(NodeCorrector.rawReplace(node.startOffset(), node.neighbor(1).endOffset(), replacement).batchCapable("spaceWithEllipsis")).enableAutoFix().withMessage(message);
        })), NodePattern.N.directlyBefore(CommonPatterns.letterWord.andNot(noSpaceWithEllipsis).and(CommonPatterns.firstWord).andNot(GermanTreePatterns.headInQuotes).andOptionally(NodePattern.N.spaceBefore().markAs("HasSpace")).and((node, match) -> {
            boolean hasSpace;
            String replacement = "\u2026\u00a0" + node.form();
            boolean bl = hasSpace = match.findMarkedNode("HasSpace") != null;
            if (hasSpace && node.tree().text().substring(node.neighbor(-1).startOffset(), node.endOffset()).equals(replacement)) {
                return null;
            }
            String message = "Setzen Sie nach den Auslassungspunkten ein" + (hasSpace ? " gesch\u00fctztes" : "") + " Leerzeichen";
            return match.withCorrector(NodeCorrector.rawReplace(node.neighbor(-1).startOffset(), node.endOffset(), replacement).batchCapable("spaceWithEllipsis")).enableAutoFix().withMessage(message);
        })));
    }

    private static NodePattern excessiveEllipsisGerman() {
        return NodePattern.N.form("\\.{4,8}").andOr(NodePattern.N.directlyAfter(NodePattern.not(noSpaceWithEllipsis)).correct(NodeCorrector.replace("\u00a0\u2026")), NodePattern.N.correct(NodeCorrector.replace("\u2026"))).message("Unn\u00f6tige Punkte");
    }

    private static NodePattern dotBeforeParenthesis() {
        return CommonPatterns.dot.markAs("Dot").includeIntoReport().directlyBefore(CommonPatterns.closingParen.markAs("ClosingP").withHead("punct", NodePattern.N.withDependent("punct", CommonPatterns.openingParen.and(CommonPatterns.firstChildPhrase).before("ClosingP").markAs("OpeningP"))).andOr(NodePattern.N.directlyBefore(CommonPatterns.dot.and(CommonPatterns.lastToken)).and(NodePattern.markedNodeMatches("Dot", NodePattern.N.correct(NodeCorrector.replace("")))), NodePattern.markedNodeMatches("OpeningP", NodePattern.N.directlyBefore(CommonPatterns.lowerCase)).and(CommonPatterns.lastToken.includeIntoReport().correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), ")."))))).directlyAfter(CommonPatterns.letterWord.noPos("ABK.*").includeIntoReport()).andNot(FormattingIssues.abbrOrNameDot(abbrPattern)).message("Der Punkt steht nicht vor der Klammer, wenn ein Satzteil eingeklammert ist");
    }

    private static NodePattern commaBeforeParenthesis() {
        return CommonPatterns.comma.markAs("Comma").directlyBefore(CommonPatterns.openingParen.markAs("OpeningP").withHead("punct", NodePattern.N.withHeadRelation("parataxis").withDependent("punct", CommonPatterns.closingParen.after("OpeningP")))).directlyAfter(CommonPatterns.letterWord.includeIntoReport()).correct(NodeCorrector.replace("")).message("\u00dcberfl\u00fcssiges Komma vor der Klammer?");
    }

    private static NodePattern wrongApostrophe() {
        String incorrect = "[\u00b4`\u2018]";
        String suffix = "(s|sche[mrns]?|ne?)";
        NodePattern afterReportedWord = NodePattern.N.directlyAfter(CommonPatterns.letterWord.includeIntoReport());
        return NodePattern.or(NodePattern.or(NodePattern.N.form(".*" + incorrect + suffix).noLabel(".*").andOr(afterReportedWord, NodePattern.N.form(".+" + incorrect + ".+")), NodePattern.N.form("c" + incorrect + "t")).correct(NodeCorrector.regexReplace("(.*)" + incorrect + "(.+)", "$1\u2019$2")), NodePattern.N.form(incorrect + suffix).noLabel(".*").correct(NodeCorrector.regexReplace(incorrect + "(.*)", "\u2019$1")), NodePattern.N.inFormSequence(0, incorrect, suffix).noSpaceAfter().correct(NodeCorrector.replace("\u2019")).reportEverythingTouched().and(afterReportedWord)).message("Meinten Sie einen Apostroph?");
    }

    private static NodePattern misplacedCurrencySymbol() {
        return NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]").directlyBefore(NodePattern.N.form("\\d+").markAs("Digit")).andNot(CommonPatterns.insideQuotes).and((symbol, match) -> match.withCorrector(NodeCorrector.replace(symbol, "").join(NodeCorrector.insertAfter(match.getMarkedNode("Digit"), "\u00a0" + symbol.form()))).withMessage("Das W\u00e4hrungssymbol wird normalerweise nach dem Betrag geschrieben"));
    }

    private static NodePattern missingSpaceWithAbbreviations() {
        Pattern abbr = AbbreviationPatterns.withPunctCaseSensitive(Language.GERMAN);
        NodePattern nonAbbrAfter = NodePattern.or(NodePattern.N.anyPos(), NodePattern.N.form(".*\\.[\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w]{3,}").andOr(NodePattern.N.spaceAfter(), CommonPatterns.lastToken));
        return NodePattern.or(WordSeparation.abbrOrNoPos.noSpaceAfter().directlyBefore(CommonPatterns.dot).andNot(dipl), NodePattern.N.form(".+\\..*").andNot(NodePattern.N.withHead(dipl))).andNot(CommonPatterns.lastToken).andNot(NodePattern.N.withDependent(".*", dipl.beforeHead())).and((n, match) -> {
            int end;
            String sentenceText = n.tree().text();
            String relevantFragment = sentenceText.substring(n.startOffset());
            TextRange foundAbbr = abbr.find(relevantFragment).stream().filter(a -> a.getStart() < n.form().length()).max(Comparator.comparingInt(a -> a.getEndExclusive() - a.getStart())).orElse(null);
            if (foundAbbr == null) {
                return null;
            }
            int start = foundAbbr.getStart() + n.startOffset();
            String abbrText = sentenceText.substring(start, end = foundAbbr.getEndExclusive() + n.startOffset());
            if (mistakenlyDottedAbbreviations.contains(abbrText)) {
                return null;
            }
            String dotSpaceLetter = "\\. ?(?=[\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w])";
            if (abbrText.matches(".*" + dotSpaceLetter + ".*")) {
                String replacement = abbrText.replaceAll(dotSpaceLetter, ".\u00a0");
                return match.withCorrector(NodeCorrector.rawReplace(new ai.grazie.rules.tree.TextRange(start, end), replacement).batchCapable("AbbreviationNbsp")).withReportedRange(start, end, n.tree()).enableAutoFix().withMessage(MISSING_SPACE_ABBREVIATION);
            }
            String textAfter = sentenceText.length() > end + 1 ? sentenceText.substring(end, end + 1) : null;
            Node nodeAfter = n.tree().findBestNodeAt(end + 1);
            if (textAfter != null && textAfter.matches("[\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w]") && nonAbbrAfter.matches(nodeAfter)) {
                return match.withCorrector(NodeCorrector.rawReplace(new ai.grazie.rules.tree.TextRange(end, end), " ").batchCapable("AbbreviationNbsp")).withReportedRange(start, end, n.tree()).enableAutoFix().withMessage(MISSING_SPACE);
            }
            return null;
        });
    }

    private static NodePattern removeDotAfterAbbreviation() {
        NodePattern looksLikeSentenceStart = CommonPatterns.capitalized.markAs("Start").spaceBefore().andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Start")), NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("Start")))));
        NodePattern abbrDot = NodePattern.N.inFormSequence(1, "\\p{L}{1,4}", "\\.").noSpaceBefore();
        return abbrDot.directlyAfter(NodePattern.not(CommonPatterns.capitalized).spaceBefore().and(abbr -> mistakenlyDottedAbbreviations.contains(abbr.form() + "."))).reportEverythingTouched().andNot(CommonPatterns.lastToken).andNot(NodePattern.N.directlyBefore(NodePattern.PUNCT.and(CommonPatterns.lastToken))).andNot(NodePattern.N.directlyBefore(NodePattern.or(looksLikeSentenceStart, CommonPatterns.capitalized.noSpaceBefore()))).andNot(NodePattern.N.withNeighbor(-2, abbrDot)).andNot(NodePattern.N.withNeighbor(2, abbrDot)).correct(NodeCorrector.replace("")).message("Diese Abk\u00fcrzung sollte ohne Punkt geschrieben werden");
    }

    private static NodePattern dotAfterDaysOfWeek() {
        NodePattern brevityAllowed = CommonPatterns.possiblySkipDown("appos|nmod", NodePattern.N.withDependent("i?obj|obl|nmod|nummod", NodePattern.not(NodePattern.N.inPhrase(GermanTreePatterns.clause)).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det"))))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("i?obj|obl|nmod").withDependent("case")));
        NodeCorrector.Relative insertPeriodAfterDaysOfWeekAbbr = NodeCorrector.insertAfter(NodePointer.anchor(), ".");
        return NodePattern.N.formCaseSensitive("Mo|Di|Mi|Do|Fr|Sa|So").andOr(NodePattern.N.spaceAfter(), NodePattern.N.directlyBefore(NodePattern.PUNCT.noForm("\\."))).andNot(NodePattern.N.directlyBefore(CommonPatterns.SOFT_HYPHEN_NODE)).andNot(CommonPatterns.possiblySkipUp("conj", NodePattern.or(NodePattern.N.withDependent("appos", brevityAllowed), NodePattern.N.withHead("appos", brevityAllowed)))).noHeadRelation("compound|flat|aux|advmod").noLabel("PERSON|LOCATION|MISC|PRODUCT").andNot(NodePattern.N.withHeadRelation("root|xcomp|discourse").pos("ADV:MOD")).andNot(NodePattern.N.withDependent("flat", GermanTreePatterns.englishWord)).andNot(NodePattern.N.withHead("nsubj", NodePattern.or(NodePattern.N.pos("VER:2:SIN.*NON"), NodePattern.N.withDependent("aux")))).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("\\u2026"), NodePattern.N.form("\\..*").withHeadRelation("punct")))).message("Diese Abk\u00fcrzung sollte mit Punkt geschrieben werden").correct(insertPeriodAfterDaysOfWeekAbbr);
    }

    private static NodePattern incorrectAbbreviationSeparation() {
        return NodePattern.or(WordSeparation.abbrOrNoPos.noSpaceAfter().directlyBefore(CommonPatterns.dot), NodePattern.N.form(".+\\..*")).andNot(CommonPatterns.lastToken).and((n, match) -> {
            String sentenceText = n.tree().text();
            String relevantFragment = sentenceText.substring(n.startOffset());
            String pattern = "(b\\. *z\\. *w\\.+|c\\. *a\\.+|e\\. *t\\. *c\\.+|g\\. *g\\. *f\\.+|l\\. *f\\. *d\\.+|p\\. *p\\. *a\\.+|u\\. *s\\. *[wf]\\.+|v\\. *g\\. *l\\.+|z\\. *z\\. *t\\.+)";
            java.util.regex.Pattern regex = java.util.regex.Pattern.compile(pattern);
            Matcher matcher = regex.matcher(relevantFragment);
            if (!matcher.lookingAt()) {
                return null;
            }
            String replacement = matcher.group().replaceAll("\\.+ *", "") + ".";
            return match.withCorrector(NodeCorrector.rawReplace(n.startOffset(), n.startOffset() + matcher.end(), replacement)).withMessage(ONE_DOT_ABBREVIATION);
        });
    }

    private static NodePattern missingQuestionMark() {
        NodePattern leftmostChildNoPunctNoCC = NodePattern.custom(node -> {
            Node head = node.head();
            if (head == null || head.isBefore((Node)node)) {
                return false;
            }
            for (Node dep : head.allDependents()) {
                if (dep == node) {
                    return true;
                }
                if (dep.hasHeadRelation("punct|cc")) continue;
                return false;
            }
            return false;
        });
        return CommonPatterns.lastToken.and(CommonPatterns.dot).markAs("Dot").andOr(NodePattern.N.withHead("punct", NodePattern.ROOT.andOr(NodePattern.N.withDependent("cop|aux.*", leftmostChildNoPunctNoCC.noPos(".*KJ1.*").noDependents().andNot(NodePattern.N.withPrevSibling(NodePattern.not(NodePattern.PUNCT)))).withDependent("nsubj.*", NodePattern.N.pos(".*")).andOr(NodePattern.N.withDependent("iobj|ob[lj]"), NodePattern.N.withDependent("cop")), NodePattern.N.withDependent("advmod|det|obl|obj|nsubj.*", leftmostChildNoPunctNoCC.andOr(GermanTreePatterns.whPhrase, NodePattern.N.withDependent("advmod", GermanTreePatterns.whWord)).andNot(afterIrgend).andOr(CommonPatterns.beforeSkipping(NodePattern.N.withHeadRelation("advmod"), NodePattern.or(NodePattern.ROOT.pos("(VER|SUB):.*").noDependents("ccomp"), NodePattern.N.withHeadRelation("cop|aux.*"))), NodePattern.N.withHead(NodePattern.N.form("nicht"))).andNot(NodePattern.N.inFormSequence(1, "so", "was"))).andOptionally(NodePattern.N.withDependent("case", NodePattern.N.form("f\u00fcr")).correct(NodeCorrector.replace(NodePointer.marked("Dot"), "!"))), NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.afterHead(), NodePattern.N.withHeadRelation("cc"))).andOr(GermanTreePatterns.whPhrase.andNot(afterIrgend).andOptionally(NodePattern.N.inFormSequence(0, "w.*", "f\u00fcr").correct(NodeCorrector.replace(NodePointer.marked("Dot"), "!"))), NodePattern.N.pos("VER:2.*").noPos("VER:.*IMP.*").withDependent("nsubj", NodePattern.N.form("du")).noDependents("cop|aux.*"))).noDependents("advmod", NodePattern.N.form("jedenfalls")).noDependents("conj|csubj|parataxis").noDependents("ccomp", NodePattern.N.withDependent("mark", NodePattern.N.form("dass")))), NodePattern.N.inFormSequence(2, ",", "richtig", "\\.").correct(NodeCorrector.replace("!")), NodePattern.N.inFormSequence(2, ",", "oder", "\\."), NodePattern.N.inFormSequence(3, ",", "oder", "nicht", "\\.").andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("csubj"))), NodePattern.N.inFormSequence(3, ",", "nicht", "wahr", "\\.")).andNot(NodePattern.N.after(NodePattern.N.form("\\?"))).and(CommonPatterns.reportWithPrevWord).correct(NodeCorrector.replace("?")).message("Sollte hier ein Fragezeichen verwendet werden?");
    }

    private static NodePattern quotePunctuation() {
        return NodePattern.or(FormattingIssues.missingSentenceDotAfterQuotedAbbreviation(abbrPattern).directlyAfter(NodePattern.custom(n -> !mistakenlyDottedAbbreviations.contains(n.form() + "."))).message("Auf schlie\u00dfende Anf\u00fchrungszeichen folgt ein Punkt, wenn ihnen im Rahmen einer Abk\u00fcrzung ein Punkt vorangestellt ist"), FormattingIssues.punctQuoteSentenceEnd.and(CommonPatterns.dot).withHead("punct", NodePattern.N.withHeadRelation("parataxis")).and((p1, match) -> {
            Node p2 = p1.neighbor(2);
            match = p2.hasForm("\\.") ? match.withCorrector(NodeCorrector.replace(p2, "")) : match.withCorrector(NodeCorrector.replace(p1, ""));
            return match.withMessage("\u00dcberfl\u00fcssiger Punkt?");
        }), FormattingIssues.punctBeforeQuote(abbrPattern).and(CommonPatterns.dot).withNeighbor(2, NodePattern.N.form(",")).correct(NodeCorrector.replace("")).message("\u00dcberfl\u00fcssiger Punkt in Anf\u00fchrungszeichen?"), FormattingIssues.movePunctBeforeQuote.and(CommonPatterns.lastToken.form("\\?").withHead("punct", GermanTreePatterns.clause.withDependent(".*", NodePattern.not(NodePattern.PUNCT)).andNot(NodePattern.ROOT))).message("Sollte das Ausrufezeichen vor dem Anf\u00fchrungszeichen stehen?"), FormattingIssues.movePunctAfterQuote(abbrPattern).andOr(NodePattern.N.form("[.?]").directlyBefore(CommonPatterns.lastToken).withHead("punct", NodePattern.not(NodePattern.N.withHead("parataxis|[xc]comp", NodePattern.or(SemanticRules.directSpeechVerb, NodePattern.not(GermanTreePatterns.clause))).noDependents("mark", CommonPatterns.firstChildPhrase))).and(node -> {
            String openingQuote;
            String closingQuote = node.neighbor(1).form();
            String string = openingQuote = closingQuote.equals("\u201d") ? "\u201e" : genericQuotes.closingToOpening(closingQuote);
            if (openingQuote == null) {
                return false;
            }
            Optional closestQuote = node.back().findFirst(NodePattern.N.form(openingQuote)::matches);
            if (closestQuote.isEmpty()) {
                return false;
            }
            boolean noQuestionInQuotes = ((Node)closestQuote.get()).forward().noneMatch(NodePattern.or(GermanTreePatterns.whPhrase, NodePattern.N.noPos())::matches);
            Node firstNode = node.tree().nodes().get(0);
            NodePattern directSpeechStart = NodePattern.N.directlyAfter(NodePattern.N.form("[:,\u2014\u2013-]"));
            return !directSpeechStart.matches((Node)closestQuote.get()) && !CommonPatterns.firstToken.matches((Node)closestQuote.get()) && !GermanTreePatterns.anyQuotation.matches(firstNode) && (!node.hasForm("\\?") || noQuestionInQuotes);
        }), NodePattern.N.form("[;,]")).message(MOVE_PUNCTUATION_AFTER_QUOTE));
    }

    private static NodePattern directSpeech() {
        NodePattern directSpeechRightEdge = NodePattern.N.directlyBefore(SemanticRules.directSpeechVerb.markAs("SpeechVerb")).andOr(NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("SpeechVerb").withHeadRelation("parataxis")), NodePattern.N.afterHead().withHead("punct", NodePattern.N.markAs("CComp").withHead("ccomp", NodePattern.N.alreadyMarkedAs("SpeechVerb").noDependents("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.before("CComp")))));
        return NodePattern.or(closingQuoteDirectSpeech.and(CommonPatterns.lastToken).correct(NodeCorrector.insertBefore(".")).correct(NodeCorrector.insertBefore("!")).correct(NodeCorrector.insertBefore("?")).message(MISSING_PUNCTUATION_AFTER_DIRECT_SPEECH), FormattingIssues.movePunctBeforeQuote.directlyAfter(closingQuoteDirectSpeech.directlyBefore(CommonPatterns.lastToken.form("[.!?]")).withHead(NodePattern.N.withPhraseStart(CommonPatterns.colon))).message("Wenn ein Satz bei direkter Rede als Ganzes wiedergegeben wird, beh\u00e4lt er sein Satzschlusszeichen"), GermanTreePatterns.closingQuotation.spaceAfter().noSpaceBefore().and(directSpeechRightEdge).and(CommonPatterns.reportWithPrevWord).andOr(NodePattern.N.directlyAfter(NodePattern.N.form("[,;]").markAs("Inner")).correct(NodeCorrector.insertAfter(",").join(NodeCorrector.replace(NodePointer.marked("Inner"), ""))), NodePattern.N.correct(NodeCorrector.insertAfter(","))).message(MISSING_COMMA_AFTER_DIRECT_SPEECH), GermanTreePatterns.openingQuotation.markAs("OpeningQ").noSpaceAfter().directlyBefore(NodePattern.not(NodePattern.PUNCT)).andOr(NodePattern.N.withHead("punct", NodePattern.N.withPrevSibling(SemanticRules.directSpeechVerb)), NodePattern.N.withPrevSibling(SemanticRules.directSpeechVerb.withHeadRelation("parataxis")), NodePattern.N.directlyAfter(CommonPatterns.skipBack(NodePattern.PUNCT, SemanticRules.directSpeechVerb.markAs("SpeechVerb"))).withHead("punct", NodePattern.N.withHead("ccomp|parataxis", NodePattern.N.alreadyMarkedAs("SpeechVerb"))).markAs("CapitalizationCheck")).withHead(NodePattern.or(NodePattern.N.noDependents("punct", GermanTreePatterns.closingQuotation.after("OpeningQ")), NodePattern.N.withDependent("punct", GermanTreePatterns.closingQuotation.after("OpeningQ").markAs("ClosingQ")).noDependents("conj", NodePattern.N.after("ClosingQ")))).andOr(NodePattern.not(NodePattern.N.directlyAfter(NodePattern.N.form("[,:.]"))).spaceBefore().andOptionally(NodePattern.N.directlyAfter(NodePattern.PUNCT.markAs("PunctToDel").and(CommonPatterns.reportWithPrevWord))).and((n, match) -> {
            boolean notFirstQuote = ((StreamEx)n.back().skip(1L)).anyMatch(node -> GermanTreePatterns.anyQuotation.matches((Node)node));
            boolean upperCaseQuote = StringTools.startsWithUppercase((String)n.neighbor(1).form());
            if (!notFirstQuote && !upperCaseQuote) {
                return null;
            }
            String missingPunct = notFirstQuote ? "," : ":";
            Node punctToDel = match.findMarkedNode("PunctToDel");
            NodeCorrector resultCorrector = NodeCorrector.insertAfter(n.neighbor(-1), missingPunct);
            if (punctToDel != null) {
                resultCorrector = resultCorrector.join(NodeCorrector.removeNode(punctToDel));
            }
            return match.withCorrector(resultCorrector);
        }).message(MISSING_PUNCTUATION_BEFORE_DIRECT_SPEECH), NodePattern.N.alreadyMarkedAs("CapitalizationCheck").withHead("punct", NodePattern.N.withHead(NodePattern.ROOT)).directlyBefore(NodePattern.not(CommonPatterns.capitalized).andNot(NodePattern.PUNCT).and(CommonPatterns.capitalize())).message("In der direkten Rede werden Satzanf\u00e4nge gro\u00dfgeschrieben")));
    }

    private static NodePattern coordinationComma() {
        return needCoordinationComma.withPhraseStart(addCommaBefore.includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport())).message(MISSING_COMMA_COORDINATION);
    }

    private static NodePattern parentheticalComma() {
        NodePattern verbNSubjParataxis = SemanticRules.directSpeechVerb.withHeadRelation("parataxis").withOnlyDependents(NodePattern.N.withHeadRelation("punct|nsubj")).withDependent("nsubj", NodePattern.N.directlyAfterHead().directlyBefore(NodePattern.not(GermanTreePatterns.anyQuotation).andNot(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.withHeadRelation("mark"))))).directlyAfter(NodePattern.not(GermanTreePatterns.anyQuotation));
        return NodePattern.or(NodePattern.or(NodePattern.N.withDependent("advmod", NodePattern.N.inFormSequence(1, "und", "zwar")).withNextSibling(NodePattern.N.withHeadRelation("conj")), NodePattern.N.withHeadRelation("appos").withDependent("aux").withDependent("cop"), SpellingRules.noun.noPos(".*GEN.*").withHead("appos", SpellingRules.noun.noLemma("Gru(ss|\u00df)").markAs("Head")).noLabel("MISC").withPhraseStart(NodePattern.N.withHeadRelation("det(:poss)?").directlyAfter(NodePattern.N.alreadyMarkedAs("Head"))).withDependent(".*", NodePattern.N.afterHead()).noDependents("conj"), NodePattern.N.withHeadRelation("parataxis").andOr(NodePattern.or(NodePattern.N.pos("VER.*"), NodePattern.N.pos("ADJ:PRD:GRU").withDependent("cop")).withDependent("nsubj.*|expl", NodePattern.N.noDependents("case")), SpellingRules.noun.withPhraseStart(NodePattern.N.form("so"))).andNot(SemanticRules.directSpeechVerb.withDependent("nsubj", NodePattern.N.directlyAfterHead()).and(CommonPatterns.firstPhrase)).andNot(NodePattern.N.withPrevSibling(NodePattern.not(GermanTreePatterns.clause).and(CommonPatterns.firstWord))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHead("appos", NodePattern.ROOT))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("parataxis").withNextSibling(NodePattern.PUNCT))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("conj")).withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("cc")))).noDependents("conj").noDependents("nsubj.*", NodePattern.N.pos("KON:UNT")).andNot(NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(CommonPatterns.dot))).andNot(NodePattern.N.withPhraseEnd(NodePattern.PUNCT).withPhraseStart(NodePattern.or(NodePattern.PUNCT, NodePattern.N.directlyAfter(NodePattern.PUNCT)))).andNot(NodePattern.N.directlyAfter(GermanTreePatterns.ambiguousQuotation)).andNot(NodePattern.N.inFormSequence(1, "das", "hei(ss|\u00df)t")).andNot(NodePattern.N.inFormSequence(1, "Gott", "sei", "Dank"))).andOr(NodePattern.N.withNextSibling(NodePattern.N), NodePattern.N.withHeadRelation("appos")).andNot(youKnowWho), NodePattern.N.withDependent("advmod", gerneAuch), NodePattern.or(NodePattern.N.withHead("appos|conj", NodePattern.ROOT)).withPhraseStart(NodePattern.N.form("n\u00e4mlich|insbesondere")), verbNSubjParataxis).andNot(NodePattern.N.after(NodePattern.N.form("(wer|wen|wem|wann|wie|wo(hin|her)?|welch)"))).withPhraseStart(NodePattern.not(CommonPatterns.capitalizedMiddle.directlyAfter(CommonPatterns.upperCase))).withPhraseEnd(NodePattern.not(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("punct"))).includeIntoReport()).and((node, match) -> CommaLicense.surroundWithCommas(match, node.phraseStart(), node.phraseEnd(), "Fehlende Satzzeichen vor einem eingeschobenen Satz oder Ausdruck?", "Fehlende Satzzeichen nach einem eingeschobenen Satz oder Ausdruck?", "Fehlende Satzzeichen bei einem eingeschobenen Satz oder Ausdruck?", commaOrOpening, commaOrClosing));
    }

    private static NodePattern subordinationComma() {
        return needSubordinationComma.and((node, match) -> {
            NodeRange range = PunctuationRules.getNodeRangeForSubordinationComma(node);
            return CommaLicense.surroundWithCommas(match, range.start(), range.end(), MISSING_COMMA_BEFORE_DEPENDENT_CLAUSE, MISSING_COMMA_AFTER_DEPENDENT_CLAUSE, MISSING_COMMA_DEPENDENT_CLAUSE, commaOrOpening, commaOrClosing);
        });
    }

    static NodeRange getNodeRangeForSubordinationComma(Node node) {
        if (zusatz.matches(node)) {
            Node zusatzStart = node.neighbor(-1);
            if (NodePattern.N.directlyAfter(CommonPatterns.firstToken.and(GermanTreePatterns.whWord)).matches(zusatzStart)) {
                zusatzStart = zusatzStart.prevNode();
            }
            return new NodeRange(zusatzStart, node);
        }
        Node start = node.phraseStart();
        Node prev = start.prevNode();
        if (!commaOrOpening.matches(start) && eatLeft.matches(prev)) {
            start = prev;
        } else if (!commaOrOpening.matches(start) && misparsedClauseBegin.matches(prev)) {
            start = prev.hasForm("allem|anderem") && prev.prevNode() != null ? prev.prevNode().phraseStart() : prev.phraseStart();
        }
        Node end = node.phraseEnd();
        if (!commaOrClosing.matches(end) && misparsedClauseEnd.matches(end.nextNode())) {
            end = end.nextNode();
        }
        if (aclWithMisattachedConjAfter.matches(node) || ccompAdvclWithMisattachedConjAfter.matches(node)) {
            end = Objects.requireNonNull(node.nextSibling()).phraseEnd();
        }
        return new NodeRange(start, end);
    }

    private static NodePattern excessiveComma() {
        NodePattern subordinate = NodePattern.N.withHeadRelation("ccomp|a(dv)?cl|csubj");
        NodePattern parenthesisSurroundedByCommas = NodePattern.N.withHeadRelation("obl|nmod").withDependent("punct", CommonPatterns.comma.afterHead());
        NodePattern commaAfterDassWeil = NodePattern.N.directlyAfter(NodePattern.N.form("da(ss|\u00df)|weil").and(CommonPatterns.reportWithPrevWord).withHead("mark", NodePattern.or(subordinate, NodePattern.N.withHead("conj", subordinate), NodePattern.N.onlyPos("ADJ:PRD:GRU").withDependent("cop"))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("csubj|a(dv)?cl", NodePattern.N.beforeHead()))).andNot(NodePattern.N.withNextSibling(parenthesisSurroundedByCommas))).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("KON:UNT"))).andNot(NodePattern.N.beforeHead().withHead(parenthesisSurroundedByCommas));
        NodePattern modalLikeVerb = NodePattern.N.lemma("brauchen|scheinen|pflegen");
        NodePattern detached = NodePattern.or(NodePattern.not(NodePattern.N.withHeadRelation("conj")), NodePattern.N.withDependent("advmod", NodePattern.N.form("insbesondere"))).noDependents("cc").withPhraseStart(commaOrOpening);
        NodePattern zuInfClause = NodePattern.N.pos(".*INF.*").andOr(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("mark").form("zu")), NodePattern.N.pos(".*EIZ.*"));
        NodePattern directWO = NodePattern.or(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.afterHead(), NodePattern.N.withHeadRelation("punct|cc"))).noDependents("aux(:pass)?|cop"), NodePattern.N.withDependent("aux(:pass)?|cop", GermanTreePatterns.firstInPhraseAfterCommasOrConj));
        NodePattern looksLikeIndependentImperative = NodePattern.N.pos(".*IMP:SIN.*").withOnlyDependents(NodePattern.or(NodePattern.N.withHeadRelation("punct|cc"), NodePattern.N.afterHead())).withHead(NodePattern.N.withDependent("nsubj(:pass)?|expl", NodePattern.N.noForm("ich")));
        NodePattern comparativeComma = CommonPatterns.firstChildPhrase.withHead("punct", NodePattern.N.noDependents("nsubj(:pass)?|expl").noDependents("mark", NodePattern.N.form("zu")).andOr(NodePattern.N.withHead("advcl", NodePattern.N.withHeadRelation("advmod").pos("ADJ:PRD:KOM").directlyBefore("Comma")), NodePattern.N.withHead("nmod|obl", NodePattern.or(NodePattern.N.pos("ADJ:PRD:KOM"), NodePattern.N.withDependent("advmod", NodePattern.or(NodePattern.N.form("eher"), NodePattern.N.pos("ADJ:PRD:KOM"))), NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("amod", NodePattern.N.pos("ADJ.*KOM.*")))).markAs("Head")).withDependent("case", NodePattern.N.form("als")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"))))).directlyAfter(NodePattern.not(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").withPhraseStart(CommonPatterns.comma).andNot(NodePattern.N.alreadyMarkedAs("Head"))).includeIntoReport());
        NodePattern commaBeforeAuch = NodePattern.N.directlyBeforeHead().withHead(NodePattern.N.form("auch").directlyBefore(CommonPatterns.dot).andNot(NodePattern.N.withPrevSibling(GermanTreePatterns.verbalClause))).directlyAfter(NodePattern.N.includeIntoReport());
        NodePattern commaAfterConj = NodePattern.N.directlyAfterHead().withHead("punct", CommonPatterns.firstChildPhrase.withHead("cc", NodePattern.N.withHeadRelation("conj")).andNot(NodePattern.N.withNextSibling(NodePattern.or(NodePattern.N.withDependent("punct"), NodePattern.N.withHeadRelation("mark"), GermanTreePatterns.whWord))).includeIntoReport());
        NodePattern middlePhraseComma = NodePattern.not(CommonPatterns.firstChildPhrase).andNot(CommonPatterns.lastChildPhrase).directlyBefore(NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("Comma"))).directlyAfter(NodePattern.N.withHeadRelation("mark").includeIntoReport());
        NodePattern commaInsideNP = NodePattern.N.directlyAfterHead().withHead(NodePattern.N.withHead("det(:poss)?|[an]mod", NodePattern.N.markAs("NPHead").noDependents("punct", GermanTreePatterns.anyQuotation)).withOnlyDependents(NodePattern.N.alreadyMarkedAs("Comma")).includeIntoReport()).directlyBefore("NPHead");
        NodePattern withMarkedAdvmodNoQuestion = NodePattern.N.withDependent("advmod", NodePattern.N.alreadyMarkedAs("Advmod")).andNot(NodePattern.N.withPhraseEnd(CommonPatterns.questionMark));
        NodePattern commaAfterAdvmod = NodePattern.N.directlyAfterHead().withHead(NodePattern.N.withHeadRelation("advmod").andOr(CommonPatterns.firstWord.andOr(NodePattern.N.pos("ADV:MOD").noPos("KON.*"), NodePattern.N.onlyPos("ADJ:PRD:GRU")), NodePattern.N.inFormSequence(1, "sogar", "da")).markAs("Advmod").withNeighbor(2, NodePattern.or(NodePattern.N.pos("VER.*").andNot(NodePattern.N.pos(".*IMP.*").noDependents("nsubj")).and(withMarkedAdvmodNoQuestion), NodePattern.N.withHead("cop|aux(:pass)?|conj", withMarkedAdvmodNoQuestion))).noForm("also").includeIntoReport());
        NodePattern brauchenScheinenPflegenZuInf = NodePattern.N.directlyBefore(NodePattern.N.form("zu").directlyBefore(NodePattern.N.pos("VER.*INF.*").withHead("xcomp", modalLikeVerb))).directlyAfter(NodePattern.N.includeIntoReport());
        NodePattern nextSiblingIsConj = NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("conj"));
        NodePattern commaWithCoordinatingConj = CommonPatterns.firstChildPhrase.directlyBefore(NodePattern.or(NodePattern.N.form("und|noch|als|sowie").andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("advmod|mark").noForm("auch|sogar"))).andNot(NodePattern.N.inFormSequence(0, "und", "zwar|nicht|auch")).withHead("cc", NodePattern.not(NodePattern.N.withPrevSibling(detached)).andNot(NodePattern.N.withPrevSiblingIncludingOtherSide(NodePattern.N.withHeadRelation("dep"))).andOr(GermanTreePatterns.clause.withHead("conj|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", GermanTreePatterns.clause.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").markAs("Head")).noDependents("[nc]subj(:pass)?|expl").andNot(looksLikeIndependentImperative).noDependents("parataxis", CommonPatterns.insideQuotes).noDependents("ccomp", NodePattern.N.withDependent("ccomp", NodePattern.N.beforeHead())).andNot(NodePattern.N.noDependents("mark").withPrevSibling(NodePattern.N.withHeadRelation("conj")).withHead(NodePattern.N.withHeadRelation("acl"))).andOr(NodePattern.N.withHead(NodePattern.N.withHeadRelation("parataxis|root")), NodePattern.not(directWO.withHead(NodePattern.N.afterHead()))), NodePattern.not(GermanTreePatterns.clause).withHead("conj", NodePattern.not(GermanTreePatterns.clause).noDependents("nsubj(:pass)?|expl").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|advmod|root").markAs("Head")).noPos("ART.*").noDependents("advmod", NodePattern.N.form("nur|allein")).withPhraseStart(NodePattern.N.directlyAfter(NodePattern.not(CommonPatterns.skipUp("aux(:pass)?", CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").andNot(NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("punct|mark")))))))))).andNot(NodePattern.N.withHead(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("conj").withDependent("cc"))).noForm("sowie")), NodePattern.N.markAs("Conj").form("wie").withHead("case", NodePattern.not(GermanTreePatterns.clause).withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("advmod", NodePattern.N.form("ebenso").before("Conj")))), NodePattern.N.inFormSequence(0, "und", "so", "weiter|fort").withNeighbor(2, NodePattern.N.noDependents(NodePattern.N.afterHead()).noHeadRelation("advmod")), NodePattern.N.inFormSequence(0, "und", "dergleichen").withNeighbor(1, NodePattern.N.withHead(NodePattern.N.withHeadRelation("conj"))), NodePattern.N.inFormSequence(0, "et", "cetera"))).directlyAfter(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.not(detached.andNot(zuInfClause.withHeadRelation("xcomp").withDependent("conj", zuInfClause))).andNot(NodePattern.N.withHead(detached.andNot(NodePattern.N.alreadyMarkedAs("Head")))).andNot(NodePattern.N.withHead("aux(:pass)?|cop", NodePattern.N.withHeadRelation("a(dv)?cl|csubj|ccomp").and(nextSiblingIsConj).before("Comma"))).andNot(NodePattern.N.withHead("acl", NodePattern.N).noDependents("conj").andNot(nextSiblingIsConj)).reportRangeTo("Comma")));
        NodePattern commaBeforeEtcAndSimilar = unmandatedComma.directlyBefore(NodePattern.or(NodePattern.N.form("usw|etc").message("Anders als im Englischen wird im Deutschen vor \u201eetc.\u201c und \u201eusw.\u201c kein Komma gesetzt"), NodePattern.or(NodePattern.N.form("uvm|usf"), NodePattern.N.inFormSequence(0, "o", "\\.", "\u00c4", "\\."), NodePattern.N.inFormSequence(0, "u", "\\.", "([a\u00e4]|dgl)", "\\."), NodePattern.N.inFormSequence(0, "u", "\\.", "(v|dgl)", "\\.", "m"), NodePattern.N.inFormSequence(0, "u", "\\.", "s", "\\.", "f"), NodePattern.N.inFormSequence(0, "u", "\\.", "v", "\\.", "a", "\\.", "m")).message("Setzen Sie kein Komma am Ende einer Aufz\u00e4hlung")).andNot(NodePattern.N.withPrevSibling(CommonPatterns.skipUp("punct", NodePattern.N.withHeadRelation("advcl"))))).withHead(NodePattern.N.withHead("conj", CommonPatterns.possiblySkipUp("appos", NodePattern.N.anyPos()))).and(CommonPatterns.reportWithPrevWord);
        NodePattern commaBetweenClauseElements = NodePattern.or(CommonPatterns.lastChildPhrase.withHead("punct", NodePattern.or(CommonPatterns.capitalized.markAs("NomDep").withHead("nsubj(:pass)?|ob[lj]|iobj", NodePattern.not(SemanticRules.directSpeechVerb.andNot(NodePattern.N.withDependent("nsubj", NodePattern.N.directlyAfterHead().directlyBefore(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.withHeadRelation("mark"))))).and(NodePattern.markedNodeMatches("NomDep", CommonPatterns.closestDepToHead))).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.alreadyMarkedAs("Comma")))), NodePattern.N.withHead("nmod", GermanTreePatterns.clause.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").noDependents("parataxis", SemanticRules.directSpeechVerb)), CommonPatterns.firstChildPhrase.withHeadRelation("advmod").andOr(NodePattern.N.pos("ADV:(TMP|CAU)"), NodePattern.N.form("andere?nfalls")).withOnlyDependents(NodePattern.N.withHeadRelation("advmod|punct")).withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("aux(:pass)?|cop|root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").noDependents("aux(:pass)?|cop").andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.pos("ADV:CAU")).withPhraseEnd(NodePattern.N.form("\\?+.*|\\?!").andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("parataxis")))))))).andNot(NodePattern.or(NodePattern.N.label("PERSON").directlyBefore("Comma"), NodePattern.N.withDependent("appos", NodePattern.N.label("PERSON"))).noDependents("case")).noDependents("mark|a(dv)?cl|ccomp|cop|nsubj(:pass)?|aux(:pass)?|xcomp").noDependents("det", NodePattern.N.withDependent("punct", CommonPatterns.comma)).noDependents("punct", NodePattern.not(NodePattern.N.alreadyMarkedAs("Comma"))).noDependents("appos|[na]mod|conj|parataxis|det(:poss)?|case|advmod", NodePattern.or(NodePattern.N.withPhraseStart(CommonPatterns.comma), NodePattern.N.withDependent("appos|[na]mod|conj", NodePattern.N.withPhraseStart(CommonPatterns.comma)))).andNot(CommonPatterns.phraseStartsWithComma.noHeadRelation("advmod")).andNot(NodePattern.N.withNextSibling(CommonPatterns.phraseEndsWithComma)).andNot(NodePattern.N.withHeadRelation("obj").withDependent("nmod", NodePattern.N.withDependent("case").afterHead())).andNot(NodePattern.N.inFormSequence(1, "im", "gegenteil")).andNot(NodePattern.N.inFormSequence(1, "zur", "erinnerung")).andNot(NodePattern.N.inFormSequence(2, "mit|in", "anderen", "worten")).andNot(NodePattern.N.withHeadRelation("obl").withNextSibling(NodePattern.N.withHeadRelation("obl"))).andNot(NodePattern.N.withHeadRelation("nmod").withNextSibling(NodePattern.N.withHeadRelation("nmod"))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("det"))).andNot(GermanTreePatterns.firstInPhraseAfterCommasOrConj.withHeadRelation("obj").noDependents("det"))).andNot(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.phraseStartsWithComma, NodePattern.N.withHead(CommonPatterns.phraseStartsWithComma.noDependents(NodePattern.N.alreadyMarkedAs("Comma"))))).andNot(NodePattern.N.directlyAfterHead())).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("nmod").withPhraseStart(NodePattern.N.form("wie")))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("appos").withPhraseStart(NodePattern.PUNCT.andNot(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceBefore())).withPhraseEnd(NodePattern.not(NodePattern.PUNCT)))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("appos").withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.withHead(NodePattern.N.withHeadRelation("acl|xcomp")))))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHead(NodePattern.N.withHead("appos|parataxis", NodePattern.N.withHeadRelation("acl|xcomp"))))).andNot(NodePattern.N.directlyAfter(NodePattern.not(NodePattern.PUNCT).withHead(NodePattern.N.withHeadRelation("appos").withPhraseStart(NodePattern.PUNCT.andNot(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceBefore()))))).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.withHeadRelation("mark"), NodePattern.N.form("zeitgleich|da(nn)?|dort")))).andNot(CommonPatterns.insideQuotes).directlyAfter(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.markAs("ReportAnchor"))).and(NodePattern.custom((node, match) -> match.withReportedRange(new ai.grazie.rules.tree.TextRange(match.getMarkedNode("ReportAnchor").startOffset(), match.getMarkedNode("Comma").endOffset()), node.tree()))), CommonPatterns.firstChildPhrase.withHead("punct", NodePattern.or(NodePattern.N.withHead("acl", NodePattern.N.withHead("ob[jl]|iobj", NodePattern.N.lemma("sein|haben"))).onlyPos(".*PA2.*").pos(".*PA2:PRD.*").noDependents("aux(:pass)?|cop"), NodePattern.N.withHeadRelation("advcl").withDependent("mark", CommonPatterns.firstChildPhrase.form("wenn")).withPrevSibling(NodePattern.N.withHeadRelation("nmod").inFormSequence(1, "vor", "allem").and(CommonPatterns.phraseStartsWithComma)))).directlyAfter(NodePattern.N.includeIntoReport()), NodePattern.N.directlyAfter(NodePattern.N.pos("ADJ:PRD:GRU").includeIntoReport()).directlyBefore(NodePattern.N.form("wie").withHead("case", NodePattern.N.withHeadRelation("advcl")).directlyBeforeHead()), NodePattern.N.withHead("punct", NodePattern.ROOT.noMatchUntil("Comma", CommonPatterns.comma).noDependents("punct", CommonPatterns.comma.andNot(NodePattern.N.alreadyMarkedAs("Comma")))).withPrevSibling(NodePattern.N.withHeadRelation("cop|nsubj(:pass)?|obl|i?obj|nmod")).withNextSibling(NodePattern.N.withHeadRelation("cop|nsubj(:pass)?|obl|i?obj|nmod")).directlyAfter(NodePattern.not(GermanTreePatterns.anyQuotation).includeIntoReport()));
        return CommonPatterns.comma.spaceAfter().markAs("Comma").includeIntoReport().andOr(NodePattern.or(middlePhraseComma, commaInsideNP, commaAfterConj, commaBetweenClauseElements, commaAfterDassWeil, commaAfterAdvmod).message(EXTRA_COMMA), brauchenScheinenPflegenZuInf.message(BRAUCHEN_SCHEINEN_PFLEGEN_NO_COMMA), commaWithCoordinatingConj.message(CONJ_NO_COMMA), comparativeComma.message(COMPARATIVE_NO_COMMA), commaBeforeEtcAndSimilar, commaBeforeAuch.message("Anders als im Englischen wird \u201eauch\u201c im Deutschen nicht durch Komma abgetrennt")).correct(NodeCorrector.replace(""));
    }

    private static NodePattern hyphenSpaceConj() {
        return CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.withHeadRelation("cc").andOr(NodePattern.N.spaceAfter(), NodePattern.N.directlyBefore(CommonPatterns.dot))).directlyAfter(NodePattern.N.noForm(".").includeIntoReport()).includeIntoReport().correct(NodeCorrector.insertAfter(" ")).message(MISSING_SPACE);
    }

    private static NodePattern hyphenToDash() {
        NodePattern digits = NodePattern.N.form("\\d{1,5}");
        NodePattern beforeDigitsWithPossibleHyphen = NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.HYPHEN_LIKE_NODE.directlyBefore(digits), digits));
        NodePattern afterDigitsWithPossibleHyphen = NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.HYPHEN_LIKE_NODE.directlyAfter(digits), digits));
        NodePattern separatesRange = NodePattern.N.directlyBefore(digits.andNot(beforeDigitsWithPossibleHyphen).includeIntoReport()).directlyAfter(digits.andNot(afterDigitsWithPossibleHyphen).includeIntoReport());
        return NodePattern.or(CommonPatterns.dashLikeHyphens.includeIntoReport().withHead(NodePattern.not(NodePattern.N.withHead("compound|flat.*", NodePattern.or(NodePattern.N.label("ORGANIZATION|PRODUCT|EVENT"), NodePattern.N.withDependent("flat", NodePattern.not(CommonPatterns.letterWord))))).andNot(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("nummod"))).andNot(NodePattern.N.withHeadRelation("appos").noDependents("advmod|mark|ob[jl]|iobj|nmod|appos").andNot(NodePattern.N.withOnlyDependents(CommonPatterns.dashLikeHyphens.directlyAfter(CommonPatterns.dot)).directlyBefore(CommonPatterns.dot)))).andNot(CommonPatterns.lastToken).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(separatesRange).andOr(NodePattern.N.spaceBefore(), CommonPatterns.firstToken).andOr(NodePattern.N.spaceAfter(), CommonPatterns.lastToken, NodePattern.N.directlyBefore(CommonPatterns.comma)).noDependents().andOr(NodePattern.not(CommonPatterns.firstToken).and(CommonPatterns.reportWithPrevWord), NodePattern.not(CommonPatterns.lastToken).and(CommonPatterns.reportWithNext)).and((node, match) -> {
            NodeCorrector corrector = FormattingIssues.properlySpacedColon.matches(node.prevNode()) ? CommonPatterns.replaceWithWhitespace(node, "\n\u2013 ") : NodeCorrector.replace(node, "\u2013");
            return match.withCorrector(corrector.batchCapable("hyphenToDash")).enableAutoFix();
        }).message(HYPHEN_TO_DASH_MSG), CommonPatterns.HYPHEN_NODE.includeIntoReport().and(separatesRange).andOr(NodePattern.custom(hyphen -> {
            int right;
            int left = Integer.parseInt(hyphen.neighbor(-1).form());
            return !(left >= (right = Integer.parseInt(hyphen.neighbor(1).form())) || right > left * 10 || left > 100 && left % 10 != 0 || right > 100 && right % 10 != 0);
        }), NodePattern.N.inFormSequence(1, "[123][0-9]{3}", "-", "[123][0-9]{3}")).and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "\u2013").batchCapable("hyphenToDash")).enableAutoFix()).message(HYPHEN_VS_DASH_RANGE));
    }

    private static NodePattern noCommaAfterFarewell() {
        NodePattern markedComma = CommonPatterns.comma.markAs("Punct");
        NodePattern directlyBeforePunctuationMark = NodePattern.N.directlyBefore(NodePattern.PUNCT.and(markedComma));
        NodePattern withDependentComma = NodePattern.N.withDependent("punct", markedComma.beforeHead());
        return NodePattern.or(NodePattern.N.lemma(".*(gru\u00df|wunsch)").andNot(NodePattern.N.inPhrase(GermanTreePatterns.clause)).withDependent("amod", NodePattern.N.lemma("(freund(schaft)?|herz)lich|lieb|herzlich|gut|kollegial|allerbeste|sch\u00f6n|nett|viel|verbindlich|warm|warmherzig|aufrichtig|h\u00f6flich|sonnig|winterlich|sommerlich|herbstlich|umarmend").includeIntoReport()).andOr(directlyBeforePunctuationMark, NodePattern.N.withDependent("appos|vocative", withDependentComma), NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("appos|vocative").and(withDependentComma))), NodePattern.N.form("herzlichst").and(directlyBeforePunctuationMark), NodePattern.N.inFormSequence(0, "Alles", "Gute|Liebe").withDependent("appos", withDependentComma)).inPhrase(NodePattern.ROOT.withPhraseStart(NodePattern.N.reportRangeTo("Punct"))).message(NO_PUNCTUATION_AFTER_FAREWELL).and((node, match) -> {
            Node punct = match.getMarkedNode("Punct");
            Node next = punct.nextNode();
            if (next != null && !punct.tree().text().substring(punct.endOffset(), next.startOffset()).contains("\n")) {
                return match.withCorrector(NodeCorrector.rawReplace(punct.startOffset(), next.startOffset(), "\n"));
            }
            return match.withCorrector(NodeCorrector.replace(punct, ""));
        });
    }

    private static NodePattern dotAfterOrdinalNumbers() {
        NodePattern caseBeforeNum = NodePattern.N.withDependent("case", NodePattern.or(NodePattern.N.form("im|zu[mr]|beim|am"), NodePattern.N.form("in|zu|bei|an|ab").directlyBefore(NodePattern.N.withHeadRelation("det(:poss)?"))).before("Num"));
        String plural = ".*PLU.*";
        String nummodOrCompoundOrAmod = "nummod|compound|amod";
        return NodePattern.N.form("\\d+").markAs("Num").and(CommonPatterns.highlightWithTrailingSpace()).andOr(NodePattern.N.directlyBefore(GermanDateChecker.monthName).and((node, match) -> match.withCorrector(NodeCorrector.rawReplace(node.endOffset(), node.neighbor(1).startOffset(), ".\u00a0"))), NodePattern.N.directlyBeforeHead().withHead(nummodOrCompoundOrAmod, NodePattern.N.pos("SUB.*SIN.*").andNot(NodePattern.N.withDependent("flat", NodePattern.N.pos(plural).directlyAfter(CommonPatterns.HYPHEN_NODE))).noPos(plural)).andOr(caseBeforeNum, NodePattern.N.withHead(caseBeforeNum.noForm("(Jahres|Monats|Sekunden|Minuten|Stunden|Wochen).+|Uhr")), NodePattern.N.withHead(nummodOrCompoundOrAmod, NodePattern.N.withDependent("det").noForm("Prozent").andNot(NodePattern.N.withHead("compound", NodePattern.N.withDependent("compound", NodePattern.not(NodePattern.N.alreadyMarkedAs("Num"))))))).correct(NodeCorrector.insertAfter("."))).noDependents("advmod").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("als"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.dot)).message(DOT_AFTER_ORDINAL_NUM_MSG);
    }

    private static NodePattern spaceAfterOrdinalNumbers() {
        return NodePattern.or(NodePattern.N.formCaseSensitive("\\d+\\.\\p{Lu}\\p{L}+").withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").correct(NodeCorrector.regexReplace("(\\d+\\.)(.+)", "$1 $2")).message("Bei Ordnungszahlen folgt auf den Punkt ein Leerzeichen"), NodePattern.N.form("\\d{1,2}").noSpaceAfter().directlyBefore(CommonPatterns.dot.spaceAfter().directlyBefore(GermanDateChecker.monthName)).and((num, match) -> {
            String space = num.tree().text().substring(num.neighbor(1).endOffset(), num.neighbor(2).startOffset());
            if (space.equals("\u00a0")) {
                return null;
            }
            return match.withCorrector(NodeCorrector.rawReplace(num.neighbor(1).endOffset(), num.neighbor(2).startOffset(), "\u00a0")).withReportedRange(num.startOffset(), num.neighbor(2).endOffset(), num.tree());
        }).message("Bei Datumsangaben folgt auf den Punkt ein gesch\u00fctztes Leerzeichen"));
    }

    private static NodePattern noDotAfterCardinalNumbers() {
        return NodePattern.or(NodePattern.N.formCaseSensitive("\\d+\\.Uhr").withDependent("case", NodePattern.N.form("um")).correct(NodeCorrector.regexReplace("(\\d+)\\.(.+)", "$1 $2")), NodePattern.N.form("\\d{1,2}").withHead("nummod", NodePattern.N.form("Uhr").withDependent("case", NodePattern.N.form("um")).markAs("Head")).noSpaceAfter().directlyBefore(CommonPatterns.dot.spaceAfter().directlyBeforeHead().withHead("punct", NodePattern.N.alreadyMarkedAs("Head")).correct(NodeCorrector.replace(""))).reportEverythingTouched()).message("Auf Kardinalzahlen folgt kein Punkt");
    }

    private static NodePattern dotsAndHyphenInDiplomaDegrees() {
        String areaAbbr = "(Angl|Anim|(Berufs|Heil|Wi)?p\u00e4d|Bibl|Bio(l|in[fg]|math|chem|geogr|phys|technol)?|Chem(\\.oec)?|Demogr|Des|Dok|Dolm|Dram|(Fin|Immobilien|Land|Verw|Volks|Forst|Staats|Betriebs)w|Filmkomp|Ges\\.oec|Geo(gr|inf|l|\u00f6kol|phys)|Germ|Geront|G[hw]l|Gyml|Hdl|Hist(\\.Sc)?|Hydrol|Inf(orm|\\.(Wirt|wiss))?|(Sicherheits|Forst|Sport)?Ing|Journ|(Wi\\.)?Jur|Kam|Kf(m|fr?)|Krim|Kult|Komm\\.Psych|Kult\\.arb|(Kunst|Musik)therap|(Lebensmittel|LM)chem|Ling|Logist|Math?|Medien(inform|\u00f6k|w(iss)?)|Me[dt]|Mikrobiol|Min|Musikl|NanoSc|Nau?t|(Neuro|System|Umwelt|Freizeit|Sprech)wiss|Pfl|Pharm|Phil|Phys(\\.Ing)?|Pol|Pr\u00e4hist|Psych|Re[dg]|Rest|Rpfl|Rom|Schau|Schnittm|Soz((ial|\\.)p\u00e4d|w|\\.(jur|w|\u00d6k))?|Sport(l|wiss)|Sprachm|Stat|Stom(at)?|Szene[bm]|Techn(oinform)?|Tonm|\u00dcbers|Wirt(schafts(psych|math)|chem|l)?|Wigeo|Wiss\\.org|WiWi|Oec|\u00d6k|Orient|Oz|Verk.wirtsch|(Wi(rt(sch)?)?|Comp|Re[lgh]|Tech|Ver[sw]|Kunst|Mus|Chem|Ing|Landsch|Vet|Sicherheits|Verw|Komm|LM)\\.?)";
        String area = "(UWT|A(gr|rchiv)ar|(Humanbi|Orientarch\u00e4)ologe|(Braumeister|(Energie|Holz|Kultur)wirt|(Ergo|Physio)therapeut|(Fach)?\u00dcbersetzer|K\u00fcnstler|Mediator|Kunstp\u00e4dagoge|Lehrer|Medien(berater|gestalter|wirt))(in)?)";
        return NodePattern.or(NodePattern.N.form("Dipl").directlyBefore(CommonPatterns.skipForward(NodePattern.N.form("[.-]"), NodePattern.or(NodePattern.or(NodePattern.N.inFormSequence(0, "Wirt(sch)?", "\\.", "Inf(orm)?").andOptionally(NodePattern.N.withNeighbor(1, NodePattern.N.noSpaceAfter().markAs("noSpace"))), NodePattern.N.inFormSequence(0, "Wi|Comp", "\\.", "Math"), NodePattern.N.inFormSequence(0, "Komm", "\\.", "Wirt(in)?"), NodePattern.N.inFormSequence(0, "Inf", "\\.", "Wirt(in)?").andOptionally(NodePattern.N.withNeighbor(1, NodePattern.N.noSpaceAfter().markAs("noSpace"))), NodePattern.N.inFormSequence(0, "Vet", "\\.", "Med"), NodePattern.N.inFormSequence(0, "Wirt(sch)?|Sicherheits|Chem|Wi", "\\.", "Ing"), NodePattern.N.inFormSequence(0, "Tech", "\\.", "Red"), NodePattern.N.inFormSequence(0, "Vers", "\\.", "Betriebsw"), NodePattern.N.inFormSequence(0, "Reg", "\\.", "Wiss"), NodePattern.N.inFormSequence(0, "Landsch", "\\.", "\u00f6kol"), NodePattern.N.inFormSequence(0, "Verw", "\\.", "Manager"), NodePattern.N.inFormSequence(0, "(Rel|Kunst|Ing|Reh|Mus)", "\\.", "p\u00e4d")).markAs("SecondPart").withNeighbor(2, NodePattern.N.markAs("ThirdPart")), NodePattern.or(NodePattern.N.inFormSequence(0, "Reha", "psych"), NodePattern.N.inFormSequence(0, "LM", "Ing"), NodePattern.N.inFormSequence(0, "Ing", "P\u00e4d")).markAs("SecondPart").withNeighbor(1, NodePattern.N.markAs("ThirdPart")), NodePattern.or(NodePattern.N.form(areaAbbr + "|" + area), NodePattern.N.inFormSequence(0, "Mol", "\\.", "Med")).markAs("SecondPart"), NodePattern.N.form("online").markAs("SecondPart").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.lemma("Journalist").markAs("ThirdPart")))))), NodePattern.N.form("Dr").directlyBefore(CommonPatterns.skipForward(NodePattern.N.form("[.-]"), NodePattern.N.form("Ing").markAs("SecondPart")))).message(PUNCTUATION_IN_DIPLOMA_DEGREES).and((node, match) -> {
            Node secondPart = match.getMarkedNode("SecondPart");
            Node thirdPart = match.findMarkedNode("ThirdPart");
            Node noSpace = match.findMarkedNode("noSpace");
            if (noSpace != null && thirdPart != null) {
                match = match.withCorrector(NodeCorrector.replaceNodes(node, thirdPart, "Dipl.-" + secondPart.form() + "." + thirdPart.form()));
            }
            if (thirdPart != null) {
                String punctAfterSecond = secondPart.form() + (secondPart.hasForm("Reha|LM|Online|Ing\\.") ? "" : ".");
                return match.withCorrector(NodeCorrector.replaceNodes(node, thirdPart, "Dipl.-" + punctAfterSecond + "-" + thirdPart.form()));
            }
            String lastPart = secondPart.hasForm("Mat") ? "Math" : (secondPart.hasForm("Bio") ? "Biol" : secondPart.form());
            String realEnd = secondPart.nextNode() != null && secondPart.nextNode().hasForm("\\..*") || secondPart.hasForm(".+\\.") || secondPart.hasForm(area) ? lastPart : lastPart + ".";
            return match.withCorrector(NodeCorrector.replaceNodes(node, secondPart, (node.hasForm("Dr") ? "Dr." : "Dipl.") + "-" + realEnd));
        });
    }

    private static NodePattern abbreviationsWithDot() {
        NodePattern beforeDot = NodePattern.N.directlyBefore(NodePattern.N.form("\\.+"));
        NodePattern abbrZumBeispiel = NodePattern.or(NodePattern.or(NodePattern.N.inFormSequence(0, "z", "\\.", "B").withNeighbor(2, NodePattern.not(beforeDot).markAs("End")), NodePattern.N.inFormSequence(0, "z", "B").andOr(NodePattern.N.withNeighbor(1, NodePattern.N.directlyBefore(CommonPatterns.dot.markAs("End"))), NodePattern.not(beforeDot).markAs("End"))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("End"), "z.\u00a0B.")), NodePattern.N.form("zB").andOr(NodePattern.N.withHeadRelation("advmod|dep"), NodePattern.ROOT.directlyBefore(CommonPatterns.colon)).andOr(beforeDot.correct(NodeCorrector.replace("z.\u00a0B")), NodePattern.N.correct(NodeCorrector.replace("z.\u00a0B."))).andNot(NodePattern.N.formCaseSensitive("zB").and(GermanParameters.VARIANT.withValue("AT"))));
        return NodePattern.or(NodePattern.or(abbrZumBeispiel, NodePattern.or(NodePattern.N.inFormSequence(0, "u", "a", "\\.").withNeighbor(2, NodePattern.N.markAs("End")), NodePattern.N.inFormSequence(0, "u", "\\.", "a").withNeighbor(2, NodePattern.not(beforeDot.markAs("End")))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("End"), "u.\u00a0a.")), NodePattern.N.form("u\\.a").andNot(beforeDot).correct(NodeCorrector.replace("u.\u00a0a.")), NodePattern.N.inFormSequence(0, "o", "\u00c4", "\\.").directlyBeforeHead().withNeighbor(2, NodePattern.N.markAs("End")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("End"), "o.\u00a0\u00c4.")), NodePattern.N.form("idR").andOr(beforeDot.correct(NodeCorrector.replace("i.\u00a0d.\u00a0R")), NodePattern.N.correct(NodeCorrector.replace("i.\u00a0d.\u00a0R."))), NodePattern.N.form("eV").withHead("flat(:name)?", SpellingRules.noun).andOr(beforeDot.correct(NodeCorrector.replace("e.V")), NodePattern.N.correct(NodeCorrector.replace("e.V."))), NodePattern.N.inFormSequence(1, "z", "H(dn?)?").andOr(beforeDot.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), m -> List.of("z.\u00a0" + m.anchor().form()))), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), m -> List.of("z.\u00a0" + m.anchor().form() + ".")))), NodePattern.N.inFormSequence(0, "[nv]", "Chr").andOr(NodePattern.N.withNeighbor(1, beforeDot).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), m -> List.of(m.anchor().form() + ".\u00a0Chr"))), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), m -> List.of(m.anchor().form() + ".\u00a0Chr.")))), NodePattern.N.inFormSequence(1, "i", "[AV]").directlyBefore(NodePattern.or(NodePattern.N.label("PERSON"), NodePattern.N.form("von"))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), m -> List.of("i.\u00a0" + m.anchor().form() + ".")))).message("Schreiben Sie diese Abk\u00fcrzung mit Punkten"), NodePattern.or(NodePattern.N.inFormSequence(1, "ad", "lib"), NodePattern.N.inFormSequence(1, "et", "al"), NodePattern.N.form("etc").noHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound")).andNot(beforeDot).message("Schreiben Sie diese Abk\u00fcrzung mit Punkt").correct(NodeCorrector.insertAfter(".")));
    }
}

