/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.document;

import ai.grazie.nlp.langs.Language;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class Metadata {
    public static final Metadata EMPTY = new Metadata(Map.of());
    @VisibleForTesting
    final Map<Key<?>, Object> map;
    private static final Map<Language, KeyRegistry> languageMetadataKeys = new ConcurrentHashMap<Language, KeyRegistry>();

    private Metadata(Map<Key<?>, Object> map2) {
        this.map = Collections.unmodifiableMap(map2);
    }

    @Nullable
    public <T> T get(Key<T> key) {
        Object t = this.map.get(key);
        return (T)t;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public <T> Metadata with(Key<T> key, @NotNull T data2) {
        return this.with(new Metadata(Map.of(key, data2)));
    }

    public Metadata with(Metadata other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        HashMap map2 = new HashMap(this.map);
        for (Map.Entry<Key<?>, Object> entry2 : other.map.entrySet()) {
            map2.merge(entry2.getKey(), entry2.getValue(), (v1, v2) -> ((Key)entry2.getKey()).mergeValues(v1, v2));
        }
        return new Metadata(map2);
    }

    public String toString() {
        return this.map.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Metadata)) return false;
        Metadata metadata = (Metadata)o;
        if (!Objects.equals(this.map, metadata.map)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.map);
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeVInt(this.map.size());
        for (Key<?> key : this.map.keySet()) {
            this.serializeEntry(key, out);
        }
    }

    private <T> void serializeEntry(Key<T> key, DataOutput out) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        key.serialize((DataOutput)new OutputStreamDataOutput((OutputStream)os), this.get(key));
        out.writeVInt(key.id);
        out.writeVInt(os.size());
        out.writeBytes(os.toByteArray(), os.size());
    }

    public static Metadata deserialize(DataInput in, @NotNull KeyRegistry registry) throws IOException {
        int size = in.readVInt();
        if (size == 0) {
            return EMPTY;
        }
        HashMap map2 = new HashMap();
        for (int i = 0; i < size; ++i) {
            int keyId = in.readVInt();
            int length = in.readVInt();
            KeyId id = registry.map.get(keyId);
            if (id == null) {
                in.skipBytes((long)length);
                continue;
            }
            map2.put(id.key, id.key.deserialize(in));
        }
        return new Metadata(map2);
    }

    public static KeyRegistry keysFor(Language language) {
        return languageMetadataKeys.computeIfAbsent(language, l -> new KeyRegistry());
    }

    public static abstract class Key<T> {
        private final int id;

        protected Key(KeyId id) {
            this.id = id.id;
            id.bind(this);
        }

        protected abstract void serialize(DataOutput var1, T var2) throws IOException;

        protected abstract T deserialize(DataInput var1) throws IOException;

        protected T mergeValues(T t1, T t2) {
            throw new UnsupportedOperationException("Intersecting metadata");
        }

        @TestOnly
        protected abstract int fingerprint();
    }

    public static class KeyRegistry {
        @VisibleForTesting
        final Map<Integer, KeyId> map = new HashMap<Integer, KeyId>();

        public synchronized KeyId newKey(int id) {
            if (this.map.containsKey(id)) {
                throw new IllegalArgumentException("Key ID " + id + " is already registered");
            }
            KeyId result2 = new KeyId(id);
            this.map.put(id, result2);
            return result2;
        }
    }

    public static class KeyId {
        private final int id;
        @VisibleForTesting
        Key<?> key;

        private KeyId(int id) {
            this.id = id;
        }

        private synchronized void bind(Key<?> key) {
            if (this.key != null) {
                throw new IllegalStateException("Key already instantiated");
            }
            this.key = key;
        }
    }
}

