/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.Severity;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseReplacement;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.List;
import java.util.Objects;

class Ableism {
    private static final String ABLEISM_MSG = "Consider replacing a possibly ableist word '$_'";
    private static final String ABLEISM_PERSON_MSG = "Consider replacing a possibly ableist word '$_' when talking about a person";
    private static final String MEDICAL_CONDITION = "Avoid '$_' when not used in reference to a medical condition that is relevant to the topic";
    private static final NodePattern aboutHuman = NodePattern.N.noHeadRelation("appos").andOr(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withHead("amod|compound|det", Semantics.Animacy.humanLike.pattern), NodePattern.N.noDependents("det").withHead("xcomp|obj", NodePattern.or(NodePattern.N.withHead("xcomp", NodePattern.or(Semantics.Animacy.humanLike.pattern, NodePattern.N.withDependent("obj", Semantics.Animacy.humanLike.pattern))), NodePattern.N.noLemma("have").withDependent("nsubj", Semantics.Animacy.humanLike.pattern))))), NodePattern.or(NodePattern.N.withDependent("nsubj", Semantics.Animacy.humanLike.pattern), NodePattern.N.withHead("conj", NodePattern.N.noPos("VB.?").withDependent("nsubj", Semantics.Animacy.humanLike.pattern))), NodePattern.N.withHeadRelation("vocative"));
    private static final String diseases = "md|aids|hiv|psychosis|schizophrenia|polio(myelitis)?";
    private static final NodePattern beforeDisability = NodePattern.or(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("md|aids|hiv|psychosis|schizophrenia|polio(myelitis)?").markAs("Disability"), NodePattern.N.form("multiple").directlyBefore(NodePattern.N.form("sclerosis").markAs("Disability")), NodePattern.N.form("muscular").directlyBefore(NodePattern.N.form("dystrophy").markAs("Disability")))), CommonPatterns.beforeSkipping(NodePattern.N.form("an?|the"), NodePattern.or(NodePattern.N.lemma("disability").markAs("Disability"), NodePattern.N.form("intellectual|mental|physical|visual|vocal|learning|neurodevelopmental|locomotor").directlyBefore(NodePattern.N.form("disabilit(y|ies)").markAs("Disability"))).andNot(EnglishTreePatterns.compound.beforeHead())));

    Ableism() {
    }

    private static NodePattern simpleReplacements() {
        return NodePattern.or(aboutHuman.andOr(NodePattern.or(NodePattern.N.form("barren").and(StyleRules.replaceFixArticle(List.of("sterile", "infertile"))), NodePattern.N.form("batshit|crazy").andNot(NodePattern.N.form("crazy").andOr(NodePattern.N.withHead("xcomp", NodePattern.N.lemma("get|go")), NodePattern.N.directlyBefore(NodePattern.N.form("about")), NodePattern.N.withDependent("cop", NodePattern.N.lemma("get")), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.form("one")))).andNot(NodePattern.N.form("batshit").directlyBefore(NodePattern.N.form("crazy"))).and(StyleRules.replaceFixArticle(List.of("rude", "malicious", "mean", "disgusting", "incredible", "vile"))).andOptionally(NodePattern.N.withHead("amod|compound", NodePattern.N.pos("NNS?").markAs("Person")).correct(NodeCorrector.insertAfter(NodePointer.marked("Person"), " with a mental disorder").join(NodeCorrector.replace(NodePointer.anchor(), "")))), NodePattern.N.andOr(NodePattern.N.noDependents("det", NodePattern.N.beforeHead()), NodePattern.N.withHeadRelation("amod|compound")).andOr(NodePattern.N.form("dumb").and(StyleRules.replaceFixArticle(List.of("foolish", "ludicrous", "speechless", "silent"))), NodePattern.N.form("bone?y").andNot(CommonPatterns.capitalized.form("boney")).and(StyleRules.replaceFixArticle(List.of("thin", "slim"))), NodePattern.N.form("daft").and(StyleRules.replaceFixArticle(List.of("foolish"))), NodePattern.N.form("imbecile|idiot").and(StyleRules.replaceFixArticle(List.of("foolish", "silly"))), NodePattern.N.form("stupid|wh?acko").and(StyleRules.replaceFixArticle(List.of("foolish", "unintelligent"))))).andNot(CommonPatterns.capitalizedMiddle).message(ABLEISM_PERSON_MSG), NodePattern.N.form("adhd").andNot(NodePattern.N.withHead("compound", NodePattern.N.lemma("researcher"))).noDependents("nmod:poss").and(StyleRules.replaceFixArticle(List.of("disorganized", "distracted", "energetic", "hyperactive", "impetuous", "impulsive", "inattentive", "restless", "unfocused"))).andOptionally(NodePattern.N.noDependents().withHead("amod|compound", NodePattern.N.pos("NNS?").noDependents("det:predet").markAs("Person")).and((node, match) -> {
            Node person = match.getMarkedNode("Person");
            String article = Articles.getIndefiniteArticle(person.lowForm());
            NodeCorrector corrector = NodeCorrector.insertAfter(person, " with ADHD").join(NodeCorrector.removeNode(node));
            if (node.prevNode() != null && node.prevNode().hasForm("an?")) {
                corrector = corrector.join(NodeCorrector.replace(node.prevNode(), article));
            }
            return match.withCorrector(corrector);
        })).message(MEDICAL_CONDITION)), NodePattern.N.form("dummy").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("you"))).andOr(NodePattern.N.noDependents("det|nmod:poss", NodePattern.N.beforeHead()), NodePattern.N.withHeadRelation("amod|compound")).and(StyleRules.replaceFixArticle(List.of("fake", "placeholder", "stub"))).message(ABLEISM_MSG), NodePattern.or(NodePattern.N.lemma("bedlam").and(StyleRules.replaceNounFixGrammar(List.of("chaos", "pandemonium"))), NodePattern.N.lemma("cretin").and(StyleRules.replaceNounFixGrammar(List.of("creep", "fool"))), NodePattern.not(CommonPatterns.capitalized).lemma("detox|rehab").noPos("VB.?").and(StyleRules.replaceNounFixGrammar(List.of("treatment"))), NodePattern.or(NodePattern.N.form("idiot|imbecile|simpleton|stupid|wh?acko").withDependent("det"), aboutHuman.form("dummy")).potentialPos("NN").noHeadRelation("amod|compound").and(StyleRules.replaceFixArticle(List.of("foolish person", "silly person", "unintelligent person"))).andOptionally(NodePattern.N.directlyAfter(NodePattern.N.form("the")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "foolish people", "silly people", "unintelligent people"))), NodePattern.or(NodePattern.N.form("idiots|imbeciles|simpletons|wh?ackos"), aboutHuman.form("dummies")).and(StyleRules.replaceFixArticle(List.of("foolish people", "silly people", "unintelligent people"))), NodePattern.N.lemma("dummy").andOr(NodePattern.N.inSentenceWith(NodePattern.N.lemma("baby")).correct(NodeCorrector.regexReplace("dumm(y|ie)", "pacifier")), NodePattern.N.pos("NN").correct(NodeCorrector.replace("fake", "placeholder", "stub")), NodePattern.N.pos("NNS").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("for"))).correct(NodeCorrector.replace("fakes", "placeholders", "stubs")))).andNot(CommonPatterns.capitalizedMiddle).message(ABLEISM_MSG), NodePattern.N.lemma("insomnia").and(StyleRules.replaceNounFixGrammar(List.of("restlessness", "sleeplessness"))).message(MEDICAL_CONDITION), NodePattern.N.inFormSequence(1, "infantile", "paralysis").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "polio")).message("Consider replacing a possibly ableist phrase 'infantile paralysis'"));
    }

    private static NodePattern asylum() {
        NodePattern asylumAdj = NodePattern.N.form("insane|mental|psychiatric");
        return NodePattern.N.lemma("asylum").andOr(NodePattern.N.form("asylums"), NodePattern.N.form("asylum").andOr(NodePattern.N.withDependent("amod", asylumAdj.directlyBeforeHead()), NodePattern.N.withHead("obl", NodePattern.N.lemma("imprison|banish")), NodePattern.N.withHead("obj", NodePattern.N.lemma("build")), NodePattern.N.withHead("compound", NodePattern.N.lemma("doctor")))).and((node, match) -> {
            Node start = node;
            if (asylumAdj.matches(node.prevNode())) {
                start = node.prevNode();
            }
            return EnglishTreePatterns.replaceNominalPhrase(start, node, match, PhraseReplacement.MatchStrategy.Lemma, List.of("psychiatric hospital", "mental health hospital"));
        }).message(ABLEISM_MSG);
    }

    private static NodePattern ableBodied() {
        return NodePattern.or(NodePattern.N.form("bodied").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("able").markAs("Able"))), NodePattern.N.form("ablebodied").markAs("Able")).andNot(NodePattern.N.withHeadRelation("amod").andNot(aboutHuman)).and((node, match) -> {
            Node able = match.getMarkedNode("Able");
            NodeCorrector corrector = NodeCorrector.replaceNodes(able, node, "non-disabled");
            if (able.prevNode() != null && able.prevNode().hasForm("an")) {
                corrector = corrector.join(NodeCorrector.replace(able.prevNode(), "a"));
            }
            return match.withCorrector(corrector).withMessage("Consider replacing a possibly ableist word 'able-bodied' when talking about a person");
        });
    }

    private static NodePattern diseaseName() {
        return NodePattern.or(NodePattern.N.lemma("anore(x|ct)ic").andOr(NodePattern.N.pos("NNS").correct(NodeCorrector.replace("people with anorexia")), NodePattern.N.pos("NN").andOr(NodePattern.N.noPos("JJ"), NodePattern.ROOT).and(StyleRules.replaceFixArticle(List.of("person with anorexia"))), aboutHuman.pos("JJ").and(StyleRules.replaceFixArticle(List.of("thin", "slim")))), NodePattern.N.lemma("bulimic").andOr(NodePattern.N.pos("NNS").correct(NodeCorrector.replace("people who suffer from bulimia")), NodePattern.N.pos("NN").andOr(NodePattern.N.noPos("JJ"), NodePattern.ROOT).correct(NodeCorrector.replace("person who suffers from bulimia")), aboutHuman.pos("JJ").correct(NodeCorrector.replace("suffering from bulimia")))).message(ABLEISM_PERSON_MSG);
    }

    private static NodePattern addict() {
        return NodePattern.N.form("addicts?").noPos("VBZ?").andNot(CommonPatterns.capitalizedMiddle).and((node, match) -> {
            String subject = node.hasPos("NNS") ? "people" : "person";
            String replacement = subject + " with a drug addiction";
            String message = "Consider replacing a possibly ableist word '" + node.lowForm() + "'";
            Node prev = node.prevNode();
            if (prev != null && prev.hasHeadRelation("conj")) {
                return match.withMessage(message + " with '" + replacement + "'");
            }
            NodeCorrector corrector = NodeCorrector.replace(node, replacement);
            Node articleNode = node;
            if (prev != null && (prev.hasForm("medical") || prev.hasHeadRelation("compound") && !prev.hasDependent(".*"))) {
                articleNode = prev;
                String article = Articles.getIndefiniteArticle(prev.form());
                replacement = subject + " with " + article + " ";
                corrector = NodeCorrector.insertBefore(prev, replacement).join(NodeCorrector.replace(node, "addiction"));
            }
            if (articleNode.prevNode() != null && articleNode.prevNode().hasForm("an")) {
                corrector = corrector.join(NodeCorrector.replace(articleNode.neighbor(-1), "a"));
            }
            return match.withCorrector(corrector).withMessage(message);
        });
    }

    private static NodePattern afflicted() {
        return NodePattern.N.form("afflicted|suffer(ing|s|ed)?").directlyBefore(beforeDisability.form("with|from").markAs("With")).andOr(NodePattern.N.withHead("xcomp", NodePattern.N.pos("VB.?").lemma("become|begin").markAs("Verb").andOr(NodePattern.N.pos("VBP?").noDependents("aux", NodePattern.N.lemma("have")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Verb"), NodePointer.marked("With"), "get")), NodePattern.N.pos("VBZ").correct(NodeCorrector.replaceNodes(NodePointer.marked("Verb"), NodePointer.marked("With"), "gets")), NodePattern.N.pos("VBN").withDependent("aux", NodePattern.N.lemma("have")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Verb"), NodePointer.marked("With"), "got", "gotten")), NodePattern.N.pos("VB[DN]").correct(NodeCorrector.replaceNodes(NodePointer.marked("Verb"), NodePointer.marked("With"), "got")))), NodePattern.N.form("suffer").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("With"), "have")), NodePattern.N.form("suffers").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("With"), "has")), NodePattern.N.form("suffered").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("With"), "had")), NodePattern.N.noForm("suffer").noDependents("aux(:pass)?").andOr(NodePattern.N.withHead("acl", Semantics.Animacy.humanLike.pattern).afterHead().correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("With"), "with")), NodePattern.N.potentialPos("VBN").withNeighbor(2, NodePattern.N.form("polio(myelitis)?")).and(CommonPatterns.skipConjUp(NodePattern.N.beforeHead())).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("With"), "having had")), CommonPatterns.skipConjUp(NodePattern.N.beforeHead()).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("With"), "having"))), NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.markAs("Aux").andOr(NodePattern.N.lemma("be").pos("VBP?").correct(NodeCorrector.replaceNodes(NodePointer.marked("Aux"), NodePointer.marked("With"), " have")), NodePattern.N.form("(i|['\u2019`\u2018])s").correct(NodeCorrector.replaceNodes(NodePointer.marked("Aux"), NodePointer.marked("With"), " has")), NodePattern.N.form("being").correct(NodeCorrector.replaceNodes(NodePointer.marked("Aux"), NodePointer.marked("With"), "having")), NodePattern.N.form("was|were|(ha|['\u2019`\u2018])ve|had").correct(NodeCorrector.replaceNodes(NodePointer.marked("Aux"), NodePointer.marked("With"), " had")))), NodePattern.N).reportEverythingTouched().message("Consider replacing a possibly ableist phrase '$_ $With disability'");
    }

    private static NodePattern amputee() {
        return NodePattern.N.lemma("amputee").andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.withHead("amod|compound", NodePattern.not(Semantics.humanLikePattern))).and((node, match) -> {
            String subject;
            String string = subject = node.hasPos("NNS") ? "people" : "person";
            if (node.hasDependent("compound|amod")) {
                return match.withMessage("Consider replacing a possibly ableist word '" + node.lowForm() + "' with '" + subject + " with an amputation'");
            }
            NodeCorrector corrector = NodeCorrector.replace(node, subject + " with an amputation");
            String article = "a";
            if (node.hasHeadRelation("amod|compound") && aboutHuman.matches(node)) {
                if (node.nextNode() != null) {
                    article = Articles.getIndefiniteArticle(node.nextNode().form());
                }
                corrector = NodeCorrector.insertAfter(Objects.requireNonNull(node.head()), " with an amputation").join(NodeCorrector.removeNode(node));
            }
            if (node.prevNode() != null && node.prevNode().hasForm("an")) {
                corrector = corrector.join(NodeCorrector.replace(node.neighbor(-1), article));
            }
            return match.withCorrector(corrector).withMessage("Consider replacing a possibly ableist word '" + node.lowForm() + "' when talking about a person");
        });
    }

    private static NodePattern victim() {
        return NodePattern.N.form("victims?").markAs("Victim").andOr(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("disabilit(y|ies)").directlyAfter(NodePattern.N.form("intellectual|mental").markAs("Disease")), NodePattern.N.form("sclerosis").directlyAfter(NodePattern.N.form("multiple").markAs("Disease")), NodePattern.N.form("dystrophy").directlyAfter(NodePattern.N.form("muscular").markAs("Disease")), NodePattern.N.form("md|aids|hiv|psychosis|schizophrenia|polio(myelitis)?|disabilit(y|ies)").markAs("Disease"))).and((node, match) -> {
            String subject = node.hasPos("NNS") ? "people" : "person";
            Node disease = match.getMarkedNode("Disease");
            Object diseaseText = disease.form();
            if (disease.nextNode() != node) {
                diseaseText = (String)diseaseText + " " + node.neighbor(-1).form();
            }
            NodeCorrector corrector = NodeCorrector.replace(node, subject + " with " + (String)diseaseText).join(NodeCorrector.replaceNodes(disease, node.neighbor(-1), ""));
            if (disease.lowForm().matches("polio(myelitis)?")) {
                corrector = NodeCorrector.replace(node, subject + " who had " + (String)diseaseText).join(NodeCorrector.replaceNodes(disease, node.neighbor(-1), ""));
            }
            String message = "Consider replacing a possibly ableist expression '" + (String)diseaseText + " " + node.form() + "'";
            if (disease.prevNode() != null && disease.prevNode().hasForm("an")) {
                corrector = corrector.join(NodeCorrector.replace(disease.prevNode(), "a"));
            }
            if (disease.hasDependent("compound") || disease.hasHeadRelation("conj") || disease.prevNode() != null && disease.prevNode().hasHeadRelation("amod")) {
                corrector = null;
            }
            return match.withCorrector(corrector).withMessage(message);
        }), NodePattern.N.directlyBefore(beforeDisability.form("of")).and((node, match) -> {
            Node victim;
            Node disability = match.getMarkedNode("Disability");
            String subject = node.hasPos("NNS") ? "people" : "person";
            Object disabilityName = disability.form();
            if (!disability.neighbor(-1).lowForm().equals("of")) {
                disabilityName = disability.neighbor(-1).form() + " " + (String)disabilityName;
                if (!disability.neighbor(-2).lowForm().equals("of")) {
                    disabilityName = disability.neighbor(-2).form() + " " + (String)disabilityName;
                }
            }
            NodeCorrector corrector = NodeCorrector.replaceNodes(node, disability, subject + " with " + (String)disabilityName);
            if (disability.lowForm().matches("polio(myelitis)?")) {
                corrector = NodeCorrector.replaceNodes(node, disability, subject + " who had " + (String)disabilityName);
            }
            if ((victim = match.getMarkedNode("Victim")).hasDependent("compound")) {
                corrector = null;
            }
            return match.withCorrector(corrector).withMessage("Consider replacing a possibly ableist expression '" + node.form() + " of " + (String)disabilityName + "'");
        })).reportEverythingTouched();
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Style.ABLEISM", "Ableism", "Avoid ableist language.", "https://www.verywellmind.com/types-of-ableist-language-and-what-to-say-instead-5201561", NodePattern.or(Ableism.ableBodied(), Ableism.diseaseName(), Ableism.addict(), Ableism.afflicted(), Ableism.amputee(), Ableism.simpleReplacements(), Ableism.asylum(), Ableism.victim()).andNot(CommonPatterns.insideQuotes), new Example[]{new Example("She is <b>anorexic</b>.", "Consider replacing a possibly ableist word 'anorexic' when talking about a person", "She is <b>thin</b>.", "She is <b>slim</b>."), new Example("Emma\u2019s show has inspired other disabled and <b>able-bodied</b> people in their lives.", "Consider replacing a possibly ableist word 'able-bodied' when talking about a person", "Emma\u2019s show has inspired other disabled and <b>non-disabled</b> people in their lives."), new Example("It\u2019s not as simple as treating <b>addicts</b> as a criminal issue instead of a social one.", "Consider replacing a possibly ableist word 'addicts'", "It\u2019s not as simple as treating <b>people with a drug addiction</b> as a criminal issue instead of a social one."), new Example("No <b>amputees</b> here.", "Consider replacing a possibly ableist word 'amputees' when talking about a person", "No <b>people with an amputation</b> here.")}){

            @Override
            public Severity getSeverity() {
                return Severity.STYLE_WARNING;
            }
        };
    }
}

