/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.toolkit.Selectioner;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.TextRange;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class EnglishSelectioner
extends Selectioner {
    EnglishSelectioner() {
    }

    @Override
    @NotNull
    protected List<TextRange> calcRangesForHead(Node head) {
        List<Node> dependents;
        List<TextRange> result2 = super.calcRangesForHead(head);
        if (head.hasHeadRelation("acl:relcl") && !(dependents = head.allDependents()).isEmpty() && dependents.get(0).hasForm("that") && dependents.get(0).isBefore(head)) {
            result2.add(new TextRange(Objects.requireNonNull(dependents.get(0).nextNode()).phraseStart().startOffset(), head.phraseEnd().endOffset()));
        }
        if (EnglishTreePatterns.verbalClause.matches(head)) {
            Node nextHead;
            Node next;
            Node aux;
            Node particle = head.findDependents("compound:prt").stream().findFirst().orElse(null);
            if (particle != null) {
                result2.add(new TextRange(head.startOffset(), particle.endOffset()));
            }
            if ((aux = (Node)head.findDependents("cop|aux|aux:pass").stream().findFirst().orElse(null)) != null && !EnglishTreePatterns.startsWithApostrophe.matches(aux)) {
                Node particleOrHead;
                Node node = particleOrHead = particle != null ? particle : head;
                if (aux.isBefore(particleOrHead)) {
                    result2.add(new TextRange(aux.startOffset(), particleOrHead.endOffset()));
                }
            }
            if ((next = head.nextNode()) != null && next.hasHeadRelation("mark") && (nextHead = Objects.requireNonNull(next.head())).hasHeadRelation("xcomp") && nextHead.head() == head) {
                result2.add(new TextRange((aux != null ? aux : head).startOffset(), next.endOffset()));
            }
        }
        return result2;
    }
}

