/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishSelectioner;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.GrammarRules;
import ai.grazie.rules.en.PosHighlighter;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.SemanticRules;
import ai.grazie.rules.en.SpellingRules;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.en.TypographyRules;
import ai.grazie.rules.en.YamlRules;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.SettingGroup;
import ai.grazie.rules.toolkit.LanguageToolkit;
import ai.grazie.rules.toolkit.PosHighlighting;
import ai.grazie.rules.toolkit.Selectioner;
import ai.grazie.rules.toolkit.StructuralWrapper;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Parameter;
import ai.grazie.rules.vale.YamlRuleSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.language.English;

public class EnglishToolkit
extends LanguageToolkit {
    public static final EnglishToolkit INSTANCE = new EnglishToolkit();

    private EnglishToolkit() {
        super(Language.ENGLISH, StreamEx.of((Object[])new Rule[0]).append(PunctuationRules.priorityRules()).append(SpellingRules.rules()).append(GrammarRules.rules()).append(PunctuationRules.rules()).append(SemanticRules.rules()).append(TypographyRules.rules()).append(StyleRules.rules()).toList());
    }

    @Override
    @Nullable
    public PosHighlighting posHighlight(Node node) {
        return PosHighlighter.posHighlight(node);
    }

    @Override
    public Selectioner selectioner() {
        return new EnglishSelectioner();
    }

    @Override
    @Nullable
    public StructuralWrapper getStructuralWrapper() {
        return new StructuralWrapper(){

            @Override
            protected boolean isPunctuation(Node node) {
                return PunctuationRules.commaLike.matches(node);
            }

            @Override
            protected boolean isClauseLike(Node node) {
                return EnglishTreePatterns.clause.matches(node) || node.hasPos("VBG");
            }
        };
    }

    @Override
    public String getRuleDescriptionLinkText() {
        return "Learn more";
    }

    @Override
    public List<SettingGroup> getSettings(RuleClient client) {
        Map map2 = StreamEx.of(this.publishedRules()).toMap(r -> r.id, Function.identity());
        return List.of(new SettingGroup("General", StreamEx.of((Object[])new Setting[]{client.hasImplicitVariant() ? null : EnglishParameters.VARIANT, EnglishToolkit.ruleSetting(map2, "Grammar.MISSING_ARTICLE", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.ENFORCE_CONTRACTION_USE", EnglishParameters.CONTRACTION_USE), EnglishToolkit.ruleSetting(map2, "Style.SPELLING_OUT_NUMBERS", EnglishParameters.SPELL_OUT_NUMERALS), EnglishToolkit.ruleSetting(map2, "Style.SPELLING_OUT_NUMBERS_SENT_START", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.SPELLING_OUT_LARGE_NUMBERS", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.CONDESCENDING", new Parameter[0])}).nonNull().toList()), new SettingGroup("Punctuation", EnglishToolkit.ruleSetting(map2, "Style.SERIAL_COMMA", EnglishParameters.SERIAL_COMMA), EnglishToolkit.ruleSetting(map2, "Style.EXCLAMATION_MARK", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.EXPRESSIVE_PUNCTUATION", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.SMILEY_OR_EMOJI_USE", new Parameter[0])), new SettingGroup("Typography", EnglishToolkit.ruleSetting(map2, "Typography.HYPHEN_TO_DASH", EnglishParameters.DASH_STYLE), EnglishToolkit.ruleSetting(map2, "Typography.HYPHEN_IN_RANGES", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Typography.VARIANT_QUOTE_PUNCTUATION", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.NON_BREAKING_SPACES", EnglishParameters.SPACES_IN_NAME_INITIALS), EnglishToolkit.ruleSetting(map2, "Spelling.MISSING_DIACRITICS", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Typography.SMART_APOSTROPHE", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Typography.NUMBERS_WITH_UNITS", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Typography.NUMBER_FORMATTING", EnglishParameters.NUMBER_FORMATTING)), new SettingGroup("Readability", EnglishToolkit.ruleSetting(map2, "Style.LESS_READABLE_PASSIVE", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.PASSIVE_VOICE", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.VERY_ABUSE", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.TAUTOLOGY", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.REDUNDANT_OF", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.OF_CHAIN", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.SIMPLICITY", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.WORDINESS", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.REDUCIBLE_RELATIVE_CLAUSE", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.FAULTY_PARALLELISM", new Parameter[0])), new SettingGroup("Formality", EnglishToolkit.ruleSetting(map2, "Style.COLLOQUIAL_SPEECH", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.INFORMAL_SHORT_FORMS", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.LOOKS_LIKE", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.SUBJECT_PRONOUNS", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.OR_SUBJECT_AGREEMENT", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.SPELL_OUT_AND_SYMBOLS", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.PRONOUN_FIRST_PERSON_SG", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.PRONOUN_FIRST_PERSON_PL", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.PRONOUN_SECOND_PERSON", new Parameter[0])), new SettingGroup("Inclusivity", EnglishToolkit.ruleSetting(map2, "Style.PRONOUN_GENDER_BIAS", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.NOUN_VERB_GENDER_BIAS", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.HONORIFIC", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.DISCRIMINATORY_LANGUAGE", new Parameter[0]), EnglishToolkit.ruleSetting(map2, "Style.NONVIOLENT_LANGUAGE", new Parameter[0])));
    }

    @Override
    public List<YamlRuleSet> publishedYamlRules(@Nullable JLanguageTool tool) {
        if (tool != null && !(tool.getLanguage() instanceof English)) {
            throw new IllegalArgumentException("Expected English, but got " + tool.getLanguage());
        }
        return new YamlRules((JLanguageTool)tool).rules;
    }
}

