/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.Severity;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseReplacement;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;

class GenderBias {
    private static final NodePattern reflexivePronoun = NodePattern.N.form("himself|herself");
    private static final NodePattern malePronoun = NodePattern.N.form("he|him|his|himself");
    private static final NodePattern femalePronoun = NodePattern.N.form("she|her|herself");
    private static final NodePattern neutralizedPronoun = NodePattern.or(NodePattern.or(NodePattern.N.withDependent("conj", NodePattern.N.markAs("Another")), NodePattern.N.withHead("conj", NodePattern.N.markAs("Another")), NodePattern.N.directlyBefore(NodePattern.N.form("/").directlyBefore(NodePattern.N.markAs("Another"))), NodePattern.N.directlyAfter(NodePattern.N.form("/").directlyAfter(NodePattern.N.markAs("Another")))).andOr(malePronoun.and(NodePattern.markedNodeMatches("Another", femalePronoun)), femalePronoun.and(NodePattern.markedNodeMatches("Another", malePronoun))), NodePattern.N.inFormSequence(2, "s", "[/)]", "he").directlyAfter(NodePattern.N.noSpaceAround()));
    private static final NodePattern generalStatement = NodePattern.or(Semantics.generalTruth, NodePattern.N.withDependent("mark", NodePattern.N.form("if|when|where|whether|to|while|whilst|because|since")), NodePattern.N.lemma("earn|grow|bear|know|learn|become|try|have|change|transform"), NodePattern.N.withDependent("aux", NodePattern.N.form("must")), NodePattern.N.pos("NN").withDependent("cop"), NodePattern.N.withHeadRelation("acl:relcl"), NodePattern.N.pos("VB").withHead("xcomp", NodePattern.N.lemma("have")), NodePattern.N.inPhrase(NodePattern.or(EnglishTreePatterns.letUs, EnglishTreePatterns.letS)));
    private static final NodePattern specificAntecedent = NodePattern.or(CommonPatterns.capitalizedMiddle, NodePattern.N.beforeHead().markAs("Antecedent").withHead(NodePattern.N.withDependent("nsubj.*", NodePattern.N.after("Antecedent").form("he"))), NodePattern.N.pos("NNP"), NodePattern.N.pos("NN").andOr(NodePattern.N.lemma("woman|girl(friend)?|dudette|lady|princess|man|boy(friend)?|dude|guy|(lord|prince)(ling)?"), Semantics.kindredRelationMale, Semantics.kindredRelationFemale, Semantics.kindredRelationNonGendered.withDependent("det", NodePattern.N.form("this|that")), Semantics.Animacy.humanLike.pattern.withDependent("det", NodePattern.N.form("an?")).withHead("nsubj.*", NodePattern.not(generalStatement)).noDependents("det:predet", NodePattern.N.form("such"))), NodePattern.N.withHead(NodePattern.N.pos("VBD")).noDependents("det", NodePattern.N.form("each|every"))).noLabel("GEO_POLITICAL_ENTITY|LOCATION");
    private static final NodePattern neutralAntecedent = NodePattern.or(EnglishTreePatterns.someAnyEveryNoAnimate.withHeadRelation("nsubj.*").noDependents("amod").andOr(NodePattern.N.withHead(NodePattern.N.withHeadRelation("advcl")), NodePattern.markedNodeMatches("Pronoun", NodePattern.or(reflexivePronoun, NodePattern.N.withHead("nsubj.*", NodePattern.or(NodePattern.N.withHeadRelation("(acl|advcl):relcl"), NodePattern.N.withHeadRelation("ccomp").withDependent("i?obj|obl", NodePattern.N.form("what")))), NodePattern.N.inFormSequence(0, "his|her", "own")))), NodePattern.N.pos("NN").andOr(Semantics.kindredRelationNonGendered, Semantics.abstractHuman.noForm("people")), NodePattern.N.form("artist|doctor|musician|reader|hitchhiker|director|president|driver|producer|extremist|refugee|farmer|postman|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|rector|officer|captain|foreman|superintendent|senior|official|nurse|midwife|secretary|master|bachelor|associate|client|customer|friend|user|colleague|teammate|groupmate|citizen|nominee|immigrant|emigrant|migrant|refugee|resident|slave|veteran|patient|employee|subordinate|chief|superior|superordinate|reportee|underboss|boss|subsidiary|managee|manager|leadee|leader").withDependent("det", NodePattern.N.form("an?|each|every")).andOr(NodePattern.N.withHeadRelation("nsubj.*"), NodePattern.N.withHead("i?obj|obl", NodePattern.N.withHeadRelation("advcl").markAs("Advcl")).andNot(NodePattern.markedNodeMatches("Pronoun", NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Advcl")))))).noDependents("amod", NodePattern.N.form("male|female"));
    private static final String PRONOUN_MESSAGE = "Consider using a gender-neutral pronoun";
    private static final String NOUN_MESSAGE = "Consider using a gender-neutral term";
    private static final String HONORIFIC_MESSAGE = "Incorrectly used address may be offensive, consider using neutral options";
    private static final NodePattern np = NodePattern.N.pos("NN.*|PRP");
    private static final NodePattern person = NodePattern.or(CommonPatterns.possiblySkipDown("flat", NodePattern.N.label("PERSON")), NodePattern.N.pos("NNP").noLabel("LOCATION"));
    private static final NodePattern nominativePronoun = NodePattern.N.form("s?he");
    private static final NodePattern possessivePronoun = NodePattern.N.form("his|her").withHeadRelation("nmod:poss");
    private static final NodePattern accusativePronoun = NodePattern.N.form("him|her").withHeadRelation("i?obj|obl|nmod");
    static final NodePattern femaleHonorific = NodePattern.N.form("(miss|mrs)\\.?").noPos("VB");
    private static final NodePattern bindingDomainBorder = EnglishTreePatterns.clause.andNot(NodePattern.N.pos("VB").withDependent("mark", NodePattern.N.form("to")));

    GenderBias() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Style.PRONOUN_GENDER_BIAS", "Avoid male pronouns in gender-neutral contexts", "People often use gendered pronouns even when they do not know the gender of the person they are talking about.\nThis can perpetuate gender stereotypes, reinforcing commonly held expectations\nabout the gender of people in certain roles.\n", "https://eige.europa.eu/publications-resources/toolkits-guides/gender-sensitive-communication/challenges/stereotypes/avoid-gendered-pronouns-he-or-she-when-persons-gender-unknown", GenderBias.pronounBias(), new Example[]{new Example("When a person is there for a long time, <b>he</b> gets used to it", PRONOUN_MESSAGE, "When a person is there for a long time, <b>they get</b> used to it", "When a person is there for a long time, <b>she or he</b> gets used to it", "When a person is there for a long time, <b>he or she</b> gets used to it")}){

            @Override
            public Severity getSeverity() {
                return Severity.STYLE_WARNING;
            }
        }.styleFlavor(StyleFlavor.Inclusivity), new Rule.PatternRule("Style.NOUN_VERB_GENDER_BIAS", "Avoid gender-specific nouns", "English uses gender-specific terms for some jobs and roles,\nlike <i>policeman</i>, <i>fireman</i>, and <i>chairman</i>.\nUse neutral alternatives when gender is not an essential part of the message.\n", "https://www.niu.edu/writingtutorial/style/bias-free-language.shtml", GenderBias.useGenderNeutralMultiWordExpressions(), new Example[]{new Example("My <b>forefathers</b> lived in Italy.", NOUN_MESSAGE, "My <b>ancestors</b> lived in Italy."), new Example("The <b>policeman</b> came by.", NOUN_MESSAGE, "The <b>police officer</b> came by.", "The <b>law enforcement officer</b> came by."), new Example("In the face of danger she behaved <b>like a man</b>", NOUN_MESSAGE, "In the face of danger she behaved <b>resolutely</b>", "In the face of danger she behaved <b>bravely</b>")}){

            @Override
            public Severity getSeverity() {
                return Severity.STYLE_WARNING;
            }
        }.styleFlavor(StyleFlavor.Inclusivity), new Rule.PatternRule("Style.HONORIFIC", "Use neutral honorifics", "Titles that don\u2019t specify marital status, like <i>Ms.</i> instead of <i>Mrs.</i> and <i>Miss</i>,\nor gender, like <i>Mx.</i> instead of <i>Mr.</i> or <i>Mrs.</i>,\nhelp promote equality and inclusivity.\n", "https://writingcenter.unc.edu/tips-and-tools/gender-inclusive-language/", GenderBias.useNeutralHonorific(), new Example[]{new Example("<b>Miss</b> Elizabeth Smith was nominated for a Nobel Prize.", HONORIFIC_MESSAGE, "<b>Ms.</b> Elizabeth Smith was nominated for a Nobel Prize.", "<b>Mx.</b> Elizabeth Smith was nominated for a Nobel Prize.")}){

            @Override
            public Severity getSeverity() {
                return Severity.STYLE_WARNING;
            }

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return false;
            }
        }.styleFlavor(StyleFlavor.Inclusivity));
    }

    private static boolean isGenderedPronounAllowed(Node pronoun, Set<Node> targets) {
        if (targets.isEmpty()) {
            return true;
        }
        NodeMatch matchWithPronoun = NodeMatch.EMPTY.withMarkedNode("Pronoun", pronoun);
        List<Node> neutralTargets = targets.stream().filter(node -> neutralAntecedent.match((Node)node, matchWithPronoun) != null).toList();
        if (neutralTargets.isEmpty()) {
            return true;
        }
        if (targets.contains(pronoun) && neutralTargets.stream().noneMatch(t -> t.isBefore(pronoun))) {
            return true;
        }
        if (targets.stream().anyMatch(t -> specificAntecedent.matches((Node)t)) && !GenderBias.sentenceAlreadyHasGenderNeutrality(pronoun)) {
            return true;
        }
        if (femalePronoun.matches(pronoun)) {
            if (targets.stream().noneMatch(NodePattern.N.form("nurse|midwife|secretary")::matches)) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasAnotherGenderInSentence(Node pronoun) {
        NodePattern anotherGender = malePronoun.matches(pronoun) ? femalePronoun : malePronoun;
        return pronoun.tree().nodes().stream().anyMatch(n -> anotherGender.matches((Node)n) && !neutralizedPronoun.matches((Node)n));
    }

    private static NodePattern pronounBias() {
        NodePattern noWh = NodePattern.N.noDependents(Questions.whPhrase);
        NodePattern noCondition = NodePattern.N.noDependents("mark|advmod", NodePattern.N.form("if|when"));
        NodePattern unboundEveryOne = NodePattern.N.withHead("nsubj.*", noWh.withHead("ccomp", noCondition.withDependent("nsubj.*", EnglishTreePatterns.someAnyEveryNoAnimate)));
        NodePattern pattern = NodePattern.or(nominativePronoun.andNot(CommonPatterns.lastToken).andNot(unboundEveryOne), possessivePronoun, accusativePronoun, reflexivePronoun).andNot(neutralizedPronoun);
        NodePattern suggestOne = nominativePronoun.and(EnglishParameters.VARIANT.withValue("GB.*"));
        return pattern.and((arg_0, arg_1) -> GenderBias.lambda$pronounBias$4(pattern, suggestOne, arg_0, arg_1)).message(PRONOUN_MESSAGE);
    }

    private static boolean sentenceRefersToSameGenderPersonFromContext(Node pronoun) {
        NodePattern sameGender = (femalePronoun.matches(pronoun) ? femalePronoun : malePronoun).andNot(neutralizedPronoun);
        return ((StreamEx)pronoun.back().skip(1L)).anyMatch(p -> sameGender.matches((Node)p) && GenderBias.possibleAntecedents(p).stream().noneMatch(t -> t.hasPos("NN")));
    }

    private static List<Node> findBiasedPronouns(List<Node> pronouns) {
        Map pronounsToTargets = StreamEx.of(pronouns).mapToEntry(p -> GenderBias.possibleAntecedents(p)).toCustomMap(LinkedHashMap::new);
        if (pronounsToTargets.isEmpty()) {
            return List.of();
        }
        GenderBias.addTransitiveTargets(pronounsToTargets);
        GenderBias.removeAllowedPronouns(pronounsToTargets);
        return new ArrayList<Node>(pronounsToTargets.keySet());
    }

    private static void addTransitiveTargets(Map<Node, Set<Node>> pronounsToTargets) {
        boolean changed;
        do {
            changed = false;
            for (Map.Entry<Node, Set<Node>> entry2 : pronounsToTargets.entrySet()) {
                Set toAdd = StreamEx.of((Collection)entry2.getValue()).flatCollection(p -> pronounsToTargets.getOrDefault(p, Set.of())).toSet();
                if (!entry2.getValue().addAll(toAdd)) continue;
                changed = true;
            }
        } while (changed);
    }

    private static void removeAllowedPronouns(Map<Node, Set<Node>> pronounsToTargets) {
        boolean changed;
        Set allowedPronouns = (Set)EntryStream.of(pronounsToTargets).filterKeyValue((p, targets) -> GenderBias.isGenderedPronounAllowed(p, targets)).keys().toCollection(HashSet::new);
        do {
            pronounsToTargets.keySet().removeAll(allowedPronouns);
            changed = false;
            for (Map.Entry<Node, Set<Node>> entry2 : pronounsToTargets.entrySet()) {
                if (!entry2.getValue().removeAll(allowedPronouns)) continue;
                allowedPronouns.add(entry2.getKey());
                changed = true;
            }
        } while (changed);
    }

    private static NodeCorrector toThey(List<Node> pronouns, String reflexive) {
        return NodeCorrector.joinAll(pronouns.stream().map(pr -> {
            if (reflexivePronoun.matches((Node)pr)) {
                return NodeCorrector.replace(pr, reflexive);
            }
            if (pr.hasForm("s?he")) {
                return GenderBias.nominativeToThey(pr);
            }
            return NodeCorrector.replace(pr, possessivePronoun.matches((Node)pr) ? "their" : "them");
        }).toList());
    }

    private static NodeCorrector nominativeToThey(Node node) {
        Node head;
        List<NodeCorrector> changeVerb;
        NodeCorrector they = NodeCorrector.replace(node, "they");
        if (node.hasHeadRelation("nsubj.*") && (changeVerb = new AgreementSet(node, Number.plural).changeVerbNumber(EnglishTreePatterns.findFiniteVerb(head = Objects.requireNonNull(node.head())), false)) != null && !changeVerb.isEmpty()) {
            return they.join((NodeCorrector)StreamEx.of(changeVerb).reduce(NodeCorrector::or).orElseThrow());
        }
        return they;
    }

    private static NodeCorrector toSheOrHe(List<Node> pronouns, boolean startWithShe) {
        return NodeCorrector.joinAll(IntStreamEx.ofIndices(pronouns).mapToObj(i -> {
            boolean she;
            Node pr = (Node)pronouns.get(i);
            boolean bl = she = i % 2 == 0 == startWithShe;
            if (reflexivePronoun.matches(pr)) {
                return NodeCorrector.replace(pr, she ? "herself or himself" : "himself or herself");
            }
            if (pr.hasForm("s?he")) {
                return NodeCorrector.replace(pr, she ? "she or he" : "he or she");
            }
            if (possessivePronoun.matches(pr)) {
                return NodeCorrector.replace(pr, she ? "her or his" : "his or her");
            }
            return NodeCorrector.replace(pr, she ? "her or him" : "him or her");
        }).toList());
    }

    private static boolean sentenceAlreadyHasGenderNeutrality(Node pronoun) {
        return pronoun.tree().nodes().stream().anyMatch(neutralizedPronoun::matches);
    }

    private static NodePattern useGenderNeutralMultiWordExpressions() {
        Map<String, List<PhraseReplacement>> entries2 = PhraseReplacement.parseLines(WordSet.loadLines("en/words/gendered_expressions.txt"));
        Set<String> keys = entries2.keySet();
        NodePattern fromFile = NodePattern.or(NodePattern.N.lemma(keys), NodePattern.N.form(keys)).and((node, match) -> {
            for (PhraseReplacement.MatchStrategy strategy : List.of(PhraseReplacement.MatchStrategy.Form, PhraseReplacement.MatchStrategy.Lemma)) {
                PhraseReplacement phrase = strategy.findRule(node, entries2);
                if (phrase == null) continue;
                return EnglishTreePatterns.replaceNominalPhrase(node, match, phrase, strategy);
            }
            return null;
        });
        NodePattern definitelyVerb = NodePattern.N.pos("VB.*").andOr(NodePattern.N.noPos("VBP?"), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|obj|obl")).noDependents("cop");
        NodePattern man = NodePattern.N.lemma("man");
        NodePattern woman = NodePattern.N.lemma("woman");
        NodePattern manWomanTogether = NodePattern.or(man.inSentenceWith(woman), woman.inSentenceWith(man));
        NodePattern knownSubj = CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.form("I|you|s?he").markAs("PronSubj")));
        NodePattern aboutSomeoneWithKnownGender = NodePattern.or(CommonPatterns.possiblySkipUp("xcomp", CommonPatterns.possiblySkipUp("xcomp", knownSubj)), NodePattern.N.withHead("obj", NodePattern.N.withHead("xcomp", knownSubj))).andNot(NodePattern.N.form(".+man").noForm(".+woman").and(NodePattern.markedNodeMatches("PronSubj", NodePattern.N.form("she"))));
        return NodePattern.or(fromFile.andNot(NodePattern.N.form("postman").and(CommonPatterns.capitalized)).andNot(NodePattern.N.withHead("amod", manWomanTogether)).andNot(NodePattern.N.inFormSequence(1, "on", "average")).andNot(NodePattern.N.inFormSequence(1, "travell?ing", "salesman")).andNot(aboutSomeoneWithKnownGender), NodePattern.N.inFormSequence(2, "like", "a", "man").andOr(NodePattern.N.withHead("obl", NodePattern.N.noLemma("look")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "resolutely", "bravely")), NodePattern.N.withDependent("cop").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "resolute", "brave"))), NodePattern.N.form("made").and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("man").markAs("Man"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Man"), NodePointer.anchor(), "artificial", "handmade", "hand-built", "synthetic", "manufactured", "fabricated", "constructed")), definitelyVerb.andOr(NodePattern.N.lemma("father").correct(EnglishTreePatterns.changeVerbLemma("beget")).correct(EnglishTreePatterns.changeVerbLemma("create")).correct(EnglishTreePatterns.changeVerbLemma("foster")).correct(EnglishTreePatterns.changeVerbLemma("sire")), NodePattern.N.lemma("mother").correct(EnglishTreePatterns.changeVerbLemma("care").join(NodeCorrector.insertAfter(" for"))).correct(EnglishTreePatterns.changeVerbLemma("nurture")), man.correct(EnglishTreePatterns.changeVerbLemma("staff")).correct(EnglishTreePatterns.changeVerbLemma("run")).correct(EnglishTreePatterns.changeVerbLemma("operate")))).andNot(NodePattern.N.withHead(NodePattern.or(person, NodePattern.N.withDependent("<unk>")))).andNot(NodePattern.N.withHead("xcomp|compound", NodePattern.N.withHead(CommonPatterns.skipUp("acl:relcl", person)))).andNot(NodePattern.N.withDependent(".*", CommonPatterns.skipForward(NodePattern.N.withHeadRelation("appos"), CommonPatterns.skipForward(CommonPatterns.dot.after(CommonPatterns.capitalized), person)))).andNot(NodePattern.N.withDependent("appos", person)).andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("cop").withDependent("nsubj", person))).andNot(NodePattern.N.withHead("xcomp", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", person))).andNot(NodePattern.N.lemma(".+man").and(n -> n.back().anyMatch(NodePattern.N.lemma("he|his")::matches))).andNot(CommonPatterns.insideQuotes).andNot(CommonPatterns.capitalizedMiddle).message(NOUN_MESSAGE);
    }

    private static NodePattern useNeutralHonorific() {
        NodePattern femPerson = NodePattern.N.label("PERSON").noForm("Hudson|Dalloway|Dursley|Monique|Marple|Maisel|Denvers");
        return femaleHonorific.andOr(NodePattern.N.directlyBefore(femPerson).correct(NodeCorrector.replace("Ms.", "Mx.")), NodePattern.N.directlyBefore(CommonPatterns.dot.directlyBefore(femPerson)).correct(NodeCorrector.replace("Ms", "Mx"))).message(HONORIFIC_MESSAGE);
    }

    private static Set<Node> possibleAntecedents(Node pronoun) {
        LinkedHashSet<Node> result2 = new LinkedHashSet<Node>();
        String prevHead = null;
        boolean allowReferents = reflexivePronoun.matches(pronoun) || pronoun.hasHeadRelation("nmod:poss");
        for (Node each : pronoun.hierarchy().toList()) {
            if (allowReferents) {
                result2.addAll(GenderBias.possibleAntecedents(pronoun, each, "advcl".equals(prevHead)));
            }
            List<Node> advClauses = each.findDependents("advcl");
            for (Node advcl : advClauses) {
                if (!advcl.isBefore(pronoun)) continue;
                result2.addAll(GenderBias.possibleAntecedents(pronoun, advcl, false));
            }
            if (bindingDomainBorder.matches(each)) {
                allowReferents = true;
            }
            prevHead = each.headRelation();
        }
        return result2;
    }

    private static List<Node> possibleAntecedents(Node pronoun, Node clause, boolean allowForwardRef) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node dep : clause.allDependents()) {
            if (!dep.isBefore(pronoun) && !allowForwardRef || !np.matches(dep)) continue;
            list.add(dep);
            if (!dep.headRelation().startsWith("nsubj")) continue;
            list.addAll(GenderBias.relclAntecedents(pronoun, dep));
            for (Node nmod : dep.findDependents("nmod")) {
                list.addAll(GenderBias.relclAntecedents(pronoun, nmod));
            }
        }
        return list;
    }

    private static List<Node> relclAntecedents(Node pronoun, Node dep) {
        Node relcl = dep.findSingleDependent("acl:relcl");
        return relcl == null ? List.of() : GenderBias.possibleAntecedents(pronoun, relcl, false);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ NodeMatch lambda$pronounBias$4(NodePattern pattern, NodePattern suggestOne, Node node, NodeMatch match) {
        if (((StreamEx)node.back().skip(1L)).anyMatch((Predicate<Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, matches(ai.grazie.rules.tree.Node ), (Lai/grazie/rules/tree/Node;)Z)((NodePattern)pattern))) {
            return null;
        }
        if (GenderBias.hasAnotherGenderInSentence(node)) {
            return null;
        }
        all = GenderBias.findBiasedPronouns(((StreamEx)StreamEx.of((Object)node).append((Stream)((StreamEx)node.forward().skip(1L)).filter((Predicate<Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, matches(ai.grazie.rules.tree.Node ), (Lai/grazie/rules/tree/Node;)Z)((NodePattern)pattern)))).toList());
        if (all.isEmpty()) {
            return null;
        }
        first = all.get(0);
        if (GenderBias.sentenceRefersToSameGenderPersonFromContext(first)) {
            return null;
        }
        suggestThey = first.tree().nodes().stream().noneMatch((Predicate<Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, matches(ai.grazie.rules.tree.Node ), (Lai/grazie/rules/tree/Node;)Z)((NodePattern)GenderBias.neutralizedPronoun));
        v0 = match.withCorrector(suggestThey != false ? GenderBias.toThey(all, "themselves") : null).withCorrectors(List.of(GenderBias.toSheOrHe(all, true), GenderBias.toSheOrHe(all, false)));
        if (!suggestThey) ** GOTO lbl-1000
        if (all.stream().anyMatch((Predicate<Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, matches(ai.grazie.rules.tree.Node ), (Lai/grazie/rules/tree/Node;)Z)((NodePattern)GenderBias.reflexivePronoun))) {
            v1 = GenderBias.toThey(all, "themself");
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        match = v0.withCorrector(v1);
        if (all.size() == 1 && suggestOne.matches(first)) {
            match = match.withCorrector(NodeCorrector.replace(first, new String[]{"one"}));
        }
        return match.withReportedNodes(all);
    }
}

