/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FormattingIssues;
import ai.grazie.rules.common.PairedPunctuation;
import ai.grazie.rules.common.PhraseCommaChange;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.common.ZeroWidthSpaceRule;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishDateChecker;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.HyphenVsDash;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.TagQuestions;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.VariantDifferences;
import ai.grazie.rules.en.WordOrder;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.util.CharUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.tools.StringTools;

class PunctuationRules {
    static final NodePattern commaLike = NodePattern.or(NodePattern.N.form("-+|[,;:]"), EnglishTreePatterns.quotations, EnglishTreePatterns.dashes, CommonPatterns.arrow);
    private static final NodePattern sentenceWithPort = NodePattern.N.inSentenceWith(NodePattern.N.form("ports?"));
    static final NodePattern gerundCommaAdverbial = NodePattern.N.pos("VBG").withDependent(".*", NodePattern.not(NodePattern.PUNCT)).andOr(CommonPatterns.firstChildPhrase, NodePattern.N.withPrevSibling(CommonPatterns.firstChildPhrase.pos("CC")), NodePattern.N.afterHead().and(CommonPatterns.possiblySkipDown("i?obj|obl|advmod", Commas.withEven.andNot(NodePattern.N.withHeadRelation("advcl").noDependents("punct", CommonPatterns.comma).withPrevSibling(NodePattern.N.afterHead().withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.pos("VB.*")))))).noDependents("punct", CommonPatterns.comma.afterHead())).andNot(NodePattern.N.withDependent("mark|advmod", NodePattern.N.form("if|when")).withDependent("aux")).andNot(NodePattern.N.withHead("advcl", NodePattern.N.pos("VBZ").noDependents("cop|aux|aux:pass").noDependents("nsubj.*|expl", NodePattern.N.beforeHead().and(n -> SubjectVerbAgreement.subjectNumber(n, n.head()) != Number.plural)))).noDependents("advmod", NodePattern.N.form("only")).noDependents("mark", NodePattern.or(NodePattern.N.form("by|before|after|in|that"), NodePattern.N.form("because").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("of")))));
    private static final NodePattern commaAdverbial = NodePattern.N.markAs("Adverbial").and(NodePattern.or(Commas.adverbsToFrontWithComma.and(CommonPatterns.firstChildPhrase).and(NodePattern.or(NodePattern.N.form("however|therefore"), CommonPatterns.firstPhrase)), gerundCommaAdverbial.withHead("advcl", EnglishTreePatterns.clause.withDependent("expl|nsubj.*")), NodePattern.N.withHead("advcl", EnglishTreePatterns.clause.after("Adverbial")).and(NodePattern.or(NodePattern.or(Semantics.directSpeech, NodePattern.N.lemma("know|have"), NodePattern.N.withDependent("cop|aux:pass")).withDependent("mark", NodePattern.N.form("as").andNot(NodePattern.N.inFormSequence(2, "same", "time", "as"))).noDependents("advmod", NodePattern.N.form("even")), NodePattern.N.withDependent("mark", NodePattern.N.form("besides")).and(NodePattern.or(NodePattern.N.pos("VBG"), NodePattern.N.withDependent("aux", NodePattern.N.pos("VBG")))), NodePattern.N.inFormSequence(0, "compared", "to"))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("obl|advcl").withDependent("case").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl")).trace("possibly misattached NP")).noDependents("advcl", NodePattern.N.afterHead().pos("NN.*").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").trace("NP attached too deep")), NodePattern.N.beforeHead().pos("VB").withHead("advcl", EnglishTreePatterns.clause.noDependents("nsubj|obj", NodePattern.N.before("Adverbial")).noHeadRelation("conj")).withDependent("mark", NodePattern.N.form("to")).noDependents("cop|aux|aux:pass").andNot(NodePattern.N.withNextSibling(NodePattern.N.beforeHead().withHeadRelation("advcl|obl"))).andNot(NodePattern.N.noDependents(".*", NodePattern.N.afterHead()).withHead(NodePattern.N.withDependent("conj|parataxis", NodePattern.N.noDependents("cc")))).andNot(NodePattern.N.withPrevSibling(NodePattern.or(NodePattern.N.inFormSequence(1, "in", "part"), NodePattern.N.form(".+ly").withHeadRelation("advmod")))).andNot(CommonPatterns.closestDepToHead.withHead(CommonPatterns.lastWord.potentialPos("NN").directlyAfter(NodePattern.N.pos("NN"))).trace("misparsed root NP")), NodePattern.N.withHeadRelation("obl").and(NodePattern.or(Commas.accordingToX, NodePattern.N.withDependent("case", NodePattern.N.form("compared")).withHead(NodePattern.N.after("Adverbial")), Commas.onTheXHand, Commas.inOpinion.andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHead("obj", NodePattern.N.lemma("seek")))), CommonPatterns.firstChildPhrase.form("default").and(EnglishTreePatterns.byPP), Commas.inTurn, Commas.asAResult.and(CommonPatterns.firstPhrase).withNextSibling(NodePattern.N.withHeadRelation("nsubj.*").beforeHead()), Commas.inAddition.and(CommonPatterns.firstChildPhrase))), Commas.forExample, Commas.anyRelcl));
    private static final NodePattern withReasonWords = NodePattern.or(NodePattern.N.withDependent("advmod|cc", NodePattern.N.form("so|as|since|for")), NodePattern.N.withDependent("advmod", NodePattern.N.form("where")).noHeadRelation("acl:relcl"), NodePattern.N.withDependent("mark", NodePattern.N.form("if|while|because|so|as|where")));
    private static final NodePattern suspiciousDep = NodePattern.N.withHeadRelation("dep").noForm("/").noPos();
    static final NodePattern unmandatedComma = CommonPatterns.comma.and(node -> {
        List<CommaLicense> licenses = Commas.allCommaLicenses(node.tree());
        return licenses.stream().noneMatch(c -> c.allows((Node)node));
    }).andNot(NodePattern.N.inSentenceWith(suspiciousDep)).and(CommonPatterns.touchHierarchy);
    static final NodePattern removeUnmandatedComma = unmandatedComma.and(CommonPatterns.reportWithPrevWord).correct(NodeCorrector.replace(""));
    private static final String TOO_MANY_PUNCTUATION_MARKS = "Too many punctuation marks";
    private static final String WRITE_CONTRACTIONS_WITHOUT_SPACES = "Write contractions without spaces";
    private static final String UNNECESSARY_HYPHEN = "Unnecessary hyphen?";
    private static final String POLITE_COMMA = "Use a comma before '$_' interjection at the end of a sentence";
    private static final String EXCESSIVE_COLON_MESSAGE = "Don\u2019t put a colon after phrases such as 'such as,' 'including,' and 'for example.'";
    private static final String REMOVE_HOWEVER_COMMA_MSG = "Don\u2019t add a comma after 'however' if it is not a linking word";
    private static final String SPLICING_MSG = "Consider separating independent sentences with stronger punctuation";
    private static final String COMMA_BEFORE_CC_MSG = "Add a comma between clauses unless they are short and closely related";
    private static final String COMMA_THAT_MSG = "Don\u2019t put a comma before 'that'";
    private static final String COMMA_ET_AL_MSG = "Don\u2019t put a comma before 'et al.'";
    private static final String COMMA_NOT_ONLY_BUT_ALSO_MSG = "Short 'not only... but also...' phrases usually don\u2019t need a comma";
    private static final String LIST_COLON_MSG = "Use a colon to introduce a list";
    private static final String MISSING_SUBORDINATION_COMMA_MSG = "Missing comma after a subordinate clause?";
    private static final String REDUNDANT_SUBORDINATION_COMMA_MSG = "Redundant comma before a subordinate clause?";
    private static final String MISSING_QUESTION_MARK_MSG = "Is this a question?";
    private static final String DIRECT_SPEECH_MISSING_PUNCTUATION = "Missing direct speech punctuation?";
    private static final String DIRECT_SPEECH_MISSING_COMMA_AFTER = "Missing comma after direct speech?";
    private static final String DIRECT_SPEECH_MISSING_COMMA_BEFORE = "Missing comma before direct speech?";
    private static final String DIRECT_SPEECH_COMMA_BEFORE_QUOTE_US = "Comma should precede closing quote after direct speech in American English";
    private static final String IS_ABBREVIATION_MSG = " is an abbreviation and thus needs a single period at the end";
    static final NodePattern possiblySententialRelative = NodePattern.N.withDependent("nsubj", NodePattern.N.form("which")).withHead(NodePattern.N.inPhrase(EnglishTreePatterns.clause).markAs("ClauseHead")).withPhraseEnd(NodePattern.or(CommonPatterns.lastWord, NodePattern.N.markAs("PhraseEnd").directlyBefore(NodePattern.N.inPhrase(NodePattern.N.after("PhraseEnd").withHead("conj|parataxis", NodePattern.N.before("ClauseHead"))))));
    static final NodePattern commaSplicing = PunctuationRules.commaSplicing();
    private static final NodePattern wordInternalPunctuation = FormattingIssues.wordInternalPunctuation("Missing space?", "and|but|yet|or|just").andNot(FormattingIssues.possiblyChainedReference3.withNeighbor(2, NodePattern.N.withHead(NodePattern.N.lemma("type|method|field|class|expression|member|framework"))));
    private static final NodePattern joinedNumberWord = FormattingIssues.joinedNumberWord("Missing space?", "NNPS?", word -> word.form().length() >= 4 || word.form().length() >= 2 && word.hasPos("CC") || word.hasPos("IN"));
    static final NodePattern wordInternalSentenceBoundary = NodePattern.or(wordInternalPunctuation.and((node, match) -> match.suppressableKind == NodeMatch.SuppressableKind.UNDECORATED_SENTENCE_SEPARATION ? match : null), joinedNumberWord);
    private static final NodePattern possiblyInformalQuestion = NodePattern.N.withDependent("advmod", NodePattern.N.form("maybe"));
    private static final String ET_AL_MSG = "'et al.' is an abbreviation for 'et alii' and thus needs a single period at the end";
    private static final int COMMA_CLAUSE_MIN_LENGTH = 4;
    private static final int CC_LENGTH = 1;
    private static final String ETC_COMMA_MESSAGE = "A comma is necessary before 'etc.' in lists";
    static final NodePattern incompleteOptionalPluralParen = CommonPatterns.openingParen.noSpaceAround().directlyBefore(NodePattern.N.formCaseSensitive("s")).directlyAfter(NodePattern.N.pos("NNP?")).andNot(NodePattern.N.withNeighbor(2, CommonPatterns.closingParen)).and((paren, match) -> {
        Node noun = paren.neighbor(-1);
        String concat = noun.lowForm() + "s";
        if (paren.tree().treeSupport().tagToken(concat).hasPos("NNP?S")) {
            return match.withMessage("Did you mean plural '" + concat + "'?").withCorrector(NodeCorrector.insertAfter(noun.neighbor(2), ")")).withCorrector(NodeCorrector.replaceNodes(noun, noun.neighbor(2), concat));
        }
        return null;
    });
    private static final NodePattern theOnes = NodePattern.N.form("ones?").withDependent("det", NodePattern.N.form("the"));
    private static final NodePattern possiblyHeadOfNonRestrictiveClause = NodePattern.or(theOnes.withDependent("amod", NodePattern.N.noForm("only")), NodePattern.N.label(".*"), CommonPatterns.capitalizedMiddle.withDependent("compound", NodePattern.N.noPos()), NodePattern.N.withHead("nsubj.*", NodePattern.ROOT).withDependent("det", EnglishTreePatterns.demonstratives), NodePattern.N.withDependent("amod", CommonPatterns.capitalizedMiddle.noDependents("punct")), NodePattern.N.withDependent("nmod:poss", NodePattern.N.noForm("there")).andNot(Semantics.definitelyUncountableNoun).noDependents("amod", NodePattern.N.form("own")).noDependents("conj")).noDependents("det", NodePattern.N.form("an?"));
    private static final NodePattern removeSurroundingCommas = NodePattern.custom((node, match) -> {
        PhraseCommaChange change = PhraseCommaChange.removeSurroundingCommas(node.phraseStart(), node.phraseEnd(), unmandatedComma);
        return change == null ? null : change.highlightAndCorrect(match);
    }).and(CommonPatterns.touchHierarchy);
    private static final NodePattern seemsClosingQuotation = EnglishTreePatterns.aposOrQuote.and(Quotes.closingPosition);
    private static final NodePattern seemsOpeningQuotation = EnglishTreePatterns.aposOrQuote.and(Quotes.openingPosition);
    static final NodePattern commaOrOpening = NodePattern.or(NodePattern.PUNCT.andNot(seemsClosingQuotation.andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT))), CommonPatterns.arrow);
    static final NodePattern commaOrClosing = NodePattern.or(NodePattern.PUNCT.noForm("``+").andNot(seemsOpeningQuotation).andNot(NodePattern.N.directlyAfter(seemsOpeningQuotation)), CommonPatterns.arrow);
    static final String aposTypos = "[\u00b4\u2032`;<>4\"!@#$%^&*()+]";
    static final Rule.PatternRule missingDot = new Rule.PatternRule("Punctuation.MISSING_DOT", "Missing dot", "Missing dot or other punctuation marks at the end of a declarative sentence.", null, PunctuationRules.missingDot(), new Example[0]);
    private static final NodePattern withQuoteMarkAfterDirectSpeechVerb = NodePattern.N.withDependent("punct", EnglishTreePatterns.aposOrQuote.noSpaceAfter().and(CommonPatterns.afterSkipping(CommonPatterns.comma, NodePattern.N.alreadyMarkedAs("DirectSpeechVerb"))));
    private static final NodePattern beforeDot = NodePattern.N.directlyBefore(NodePattern.N.form("\\.+|\u2026"));

    PunctuationRules() {
    }

    private static NodePattern commaSplicing() {
        NodePattern withCoordinatingWords = NodePattern.or(NodePattern.N.withDependent("cc", NodePattern.N.form("and|but|or|yet|while")), NodePattern.N.withDependent("advmod", Commas.egIe), NodePattern.N.lemma("be").directlyBefore(NodePattern.N.form("why")));
        NodePattern withSubordinatingWords = NodePattern.or(withReasonWords, NodePattern.N.withDependent("nsubj.*|obj|obl", Questions.whPhrase), NodePattern.N.withHeadRelation("parataxis").withDependent("mark", NodePattern.N.markAs("Mark")).noDependents("cop", NodePattern.N.before("Mark")).trace("it's based on X, not whether Y"), NodePattern.N.withDependent("cop", NodePattern.N.form("be").withNextSibling(NodePattern.N.withHeadRelation("nsubj"))).noDependents("aux.*"));
        NodePattern frontedAdvCl = NodePattern.N.withDependent("advcl", CommonPatterns.firstChildPhrase.beforeHead().withDependent("mark", NodePattern.N.form("to")).noDependents(NodePattern.N.afterHead()).withNextSibling(NodePattern.not(NodePattern.PUNCT)));
        NodePattern frontedSubordinate = NodePattern.or(NodePattern.N.withDependent("obl", Commas.inAddition), frontedAdvCl, NodePattern.ROOT.withDependent("mark", NodePattern.N.form("whereas")), NodePattern.ROOT.and(CommonPatterns.firstWord).pos("VBN").withDependent("advmod"));
        NodePattern ambiguousSubordination = NodePattern.or(CommonPatterns.possiblySkipDown("advmod", NodePattern.N.withDependent("advcl", NodePattern.N.afterHead().and(Commas.commaStartingPhrase).and(withSubordinatingWords))), NodePattern.N.withDependent("advcl", NodePattern.N.beforeHead().and(withSubordinatingWords)));
        NodePattern misparsedRelCl = NodePattern.N.withDependent("nsubj", CommonPatterns.firstChildPhrase.form("that").markAs("That")).andOr(NodePattern.N.withHeadRelation("acl:relcl"), NodePattern.N.withHeadRelation("parataxis").withPrevSibling(CommonPatterns.skipBack(CommonPatterns.comma, NodePattern.N.onlyPos("NNS?").withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").markAs("HeadNoun"))).andOr(NodePattern.N.pos("VB[DP]?"), NodePattern.N.pos("VBZ").and(NodePattern.markedNodeMatches("HeadNoun", NodePattern.N.pos("NN")))));
        NodePattern validClause2 = NodePattern.or(EnglishTreePatterns.verbalClause, NodePattern.N.withDependent("cop|aux|aux:pass")).withDependent("nsubj.*|expl").noDependents("mark", NodePattern.N.form("that")).andNot(misparsedRelCl.trace("misparsed relative clause")).andNot(ambiguousSubordination).noDependents("cop", NodePattern.N.form("being")).andNot(NodePattern.N.withPhraseStart(NodePattern.N.withHeadRelation("advcl").noPos()).trace("possibly misparsed conjunction")).andNot(TagQuestions.possiblyTagQuestion);
        NodePattern withFrontedIntroduction = NodePattern.N.withDependent("advmod", CommonPatterns.firstChildPhrase);
        NodePattern checkJoining = NodePattern.custom((comma, match) -> {
            Node prev = comma.neighbor(-1);
            Node next = comma.neighbor(1);
            ArrayList<Node> clausesBefore = new ArrayList<Node>(((StreamEx)((StreamEx)prev.hierarchy().takeWhile(n -> n.isBefore(comma))).filter(EnglishTreePatterns.clause::matches)).toList());
            ArrayList<Node> clausesAfter = new ArrayList<Node>(((StreamEx)((StreamEx)next.hierarchy().takeWhile(n -> n.isAfter(comma))).filter(EnglishTreePatterns.clause::matches)).toList());
            Node clause2 = match.getMarkedNode("Clause2");
            Node clause1 = Objects.requireNonNull(clause2.head());
            if (clause1.findDependents("ccomp").stream().anyMatch(c -> c.isAfter(clause2))) {
                return null;
            }
            if (comma.back().anyMatch(n -> CommonPatterns.colon.matches((Node)n) || CommonPatterns.semicolon.matches((Node)n))) {
                return null;
            }
            if (PunctuationRules.isTooSmall(clause2) && !withFrontedIntroduction.matches(clause2)) {
                return null;
            }
            if (clause1.nextUntil(clause2.phraseStart()).anyMatch(EnglishTreePatterns.sentenceBoundary::matches)) {
                return null;
            }
            if (PunctuationRules.hasParataxisBeforeClause2(clause1, clause2)) {
                return null;
            }
            clausesBefore.removeIf(n -> !n.isInPhraseOf(clause1));
            clausesAfter.removeIf(n -> !n.isInPhraseOf(clause2));
            if (!PunctuationRules.hasInternalComplexity(clause1, clause2) && !PunctuationRules.hasInternalComplexity(clause2, null)) {
                return null;
            }
            if (clausesBefore.stream().anyMatch(c1 -> PunctuationRules.seemAboutTheSame(c1, (Node)clausesAfter.get(0)) || PunctuationRules.seemsRequiringExplanation(c1) || frontedSubordinate.matches((Node)c1) || c1.phraseStart().startOffset() > 0 && withReasonWords.matches((Node)c1))) {
                return null;
            }
            if (clausesAfter.stream().anyMatch(c2 -> frontedAdvCl.matches((Node)c2))) {
                return null;
            }
            if (clausesBefore.stream().anyMatch(c1 -> PunctuationRules.hasConjWithCCAfter(c1, clause2))) {
                return null;
            }
            if (clausesAfter.stream().anyMatch(n -> NodePattern.or(withCoordinatingWords, withSubordinatingWords, Semantics.directSpeech).matches((Node)n) || PunctuationRules.hasConjWithCCAfter(n, n))) {
                return null;
            }
            if (comma.tree().nodes().stream().anyMatch(NodePattern.or(suspiciousDep, wordInternalSentenceBoundary)::matches)) {
                return null;
            }
            boolean mayAddDash = NodePattern.N.inFormSequence(0, "for", "example").matches(next);
            boolean mayAddLinkingWord = !NodePattern.N.withDependent("advmod", Commas.adverbsToFrontWithComma).matches(clause2);
            Object message = SPLICING_MSG;
            message = (String)message + (mayAddLinkingWord ? " or a linking word" : "");
            if (mayAddDash) {
                match = match.withCorrector(NodeCorrector.replace(comma, " \u2014"));
            }
            NodeCorrector splitSentences = NodeCorrector.replace(comma, ".").join(NodeCorrector.rawReplace(next.textRange(), StringTools.uppercaseFirstChar((String)next.form(), (Language)next.language())));
            return match.withTouchedNodes(clause1, clause2).withMessage((String)message).withCorrector(NodeCorrector.replace(comma, ";")).withCorrector(splitSentences);
        });
        NodePattern ambiguousClauseBoundary = CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("obl").and(Commas.commaStartingPhrase));
        NodePattern misparsedCoordination = NodePattern.N.withDependent("conj", NodePattern.N.after("Clause2"));
        return CommonPatterns.comma.markAs("Comma").directlyBefore(NodePattern.N.inPhrase(NodePattern.N.markAs("Clause2").withHead("parataxis", EnglishTreePatterns.clause.before("Comma").andNot(misparsedCoordination).andNot(NodePattern.N.lemma("know").noDependents("ccomp", NodePattern.N.before("Clause2")))).withPhraseStart(NodePattern.not(NodePattern.N.before("Comma"))).and(EnglishTreePatterns.clause).and(validClause2)).noForm("[\"(]").includeIntoReport().andOptionally(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.not(NodePattern.PUNCT).includeIntoReport()))).and(checkJoining).directlyAfter(NodePattern.not(NodePattern.N.withHeadRelation("discourse")).noForm("thus").andNot(NodePattern.N.inFormSequence(1, "that", "is")).andNot(ambiguousClauseBoundary).andNot(CommonPatterns.capitalizedMiddle.withHeadRelation("advmod"))).andNot(CommonPatterns.inParentheses).and(CommonPatterns.reportWithPrevWord);
    }

    private static boolean isTooSmall(Node clause2) {
        return ((StreamEx)clause2.phraseStart().forward().filter(n -> !NodePattern.PUNCT.matches((Node)n))).count() < 4L;
    }

    private static boolean hasParataxisBeforeClause2(Node clause1, Node clause2) {
        return clause1.findDependents("parataxis").stream().anyMatch(c -> c.isBefore(clause2) && CommonPatterns.comma.matches(c.phraseStart().prevNode()));
    }

    private static boolean seemsRequiringExplanation(Node clause) {
        return Semantics.differOrSame.matches(clause);
    }

    private static boolean hasConjWithCCAfter(Node clause, Node anchorAfter) {
        return ((StreamEx)anchorAfter.forward().skip(1L)).anyMatch(n -> {
            Node head = n.head();
            return n.hasHeadRelation("cc") && head != null && head.hasHeadRelation("conj") && (head.tree().isLocal() || EnglishTreePatterns.clause.matches(head)) && head.hierarchy().has((Object)clause);
        });
    }

    private static boolean seemAboutTheSame(Node clause1, Node clause2) {
        if (Commas.withEven.matches(clause2)) {
            return false;
        }
        Set aux1 = StreamEx.of(clause1.findDependents("aux")).flatCollection(Tree.Token::lemmaReadings).toSet();
        if (clause2.findDependents("aux").stream().anyMatch(aux -> aux.lemmaReadings().stream().anyMatch(aux1::contains))) {
            return true;
        }
        if (clause2.hasDependent("cop")) {
            if (clause1.hasDependent("cop") && PunctuationRules.noClausalDependentsBetween(clause1, clause2)) {
                return true;
            }
            if (PunctuationRules.noChildPunctBefore(clause2) && PunctuationRules.hasSameWordWithNumber(clause1, clause2)) {
                return true;
            }
        }
        Node subj1 = clause1.findSingleDependent("nsubj(:pass|:outer)?|csubj(:pass)?");
        Node subj2 = clause2.findSingleDependent("nsubj(:pass|:outer)?|csubj(:pass)?");
        if (subj1 != null && subj2 != null) {
            if (subj1.form().equalsIgnoreCase(subj2.form())) {
                return true;
            }
            if (subj1.hasPos("NNP") && subj2.hasLemma("s?he")) {
                return true;
            }
            if (subj1.hasForm("it") && clause2.allDependents().stream().anyMatch(n -> n.hasForm("it"))) {
                return true;
            }
            Node poss1 = subj1.findSingleDependent("nmod:poss");
            Node poss2 = subj2.findSingleDependent("nmod:poss");
            return poss1 != null && poss2 != null && poss1.form().equalsIgnoreCase(poss2.form());
        }
        return false;
    }

    private static boolean noChildPunctBefore(Node clause) {
        return clause.phraseStart().nextUntil(clause).noneMatch(NodePattern.PUNCT::matches);
    }

    private static boolean noClausalDependentsBetween(Node clause1, Node clause2) {
        return clause1.findDependents("advcl|acl(:relcl)?|ccomp|parataxis").stream().noneMatch(c -> c.isAfter(clause1) && c.isBefore(clause2));
    }

    private static boolean hasSameWordWithNumber(Node clause, Node word) {
        return word.hasDependent("nummod") && clause.phraseStart().nextUntil(word.phraseStart()).anyMatch(n -> n.lowForm().equals(word.lowForm()) && n.hasDependent("nummod"));
    }

    private static boolean hasInternalComplexity(Node clause, @Nullable Node nextClause) {
        if (clause.hasDependent("ccomp|acl.*") || clause.hasHeadRelation("csubj") || clause.findDependents("advcl").stream().anyMatch(n -> n.isBefore(clause)) || clause.findDependents("obj|obl").stream().anyMatch(n -> n.hasDependent("acl"))) {
            return true;
        }
        return PunctuationRules.hasInternalCommas(clause, nextClause);
    }

    private static boolean hasInternalCommas(Node clause, @Nullable Node nextClause) {
        Node end;
        Node start = clause.phraseStart();
        Node node = end = nextClause != null ? nextClause.phraseStart().neighbor(-1) : clause.phraseEnd();
        if (nextClause == null) {
            for (Node dep : clause.findDependents("conj|parataxis")) {
                if (!dep.isAfter(clause)) continue;
                end = dep.phraseStart().neighbor(-1);
                break;
            }
        }
        return start.nextUntil(end).anyMatch(CommonPatterns.comma::matches);
    }

    private static NodePattern relativeClauseComma_ProperNoun() {
        NodePattern specificProper = Commas.properNoun.withDependent("det", NodePattern.N.form("the")).noDependents("flat|appos").andNot(Articles.geoRequiringThe).andNot(NodePattern.N.formCaseSensitive("Forces?").withDependent("compound", NodePattern.N.form("space|air|armed"))).noForm("Dalai|Lama|Pope").noLabel("NATIONALITY_OR_GROUP|PRODUCT|ORGANIZATION");
        return NodePattern.or(Commas.properNonRestrictiveRelClause().andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("cc")))).and(PunctuationRules.surroundWithCommas(NodePattern.N, "a non-restrictive clause on a proper noun")), EnglishTreePatterns.clause.withHead("acl:relcl", specificProper).noDependents(NodePattern.N.form("which")).and(PunctuationRules.thatToWhichWho()).and(removeSurroundingCommas));
    }

    private static NodePattern relativeClauseComma_That() {
        NodePattern possiblyMisparsedIndependentClause = NodePattern.custom(Semantics::canDescribeAbstractConcept).and(NodePattern.markedNodeMatches("Noun", NodePattern.N.afterHead().withHead(NodePattern.N.inPhrase(EnglishTreePatterns.clause.before("Noun"))))).and(NodePattern.markedNodeMatches("That", NodePattern.N.withHeadRelation("nsubj.*")));
        return EnglishTreePatterns.clause.markAs("RelCl").withHead("acl:relcl", NodePattern.N.pos("NN.*").markAs("Noun").noDependents("amod", NodePattern.N.afterHead().before("RelCl")).noDependents("advmod", Commas.egIe.afterHead().before("RelCl")).withHeadRelation("nsubj.*|i?obj|obl.*|nmod|root").andNot(NodePattern.N.withHeadRelation("obl:tmod").withDependent("det")).andNot(NodePattern.N.withHead("nsubj.*", NodePattern.N.pos("VBN").directlyAfter(CommonPatterns.comma).noDependents("i?obj")))).withDependent("nsubj.*|mark", NodePattern.N.form("that").markAs("That")).noDependents("advmod", Commas.egIe.before("RelCl")).andNot(NodePattern.N.withDependent("nsubj", NodePattern.N.after("That")).withDependent("cop")).and(removeSurroundingCommas).and(PunctuationRules.thatToWhichWho()).andNot(NodePattern.custom(n -> n.forward().anyMatch(NodePattern.N.inFormSequence(1, "and", "that")::matches))).andNot(PunctuationRules.hasPunctuationAfter(CommonPatterns.comma.directlyBefore(NodePattern.N.form("that")))).andNot(PunctuationRules.hasPunctuationBefore(CommonPatterns.comma.directlyAfter(NodePattern.N.inPhrase(EnglishTreePatterns.clause.withHead("acl:relcl", NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Noun"))))))).andNot(NodePattern.N.inPhrase(NodePattern.N.withDependent(".*", Questions.whPhrase))).andNot(possiblyMisparsedIndependentClause);
    }

    private static NodePattern relativeClauseComma_Which() {
        NodePattern thatInTheClause = NodePattern.or(NodePattern.N.withDependent("acl:relcl", NodePattern.N.withDependent("ccomp", EnglishTreePatterns.withThatMark)), NodePattern.N.withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", EnglishTreePatterns.withThatMark), NodePattern.N.withDependent("det", NodePattern.N.form("that")));
        NodePattern possiblyDefinite = NodePattern.or(NodePattern.N.withDependent("appos|compound", CommonPatterns.insideQuotes), NodePattern.N.withDependent("amod", NodePattern.N.form("following|next|previous")).noHeadRelation("obj"), NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.pos("JJS"), NodePattern.N.withDependent("advmod", NodePattern.N.form("most")))), NodePattern.N.withDependent("amod", CommonPatterns.capitalizedMiddle).withDependent("det", NodePattern.N.form("the")));
        NodePattern possiblySententialRelative = PunctuationRules.possiblySententialRelative.andOr(CommonPatterns.possiblySkipDown("cop", NodePattern.N.pos("VBZ?")).andOr(NodePattern.N.withHead("(acl|advcl):relcl", NodePattern.N.withDependent("cop", NodePattern.N.pos("VBD"))), NodePattern.N.pos("NN").withDependent("det", NodePattern.N.form("an?").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("neither")))), NodePattern.N.pos("JJ").noDependents("aux", NodePattern.N.lemma("will")).withHead("(acl|advcl):relcl", NodePattern.N.noPos("NN").andNot(NodePattern.N.directlyBefore("Which")))), NodePattern.N.pos("WRB").withDependent("cop"), NodePattern.N.pos("VBZ").directlyAfter("Which").andOr(NodePattern.N.withHead("(acl|advcl):relcl", NodePattern.or(NodePattern.N.pos("NNS").andNot(NodePattern.N.directlyBefore("Which")), NodePattern.ROOT.pos("JJ").withDependent("advmod", NodePattern.N.directlyBeforeHead()))), NodePattern.N.withHeadRelation("parataxis"))).andNot(NodePattern.N.withHead("(acl|advcl):relcl", NodePattern.N.inPhrase(NodePattern.ROOT.and(EnglishTreePatterns.imperativeVB)))).andNot(NodePattern.N.pos("JJ").withHead("(acl|advcl):relcl", NodePattern.or(NodePattern.N.withHead("nsubj", NodePattern.N.form("here")), EnglishTreePatterns.isSubjectOfExpl)));
        NodePattern explanatoryAppos = NodePattern.N.markAs("Appos").withHead("appos", NodePattern.N.sameWordAs("Appos"));
        NodePattern requiresRestrictiveRel = NodePattern.or(NodePattern.N.withHead("nsubj", NodePattern.N.withDependent("expl")), NodePattern.N.withDependent("cop").andOr(NodePattern.N.withDependent("nsubj|expl", NodePattern.not(possiblyDefinite).noDependents("(acl|advcl):relcl")).andNot(NodePattern.N.pos("JJ").noPos("CD").noDependents("det|nmod:poss|amod|nummod", NodePattern.N.beforeHead())), NodePattern.N.potentialPos("NNP?").withDependent("expl|nsubj", NodePattern.N.form("it"))), theOnes.noDependents("amod", NodePattern.N.noForm("only")), EnglishTreePatterns.someAnyEveryNoX, NodePattern.N.withDependent("det", NodePattern.N.form("all|any|no|every|each|some")), NodePattern.N.withDependent("(acl|advcl):relcl", NodePattern.N.withDependent("cc:preconj", NodePattern.N.form("neither")))).andNot(possiblyDefinite).andNot(NodePattern.N.withDependent("(acl|advcl):relcl", possiblySententialRelative));
        NodePattern requiresNonRestrictiveRel = NodePattern.or(possiblyHeadOfNonRestrictiveClause, NodePattern.N.withDependent("appos", CommonPatterns.insideQuotes.noDependents("det", NodePattern.N.form("an?")).afterHead().withNextSibling(NodePattern.N.alreadyMarkedAs("RelCl"))), NodePattern.N.noPos("NNS").withDependent("conj", NodePattern.N.after("RelCl").withDependent("acl:relcl")));
        NodePattern probablyNonRestrictiveRel = NodePattern.N.withDependent("nsubj:pass", NodePattern.N.form("which")).andOr(NodePattern.N.withDependent("advmod", NodePattern.N.form("first|initially|previously")), EnglishTreePatterns.withModal.pos("VBN").withPhraseEnd(CommonPatterns.lastToken).withHead(NodePattern.ROOT));
        NodePattern possiblyWrongHead = NodePattern.or(NodePattern.N.pos("NNS?").noDependents("det").withDependent("case").withHead("nmod", NodePattern.N.withDependent("det")), NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("at|between"))).afterHead(), NodePattern.N.withDependent("case").withHead("nmod", NodePattern.ROOT.pos("NN")), NodePattern.N.noPos().withHead("nmod", NodePattern.N.pos("NNS")), NodePattern.N.inPhrase(NodePattern.N.withHeadRelation("acl")));
        NodePattern quotedNP = NodePattern.N.directlyAfter(EnglishTreePatterns.aposOrQuote).and(CommonPatterns.insideQuotes).noMatchUntil("RelCl", EnglishTreePatterns.aposOrQuote);
        return EnglishTreePatterns.clause.withDependent("nsubj.*|obj|obl", NodePattern.N.form("which").noDependents().markAs("Which")).markAs("RelCl").andOr(EnglishParameters.VARIANT.withValue("US").withHead("(acl|advcl):relcl", requiresRestrictiveRel.andNot(thatInTheClause).andNot(possiblyWrongHead)).andNot(NodePattern.N.withPhraseStart(NodePattern.or(EnglishTreePatterns.anyPunct, NodePattern.N.directlyAfter(EnglishTreePatterns.anyPunct)))).andNot(NodePattern.markedNodeMatches("Which", NodePattern.N.directlyAfter(EnglishTreePatterns.anyPunct))).correct(NodeCorrector.replace(NodePointer.marked("Which"), "that")).message("In American English, 'that' is preferred over 'which' for restrictive relative clauses"), NodePattern.N.withHead("(acl|advcl):relcl", requiresNonRestrictiveRel.andNot(requiresRestrictiveRel).andNot(explanatoryAppos).andNot(possiblyWrongHead)).and(PunctuationRules.surroundWithCommas(NodePattern.N, "a non-restrictive clause")).trace("head requires non-restrictive rel clause"), possiblySententialRelative.and(PunctuationRules.surroundWithCommas(NodePattern.N, "a non-restrictive clause")).trace("sentential rel clause"), probablyNonRestrictiveRel.and(PunctuationRules.surroundWithCommas(NodePattern.N, "a non-restrictive clause")).trace("probably non-restrictive rel clause")).withHead(NodePattern.not(quotedNP)).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.form("and|or").withHead("cc", EnglishTreePatterns.clause.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl")))));
    }

    private static NodePattern thatToWhichWho() {
        return NodePattern.custom((relcl, match) -> {
            String head = PunctuationRules.clauseHeadText(Objects.requireNonNull(relcl.head()));
            String message = "If this is a restrictive clause on '" + head + "', remove surrounding commas";
            Node that = StreamEx.of(relcl.findDependents("mark")).findFirst(n -> n.hasForm("that")).orElse(relcl.findSingleDependent("nsubj.*"));
            if (that == null || !that.hasForm("that")) {
                return match.withMessage(message);
            }
            List<Node> nouns = EnglishTreePatterns.findRelativeClauseHostCandidates(that, relcl);
            if (relcl.hasDependent("cop")) {
                nouns.add(relcl);
            }
            ArrayList<String> toSuggest = new ArrayList<String>(List.of("which", "who"));
            for (Node noun : nouns) {
                Semantics.Animacy animacy = Semantics.animacy(noun);
                if (animacy == Semantics.Animacy.humanLike && !noun.nerLabels().has((Object)SentenceWithNERAnnotations.Annotation.Label.MISC)) {
                    toSuggest.remove("which");
                    break;
                }
                if (animacy != Semantics.Animacy.inanimate) continue;
                toSuggest.remove("who");
                break;
            }
            NodeCorrector corrector = NodeCorrector.replace(that, toSuggest);
            PhraseCommaChange change = CommaLicense.forPhrase(relcl, CommaLicense.NeedCommas.around).addMissingCommas(commaOrOpening, commaOrClosing);
            if (change != null) {
                corrector = corrector.join(change.correct());
                if (change.changeBefore() != null) {
                    Tree tree = relcl.tree();
                    match = match.withReportedRange(PhraseCommaChange.mainReportedRange(tree, change.changeBefore()), tree);
                }
            }
            match = match.withCorrector(corrector);
            return match.withMessage(message + "; otherwise, use " + StreamEx.of(toSuggest).map(s -> "'" + s + "'").joining((CharSequence)" or "));
        });
    }

    private static String clauseHeadText(Node head) {
        Object headText = head.form();
        Node next = head.nextNode();
        if (next != null) {
            if (next.head() == head && next.hasHeadRelation("flat")) {
                headText = (String)headText + " " + next.form();
            }
            if (head.allDependents().stream().anyMatch(n -> n.isAfter(next) && n.hasHeadRelation("conj"))) {
                headText = (String)headText + "...";
            }
        }
        return headText;
    }

    private static NodePattern adverbialComma() {
        NodePattern complex = NodePattern.N.withDependent("case|nsubj.*|obj").andNot(NodePattern.N.afterHead().withDependent("mark", NodePattern.N.form("if|when")));
        NodePattern unclearEnding = complex.withHead(NodePattern.N.markAs("Head").before("Adverbial")).withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.form("as").withHead("mark", NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("Head")))));
        NodePattern frontedObl = NodePattern.N.markAs("Obl").withHead("obl", NodePattern.N.after("Obl"));
        NodePattern afterLinkingWord = NodePattern.N.directlyAfter(NodePattern.N.form("so|and"));
        NodePattern withMisparsedCompound = NodePattern.N.withHead("obl", NodePattern.ROOT.pos("VB").potentialPos("NN.*").markAs("VB")).withPhraseEnd(NodePattern.N.directlyBefore("VB"));
        NodePattern adverbialInNeedOfCommas = commaAdverbial.andOr(CommonPatterns.firstPhrase, NodePattern.or(complex.andNot(Commas.inTurn), Commas.inTurn.withPrevSibling(NodePattern.or(CommonPatterns.comma.withPrevSibling(frontedObl), frontedObl)), Commas.adverbsToFrontWithComma.andNot(afterLinkingWord).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("punct"))).andNot(NodePattern.N.markAs("Adverb").withHead(NodePattern.N.after("Adverb").withDependent("cop|aux.*|nsubj.*", NodePattern.N.before("Adverb"))))).andNot(unclearEnding)).andNot(withMisparsedCompound).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("advmod")).directlyBefore(NodePattern.N.withHeadRelation("cc")));
        NodePattern needsCommaBefore = NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.not(NodePattern.N.form("and|but|or|that|so")))).andNot(NodePattern.N.withPrevSibling(adverbialInNeedOfCommas));
        return NodePattern.or(adverbialInNeedOfCommas.and((node, match) -> {
            Node start = node.phraseStart().skipForward(NodePattern.PUNCT::matches);
            Node end = node.phraseEnd().skipBack(NodePattern.PUNCT::matches);
            String kind = Commas.anyRelcl.matches(node) ? "an adverbial phrase" : (start != end && node.hasPos("VB[NG]") ? "a participial phrase" : (start != end ? "a linking/introductory phrase" : "a linking/introductory word"));
            return PunctuationRules.addCommas(node, match, needsCommaBefore.matches(node) ? CommaLicense.NeedCommas.around : CommaLicense.NeedCommas.after, kind);
        }), NodePattern.N.form("however").includeIntoReport().directlyBefore(CommonPatterns.comma.includeIntoReport().directlyBefore(Commas.howeverContinuationNoComma).message(REMOVE_HOWEVER_COMMA_MSG).correct(NodeCorrector.replace(""))), CommonPatterns.firstWord.and(Semantics.timePoints).noForm("before").includeIntoReport().andOr(NodePattern.N.withHead("advmod|obl:tmod", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")), NodePattern.N.withHeadRelation("case")).message("Don\u2019t add a comma after '$_' at the beginning of a sentence unless it is an introductory word").directlyBefore(removeUnmandatedComma).noForm("now|then"));
    }

    private static NodePattern surroundWithCommas(NodePattern needsCommaBefore, String phraseKind) {
        return NodePattern.custom((head, match) -> PunctuationRules.addCommas(head, match, needsCommaBefore.matches(head) ? CommaLicense.NeedCommas.around : CommaLicense.NeedCommas.after, phraseKind));
    }

    @Nullable
    static PhraseCommaChange addCommasQuoteAware(Node head, CommaLicense.NeedCommas need) {
        CommaLicense license = CommaLicense.forPhrase(head, need);
        NodeCorrector changeBefore = PunctuationRules.insertCommaQuoteAware(license.firstCommaInsertionPosition(commaOrOpening));
        NodeCorrector changeAfter = PunctuationRules.insertCommaQuoteAware(license.secondCommaInsertionPosition(commaOrClosing));
        if (changeBefore == null && changeAfter == null) {
            return null;
        }
        return new PhraseCommaChange(license.start, license.end, changeBefore, changeAfter);
    }

    @Nullable
    private static NodeMatch addCommas(Node head, NodeMatch match, CommaLicense.NeedCommas need, String phraseKind) {
        PhraseCommaChange change = PunctuationRules.addCommasQuoteAware(head, need);
        return change == null ? null : change.highlightAndCorrect(match).withMessage(change.selectMessage("Missing comma before " + phraseKind + "?", "Missing comma after " + phraseKind + "?", "Missing commas around " + phraseKind + "?"));
    }

    private static NodeCorrector insertCommaQuoteAware(@Nullable Node beforeComma) {
        if (beforeComma == null) {
            return null;
        }
        if (EnglishTreePatterns.aposOrQuote.matches(beforeComma) && Quotes.closingPosition.matches(beforeComma) && VariantDifferences.punctBeforeQuotesVariant.matches(beforeComma)) {
            return NodeCorrector.insertBefore(beforeComma, ",");
        }
        return CommaLicense.addCommaDirectlyAfter(beforeComma);
    }

    private static NodePattern hasPunctuationAfter(NodePattern punct) {
        return NodePattern.N.withPhraseEnd(NodePattern.or(punct, NodePattern.N.directlyBefore(punct)));
    }

    private static NodePattern hasPunctuationBefore(NodePattern punct) {
        return NodePattern.N.withPhraseStart(NodePattern.or(punct, NodePattern.N.directlyAfter(punct)));
    }

    private static NodePattern missingQuestionMark() {
        NodePattern addQuote = NodePattern.or(NodePattern.N.form("[.!]").and((node, match) -> match.withReportedRange(Objects.requireNonNull(node.prevNode()).startOffset(), node.endOffset(), node.tree())).correct(NodeCorrector.replace("?")), NodePattern.not(NodePattern.N.form("\\?")).correct(NodeCorrector.insertAfter("?")).andOptionally(CommonPatterns.ellipsis.correct(NodeCorrector.replace("?"))));
        NodePattern normalWordOrder = NodePattern.or(NodePattern.N.withDependent("nsubj.*", NodePattern.or(CommonPatterns.firstWord, NodePattern.N.directlyAfter(CommonPatterns.firstWord.form("what")))), Questions.whWord.and(CommonPatterns.firstWord).withDependent("nsubj", CommonPatterns.lastWord));
        String aposOrQuote = EnglishTreePatterns.aposOrQuote.getFormRegex();
        NodePattern exclOverridesQuestion = NodePattern.or(NodePattern.N.inFormSequence(0, "!", aposOrQuote).noSpaceAfter(), NodePattern.N.inFormSequence(1, aposOrQuote, "!").noSpaceBefore());
        NodePattern ignore = NodePattern.or(NodePattern.N.form(".*[?;:].*"), CommonPatterns.ellipsis.andOr(NodePattern.not(CommonPatterns.lastToken), NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.pos("IN"), NodePattern.N.form("a")))), exclOverridesQuestion);
        NodePattern whyDontYou = NodePattern.N.withDependent("advmod", NodePattern.N.form("why").withNeighbor(1, NodePattern.N.lemma("do")).withNeighbor(2, EnglishTreePatterns.negation).withNeighbor(3, NodePattern.N.pos("PRP")).withNeighbor(4, NodePattern.N.pos("VBP?")));
        return NodePattern.ROOT.and(Questions.question).noDependents("aux", NodePattern.N.form("may").beforeHead()).andNot(ignore).andNot(NodePattern.N.inSentenceWith(ignore)).withPhraseStart(NodePattern.N).withPhraseEnd(NodePattern.N).message(MISSING_QUESTION_MARK_MSG).andNot(NodePattern.N.withDependent("cop|aux|aux:pass").withDependent("parataxis")).andNot(normalWordOrder).andNot(NodePattern.N.inFormSequence(3, "are|do|is", "n.t", ".*", "something").directlyAfter(NodePattern.N.pos("PRP"))).andNot(whyDontYou).andNot(NodePattern.N.form("try|give|hang|dare|worry|go").withPhraseStart(NodePattern.N.inFormSequence(0, "do", "n.t", "you"))).andOr(NodePattern.N.withPhraseStart(EnglishTreePatterns.quotations).withPhraseEnd(CommonPatterns.skipBack(EnglishTreePatterns.quote, addQuote)), NodePattern.N.withPhraseEnd(addQuote));
    }

    private static NodePattern missingDot() {
        NodePattern possiblyMisparsedQuestion = NodePattern.or(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.markAs("Subj")).withDependent("cop|aux|aux:pass", NodePattern.N.before("Subj")), NodePattern.N.withDependent("cop", CommonPatterns.firstChildPhrase).withDependent("det").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl|aux.*"));
        return EnglishTreePatterns.clause.withHeadRelation("root").andNot(Questions.question).withPhraseEnd(NodePattern.not(CommonPatterns.skipBack(EnglishTreePatterns.aposOrQuote, NodePattern.N.form(".*[.!\u2026].*")))).andOr(NodePattern.not(possiblyMisparsedQuestion).andNot(possiblyInformalQuestion).andNot(WordOrder.topLevelInvertedQuestion).withPhraseEnd(NodePattern.N.form("\\?").includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport()).correct(NodeCorrector.replace("."))).message("This sentence does not look like a question"), NodePattern.N.withPhraseEnd(NodePattern.not(CommonPatterns.skipBack(EnglishTreePatterns.aposOrQuote, NodePattern.N.form("[!?]")))).correct(NodeCorrector.insertAfterPhrase(".")).message("No punctuation mark at the end of the sentence?"));
    }

    private static NodePattern subordination() {
        NodePattern isTimeOrPlace = NodePattern.or(NodePattern.N.pos("NNP"), Semantics.timeUnits, NodePattern.N.form("initially|then"));
        NodePattern notSubordinate = NodePattern.not(NodePattern.N.withHeadRelation("(advcl|mark|advmod|punct)"));
        NodePattern afterThen = NodePattern.N.withPrevSibling(NodePattern.N.form("then"));
        NodePattern misparsedConjHead = NodePattern.N.withHeadRelation("advcl").withDependent("mark|advmod", NodePattern.N.sameWordAs("Mark"));
        return NodePattern.or(NodePattern.N.beforeHead().withDependent("nsubj").noDependents("mark|advmod", NodePattern.N.directlyAfter(NodePattern.N.form("that"))).withHead("advcl", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")).andOr(NodePattern.custom(node -> ((StreamEx)node.phraseStart().forward().takeWhile(n -> n != node.phraseEnd())).count() >= 5L), NodePattern.or(NodePattern.N.pos("MD"), NodePattern.N.lemma("do|have|be").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("to")))).noDependents(NodePattern.N.afterHead().noLemma("not")).withHead(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.not(SubjectVerbAgreement.possiblyMisattachedNP))), afterThen).withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.not(NodePattern.N.withHeadRelation("cc"))).andOr(NodePattern.N.spaceAfter(), NodePattern.N.directlyBefore(commaOrClosing))).andNot(NodePattern.N.withPhraseStart(NodePattern.N.inFormSequence(0, "only", "if|when|after")).withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("aux")))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound"))).andNot(NodePattern.N.withNextSibling(NodePattern.or(NodePattern.N.withHeadRelation("mark"), NodePattern.N.withHeadRelation("advcl").noDependents(NodePattern.N.beforeHead()), NodePattern.N.withHeadRelation("advmod").and(CommonPatterns.phraseEndsWithComma)))).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.withHeadRelation("nmod")).withNextSibling(NodePattern.N.withHeadRelation("obl"))).andNot(NodePattern.N.withNextSibling(NodePattern.N.inFormSequence(1, "so", "far"))).andNot(NodePattern.N.withPhraseEnd(NodePattern.or(NodePattern.N.withHeadRelation("advcl").directlyBefore(NodePattern.N.form("that")), NodePattern.N.pos("W.*")))).and(PunctuationRules.surroundWithCommas(afterThen, "a subordinate clause")), NodePattern.N.afterHead().withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").withDependent("mark|advmod", CommonPatterns.firstChildPhrase.andOr(NodePattern.N.form("if").directlyAfter(NodePattern.not(NodePattern.N.form("especially|only|particularly|even"))), NodePattern.N.form("when").directlyAfter(NodePattern.not(isTimeOrPlace).andNot(CommonPatterns.comma.directlyAfter(isTimeOrPlace)).andNot(CommonPatterns.comma.directlyAfter(NodePattern.N.pos("NNS?|CD|JJ"))).andNot(CommonPatterns.comma.directlyAfter(NodePattern.N.withHead(CommonPatterns.parenthesizedPhrase.withPrevSibling(CommonPatterns.withNumberLikeForm)))))).markAs("Mark")).markAs("Subordinate").withHead("advcl|ccomp", NodePattern.or(EnglishTreePatterns.clause, NodePattern.N.pos("VBG")).withDependent(".*", NodePattern.not(NodePattern.PUNCT).before("Subordinate")).noDependents("mark", NodePattern.or(Questions.whWord, NodePattern.N.sameWordAs("Mark")))).noDependents("mark|advmod", NodePattern.N.form("when|where").withHead("mark|advmod", NodePattern.N.withNextSibling(NodePattern.or(EnglishTreePatterns.anyPunct.withNextSibling(notSubordinate), notSubordinate)))).andNot(NodePattern.N.inFormSequence(2, "if", "you", "will")).andNot(NodePattern.N.lemma("do|have").directlyAfter(NodePattern.N.pos("PRP.*").directlyAfter(NodePattern.N.form("if"))).directlyBefore(NodePattern.N.form("\\?"))).andNot(NodePattern.N.inFormSequence(3, "if", "that|this|it", "[i'\u2019`\u2018]s|was|were", "possible")).andNot(NodePattern.custom(advcl -> PunctuationRules.hasInternalCommas(advcl, null))).andNot(NodePattern.N.withDependent("conj").andOr(NodePattern.N.withHead(NodePattern.N.withHead("xcomp", misparsedConjHead)), NodePattern.N.withPrevSibling(CommonPatterns.comma.withPrevSibling(misparsedConjHead)))).and(PunctuationRules.hasPunctuationBefore(removeUnmandatedComma.markAs("Comma"))).andNot(NodePattern.markedNodeMatches("Mark", NodePattern.N.form("when")).and(NodePattern.markedNodeMatches("Comma", NodePattern.N.directlyAfter(Semantics.timePoints)))).withPhraseEnd(NodePattern.N.reportRangeTo("Comma", ReportingKind.Hover)).message(REDUNDANT_SUBORDINATION_COMMA_MSG));
    }

    private static NodePattern formattingIssues() {
        NodePattern isPossessive = NodePattern.N.afterHead().withHeadRelation("case");
        NodePattern contractionWhitespace = EnglishTreePatterns.startsWithApostrophe.directlyAfter(CommonPatterns.letterWord).and((node, match) -> {
            int offset = node.startOffset();
            String text2 = node.tree().text();
            Node next = node.nextNode();
            Node prev = node.prevNode();
            if (offset > 0 && offset < text2.length() - 1 && next != null && prev != null && (CharUtil.isAnySpace(text2.charAt(offset - 1)) || CharUtil.isAnySpace(text2.charAt(offset + 1)))) {
                String after;
                String form = node.form();
                boolean joined = form.length() > 1;
                if (!NodePattern.N.spaceAfter().matches(joined ? node : next)) {
                    return null;
                }
                String string = after = joined ? form.substring(1) : next.form();
                if (ToggleContraction.CONTRACTION_SUFFIXES.contains(after.toLowerCase(Locale.ROOT))) {
                    NodeCorrector corrector = NodeCorrector.rawReplace(new TextRange(prev.endOffset(), joined ? offset + 1 : next.startOffset()), form.substring(0, 1));
                    String msg = isPossessive.matches(node) ? "Write possessive apostrophes without spaces" : WRITE_CONTRACTIONS_WITHOUT_SPACES;
                    return match.withMessage(msg).withReportedNodes(prev, node, joined ? null : next).withCorrector(corrector);
                }
            }
            return null;
        }).andNot(TreeMigration.revise("check after tokenization changes", CommonPatterns.beforeSkipping(NodePattern.N.form(ToggleContraction.CONTRACTION_SUFFIXES), NodePattern.N.lemma("(af|pre|suf|in|post)fix"))));
        NodePattern hyphenMarkupStart = CommonPatterns.HYPHEN_NODE.noSpaceAfter().spaceBefore();
        NodePattern hyphenMarkupEnd = CommonPatterns.HYPHEN_NODE.spaceAfter().noSpaceBefore().and(n -> n.back().anyMatch(hyphenMarkupStart::matches));
        NodePattern spacedEllipsis = NodePattern.N.inFormSequence(1, "\\.", "\\.", "\\..*").spaceAround();
        return NodePattern.or(FormattingIssues.doublePunctuation.message(TOO_MANY_PUNCTUATION_MARKS).andNot(spacedEllipsis), PunctuationRules.wrongApostrophe(), incompleteOptionalPluralParen, FormattingIssues.punctWhitespace(m -> "There should be no space before " + PunctuationRules.punctuationName(m.anchor().form()) + " and a single space after it").andNot(NodePattern.N.noSpaceAfter().directlyAfter(NodePattern.N.noSpaceAfter().formCaseSensitive("[a-z]{1,5}"))).andNot(CommonPatterns.colon.noSpaceAfter().directlyBefore(NodePattern.N.formCaseSensitive("[a-z]+"))).andNot(CommonPatterns.colon.noSpaceAfter().directlyBefore(NodePattern.N.form("\\d{1,4}")).and(sentenceWithPort)).andNot(NodePattern.N.noSpaceAround().inFormSequence(1, "[A-Z]+", ":", "[A-Z]+")).andNot(FormattingIssues.namedEmojiInColons), FormattingIssues.endWhitespace(m -> "Extra space before " + PunctuationRules.punctuationName(m.anchor().form())), contractionWhitespace, FormattingIssues.quoteWhitespace("Missing space?", "Unnecessary space?").andNot(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.form("s"))), EnglishTreePatterns.quotes.asymmetricalRule(Set.of("\u201d", "`", "\"")).message("Consider using matching quotation marks"), FormattingIssues.joinAdjacentFixes(NodePattern.N.form("[\u201c(]").and(PairedPunctuation.Opening.checkSpace("Missing space", "Unnecessary space")), NodePattern.N.form("[\u201d)]").and(PairedPunctuation.Closing.checkSpace("Missing space", "Unnecessary space")).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.apostropheS))), FormattingIssues.multiWhiteSpace("Multiple space"), FormattingIssues.trailingComma(EnglishTreePatterns.clause.andNot(NodePattern.N.pos("NN.*").noDependents("cop")).noFormCaseSensitive("Thank").andNot(CommonPatterns.firstWord.and(CommonPatterns.lastWord).form("please")).andNot(EnglishTreePatterns.imperativePossible), "Unfinished sentence?"), FormattingIssues.wordSplittingHyphen(UNNECESSARY_HYPHEN).directlyAfter(NodePattern.not(NodePattern.N.form("co"))), FormattingIssues.singleHyphenWhitespace("Unnecessary space?", "Missing space?", NodePattern.or(new NodePattern[0])).directlyBefore(NodePattern.not(NodePattern.or(NodePattern.N.pos("CC"), NodePattern.N.withHeadRelation("cop"))).noForm(".|to")).andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.lemma("prefix"))).andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form(".*\\W.*"), CommonPatterns.conjBeforeHead))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("amod").directlyAfter(NodePattern.N.withHeadRelation("det|nmod:poss|case"))).directlyBefore(NodePattern.N.withHeadRelation("nsubj.*|i?obj|obl.*|nmod.*"))).andNot(FormattingIssues.hyphenTextHighlightingStart).andNot(CommonPatterns.insideQuotes).andNot(hyphenMarkupEnd), FormattingIssues.leadingHyphen(UNNECESSARY_HYPHEN), FormattingIssues.sentenceStartingPunctuation("Incorrect sentence-starting punctuation"), wordInternalPunctuation, joinedNumberWord, FormattingIssues.noSpaceWithBrackets("Missing space?"), FormattingIssues.excessiveEllipsis("Unusually long ellipsis"), FormattingIssues.colonDash("Start list items on a new line"));
    }

    private static NodePattern quotePunctuation() {
        NodePattern questionSentence = NodePattern.ROOT.and(Questions.question);
        NodePattern singleQuoteUntilHead = NodePattern.custom((quote, match) -> ((StreamEx)match.getMarkedNode("Head").nextUntil(quote).filter(EnglishTreePatterns.aposOrQuote::matches)).count() == 1L ? match : null);
        NodePattern movementMessage = NodePattern.custom((node, match) -> {
            String expected = EnglishTreePatterns.aposOrQuote.matches(node.prevNode()) ? "inside" : "outside";
            String message = StringTools.uppercaseFirstChar((String)PunctuationRules.punctuationName(node.form())) + " should be placed " + expected + " quotation marks";
            return match.withMessage(message);
        });
        NodePattern questionOutsideQuotes = NodePattern.N.withHead("punct", CommonPatterns.skipUp("xcomp|ccomp|obj", questionSentence.markAs("Head"))).and(singleQuoteUntilHead);
        NodePattern beforeQuestionStart = NodePattern.N.directlyBefore(NodePattern.N.markAs("Start").inPhrase(Questions.question.after("Start")));
        NodePattern questionInsideQuotes = NodePattern.or(NodePattern.N.inPhrase(Questions.question.andNot(NodePattern.ROOT).withPhraseStart(NodePattern.N.directlyAfter(EnglishTreePatterns.aposOrQuote))), NodePattern.custom(n -> {
            Node openingQuote = n.back().findFirst(EnglishTreePatterns.aposOrQuote::matches).orElse(null);
            if (beforeQuestionStart.matches(openingQuote)) return true;
            if (!((StreamEx)n.back().takeWhile(nn -> nn != openingQuote)).anyMatch(Questions.whWord::matches)) return false;
            return true;
        }));
        NodePattern exclWithQuestion = NodePattern.N.form("[!?]").withNeighbor(2, NodePattern.N.form("[!?]").andNot(NodePattern.N.sameWordAs(-2)));
        return NodePattern.or(FormattingIssues.punctQuoteSentenceEnd.and(Quotes.punctAllowedBeforeClosingQuote).andNot(exclWithQuestion).andNot(CommonPatterns.dot.directlyAfter(NodePattern.N.form("[ap]\\.?m"))).and((p1, match) -> {
            boolean moveOut;
            Node p2 = p1.neighbor(2);
            String strongest = PunctuationRules.rankPunctuation(p1.form()) > PunctuationRules.rankPunctuation(p2.form()) ? p1.form() : p2.form();
            boolean genericEnglish = EnglishParameters.VARIANT.getValue(p1.tree()).isEmpty();
            boolean moveIn = genericEnglish || VariantDifferences.punctBeforeQuotesVariant.match(p1, match) != null;
            boolean bl = moveOut = genericEnglish || VariantDifferences.punctAfterQuotesVariant.match(p1, match) != null;
            if (strongest.contains("?")) {
                boolean questionOutside = questionOutsideQuotes.matches(p1);
                boolean questionInside = questionInsideQuotes.matches(p1.prevNode());
                if (!questionInside && !questionOutside) {
                    moveOut = true;
                    moveIn = true;
                } else if (questionInside && questionOutside) {
                    moveIn = true;
                    moveOut = false;
                } else {
                    moveIn = questionInside;
                    moveOut = questionOutside;
                }
            }
            if (moveIn) {
                match = match.withCorrector(NodeCorrector.replace(p1, strongest).join(NodeCorrector.replace(p2, "")));
            }
            if (moveOut) {
                match = match.withCorrector(NodeCorrector.replace(p2, strongest).join(NodeCorrector.replace(p1, "")));
            }
            Node weakest = p1.form().equals(strongest) ? p2 : p1;
            String weakestName = PunctuationRules.punctuationName(weakest.form());
            int afterDet = weakestName.indexOf(32);
            String msg = "Excessive " + weakestName.substring(afterDet + 1) + "?";
            return match.withMessage(msg);
        }), NodePattern.N.form("\\?").and(CommonPatterns.lastToken).and(FormattingIssues.movePunctBeforeQuote).withHead("punct", EnglishTreePatterns.clause.andNot(questionSentence).andNot(possiblyInformalQuestion).markAs("Head")).directlyAfter(singleQuoteUntilHead).and(movementMessage), FormattingIssues.movePunctAfterQuote(AbbreviationPatterns.withPunctCaseSensitive(ai.grazie.nlp.langs.Language.ENGLISH)).andOr(NodePattern.N.form("\\?").directlyBefore(CommonPatterns.lastToken).andNot(questionInsideQuotes).and(questionOutsideQuotes), NodePattern.N.form("[:;]")).and(movementMessage));
    }

    private static int rankPunctuation(String form) {
        if (form.contains("!")) {
            return 10;
        }
        if (form.contains("?")) {
            return 9;
        }
        if (form.contains(".")) {
            return 8;
        }
        if (form.contains(";")) {
            return 7;
        }
        if (form.contains(":")) {
            return 6;
        }
        return 0;
    }

    private static NodePattern wrongApostrophe() {
        NodePattern anotherPunct = NodePattern.or(NodePattern.N.form("(is|are|were|was|had|has|have|did|does|do|could|must|should|would|need)n[\u00b4\u2032`;<>4\"!@#$%^&*()+]t"), NodePattern.N.form("n[\u00b4\u2032`;<>4\"!@#$%^&*()+]t").noSpaceBefore(), NodePattern.N.form("[a-z]*[\u00b4\u2032`;<>4\"!@#$%^&*()+](ll|s|d|m|re|ve)").withHeadRelation("cop|aux|aux:pass|case|root|nsubj|nmod").noLabel(".*").noDependents("flat(:name)?")).includeIntoReport().andNot(NodePattern.N.directlyBefore(NodePattern.PUNCT.noSpaceAfter())).andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT.noSpaceAfter())).andOptionally(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.includeIntoReport())).correct(NodeCorrector.regexReplace("(.*)[\u00b4\u2032`;<>4\"!@#$%^&*()+](.*)", "$1\u2019$2"));
        NodePattern space = NodePattern.N.inFormSequence(0, "(is|are|were|was|had|has|have|did|does|do|could|must|should|would|need)n", "t").and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), node.form() + "\u2019t")));
        return NodePattern.or(anotherPunct, space).message("Did you mean an apostrophe?");
    }

    static String punctuationName(String form) {
        return ",".equals(form) ? "a comma" : (";".equals(form) ? "a semicolon" : (":".equals(form) ? "a colon" : (".".equals(form) ? "a period" : ("!".equals(form) ? "an exclamation mark" : ("?".equals(form) ? "a question mark" : "this punctuation mark")))));
    }

    private static NodePattern listColon() {
        NodePattern firstItem = NodePattern.N.before("Comma").pos("NN.*").withDependent("amod", NodePattern.N.form("following"));
        NodePattern secondItem = NodePattern.N.markAs("Second").after("Comma").withHead("conj|appos", firstItem.noDependents("conj|appos|nmod", NodePattern.N.before("Second")));
        return CommonPatterns.comma.markAs("Comma").includeIntoReport().directlyBefore(NodePattern.N.inPhrase(secondItem.noDependents("cc"))).directlyAfter(NodePattern.not(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Second"))).includeIntoReport()).message(LIST_COLON_MSG).correct(NodeCorrector.replace(":"));
    }

    private static NodePattern commaBeforeCcClause() {
        NodePattern singleClauseIntros = NodePattern.N.form("overall");
        NodePattern ccAndOr = NodePattern.markedNodeMatches("CC", NodePattern.N.form("and|or"));
        NodePattern hasCommonIntro = NodePattern.or(NodePattern.N.withDependent("advmod|obl|case", NodePattern.N.beforeHead().and(CommonPatterns.phraseEndsWithComma).andNot(singleClauseIntros)), NodePattern.N.withDependent("advmod", NodePattern.N.form("maybe|possibly|seemingly|when").beforeHead()).and(ccAndOr), NodePattern.N.withDependent("discourse", NodePattern.N.beforeHead().and(CommonPatterns.phraseEndsWithComma)), NodePattern.N.withDependent("advcl", NodePattern.N.beforeHead()));
        NodePattern unitingExclamation = NodePattern.N.pos("NNP").withDependent("amod");
        NodePattern singleWordClauseBefore = NodePattern.N.form("pardon|sorry|thanks?");
        NodePattern clauseBefore = NodePattern.N.before("CC").and(NodePattern.or(NodePattern.ROOT, NodePattern.N.withHead("conj|parataxis", NodePattern.ROOT.andNot(unitingExclamation)))).andOr(singleWordClauseBefore, NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl|i?obj|obl.*|[xc]comp|cop|aux|aux:pass")).noDependents("vocative", unitingExclamation).andNot(NodePattern.not(NodePattern.N.lemma("be")).withDependent("ccomp")).andNot(NodePattern.N.lemma("be").directlyBefore("CC")).andNot(NodePattern.N.withHeadRelation("parataxis").and(ccAndOr).and(CommonPatterns.parenthesizedPhrase)).noDependents("cc:preconj", NodePattern.N.form("n?either"));
        NodePattern andAmbiguity = NodePattern.N.form("and").markAs("And").directlyAfter(NodePattern.N.inPhrase(NodePattern.N.before("And").withHeadRelation("conj").withDependent("cc", NodePattern.N.form("and"))));
        NodePattern isLikelyMainClause = NodePattern.N.withHeadRelation("root|parataxis");
        NodePattern subordinateClause = NodePattern.N.withHeadRelation("acl|advcl|csubj.*").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").andNot(CommonPatterns.parenthesizedPhrase).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("for")).withDependent("mark", NodePattern.N.form("to")));
        NodePattern misattachedSubordinateCoordination = NodePattern.N.withHeadRelation("conj").withPrevSibling(NodePattern.or(subordinateClause, NodePattern.N.withHeadRelation("advmod").withDependent("advcl", subordinateClause), NodePattern.N.withHeadRelation("xcomp").and(EnglishTreePatterns.withToMark).withDependent("advcl", subordinateClause).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl"))).trace("misattachedSubordinateCoordination");
        NodePattern withPotentiallyMisparsedDash = NodePattern.N.withDependent("obl|compound", NodePattern.N.withDependent("punct", CommonPatterns.DASH_NODE));
        NodePattern misparsedExpl = NodePattern.N.form("it").afterHead().withHeadRelation("expl");
        NodePattern afterUnitingColon = NodePattern.N.withPhraseStart(CommonPatterns.skipForward(CommonPatterns.colon, NodePattern.N.directlyAfter(CommonPatterns.colon).noFormCaseSensitive("\\p{Ll}.*")));
        NodePattern possiblySharingArgument = EnglishTreePatterns.verbalClause.withDependent("i?obj|obl.*", NodePattern.N.withPhraseStart(NodePattern.N.markAs("ArgStart"))).withDependent("nsubj", NodePattern.N.markAs("Subj2").noDependents()).withHead(EnglishTreePatterns.verbalClause.and(CommonPatterns.beforeSkipping(NodePattern.N.pos("IN"), NodePattern.N.alreadyMarkedAs("CC"))).withDependent("nsubj", NodePattern.N.sameWordAs("Subj2")).noDependents("i?obj|obl.*", NodePattern.N.beforeHead())).and((__, m) -> PunctuationRules.wordsBetween(m.getMarkedNode("CC"), m.getMarkedNode("ArgStart")) < 4L ? m : null).andNot(NodePattern.markedNodeMatches("CC", NodePattern.N.form("for|although|so")));
        NodePattern auxEllipsis = NodePattern.N.withDependent("aux:pass", NodePattern.N.form("be").markAs("BeAux")).noDependents("cop|aux|aux:pass", NodePattern.N.before("BeAux"));
        NodePattern interruptingClause = NodePattern.or(NodePattern.N.withHeadRelation("advcl").noDependents("punct", NodePattern.N.form("[()]")), NodePattern.N.withHeadRelation("advmod").withDependent("advcl|ccomp"), NodePattern.N.withHeadRelation("obl").withDependent("case", NodePattern.N.pos("VBG"))).beforeHead().and(CommonPatterns.phraseEndsWithComma);
        NodePattern clauseAfter = NodePattern.or(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.not(misparsedExpl)), EnglishTreePatterns.imperativePossible, Semantics.thanksApologies.withHead(EnglishTreePatterns.clause)).withHead("conj|parataxis|advcl", clauseBefore.markAs("ClauseBefore")).andOr(NodePattern.custom(clause2 -> PunctuationRules.hasManyConjuncts(Objects.requireNonNull(clause2.head()), clause2)), NodePattern.N.withHead(singleWordClauseBefore), NodePattern.N.withPhraseStart(andAmbiguity), NodePattern.custom(clause2 -> !PunctuationRules.areShortAndSimple(clause2.head(), clause2)).withHead(NodePattern.not(hasCommonIntro))).noDependents("mark", NodePattern.or(NodePattern.N.form("to|how|because|as"), NodePattern.N.inFormSequence(1, "now", "that"))).andNot(auxEllipsis).noDependents(NodePattern.N.before("CC")).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("so")).withHead(NodePattern.N.lemma("explain"))).andNot(EnglishTreePatterns.misparsedObl).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.withDependent("amod", NodePattern.N.form("resulting"))).andNot(CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|csubj(:pass)?", withPotentiallyMisparsedDash)).andNot(EnglishTreePatterns.imperativePossible.sameWordAs("ClauseBefore").withHead(EnglishTreePatterns.imperativePossible)).and(clause2 -> {
            Node clause1 = Objects.requireNonNull(clause2.head());
            int twoShortClauses = 9;
            if (PunctuationRules.wordsBetween(clause1.phraseStart(), clause2.phraseEnd()) <= (long)twoShortClauses && afterUnitingColon.matches(clause1)) {
                return false;
            }
            Node colonAfter = clause2.forward().findFirst(CommonPatterns.colon.directlyBefore(NodePattern.not(NodePattern.PUNCT))::matches).orElse(null);
            return colonAfter == null || PunctuationRules.wordsBetween(clause1.phraseStart(), colonAfter) > (long)twoShortClauses;
        }).andNot(possiblySharingArgument).noDependents("cop", EnglishTreePatterns.itsConfusion);
        NodePattern withModalVerb = NodePattern.or(NodePattern.N.withDependent("aux", NodePattern.N.pos("MD")), NodePattern.N.inFormSequence(0, "have", "to").withDependent("xcomp"));
        NodePattern possiblySoThat = NodePattern.N.form("so").withNextSibling(NodePattern.N.withHeadRelation("nsubj.*")).withHead("advmod|mark", NodePattern.or(NodePattern.N.withHead("advcl|parataxis|conj", EnglishTreePatterns.imperativeVB), NodePattern.N.withHeadRelation("advcl").andOr(NodePattern.N.withHead(NodePattern.N.pos("VBG").noDependents("cop|aux|aux:pass")).trace("learning the shortcuts so they get loaded into our muscle memory"), NodePattern.markedNodeMatches("CC", NodePattern.N.withNeighbor(-1, NodePattern.N.form("it")).withNeighbor(-2, NodePattern.N.pos("V.*"))).trace("make it so something happens")), NodePattern.N.withDependent("aux", NodePattern.N.inFormSequence(1, "you", "can").directlyBefore(NodePattern.not(EnglishTreePatterns.negation))), NodePattern.N.noPos("VBD").noDependents("cop").withHead("advcl|parataxis|conj", NodePattern.or(CommonPatterns.possiblySkipDown("xcomp|acl:relcl", NodePattern.N.withDependent("obj").noLemma("have")), CommonPatterns.skipConjUp(NodePattern.N.withDependent("aux:pass"))).andNot(EnglishTreePatterns.negated))));
        NodePattern misparsedNpInternalConj = NodePattern.N.form("and").directlyAfter(NodePattern.N.pos("NN.*|JJ.*").withDependent("det").withPhraseStart(NodePattern.N.directlyAfter(commaLike))).directlyBefore(NodePattern.N.withHead("det", NodePattern.N.withDependent("amod|compound")));
        NodePattern soForAlthoughClause = NodePattern.N.withHeadRelation("conj|parataxis").withDependent("cc|advmod|mark", NodePattern.N.form("so|for|although").and(CommonPatterns.firstChildPhrase));
        NodePattern beforeCommonReasoning = NodePattern.N.withHead("cc", NodePattern.N.withPrevSiblingIncludingOtherSide(NodePattern.N.noDependents("cc")).andOr(NodePattern.N.withNextSibling(NodePattern.or(soForAlthoughClause, CommonPatterns.comma.withNextSibling(soForAlthoughClause))), NodePattern.N.withDependent("parataxis", soForAlthoughClause))).trace("beforeCommonReasoning");
        return NodePattern.or(NodePattern.N.form("so").markAs("CC"), NodePattern.N.form("for|and|although|nor|but|or|yet").markAs("CC").withHead(NodePattern.or(isLikelyMainClause, NodePattern.N.withPrevSibling(isLikelyMainClause), NodePattern.N.withHead(NodePattern.or(isLikelyMainClause, NodePattern.N.withDependent("cc", NodePattern.N.sameWordAs("CC")).withHead("conj", isLikelyMainClause).andNot(hasCommonIntro)))))).andNot(CommonPatterns.firstWord).andNot(NodePattern.N.directlyAfter(NodePattern.or(commaLike, EnglishTreePatterns.sentenceBoundary, CommonPatterns.openingParen))).withHead("cc|advmod|mark", NodePattern.or(clauseAfter, NodePattern.N.beforeHead().withHead("ccomp", clauseAfter))).andNot(misparsedNpInternalConj).andNot(NodePattern.N.directlyBefore(CommonPatterns.comma)).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations)).andNot(NodePattern.N.form("for").directlyBefore(NodePattern.N.pos("CC"))).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.inFormSequence(0, ".*", ","), NodePattern.N.inFormSequence(0, ".*", ".*", ",")))).andNot(NodePattern.N.inFormSequence(1, "(no|any|every)body", "but")).andNot(NodePattern.N.inFormSequence(0, "so", "that")).andNot(NodePattern.N.inFormSequence(1, "even", "so")).andNot(possiblySoThat).andNot(NodePattern.N.withHead("cc", misattachedSubordinateCoordination)).andNot(NodePattern.not(NodePattern.N.form("so")).withHead(NodePattern.N.withDependent(".*", NodePattern.or(Questions.whPhrase, NodePattern.N.form("whether"))))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("advcl").withDependent("mark", NodePattern.N.form("how")))).andNot(NodePattern.not(NodePattern.N.form("and").directlyBefore(NodePattern.N.form("so"))).withHead("cc", NodePattern.N.withPrevSibling(NodePattern.N.withDependent("cc", NodePattern.N.form("but"))))).andNot(NodePattern.N.withHead("cc", NodePattern.N.withPrevSibling(NodePattern.N.withDependent("advmod", NodePattern.N.form("then"))))).andNot(NodePattern.N.form("and").withHead("cc", withModalVerb.withPrevSiblingIncludingOtherSide(NodePattern.N.withDependent("ccomp", withModalVerb.withDependent("mark", NodePattern.N.form("that")))))).andNot(NodePattern.N.form("and").withHead("cc", NodePattern.N.withDependent("expl").withPrevSibling(NodePattern.N.withDependent("expl").withDependent("ccomp", NodePattern.N.withDependent("mark", NodePattern.N.form("that")))))).andNot(NodePattern.N.form("and").directlyBefore(NodePattern.N.form("that").withHeadRelation("mark"))).andNot(beforeCommonReasoning).andNot(NodePattern.N.withHead("cc", NodePattern.N.noPos("VB.*").withHead("conj", NodePattern.N.pos("VBZ").potentialPos("NNS").withDependent("obl", NodePattern.N.directlyBefore("CC"))))).andNot(NodePattern.N.withHead("cc", NodePattern.N.withDependent("nsubj", NodePattern.N.inFormSequence(1, "the", "other")).withHead(NodePattern.N.withDependent("nsubj", NodePattern.N.form("one"))))).andNot(NodePattern.N.withHead("cc", NodePattern.N.onlyPos("JJ|VBG").noDependents("cop|aux|aux:pass")).trace("incomplete or misparsed clause")).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.form("that")).withPrevSibling(NodePattern.N.withHeadRelation("acl:relcl")))).andNot(NodePattern.N.form("and|or").withHead("cc", NodePattern.N.withHead(NodePattern.N.withPhraseStart(NodePattern.N.pos("WRB").noForm("how(ever)?|whereby").withHead("mark|advmod", NodePattern.ROOT)))).trace("parcellated subordinate clause")).noDependents(NodePattern.N.beforeHead()).andNot(NodePattern.N.withNextSibling(interruptingClause)).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("advmod").withNextSibling(interruptingClause))).correct(NodeCorrector.insertAfterPrevious(", ")).and((n, m) -> m.withReportedRange(CommonPatterns.withPrevWord(n.neighbor(-1)).start(), n.endOffset(), n.tree())).message(COMMA_BEFORE_CC_MSG).nonCrazy().andNot(NodePattern.markedNodeMatches("ClauseBefore", EnglishTreePatterns.severalSubjects));
    }

    private static boolean areShortAndSimple(Node clause1, Node clause2) {
        if (PunctuationRules.hasInternalComplexity(clause1, clause2) || PunctuationRules.hasInternalComplexity(clause2, null)) {
            return false;
        }
        Node c2Start = clause2.phraseStart();
        return PunctuationRules.wordsBetween(clause1.phraseStart(), c2Start) <= 4L || PunctuationRules.wordsBetween(c2Start, clause2.phraseEnd()) <= 5L;
    }

    private static long wordsBetween(Node from, Node to) {
        return ((StreamEx)from.nextUntil(to).filter(n -> !NodePattern.PUNCT.matches((Node)n))).count();
    }

    private static boolean hasManyConjuncts(Node clause1, Node clause2) {
        return clause1.hasHeadRelation("conj|parataxis") || clause1.allDependents().stream().filter(n -> n == clause2 || n.hasHeadRelation("conj|parataxis")).count() > 1L || clause2.hasDependent("conj|parataxis");
    }

    private static NodePattern markedness() {
        return NodePattern.N.form("please|but|yet|maybe").and(CommonPatterns.firstWord).andNot(NodePattern.ROOT).andNot(TreeMigration.revise("In tree-exp, checking for 'root' should suffice", NodePattern.N.inFormSequence(0, "maybe", ",", "but|and|or|once"))).withNeighbor(2, NodePattern.not(NodePattern.N.withHeadRelation("discourse")).andNot(CommonPatterns.lastWord)).directlyBefore(removeUnmandatedComma).and((node, match) -> match.withLowConfidence()).message("The comma makes '$_' very emphasized, is that intended?");
    }

    private static NodePattern commaBetweenSubjAndVerb() {
        NodePattern possiblyMisparsedSubj = NodePattern.N.withDependent("advmod", CommonPatterns.capitalizedMiddle.noPos());
        return NodePattern.N.withHead("cc", NodePattern.N.pos("VB[ZPDN]?").withHead("conj", NodePattern.ROOT.and(EnglishTreePatterns.clause).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl").and((node, match) -> node.phraseStart().nextUntil(match.getMarkedNode("Comma")).count() < 4L ? match : null).noDependents("advcl", NodePattern.N.beforeHead()).andNot(CommonPatterns.severalDependents("conj"))).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl|advcl").andNot(EnglishTreePatterns.withToMark).andNot(possiblyMisparsedSubj).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("conj|advcl"))).andNot(NodePattern.N.form("let").directlyBefore(NodePattern.N.lemma("we")))).message("Don\u2019t separate a verb from its subject by a comma before '$_'");
    }

    private static NodePattern commaInSimpleCoordination() {
        NodePattern withComplexCompound = NodePattern.N.withDependent("compound", NodePattern.N.withDependent("advmod|punct|conj"));
        NodePattern misparsedIndependentConj = NodePattern.N.andOr(NodePattern.not(CommonPatterns.capitalizedMiddle).potentialPos("VBZ").withDependent("compound", NodePattern.or(NodePattern.N.pos("NNP"), CommonPatterns.capitalizedMiddle.noPos())), NodePattern.N.withDependent("nmod|obj", NodePattern.N.withDependent("det")), NodePattern.N.pos("NNP").withDependent("case|flat", NodePattern.N.afterHead()), NodePattern.N.withDependent("advmod", NodePattern.N.form("otherwise")));
        NodePattern frontedAmodNoun = NodePattern.N.pos("JJ").withHead("conj", NodePattern.N.onlyPos("NN.*").withDependent("amod", NodePattern.N.pos("JJ")));
        NodePattern predicateCoordination = NodePattern.N.pos("NN.*|JJ").andOr(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.pos(".*")), NodePattern.N.withDependent("advmod", NodePattern.or(NodePattern.N.form("maybe"), Semantics.frequencyAdverb)), NodePattern.N.noPos("NN.*").noDependents("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").withHead(NodePattern.N.pos("JJ"))).withHead("conj", NodePattern.N.anyPos().noHeadRelation("advcl|acl(:relcl)?").and(CommonPatterns.skipUp("xcomp", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")))).andNot(NodePattern.N.potentialPos("VBG").withDependent("case"));
        NodePattern withComplexDependentsBeforeConj = NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|conj", NodePattern.N.afterHead().before("Conj"));
        NodePattern headClause = EnglishTreePatterns.clause.and(CommonPatterns.possiblySkipUp("[xc]comp|advcl", NodePattern.N.withHeadRelation("root|parataxis").andNot(EnglishTreePatterns.imperativeVB)));
        NodePattern nominalCoordination = NodePattern.N.pos("NN.*|JJ").noPos("RP").noPotentialPos("VBN").noDependents("amod", NodePattern.N.onlyPos("VBP?")).noDependents("cop|aux|aux:pass").withHead("conj", NodePattern.N.anyPos().noDependents("aux:pass").andOr(NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod", NodePattern.N.andOr(CommonPatterns.skipUp("obj", headClause), headClause).andNot(CommonPatterns.severalDependents("obl")).noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|conj", NodePattern.N.after("Conj"))).noDependents("flat").andNot(CommonPatterns.phraseStartsWithComma).andNot(CommonPatterns.possiblySkipDown("amod|nmod", withComplexDependentsBeforeConj)), NodePattern.ROOT.withDependent("case").withDependent("cop"))).andNot(Semantics.uomPattern).andNot(CommonPatterns.possiblyConj(withComplexCompound)).andNot(frontedAmodNoun).andNot(misparsedIndependentConj);
        NodePattern causalAdverbs = NodePattern.N.form("thus|therefore");
        NodePattern allowedBeforeBut = NodePattern.or(NodePattern.N.inFormSequence(0, "but", "not|also"), NodePattern.N.form("but").withHead("cc", NodePattern.N.withHead("conj", NodePattern.N.withDependent("cc:preconj", NodePattern.N.inFormSequence(1, "not", "just|only")))));
        return NodePattern.N.markAs("Cc").withHead("cc", NodePattern.N.markAs("Conj").andOr(predicateCoordination.trace("comma before cc, predicate coordination"), nominalCoordination.trace("comma before cc, nominal coordination")).noDependents("advmod", NodePattern.or(causalAdverbs, NodePattern.N.form("nor"))).noDependents("punct", NodePattern.not(CommonPatterns.noSpaceHyphen).between("Cc", "Conj")).and((conj, match) -> PunctuationRules.wordsBetween(Objects.requireNonNull(conj.head()), conj) < 10L ? match : null).andNot(NodePattern.or(NodePattern.N.directlyAfter(CommonPatterns.comma), CommonPatterns.phraseEndsWithComma)).andNot(CommonPatterns.skipConjUp(NodePattern.or(withComplexDependentsBeforeConj, CommonPatterns.severalDependents("nmod|conj")))).andNot(CommonPatterns.possiblyConj(NodePattern.or(EnglishTreePatterns.abbreviation, CommonPatterns.severalDependents("conj")))).andNot(CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|nummod", NodePattern.or(NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"), CommonPatterns.severalDependents("conj")))).andNot(NodePattern.N.inPhrase(NodePattern.ROOT.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.after("Conj"))))).andNot(allowedBeforeBut).message("In simple coordination, a comma before '$Cc' is usually unnecessary");
    }

    private static NodePattern excessiveCommaBeforeConj() {
        return NodePattern.N.directlyBefore(Commas.basicCoordinatingConjunction.reportRangeTo("Comma", ReportingKind.Hover).andOr(PunctuationRules.commaBetweenSubjAndVerb(), PunctuationRules.commaInSimpleCoordination()));
    }

    private static NodePattern excessiveCommaAfterSubj() {
        NodePattern subjAsClause = NodePattern.N.withDependent("det", NodePattern.N.form("no")).withHead(EnglishTreePatterns.negated);
        NodePattern withNumberInParentheses = NodePattern.N.withDependent("appos|nmod:tmod", CommonPatterns.withNumberLikeForm.and(CommonPatterns.parenthesizedPhrase));
        NodePattern vocativeImperative = NodePattern.N.form("be").withHead(NodePattern.ROOT);
        return NodePattern.N.directlyBefore(NodePattern.N.includeIntoReport().andOr(NodePattern.N.withHead("cop|aux|aux:pass", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.before("Comma").markAs("Subject").andNot(CommonPatterns.possiblySkipDown("nmod", NodePattern.N.withDependent("punct", CommonPatterns.comma).withDependent("acl").before("Comma"))))).andNot(vocativeImperative), NodePattern.ROOT.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", CommonPatterns.possiblySkipDown("conj", withNumberInParentheses.before("Comma").markAs("Subject")))).andOptionally(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.lemma("not").includeIntoReport()))).directlyAfter(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Subject").andNot(subjAsClause).andNot(NodePattern.N.withHead(EnglishTreePatterns.severalSubjects)).noDependents("acl:relcl", PunctuationRules.relativeClauseComma_Which()))).message("Don\u2019t separate subject and predicate with a comma");
    }

    private static NodePattern excessiveCommaBeforeThat() {
        return NodePattern.N.directlyBefore(NodePattern.N.form("that").withHead("mark", NodePattern.N.withHeadRelation("ccomp|acl")).reportRangeTo("Comma", ReportingKind.Hover)).message(COMMA_THAT_MSG);
    }

    private static NodePattern excessiveCommaBeforeEtAl() {
        return NodePattern.N.directlyBefore(EnglishTreePatterns.etAl.directlyBefore(NodePattern.N.reportRangeTo("Comma", ReportingKind.Hover))).message(COMMA_ET_AL_MSG);
    }

    private static NodePattern excessiveCommaBeforeYear() {
        NodePattern betweenMonthAndYear = NodePattern.N.directlyBefore(EnglishDateChecker.year.markAs("Year")).directlyAfter(NodePattern.N.form(StreamEx.of((Collection)EnglishDateChecker.INSTANCE.monthNames).joining((CharSequence)"|")).noDependents("nummod", NodePattern.N.after("Year")).andNot(NodePattern.N.withHead("nmod", NodePattern.N.form("\\d+(st|nd|rd|th)")))).andNot(NodePattern.N.withHead(NodePattern.N.label("PERSON"))).andNot(CommonPatterns.inParentheses).message("Do not put a comma between the month and the year");
        NodePattern beforeYearInParentheses = NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "\\(", "[123][0-9]{3}", "\\)")).andNot(NodePattern.N.directlyAfter(CommonPatterns.upperCase)).message("Do not use comma before year in parentheses");
        return NodePattern.or(betweenMonthAndYear, beforeYearInParentheses);
    }

    private static NodePattern excessiveCommaInCorrelativeConjunction() {
        NodePattern noComplexDependentsAfter = NodePattern.N.noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.afterHead());
        NodePattern notOnlyButAlso = NodePattern.N.inFormSequence(0, "but", "also").withHead("cc", NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").withHead("conj", NodePattern.N.withDependent("cc:preconj", NodePattern.N.inFormSequence(1, "not", "only").reportEverythingTouched(ReportingKind.Hover)).andOr(NodePattern.N.withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", noComplexDependentsAfter).and(noComplexDependentsAfter), NodePattern.ROOT).andNot(CommonPatterns.severalDependents("conj"))).and(noComplexDependentsAfter).and((node, match) -> match.getMarkedNode("Comma").nextUntil(node.phraseEnd()).count() < 7L ? match : null)).message(COMMA_NOT_ONLY_BUT_ALSO_MSG);
        NodePattern eitherWhetherOr = NodePattern.N.form("n?or").markAs("SecondCc").withHead("cc", NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").markAs("CcHead").withHead("conj", NodePattern.or(CommonPatterns.possiblySkipDown("nsubj", NodePattern.N.withDependent("cc:preconj|det", NodePattern.N.form("n?either").markAs("FirstCc"))), NodePattern.N.inPhrase(NodePattern.N.withHeadRelation("ccomp").withDependent("mark", NodePattern.N.form("whether").markAs("FirstCc")).noDependents("conj", NodePattern.N.after("CcHead")))).noDependents("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.before("Comma")).andNot(CommonPatterns.severalDependents("conj")).andNot(NodePattern.N.withDependent("punct", CommonPatterns.comma.between("FirstCc", "Comma"))))).andOr(NodePattern.N.form("or").and(NodePattern.markedNodeMatches("FirstCc", NodePattern.N.form("whether|either").includeIntoReport(ReportingKind.Hover))), NodePattern.N.form("nor").and(NodePattern.markedNodeMatches("FirstCc", NodePattern.N.form("neither").includeIntoReport(ReportingKind.Hover)))).includeIntoReport(ReportingKind.Hover).message("'$FirstCc... $SecondCc...' phrases usually don\u2019t need a comma");
        return NodePattern.N.directlyBefore(NodePattern.or(notOnlyButAlso, eitherWhetherOr));
    }

    private static NodePattern excessiveCommasAroundParticipialClause() {
        return NodePattern.N.pos("VBG").markAs("Acl").directlyAfter(CommonPatterns.comma.markAs("Comma")).withHead("acl", NodePattern.N.pos("NNS?").markAs("Noun").andNot(possiblyHeadOfNonRestrictiveClause).and(CommonPatterns.possiblySkipDown("nmod", NodePattern.N.directlyBefore("Comma")))).andOr(NodePattern.markedNodeMatches("Noun", NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(NodePattern.N.withDependent("cop", NodePattern.N.after("Comma")), NodePattern.N.withDependent("aux", NodePattern.N.pos("MD").noLemma("will").after("Comma")))).noDependents("conj")), NodePattern.N.inPhrase(NodePattern.ROOT.andOr(EnglishTreePatterns.imperativeVB.and(NodePattern.markedNodeMatches("Acl", SemCompatibility.needsInanimateSubject)), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", SemCompatibility.Unlikely.between(SemCompatibility.Relation.Subject, NodePointer.marked("Acl"), NodePointer.anchor()))))).andNot(SemCompatibility.Unlikely.between(SemCompatibility.Relation.Subject, NodePointer.anchor(), NodePointer.marked("Noun"))).message("If this is a restrictive clause on '$Noun', remove surrounding commas");
    }

    private static NodePattern excessiveColonAfterSuchAs() {
        return CommonPatterns.colon.andNot(CommonPatterns.lastWord).andOr(NodePattern.N.inFormSequence(2, "such", "as", ":").reportEverythingTouched().correct(NodeCorrector.replace("")), NodePattern.N.inFormSequence(2, "for", "example", ":").reportEverythingTouched().andNot(NodePattern.N.directlyBefore(CommonPatterns.urlLike)).correct(NodeCorrector.replace(",")), NodePattern.N.directlyAfter(NodePattern.N.form("including")).reportEverythingTouched().correct(NodeCorrector.replace(""))).message(EXCESSIVE_COLON_MESSAGE);
    }

    private static NodePattern commaBeforePoliteWords() {
        return NodePattern.N.form("please|thanks?|sorry").directlyAfter(NodePattern.N.form(".*[\\p{L}\\d].*").andNot(CommonPatterns.personMentionEnd).includeIntoReport()).andOr(NodePattern.N.form("please").and(CommonPatterns.lastWord).noDependents().includeIntoReport().correct(NodeCorrector.insertBefore(", ")).message(POLITE_COMMA), NodePattern.N.form("thanks|sorry").includeIntoReport().andOr(CommonPatterns.lastWord.noHeadRelation("conj").andNot(NodePattern.N.withHeadRelation("root|parataxis").withDependent("amod").noDependents("cop")), NodePattern.ROOT.directlyAfter(CommonPatterns.firstWord.form("awesome|cool|great|nice|wow|well"))).andNot(NodePattern.N.directlyAfter(CommonPatterns.firstWord.form("oh"))).noDependents("det", NodePattern.N.form("an?|the")).noDependents("nmod:poss|nummod|case").andNot(NodePattern.N.withHeadRelation("parataxis").withDependent("nsubj")).andNot(NodePattern.N.withHead("vocative|obj|[cx]comp|discourse", NodePattern.or(Semantics.directSpeech, NodePattern.N.lemma("give|make"), NodePattern.N.noPos()))).andNot(NodePattern.N.form("sorry").withDependent("cop|aux|aux:pass")).correct(NodeCorrector.insertBefore(", ")).message(POLITE_COMMA), EnglishTreePatterns.thankYou.directlyBefore(CommonPatterns.lastWord).directlyAfter(NodePattern.or(NodePattern.N.noForm("no").noHeadRelation("advmod"), CommonPatterns.firstWord)).noHeadRelation("xcomp|ccomp|conj").andNot(NodePattern.N.withHeadRelation("parataxis").withDependent("advmod")).andNot(NodePattern.ROOT.withDependent("cop|aux|aux:pass")).and(CommonPatterns.skipUp("compound", NodePattern.N.noDependents("aux|mark|det|nsubj|nmod:poss"))).reportEverythingTouched().correct(NodeCorrector.insertBefore(", ")).message("Use a comma before 'thank you' interjection at the end of a sentence"));
    }

    private static NodePattern directSpeech() {
        NodePattern directSpeechRightEdge = EnglishTreePatterns.aposOrQuote.noSpaceBefore().includeIntoReport().andOr(NodePattern.N.beforeHead().withHead("punct", Semantics.directSpeech.withDependent("ccomp", NodePattern.N.markAs("DirectSpeech"))).withPrevSibling(NodePattern.N.alreadyMarkedAs("DirectSpeech")), NodePattern.N.afterHead().markAs("ClosingQuote").andOr(NodePattern.N.withHead("punct", NodePattern.N.withPhraseEnd(CommonPatterns.skipBack(CommonPatterns.comma, NodePattern.N.alreadyMarkedAs("ClosingQuote"))).beforeHead().withHead("ccomp", Semantics.directSpeech)), NodePattern.N.withHead("punct", NodePattern.or(NodePattern.ROOT, NodePattern.N.withPhraseEnd(NodePattern.N.alreadyMarkedAs("ClosingQuote"))).withDependent("parataxis", Semantics.directSpeech.afterHead().markAs("DirectSpeechVerb").andOr(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("ccomp|parataxis")), NodePattern.N.withDependent("ccomp|parataxis")))).before("DirectSpeechVerb")));
        NodePattern directSpeechLeftEdge = NodePattern.or(NodePattern.N.afterHead().withHead("punct", Semantics.directSpeech.withDependent("ccomp", NodePattern.N.afterHead().markAs("DirectSpeech"))).withNextSibling(NodePattern.N.alreadyMarkedAs("DirectSpeech")), NodePattern.N.beforeHead().withHead("punct", NodePattern.N.afterHead().andOr(NodePattern.N.withHead("ccomp", Semantics.directSpeech.markAs("DirectSpeechVerb").andOr(NodePattern.ROOT, NodePattern.N.pos("VBG").withDependent("mark"))), NodePattern.N.withHead(Semantics.directSpeech.markAs("DirectSpeechVerb").withHeadRelation("parataxis")), NodePattern.N.withPrevSibling(Semantics.directSpeech.markAs("DirectSpeechVerb").withHeadRelation("parataxis"))).and(withQuoteMarkAfterDirectSpeechVerb).noDependents("mark")));
        return NodePattern.or(EnglishTreePatterns.aposOrQuote.noSpaceBefore().and(CommonPatterns.lastToken).includeIntoReport().directlyAfter(NodePattern.not(NodePattern.PUNCT).includeIntoReport()).withHead("punct", TreeMigration.revise("one of the conditions might become redundant", NodePattern.or(Semantics.directSpeech.markAs("DirectSpeechVerb").withDependent("ccomp", NodePattern.N.afterHead().withPrevSibling(EnglishTreePatterns.aposOrQuote)), NodePattern.N.withHead("ccomp", Semantics.directSpeech.markAs("DirectSpeechVerb").noHeadRelation("ccomp").andNot(NodePattern.N.pos("VBG").withDependent("mark"))).and(withQuoteMarkAfterDirectSpeechVerb)))).correct(NodeCorrector.insertBefore(".")).correct(NodeCorrector.insertBefore("!")).correct(NodeCorrector.insertBefore("?")).message(DIRECT_SPEECH_MISSING_PUNCTUATION), directSpeechRightEdge.spaceAfter().andNot(CommonPatterns.afterSkipping(EnglishTreePatterns.aposOrQuote.noSpaceAround(), NodePattern.N.form("[,?!]"))).directlyBefore(NodePattern.not(NodePattern.PUNCT).includeIntoReport()).directlyAfter(NodePattern.N.includeIntoReport()).correct(NodeCorrector.insertBefore(",")).message(DIRECT_SPEECH_MISSING_COMMA_AFTER), EnglishTreePatterns.aposOrQuote.spaceBefore().noSpaceAfter().includeIntoReport().andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT)).and(directSpeechLeftEdge).andOr(NodePattern.N.directlyBefore(CommonPatterns.capitalized), NodePattern.N.withHead("punct", NodePattern.or(NodePattern.N.withDependent("ccomp", NodePattern.N.beforeHead()), NodePattern.N.withHeadRelation("parataxis")))).directlyBefore(NodePattern.N.includeIntoReport()).directlyAfter(NodePattern.N.includeIntoReport()).correct(NodeCorrector.insertBefore(", ")).message(DIRECT_SPEECH_MISSING_COMMA_BEFORE), FormattingIssues.movePunctBeforeQuote.directlyAfter(directSpeechRightEdge.directlyAfter(NodePattern.N.includeIntoReport())).directlyBefore(NodePattern.N.includeIntoReport()).and(EnglishParameters.VARIANT.withValue("US")).suggestActions(EnglishParameters.VARIANT.changeTo("GB")).message(DIRECT_SPEECH_COMMA_BEFORE_QUOTE_US));
    }

    static List<Rule> priorityRules() {
        return List.of(new ZeroWidthSpaceRule("Zero-width space", "Find and remove Unicode zero-width space characters in words.", "https://en.wikipedia.org/wiki/Zero-width_space", "This word contains invisible zero-width space characters, remove them?", "Very <b>eas\u200by</b> to use."));
    }

    static List<Rule.PatternRule> rules() {
        return StreamEx.of((Object[])new Rule.PatternRule[]{new Rule.PatternRule("Punctuation.RELATIVE_CLAUSE_COMMA", "Commas around relative clauses", "Restrictive (or defining) relative clauses give essential information about the object they refer to.\nSuch clauses don\u2019t need commas around them.\nThe word \"that\" can only introduce a restrictive clause, so commas are unnecessary.\n<p>\nNon-restrictive (or non-defining) clauses provide additional, comment-like information about something.\nRemoving them from a sentence does not change who or what is being referred to.\nLike other similar optional elements in the sentence, non-restrictive clauses are surrounded by commas.\nSuch commas are called <i>bracketing commas</i>.\n<p>\nRelative clauses on proper names are almost never restrictive (with some exceptions, e.g. 'the' determiner),\nso they should be surrounded by commas.\n", "https://dictionary.cambridge.org/grammar/british-grammar/relative-clauses-defining-and-non-defining", NodePattern.or(PunctuationRules.relativeClauseComma_That(), PunctuationRules.relativeClauseComma_ProperNoun(), PunctuationRules.relativeClauseComma_Which()), new Example("Russell struck up a surprising friendship with <b>Lawrence</b><i> whose strange ideas seemed to fascinate him</i>.", "Missing comma before a non-restrictive clause on a proper noun?", "Russell struck up a surprising friendship with Lawrence<b>, whose</b> strange ideas seemed to fascinate him.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.ADVERBIAL_COMMA", "Commas around linking phrases", "Sentence-linking phrases like 'for example' or 'according to' should be surrounded by commas in many cases.", "https://www.englishessaywritingtips.com/2012/08/transition-words-punctuation/", PunctuationRules.adverbialComma(), new Example("<i>As I was </i><b>requested</b> I chose two activities from the list.", "Missing comma after a participial phrase?", "As I was <b>requested,</b> I chose two activities from the list."), new Example("<b>However</b> this is not the only reason", "Missing comma after a linking/introductory word?", "<b>However,</b> this is not the only reason"), new Example("He tries to solve a problem, <b>however,</b> difficult it may seem.", REMOVE_HOWEVER_COMMA_MSG, "He tries to solve a problem, <b>however</b> difficult it may seem.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.ETC_COMMA", "Check for comma before 'etc.'", "A comma is necessary before <i>etc.</i> right after the last element on a list.\n", "https://linguaholic.com/linguablog/comma-before-etc/", PunctuationRules.etcComma(), new Example("I like apples, <b>pears etc</b>.", ETC_COMMA_MESSAGE, "I like apples, <b>pears, etc</b>.")), new Rule.PatternRule("Punctuation.ABBREVIATION_DOTS", "Abbreviation dots", "Missing or extra periods with abbreviations.", "https://www.e-education.psu.edu/styleforstudents/c3_p28.html", PunctuationRules.abbreviationDots(), new Example("Holmlund <b>et al</b> report similar results.", ET_AL_MSG, "Holmlund <b>et al.</b> report similar results.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.COMMA_SPLICING", "Joining sentences with comma", "Comma splice: independent sentences should not be joined with a comma. There should be either connecting words or a semicolon.<p>In some cases, such commas are acceptable. For example, when sentences are closely connected or have neither internal commas nor subordinate clauses. Therefore, this rule only reports complex sentences where commas aren\u2019t advised by any style guide.", "https://en.wikipedia.org/wiki/Comma_splice", commaSplicing, new Example("Saturn was long thought to be the only ringed <b>planet, however</b>, this is now known not to be the case.", SPLICING_MSG, "Saturn was long thought to be the only ringed <b>planet; however</b>, this is now known not to be the case.", "Saturn was long thought to be the only ringed <b>planet. However</b>, this is now known not to be the case.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.COMMA_BEFORE_CC_CLAUSE", "Comma before conjunction between clauses", "Check if a comma is necessary between independent clauses joined by a coordinating conjunction.", "https://palimpsestediting.com/writers-notebook/copyediting/punctuation-notes/when-to-omit-the-comma-before-the-coordinating-conjunction-that-joins-two-independent-clauses", PunctuationRules.commaBeforeCcClause(), new Example("This is a tragic <b>event and</b> that\u2019s all I can say.", COMMA_BEFORE_CC_MSG, "This is a tragic <b>event, and</b> that\u2019s all I can say.")), new Rule.PatternRule("Punctuation.EXCESSIVE_COMMA", "Excessive comma", "Check for unnecessary commas within a clause or before clauses that serve as objects of verbs.", null, NodePattern.or(CommonPatterns.comma.markAs("Comma").andOr(PunctuationRules.excessiveCommaInCorrelativeConjunction(), PunctuationRules.excessiveCommaBeforeConj(), PunctuationRules.excessiveCommaAfterSubj(), PunctuationRules.excessiveCommaBeforeThat(), PunctuationRules.excessiveCommaBeforeEtAl(), PunctuationRules.excessiveCommaBeforeYear()).and(removeUnmandatedComma), PunctuationRules.excessiveCommasAroundParticipialClause().and(removeSurroundingCommas)), new Example("Cats <b>frolic,</b><i> and</i> purr.", "Don\u2019t separate a verb from its subject by a comma before 'and'", "Cats frolic <b>and</b> purr."), new Example("Do I understand <b>correctly,</b><i> that</i> there\u2019s no simple way to achieve this?", COMMA_THAT_MSG, "Do I understand <b>correctly that</b> there\u2019s no simple way to achieve this?"), new Example("The hike was <b>long,</b><i> and</i> challenging.", "In simple coordination, a comma before 'and' is usually unnecessary", "The hike was <b>long and</b> challenging."), new Example("The book was <i>not only</i> <b>interesting,</b> <i>but also</i> educational.", COMMA_NOT_ONLY_BUT_ALSO_MSG, "The book was not only <b>interesting</b> but also educational.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.EXCESSIVE_COLON", "Excessive colon", "Check if a colon is superfluous.", "https://medium.com/@Ediket/how-do-you-use-a-colon-1ea08a135d9e", PunctuationRules.excessiveColonAfterSuchAs(), new Example("She had skills of a great litigator, <b>such as:</b> writing ability, perseverance, persuasiveness, and obsessive attention to detail.", EXCESSIVE_COLON_MESSAGE, "She had skills of a great litigator, <b>such as</b> writing ability, perseverance, persuasiveness, and obsessive attention to detail.")), new Rule.PatternRule("Punctuation.POLITE_COMMA", "'Please' comma", "Checks if a comma before <i>please</i>, <i>thanks</i> or <i>thank you</i> at the end of a sentence is necessary.", "https://dictionary.cambridge.org/grammar/british-grammar/please-and-thank-you", PunctuationRules.commaBeforePoliteWords(), new Example("Leave the door <b>open please</b>.", "Use a comma before 'please' interjection at the end of a sentence", "Leave the door <b>open, please</b>.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.LIST_COLON", "Colons with lists", "Check that lists of items are introduced with a colon.", "https://www.grammarbook.com/blog/colons/colons/", PunctuationRules.listColon(), new Example("Access them at the following <b>links,</b> Equifax, Experian and Trans Union.", LIST_COLON_MSG, "Access them at the following <b>links:</b> Equifax, Experian and Trans Union.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.SUBORDINATION_COMMA", "Sentence subordination commas", "Subordinate sentences should be comma-separated when they occur before the main sentences.", "https://owl.purdue.edu/owl/general_writing/punctuation/commas/extended_rules_for_commas.html", PunctuationRules.subordination(), new Example("<i>If it does not rain </i><b>heavily</b> we will stay home.", MISSING_SUBORDINATION_COMMA_MSG, "If it does not rain <b>heavily,</b> we will stay home."), new Example("We will call <b>you,</b><i> when we need you</i>.", REDUNDANT_SUBORDINATION_COMMA_MSG, "We will call <b>you when</b> we need you.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.MISSING_QUESTION_MARK", "Missing question mark", "Missing question mark at the end of an interrogative sentence.", null, PunctuationRules.missingQuestionMark(), new Example("Did you forget the question <b>mark</b>", MISSING_QUESTION_MARK_MSG, "Did you forget the question <b>mark?</b>")).honorCrazyParses(), new Rule.PatternRule("Style.PUNCTUATION_MARKEDNESS", "Punctuation markedness", "Cases where punctuation indicates that some nontypical intonation or meaning is implied. While this may be fine, it often means the punctuation should be adjusted.", "https://en.wikipedia.org/wiki/Markedness", PunctuationRules.markedness(), new Example("<b>Please,</b> go away.", "The comma makes 'please' very emphasized, is that intended?", "<b>Please</b> go away."))}).append(HyphenVsDash.punctuationRules()).append((Object[])new Rule.PatternRule[]{new Rule.PatternRule("Punctuation.DIRECT_SPEECH", "Correct punctuation when rendering direct speech", "Direct speech is enclosed within quotation marks, and commas are used to set it apart from the surrounding text.", "https://grammar.collinsdictionary.com/easy-learning/how-do-you-write-direct-speech-in-english", PunctuationRules.directSpeech(), new Example("\u2018There is nothing we can do about <b>it\u2019 said</b> Monica.", DIRECT_SPEECH_MISSING_COMMA_AFTER, "\u2018There is nothing we can do about <b>it,\u2019 said</b> Monica."), new Example("Monica <b>said \u2018There</b> is nothing we can do about it.\u2019", DIRECT_SPEECH_MISSING_COMMA_BEFORE, "Monica <b>said, \u2018There</b> is nothing we can do about it.\u2019"), new Example("Monica said, \u2018There is nothing we can do about <b>it\u2019</b>", DIRECT_SPEECH_MISSING_PUNCTUATION, "Monica said, \u2018There is nothing we can do about <b>it.\u2019</b>", "Monica said, \u2018There is nothing we can do about <b>it!\u2019</b>", "Monica said, \u2018There is nothing we can do about <b>it?\u2019</b>"), new Example("\u2018There is nothing we can do about <b>it\u2019, said</b> Monica.", List.of(DIRECT_SPEECH_COMMA_BEFORE_QUOTE_US), List.of("\u2018There is nothing we can do about <b>it,\u2019 said</b> Monica."), Map.of(EnglishParameters.VARIANT, "US"))), new Rule.PatternRule("Punctuation.FORMATTING_ISSUES", "Punctuation/whitespace issues", "Check incorrect comma vs. space placement, double punctuation, etc.", null, PunctuationRules.formattingIssues(), new Example("For <b>example,,</b> a dog.", TOO_MANY_PUNCTUATION_MARKS, "For <b>example,</b> a dog."), new Example("<b>It \u2019s</b> a nice day today.", WRITE_CONTRACTIONS_WITHOUT_SPACES, "<b>It\u2019s</b> a nice day today."), new Example("I began to involuntarily <b>un-focus</b> my eyes", UNNECESSARY_HYPHEN, "I began to involuntarily <b>unfocus</b> my eyes")), new Rule.PatternRule("Punctuation.QUOTE_PUNCTUATION", "Check punctuation relative to closing quotation marks", "Colons and semicolons should be placed outside the quotation marks.\n<p>\nThere should be no double sentence-ending punctuation (periods and question and exclamation marks)\naround the quotation marks: only one of them should be retained.\nIn American English, question and exclamation marks precede closing quotation marks,\nwhile British English only places punctuation inside quotes when it is part of the quoted material.\n", "https://www.transcendwithwords.com/post/separated-by-a-common-language-british-vs-american-english-quotations", PunctuationRules.quotePunctuation(), new Example("What she calls her \u201cOlympic <b>journey:\u201d</b> family support and personal commitment.", "A colon should be placed outside quotation marks", "What she calls her \u201cOlympic journey<b>\u201d:</b> family support and personal commitment."), new Example("Did he say, \u201cThis is the <b>way.\u201d?</b>", "Excessive period?", "Did he say, \u201cThis is the <b>way\u201d?</b>"))}).toList();
    }

    private static NodePattern etcComma() {
        NodePattern xAndYSeparate = NodePattern.N.withPhraseStart(NodePattern.N.withHeadRelation("cc").directlyAfter(NodePattern.not(CommonPatterns.comma))).withPrevSibling(Commas.commaStartingPhrase.noDependents("cc"));
        NodePattern prevConj = NodePattern.N.withHead("conj|list", NodePattern.or(NodePattern.not(EnglishTreePatterns.clause), NodePattern.N.pos("VBG?").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl"))).andOr(Commas.commaStartingPhrase.noDependents("cc"), xAndYSeparate);
        return NodePattern.N.form("etc").directlyAfter(CommonPatterns.skipBack(EnglishTreePatterns.quotes.closing(), NodePattern.N.noForm("[,/]"))).reportEverythingTouched().afterHead().and(CommonPatterns.lastChildPhrase).andOr(NodePattern.N.withPrevSibling(prevConj), NodePattern.N.withHead("advmod", CommonPatterns.capitalizedMiddle.withHeadRelation("parataxis").withPrevSibling(prevConj))).withOnlyDependents(NodePattern.PUNCT).correct(NodeCorrector.insertAfterPrevious(",")).message(ETC_COMMA_MESSAGE);
    }

    private static NodePattern popularLatinAbbreviations() {
        Map<String, String> latinAbbreviation = Map.of("etc", "et cetera", "ca", "circa", "c", "circa");
        NodePattern etcCa = NodePattern.or(NodePattern.N.formCaseSensitive("etc").andNot(beforeDot).andNot(NodePattern.or(NodePattern.N.withNeighbor(1, CommonPatterns.slash), NodePattern.N.withNeighbor(-1, CommonPatterns.slash))), NodePattern.N.formCaseSensitive("ca?").andOptionally(NodePattern.N.form("c").and(CommonPatterns.highlightPlusOneChar)).directlyBefore(CommonPatterns.skipForward(NodePattern.N.form("AD|BC"), CommonPatterns.withNumberLikeForm))).and(NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.insertAfter(node, ".")).withMessage("'" + node.lowForm() + "' is an abbreviation for '" + (String)latinAbbreviation.get(node.lowForm()) + "' and thus needs a single period at the end")));
        NodePattern vs = NodePattern.N.formCaseSensitive("vs").andNot(beforeDot).and(EnglishParameters.VARIANT.withValue("US")).andNot(CommonPatterns.insideQuotes).correct(NodeCorrector.insertAfter(".")).message("Put a period after '$_' in American English");
        return NodePattern.or(etcCa, vs).andNot(CommonPatterns.quotedWord);
    }

    private static NodePattern referenceAbbreviations() {
        NodePattern etAl = NodePattern.N.form("al").and(CommonPatterns.afterSkipping(CommonPatterns.dot, NodePattern.N.form("[ae]t").markAs("Et"))).message(ET_AL_MSG).andOr(NodePattern.not(beforeDot), NodePattern.N.spaceAfter(), NodePattern.not(NodePattern.N.directlyAfter("Et"))).andOr(NodePattern.not(beforeDot).markAs("End"), NodePattern.N.directlyBefore(NodePattern.N.markAs("End"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Et"), NodePointer.marked("End"), "et al."));
        String abbrFollowedByNumber = "(pp?|paras?|[Vv]ols?|[Pp]t|[Cc]h)";
        NodePattern oneWordAbbreviations = NodePattern.or(NodePattern.N.formCaseSensitive(abbrFollowedByNumber).directlyBefore(CommonPatterns.withNumberLikeForm), NodePattern.N.form("ed").directlyAfter(NodePattern.N.form("\\d+(st|nd|rd|th)")), NodePattern.N.formCaseSensitive("Eds?|cf").directlyBefore(NodePattern.or(NodePattern.not(NodePattern.PUNCT), CommonPatterns.closingParen))).andOr(NodePattern.N.noLabel(".*"), CommonPatterns.inParentheses).andNot(beforeDot).andOptionally(NodePattern.N.form("\\w").and(CommonPatterns.highlightPlusOneChar)).correct(NodeCorrector.insertAfter(".")).message("'$_' is an abbreviation and thus needs a single period at the end");
        NodePattern missingSpaceBeforeNumber = NodePattern.N.formCaseSensitive(abbrFollowedByNumber + "[0-9]+").andOr(CommonPatterns.inParentheses, NodePattern.N.noDependents("compound").noDependents("case", NodePattern.N.afterHead()).noLabel(".*").andNot(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("nummod|appos|compound")))).and(NodePattern.custom((node, match) -> {
            String abbreviation = node.form().replaceAll("\\d+", "");
            return match.withCorrector(NodeCorrector.regexReplace(node, abbreviation, abbreviation + ".\u00a0")).withMessage("'" + abbreviation + "' is an abbreviation and thus needs a single period at the end");
        }));
        return NodePattern.or(etAl, oneWordAbbreviations, missingSpaceBeforeNumber);
    }

    private static NodePattern abbreviationDots() {
        return NodePattern.or(PunctuationRules.popularLatinAbbreviations(), PunctuationRules.referenceAbbreviations(), PunctuationRules.noDot());
    }

    private static NodePattern noDot() {
        NodePattern dotVariant = NodePattern.not(EnglishParameters.VARIANT.withValue("GB.*"));
        return NodePattern.or(NodePattern.N.inFormSequence(0, "no", "\\.").withNeighbor(2, CommonPatterns.withNumberLikeForm).andNot(dotVariant).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "no")).message("The abbreviation for 'number' does not require a period in British English"), NodePattern.N.form("no").directlyBefore(CommonPatterns.withNumberLikeForm).and(dotVariant).correct(NodeCorrector.replace("no.")).message("The abbreviation for 'number' requires a period")).and(EnglishParameters.VARIANT.withValue(".+"));
    }
}

