/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.en.EnglishDateChecker;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.WordConfusion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.List;
import one.util.streamex.StreamEx;

class SemanticRules {
    private static final NodePattern frontedNonVerbalModifier = CommonPatterns.firstChildPhrase.noPos("VB.*").andOr(NodePattern.N.withDependent("cop", NodePattern.N.form("being")).noDependents("aux.*"), NodePattern.N.noDependents("cop|aux|aux:pass").noDependents("case", CommonPatterns.firstWord.pos("VBN")));
    static final NodePattern subjectModifier = NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|mark").andOr(NodePattern.N.pos("VBG|VBN"), frontedNonVerbalModifier).noDependents("advmod", NodePattern.N.form("when"));

    SemanticRules() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Semantics.ABSOLUTE_DATE_ISSUES", "Absolute date issues", "Check that the dates are valid and the weekdays are consistent with the dates.", null, EnglishDateChecker.INSTANCE.absolutePattern(), EnglishDateChecker.INSTANCE.weekdayExample(DateChecker.YearStrategy.absolute), new Example("An example of an incorrect date is <b>April 31, 2000</b>", "April has only 30 days", new String[0])), new Rule.PatternRule("Semantics.RELATIVE_DATE_ISSUES", "Relative date issues", "Find various mistakes assuming the text relates to the current date:\n<ul>\n<li>Using a past-tense verb with a future date,\n<li>Suspicious usage of dates from the previous year at the beginning of a new one,\n<li>Dates without no year specified (so likely from the current year) with non-matching week day.\n</ul>\n", null, EnglishDateChecker.INSTANCE.relativePattern(), new Example("It was in <b>2048</b>.", "The future date disagrees with the past 'was'", new String[0]), EnglishDateChecker.INSTANCE.weekdayExample(DateChecker.YearStrategy.current)).honorCrazyParses(), new Rule.PatternRule("Semantics.DANGLING_MODIFIER", "Dangling or misplaced modifier", "A misplaced modifier is a word, phrase, or clause improperly separated from the word it modifies or describes.\nA dangling modifier is a word, phrase, or clause that doesn\u2019t clearly and logically relate to the word it\u2019s intended to modify.\n", "https://webapps.towson.edu/ows/moduleDangling.htm", SemanticRules.danglingModifier(), new Example("<b>Being a rainy day</b>, we had to abandon the match.", "This modifier phrase doesn\u2019t seem to relate to the subject 'we'", new String[0])).honorCrazyParses(), WordConfusion.commonlyConfusedWords());
    }

    private static NodePattern danglingModifier() {
        NodePattern adjSemanticMismatch = new ConjSequence(NodePattern.N.potentialPos("JJ.*")).any(SemanticRules.incompatibleWithNoun(SemCompatibility.Relation.Subject));
        NodePattern npSemanticMismatch = new ConjSequence(NodePattern.N.pos("NN.*")).any(SemanticRules.incompatibleWithNoun(SemCompatibility.Relation.Subject));
        NodePattern verbObjSemanticMismatch = SemanticRules.incompatibleWithNoun(SemCompatibility.Relation.Object);
        NodePattern verbSubjSemanticMismatch = NodePattern.or(SemanticRules.incompatibleWithNoun(SemCompatibility.Relation.Subject), SemCompatibility.Possible.between(SemCompatibility.Relation.Subject, NodePointer.anchor(), NodePointer.marked("Noun")).markAs("Predicate").and(NodePattern.markedNodeMatches("MainClause", CommonPatterns.possiblySkipDown("xcomp", NodePattern.N.withDependent("i?obj|obl", SemCompatibility.Likely.between(SemCompatibility.Relation.Subject, NodePointer.marked("Predicate"), NodePointer.anchor()))))));
        NodePattern postNpModifier = EnglishTreePatterns.clause.afterHead().withPrevSibling(NodePattern.N.afterHead().withHeadRelation("nsubj.*|i?obj|obl").markAs("Noun")).andOr(NodePattern.markedNodeMatches("Noun", NodePattern.N.pos("PRP.*").message("This modifier phrase doesn\u2019t seem to relate to the nearest pronoun '$Noun'")), NodePattern.N.message("This modifier phrase doesn\u2019t seem to relate to the nearest noun '$Noun'"));
        NodePattern clauseSubjectModifier = NodePattern.markedNodeMatches("MainClause", NodePattern.N.withDependent("nsubj(:pass)?|expl", NodePattern.N.noLabel("PRODUCT|ORGANIZATION").markAs("Noun"))).message("This modifier phrase doesn\u2019t seem to relate to the subject '$Noun'");
        NodePattern passiveVbnModifier = NodePattern.N.pos("VBN").andOr(NodePattern.N.withDependent("aux:pass|cop", NodePattern.N.form("being")), NodePattern.N.noDependents("cop|aux|aux:pass"));
        NodePattern gerundModifier = NodePattern.or(NodePattern.N.pos("VBG"), NodePattern.N.pos("VBN").withDependent("aux", NodePattern.N.form("having")));
        NodePattern skipNsubjMainCl = CommonPatterns.skipUp("nsubj", NodePattern.N.markAs("MainClause"));
        return subjectModifier.andOr(NodePattern.N.withHead("advcl", skipNsubjMainCl), NodePattern.N.beforeHead().and(CommonPatterns.phraseEndsWithComma).withHead("acl|amod", skipNsubjMainCl)).andOr(postNpModifier, clauseSubjectModifier).andOr(frontedNonVerbalModifier.andOr(npSemanticMismatch, adjSemanticMismatch), new ConjSequence(passiveVbnModifier).any(verbObjSemanticMismatch), new ConjSequence(gerundModifier.noDependents("aux:pass")).any(verbSubjSemanticMismatch), new ConjSequence(gerundModifier.withDependent("aux:pass")).any(verbObjSemanticMismatch)).and(CommonPatterns.highlightPhrase());
    }

    private static NodePattern incompatibleWithNoun(SemCompatibility.Relation rel) {
        return SemCompatibility.Unlikely.between(rel, NodePointer.anchor(), NodePointer.marked("Noun"));
    }

    private record ConjSequence(NodePattern filter) {
        NodePattern any(NodePattern condition) {
            return NodePattern.custom((node, match) -> {
                for (Node conj : StreamEx.of((Object)node).append(node.findDependents("conj"))) {
                    if (this.filter.match(conj, match) == null) {
                        return null;
                    }
                    NodeMatch cm = condition.match(conj, match);
                    if (cm == null) continue;
                    return cm;
                }
                return null;
            });
        }
    }
}

