/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TenseChanges {
    private static final NodePattern aposSMisparsedAsCop = EnglishTreePatterns.apostropheS.withHead("cop|aux|aux:pass", NodePattern.N.pos("VBN").noPos("NN.*"));
    private static final NodePattern perfectHaveAux = NodePattern.or(NodePattern.N.pos("VB[ZDP]?").lemma("have").withHeadRelation("aux"), aposSMisparsedAsCop);
    private static final NodePattern withPossiblyMisparsedAux = NodePattern.N.withDependent("advmod|nsubj", NegativePhrases.mistypedNot);

    TenseChanges() {
    }

    @Nullable
    static Node findPerfectHave(Node predicate) {
        return StreamEx.of(predicate.findDependents("cop|aux|aux:pass")).findFirst(perfectHaveAux::matches).orElse(null);
    }

    @Nullable
    static NodeMatch nonPastToPast(Node predicate, NodeMatch match) {
        Node aux = EnglishTreePatterns.findFirstCopAuxInner(predicate);
        if (aux == null) {
            if (predicate.hasPos("VB[PZ]") && !predicate.hasPos("VBD")) {
                if (predicate.hasLemma("be")) {
                    return match.withCorrector(TenseChanges.beToPast(predicate, predicate));
                }
                return match.withCorrector(NodeCorrector.inflect(predicate, "VB.*", "VBD"));
            }
            return null;
        }
        if (aux.hasForm("may")) {
            return match.withCorrector(NodeCorrector.replace(aux, "might"));
        }
        if (aux.hasForm("can?")) {
            return match.withCorrector(NodeCorrector.replace(aux, "could"));
        }
        if (aux.hasLemma("will|might")) {
            List<Node> auxVerbs = predicate.findDependents("cop|aux|aux:pass");
            Node next = auxVerbs.size() > 1 ? auxVerbs.get(1) : predicate;
            return TenseChanges.auxToFinite(match, EnglishTreePatterns.findNegation(predicate), aux, next, true, false);
        }
        if (aux.hasPos("VB[ZP]")) {
            if (aux.hasLemma("have") && EnglishTreePatterns.startsWithApostrophe.matches(aux)) {
                return match.withCorrector(NodeCorrector.replace(aux, aux.lowForm().charAt(0) + "d"));
            }
            if (aux.hasLemma("be")) {
                return match.withCorrector(TenseChanges.beToPast(predicate, aux));
            }
            return match.withCorrector(NodeCorrector.inflect(aux, "VB[ZP]", "VBD"));
        }
        return null;
    }

    private static NodeCorrector beToPast(Node predicate, Node be) {
        String space = EnglishTreePatterns.startsWithApostrophe.matches(be) ? " " : "";
        String wasWere = VerbInflectionNumber.from(predicate, EnglishTreePatterns.findSubject(predicate)).past(true).inflectBe();
        return NodeCorrector.replace(be, space + wasWere);
    }

    static NodeMatch perfectToSimple(Node predicate, NodeMatch match, Node have) {
        Node subj = predicate.findSingleDependent("[nc]subj(:pass)?");
        if (subj == null) {
            return null;
        }
        Node not = EnglishTreePatterns.findNegation(predicate);
        if (predicate.hasPos("VBN") && predicate.findDependents("aux.*").stream().noneMatch(n -> n.hasLemma("be") && !aposSMisparsedAsCop.matches((Node)n))) {
            return TenseChanges.auxToFinite(match, not, have, predicate, true, false);
        }
        Node been = predicate.findSingleDependent("cop|aux:pass");
        if (been != null && been.hasForm("been")) {
            String wasWere = VerbInflectionNumber.from(predicate, subj).past(true).inflectBe();
            if (not != null) {
                return match.withCorrector(NodeCorrector.replace(have, wasWere));
            }
            return match.withCorrector(NodeCorrector.removeNode(have).join(NodeCorrector.replace(been, wasWere)));
        }
        return null;
    }

    static NodeMatch simpleToPerfect(Node predicate, NodeMatch match) {
        Node subj = EnglishTreePatterns.findSubject(predicate);
        if (subj == null) {
            return null;
        }
        if (withPossiblyMisparsedAux.matches(predicate)) {
            return null;
        }
        String haveForm = VerbInflectionNumber.from(predicate, subj).past(false).inflectHave();
        Node aux = predicate.findSingleDependent("cop|aux|aux:pass");
        boolean beClause = predicate.hasLemma("be") && !predicate.hasForm("been");
        Node anchor = TenseChanges.findAuxInsertionAnchor(aux == null || beClause ? predicate : aux, subj);
        boolean mayContract = ToggleContraction.afterSubjectOrExpletive.matches(anchor);
        Node not = EnglishTreePatterns.findNegation(predicate);
        boolean suggestFull = EnglishParameters.suggestFullForms.matches(anchor);
        boolean suggestContracted = EnglishParameters.suggestContractedForms.matches(anchor);
        NodeCorrector predicateToPastParticiple = NodeCorrector.inflect(predicate, "VB", "VBN");
        if (anchor.hasLemma("be") && !anchor.hasForm("been")) {
            if (not != null && not == anchor.nextNode()) {
                String replacement = haveForm + (not.hasForm("not") ? " " : "") + not.form() + " been";
                return match.withCorrector(NodeCorrector.replaceNodes(anchor, not, replacement));
            }
            if (suggestFull || !mayContract) {
                String replacement = " " + haveForm + " been";
                return match.withCorrector(NodeCorrector.replace(anchor, replacement));
            }
            if (suggestContracted) {
                String replacement = "\u2019" + haveForm.substring(2) + " been";
                Node prev = anchor.neighbor(-1);
                return match.withCorrector(NodeCorrector.insertAfter(prev, replacement).join(NodeCorrector.removeNode(anchor))).withReportedNodes(prev, anchor);
            }
        }
        if (anchor.hasLemma("do")) {
            match = match.withReportedNodes(anchor, predicate);
            if (not != null && not == anchor.nextNode()) {
                String replacement = haveForm + (not.hasForm("not") ? " " : "") + not.form();
                return match.withCorrector(NodeCorrector.replaceNodes(anchor, not, replacement).join(predicateToPastParticiple));
            }
            if (suggestFull || !mayContract) {
                return match.withCorrector(NodeCorrector.replace(anchor, haveForm).join(predicateToPastParticiple));
            }
            if (suggestContracted) {
                String replacement = "\u2019" + haveForm.substring(2);
                Node prev = anchor.neighbor(-1);
                return match.withCorrector(NodeCorrector.insertAfter(prev, replacement).join(NodeCorrector.removeNode(anchor)).join(predicateToPastParticiple));
            }
        }
        ArrayList<NodeCorrector> verbForms = new ArrayList<NodeCorrector>();
        boolean continuous = predicate.hasLemma("sit|stand|lie|lean|hunch|kneel|crouch|go|walk|drive|sleep|live|work|store|expand|run");
        verbForms.add(NodeCorrector.inflect(predicate, "VB.*", "VBN"));
        if (continuous && anchor == predicate) {
            verbForms.add(NodeCorrector.insertBefore(anchor, "been ").join(NodeCorrector.inflect(predicate, "VB.*", "VBG")));
        }
        if (suggestFull || !mayContract) {
            return match.withCorrectors(verbForms.stream().map(g -> NodeCorrector.insertBefore(anchor, haveForm + " ").join((NodeCorrector)g)).toList());
        }
        if (suggestContracted) {
            Node prev = anchor.neighbor(-1);
            return match.withCorrectors(verbForms.stream().map(g -> g.join(NodeCorrector.insertAfter(prev, "\u2019" + haveForm.substring(2) + " "))).toList()).withReportedNodes(prev, anchor, predicate);
        }
        return null;
    }

    static NodeMatch simpleToProgressive(Node predicate, NodeMatch match) {
        Node subj = EnglishTreePatterns.findSubject(predicate);
        if (subj == null) {
            return null;
        }
        boolean past = predicate.hasPos("VBD") && !predicate.hasDependent("cop|aux|aux:pass");
        String beForm = past ? VerbInflectionNumber.from(predicate, subj).past(true).inflectBe() : VerbInflectionNumber.from(predicate, subj).past(false).inflectBe();
        return match.withCorrector(NodeCorrector.insertBefore(predicate, beForm + " ").join(NodeCorrector.inflect(predicate, "VB.*", "VBG")));
    }

    static NodeMatch auxToFinite(NodeMatch match, Node not, Node aux, Node next, boolean toPast, boolean includeConjClauses) {
        NodeCorrector verbsToFinite;
        boolean notAfterAux;
        Node predicate = Objects.requireNonNull(aux.head());
        Node subject = EnglishTreePatterns.findSubject(predicate);
        VerbInflectionNumber inflectionNumber = VerbInflectionNumber.from(predicate, subject);
        VerbInflectionNumber.Inflector inflector = inflectionNumber.past(toPast);
        boolean bl = notAfterAux = not != null && not == aux.nextNode();
        if (next == predicate && (not != null || Questions.question.matches(predicate))) {
            if (notAfterAux && predicate.hasLemma("be")) {
                return match.withCorrector(NodeCorrector.replaceNodes(aux, not, "").join(NodeCorrector.replace(predicate, inflector.inflectBe() + " no")));
            }
            return match.withCorrector(NodeCorrector.inflect(next, "VB.*", "VB").join(NodeCorrector.replace(aux, inflector.inflectDo())));
        }
        boolean contractAm = !toPast && inflectionNumber == VerbInflectionNumber.I && subject != null && aux.prevNode() == subject && next.hasLemma("be");
        NodeCorrector nodeCorrector = verbsToFinite = notAfterAux && contractAm ? null : inflector.inflectFinite(next);
        if (includeConjClauses) {
            for (Node conj : next.findDependents("conj")) {
                if (conj.hasDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl|cop|aux|aux:pass") || !conj.hasPos("VB.*")) break;
                NodeCorrector another = inflector.inflectFinite(conj);
                verbsToFinite = verbsToFinite == null ? another : verbsToFinite.join(another);
            }
        }
        if (notAfterAux) {
            if (contractAm) {
                return match.withCorrector(NodeCorrector.replaceNodes(subject, not, "I\u2019m not").join(NodeCorrector.replace(next, "")).join(verbsToFinite));
            }
            return match.withCorrector(NodeCorrector.replaceNodes(aux, not, "").join(verbsToFinite).join(NodeCorrector.insertAfter(next, (not.hasForm("not") ? " " : "") + not.form())));
        }
        return match.withCorrector(NodeCorrector.removeNode(aux).join(verbsToFinite));
    }

    @Nullable
    static NodeMatch willToPresent(Node predicate, NodeMatch match) {
        Node not = EnglishTreePatterns.findNegation(predicate);
        List<Node> auxVerbs = predicate.findDependents("cop|aux|aux:pass");
        for (int i = 0; i < auxVerbs.size(); ++i) {
            Node aux = auxVerbs.get(i);
            if (!aux.hasLemma("will")) continue;
            Node next = i + 1 < auxVerbs.size() ? auxVerbs.get(i + 1) : predicate;
            return TenseChanges.auxToFinite(match, not, aux, next, false, true);
        }
        return match;
    }

    @Nullable
    static NodeMatch presentToGoingTo(Node predicate, NodeMatch match) {
        Node subj = EnglishTreePatterns.findSubject(predicate);
        if (subj == null) {
            return null;
        }
        String beForm = VerbInflectionNumber.from(predicate, subj).past(false).inflectBe();
        Node anchor = TenseChanges.findAuxInsertionAnchor(predicate, subj);
        boolean mayContract = ToggleContraction.afterSubjectOrExpletive.matches(anchor);
        ArrayList<NodeCorrector> addGoingTo = new ArrayList<NodeCorrector>();
        if (!mayContract || EnglishParameters.suggestFullForms.matches(subj)) {
            addGoingTo.add(NodeCorrector.insertBefore(anchor, beForm + " going to "));
            match = match.withReportedNode(anchor);
        }
        if (mayContract && Set.of("am", "re", "is").contains(beForm) && EnglishParameters.suggestContractedForms.matches(subj)) {
            Node prev = anchor.neighbor(-1);
            addGoingTo.add(NodeCorrector.insertAfter(prev, "\u2019" + beForm.substring(1) + " going to"));
            match = match.withReportedNodes(prev, anchor);
        }
        match = match.withReportedNode(predicate);
        Node have = TenseChanges.findPerfectHave(predicate);
        if (have != null) {
            return match.withCorrectors(addGoingTo.stream().map(g -> g.join(NodeCorrector.removeNode(have)).join(NodeCorrector.inflect(predicate, "VBN", "VB"))).toList()).withReportedNode(have);
        }
        return match.withCorrectors(addGoingTo.stream().map(g -> g.join(NodeCorrector.inflect(predicate, "VB[ZP]", "VB"))).toList());
    }

    @Nullable
    static NodeMatch toFuture(Node predicate, NodeMatch match) {
        Node anchor;
        boolean mayContract;
        Node not;
        boolean replaceAux;
        Node subj = EnglishTreePatterns.findSubject(predicate);
        if (subj == null) {
            return null;
        }
        NodeCorrector toBaseForm = predicate.hasPos("VB.+") ? NodeCorrector.inflect(predicate, "VB.*", "VB") : null;
        Node aux = EnglishTreePatterns.findFirstCopAuxInner(predicate);
        boolean bl = replaceAux = aux != null && aux.hasLemma("do|have");
        if (replaceAux && (not = EnglishTreePatterns.findNegation(predicate)) != null) {
            if (!not.hasForm("not")) {
                return match.withCorrector(NodeCorrector.replace(aux, "wo").join(toBaseForm));
            }
            if (EnglishParameters.suggestContractedForms.matches(subj)) {
                return match.withCorrector(NodeCorrector.replaceNodes(aux, not, "won\u2019t"));
            }
        }
        if (!(mayContract = ToggleContraction.afterSubjectOrExpletive.matches(anchor = replaceAux ? aux : TenseChanges.findAuxInsertionAnchor(predicate, subj))) || EnglishParameters.suggestFullForms.matches(subj)) {
            match = match.withCorrector((replaceAux ? NodeCorrector.replace(anchor, "will") : NodeCorrector.insertBefore(anchor, "will ")).join(toBaseForm));
        }
        if (mayContract && EnglishParameters.suggestContractedForms.matches(subj)) {
            Node prev = anchor.neighbor(-1);
            match = match.withCorrector((replaceAux ? NodeCorrector.replaceNodes(prev, aux, prev.form() + "\u2019ll") : NodeCorrector.insertAfter(prev, "\u2019ll ")).join(toBaseForm)).withReportedNodes(prev, replaceAux ? aux : null, toBaseForm != null ? predicate : null);
        }
        return match;
    }

    @NotNull
    private static Node findAuxInsertionAnchor(Node predicate, Node subj) {
        return StreamEx.of(predicate.findDependents("advmod")).findFirst(n -> n.isBefore(predicate) && n.isAfter(subj)).orElse(predicate);
    }
}

