/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.common.AsciiApproximations;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FormattingIssues;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.HyphenVsDash;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.VariantDifferences;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;

class TypographyRules {
    private static final String USE_SMART_APOSTROPHE = "Use a smart apostrophe";
    private static final String NBSP_IBAN = "For better readability, split the IBAN by non-breaking spaces after every fourth character";
    private static final String NUMBER_GROUPING = "Consider dividing the number into groups of three digits for better readability";
    private static final String NBSP_NUMBER_UNIT = "There should be a space between the number and the unit of measurement";

    TypographyRules() {
    }

    static List<Rule> rules() {
        return StreamEx.of((Object[])new Rule[]{new Rule.PatternRule("Typography.SMART_APOSTROPHE", "Use curly apostrophes", "Curly or \u201csmart\u201d apostrophes are preferred over their straight-shaped counterparts in professional publishing and print materials.", "https://en.wikipedia.org/wiki/Apostrophe#Unicode", TypographyRules.smartApostrophe(), new Example[]{new Example("<b>It's</b> here.", USE_SMART_APOSTROPHE, "<b>It\u2019s</b> here.")}){

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return client.supportsAutoFixes() && client.suggestCurlyPunctuationByDefault();
            }
        }.enableInFlatTrees(), new AsciiApproximations(Language.ENGLISH, "Replace typographic approximations with Unicode characters", "Some Unicode characters are hard to enter on most keyboards,\nand people often enter sequences of plain characters instead.\n", "https://en.wikipedia.org/wiki/Typographic_approximation", "Would you like to insert '%s'?"), new Rule.PatternRule("Typography.IBAN_FORMATTING", "Group the characters in IBAN", "IBANs are traditionally expressed in groups of four characters separated by spaces.", "https://en.wikipedia.org/wiki/International_Bank_Account_Number", FormattingIssues.ibanFormatting(NBSP_IBAN), new Example("IBAN <b>DE89123447624758123400</b>", NBSP_IBAN, "IBAN <b>DE89\u00a01234\u00a04762\u00a04758\u00a01234\u00a000</b>")), new Rule.PatternRule("Typography.NUMBER_FORMATTING", "Format large numbers", "To improve readability, use a delimiter to break down large numbers into groups of three digits.", null, TypographyRules.numberFormatting(), new Example("We have <b>10000</b> people (use comma)", List.of(NUMBER_GROUPING), List.of("We have <b>10,000</b> people (use comma)"), Map.of(EnglishParameters.NUMBER_FORMATTING, "comma")), new Example("We have <b>10000</b> people (use narrow non-breaking space)", List.of(NUMBER_GROUPING), List.of("We have <b>10\u202f000</b> people (use narrow non-breaking space)"), Map.of(EnglishParameters.NUMBER_FORMATTING, "narrowNbsp"))), new Rule.PatternRule("Typography.NUMBERS_WITH_UNITS", "Add a space between number and unit of measurement", "Generally, there should be a space between the number and the unit of measurement.", "https://ukma.org.uk/style-guide/", TreeMigration.revise("try to delete 'tree-en' andNots", FormattingIssues.spacesAfterNumbers(List.of("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])"), NBSP_NUMBER_UNIT, false).noFormCaseSensitive("(\\d\\d)?\\d0s|35S|\\d+cc").andNot(NodePattern.N.label("PRODUCT|LOCATION").andNot(NodePattern.N.formCaseSensitive("\\d+N").label("PRODUCT"))).andNot(NodePattern.N.form("\\d+s").withDependent("det")).andNot(NodePattern.N.directlyBefore(NodePattern.N.formCaseSensitive("K").andOr(NodePattern.N.withHeadRelation("nummod"), NodePattern.N.beforeHead()))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("[\u00a3$]")).directlyBefore(NodePattern.N.formCaseSensitive("[Km]"))).andNot(NodePattern.N.formCaseSensitive("\\d.+[Km]").withHeadRelation("nummod")).andNot(NodePattern.N.formCaseSensitive("\\d+S").andOr(NodePattern.N.withHead("nmod", NodePattern.N.lemma("coefficient")), NodePattern.N.before(NodePattern.N.lemma("ribosome")))).andNot(NodePattern.N.inFormSequence(1, "Robo", "3", "T")).andNot(NodePattern.N.withHeadRelation("nummod|compound").directlyBefore(NodePattern.N.formCaseSensitive("M").withHeadRelation("compound|nummod"))).andNot(NodePattern.N.formCaseSensitive("\\d+(\\.\\d+)?MM?").directlyAfter(NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]"))).andNot(NodePattern.N.form("\\d+(\\.\\d+)?").directlyAfter(NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]")).directlyBefore(NodePattern.N.formCaseSensitive("MM?"))).andNot(NodePattern.N.formCaseSensitive("\\d\\d?PM")).andNot(NodePattern.or(NodePattern.N.withHead(Semantics.addressWord), CommonPatterns.possiblySkipDown("appos", Semantics.addressWord)))), new Example("In this experiment, <b>2mg</b> of the extract was dissolved in water.", NBSP_NUMBER_UNIT, "In this experiment, <b>2\u00a0mg</b> of the extract was dissolved in water.")), VariantDifferences.variantQuotePunctuation()}).append(HyphenVsDash.typographyRules()).toList();
    }

    private static NodePattern smartApostrophe() {
        return NodePattern.or(NodePattern.N.form("'.+").noSpaceBefore().withHeadRelation("cop|aux|aux:pass"), NodePattern.N.form("'s?").noSpaceBefore().withHead("case", NodePattern.N.noHeadRelation("cop|aux|aux:pass")), NodePattern.N.inFormSequence(1, "let", "'s").noSpaceBefore(), NodePattern.N.form("o'clock|n't")).includeIntoReport().andOptionally(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.includeIntoReport())).correct(NodeCorrector.regexReplace("(.*)'(.*)", "$1\u2019$2").batchCapable("UseSmartApostrophe")).message(USE_SMART_APOSTROPHE).and((node, match) -> match.enableAutoFix());
    }

    private static NodePattern numberFormatting() {
        NodePattern number = NodePattern.N.form("[1-9]\\d{4,}");
        NodePattern possiblyAddress = NodePattern.or(NodePattern.N.withHeadRelation("list|fixed|<unk>|obl:tmod"), CommonPatterns.possiblySkipDown("appos", NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION|MISC")));
        NodePattern documentName = NodePattern.N.form("no|number|data|sample|passport|document|certificate|registration");
        NodePattern possiblyDocumentNumber = NodePattern.or(NodePattern.N.inPhrase(documentName), NodePattern.ROOT.withDependent("nsubj", documentName));
        return number.andNot(NodePattern.or(NodePattern.N.withHead(possiblyAddress), CommonPatterns.possiblySkipDown(".*", possiblyAddress))).andNot(CommonPatterns.skipConjUp(NodePattern.N.withHead("appos|parataxis", NodePattern.or(NodePattern.N.pos("NNP"), NodePattern.N.noPos(), NodePattern.N.withHeadRelation("parataxis"))))).andNot(NodePattern.N.withHeadRelation("nummod|nmod").noDependents("case").afterHead()).andNot(NodePattern.N.withHeadRelation("appos").directlyAfterHead()).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)).andNot(possiblyDocumentNumber).and((node, match) -> {
            String formattingParameter = EnglishParameters.NUMBER_FORMATTING.getValue(node.tree());
            DecimalFormat df = new DecimalFormat("#,###");
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setGroupingSeparator(formattingParameter.equals("narrowNbsp") ? (char)'\u202f' : (char)',');
            df.setDecimalFormatSymbols(symbols);
            BigInteger numberParsed = new BigInteger(node.form());
            String formatted = df.format(numberParsed);
            return match.withCorrector(NodeCorrector.replace(node, formatted));
        }).message(NUMBER_GROUPING);
    }
}

