/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.AdverbAdjectiveConfusion;
import ai.grazie.rules.en.ComparativeSuperlative;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.languagetool.tools.StringTools;

class WordOrder {
    static final NodePattern headlessWhCopulaClause = Questions.whWord.withHead("i?obj|obl", NodePattern.N.markAs("Head"));
    private static final String A_BIT_MSG = "The position of 'a bit' seems incorrect";
    private static final String GENERAL_MSG = "The position of the adverb seems incorrect";
    private static final String INVERSION_MESSAGE = "In embedded questions, subjects go before verbs";
    private static final String INCORRECT_HAVE_QUESTION_MESSAGE = "Using 'have' as the main verb in questions might seem too formal";
    private static final String PARTICLE_PRONOUN_MSG = "Pronouns should go between phrasal verb parts";
    static final NodePattern topLevelInvertedQuestion = NodePattern.ROOT.and(CommonPatterns.withQuestionMark).andOr(CommonPatterns.firstWord.and(Questions.whWord).markAs("Wh"), NodePattern.N.withDependent(".*", CommonPatterns.firstPhrase.and(Questions.whPhrase).markAs("Wh"))).and(NodePattern.markedNodeMatches("Wh", NodePattern.or(NodePattern.N.withNextSibling(NodePattern.N.beforeHead().withHeadRelation("nsubj.*|expl").markAs("Subj")), NodePattern.N.directlyBefore(NodePattern.N.beforeHead().withHeadRelation("nsubj.*|expl").markAs("Subj"))))).and(NodePattern.markedNodeMatches("Subj", NodePattern.not(Questions.whPhrase).andOr(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("cop|aux|aux:pass").noForm("be").markAs("Aux")), NodePattern.N.withHead(NodePattern.N.noLemma("have").noDependents("cop|aux|aux:pass")))));
    private static final NodePattern withNmodMisparsedAsObl = NodePattern.N.withDependent("obl", NodePattern.N.inFormSequence(2, "at", "a", "time"));

    WordOrder() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Grammar.SUBJECT_VERB_INVERSION", "Subject-verb inversion", "In top-level questions, the verb should be placed before the subject.\nIn embedded questions, the subject goes before the verb.\nUsing 'have' as the main verb in questions might seem too formal.\n", "https://en.wikipedia.org/wiki/Subject\u2013auxiliary_inversion", WordOrder.inversion(), new Example("I don\u2019t quite understand what <b>does it mean</b>", INVERSION_MESSAGE, "I don\u2019t quite understand what <b>it means</b>"), new Example("<b>Have you</b> a cat?", INCORRECT_HAVE_QUESTION_MESSAGE, "<b>Do</b> you have a cat?", "Have you <b>got</b> a cat?")).honorCrazyParses(), new Rule.PatternRule("Grammar.ADVERB_WORD_ORDER", "Adverb placed incorrectly", "Report some adverbs and adverbial phrases placed incorrectly in the sentence.", "https://faculty.washington.edu/marynell/grammar/AdverbPl.html", NodePattern.or(WordOrder.adverbPattern(), WordOrder.aBit(), WordOrder.veryMuch(), WordOrder.more(), WordOrder.adverbBeforeDirectObject(), WordOrder.drunkDrive()), new Example("Isn\u2019t he happy <b>always</b>?", GENERAL_MSG, "Isn\u2019t he <b>always</b> happy?"), new Example("Fix <b>a bit</b> rendering.", A_BIT_MSG, "Fix rendering <b>a bit</b>.", "Fix <b>a bit of</b> rendering.")).honorCrazyParses(), new Rule.PatternRule("Grammar.UNEXPECTED_WORD_ORDER", "Word order issues", "Report cases of unusual or non-standard word order.", "https://langeek.co/en/grammar/course/262/word-order", NodePattern.or(WordOrder.unexpectedSubjectPosition(), WordOrder.particleBeforePronounObject()), new Example("Are <b>ready they</b>?", "Unexpected word order", "Are <b>they ready</b>?"), new Example("I\u2019ve decided to throw <b>out them</b>.", PARTICLE_PRONOUN_MSG, "I\u2019ve decided to throw <b>them out</b>.")).honorCrazyParses());
    }

    private static NodePattern particleBeforePronounObject() {
        return NodePattern.N.withHeadRelation("compound:prt").directlyBefore(EnglishTreePatterns.pronounToPlaceBeforeParticle.withHeadRelation("obj")).andNot(NodePattern.N.inFormSequence(1, "take", "on", "me")).message(PARTICLE_PRONOUN_MSG).and((prt, match) -> {
            Node pronoun = prt.neighbor(1);
            return match.withCorrector(NodeCorrector.replaceNodes(prt, pronoun, pronoun.form() + " " + prt.form()));
        });
    }

    private static NodePattern adverbPattern() {
        NodePattern adverb = NodePattern.N.pos("RB").markAs("adverb").includeIntoReport().noDependents("conj|advcl|cc|case|mark").andNot(CommonPatterns.insideQuotes).andNot(CommonPatterns.beforeSkipping(CommonPatterns.comma, NodePattern.N.form("if").withHead("mark", NodePattern.N.pos("RB.*"))));
        NodePattern subjectAfterAux = NodePattern.N.markAs("subj").withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.before("subj")));
        NodePattern afterSecondAux = NodePattern.N.withDependent("cop|aux|aux:pass", SubjectVerbAgreement.secondaryAux().before("adverb"));
        NodePattern startPosition = NodePattern.N.beforeHead().withHead("advmod", NodePattern.N.andOr(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.after("adverb").andNot(subjectAfterAux)), NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").withHeadRelation("conj").and(afterSecondAux)).noDependents(Questions.whPhrase.after("adverb").beforeHead())).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.withHeadRelation("advmod"), NodePattern.N.pos("VBG"), CommonPatterns.colon)));
        NodePattern beforeIn = NodePattern.N.directlyBefore(NodePattern.N.lemma("in"));
        NodePattern beforeTo = NodePattern.N.directlyBefore(NodePattern.N.lemma("to").withHead("mark", NodePattern.N.withHeadRelation("[xc]comp")));
        NodePattern beforeEnough = NodePattern.N.directlyBefore(NodePattern.N.form("enough"));
        NodePattern afterHead = NodePattern.N.afterHead();
        NodePattern repeatedUsage = NodePattern.custom(adv -> adv.tree().nodes().stream().anyMatch(n -> n != adv && n.form().equals(adv.form()) && afterHead.matches((Node)n)));
        NodePattern advAttachingAmbiguity = NodePattern.N.withPhraseEnd(NodePattern.N.alreadyMarkedAs("adverb").directlyBefore(NodePattern.not(NodePattern.N.withHeadRelation("punct"))));
        NodePattern secondClauseAfter = NodePattern.N.withHead("advmod", NodePattern.or(NodePattern.N.withDependent("parataxis|advcl", NodePattern.N.withDependent("advmod|mark", NodePattern.N.form("so")).after("adverb")), NodePattern.N.withDependent("parataxis", NodePattern.N.withDependent("advmod", NodePattern.N.directlyAfter("adverb"))), NodePattern.N.withDependent("conj", EnglishTreePatterns.verbalClause.withDependent("cc").after("adverb"))));
        NodePattern clausalComplement = NodePattern.N.withHead("advmod", NodePattern.N.lemma("be").withDependent("[xc]comp", EnglishTreePatterns.withToMark.after("adverb")));
        NodePattern endPosition = NodePattern.N.withHead("advmod", NodePattern.N.before("adverb").markAs("AdvHead").andNot(EnglishTreePatterns.withSyntacticExpletive()).noLemma("say").andNot(advAttachingAmbiguity).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")).andNot(repeatedUsage).noDependents("advmod").noDependents("punct", CommonPatterns.comma.before("adverb"));
        NodePattern middlePosition = NodePattern.N.withHead("advmod", NodePattern.N.after("adverb").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.before("adverb")).withDependent("cop|aux|aux:pass").noDependents("advmod", NodePattern.N.lemma("not")).andNot(NodePattern.N.pos("RB").noDependents("aux.*")).and(afterSecondAux.andNot(NodePattern.N.withDependent("aux", NodePattern.N.form("would|might|may").directlyBefore(NodePattern.N.lemma("have"))))));
        NodePattern beforeBe = NodePattern.N.withHead(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.form("be|being").after("adverb")));
        NodePattern beforeComma = NodePattern.N.directlyBefore(CommonPatterns.comma);
        NodePattern negated = NodePattern.N.withHead(EnglishTreePatterns.negated);
        NodePattern beforeDependentObl = NodePattern.N.withDependent("obl", NodePattern.N.afterHead());
        return adverb.andOr(NodePattern.N.form("always|seldom").andNot(beforeBe).andNot(NodePattern.N.form("always").withNextSiblingIncludingOtherSide(NodePattern.N.withHeadRelation("conj").afterHead().noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").withDependent("cc", NodePattern.N.form("but|or")).withDependent("advmod"))).andNot(CommonPatterns.phraseEndsWithComma.withDependent("advmod")).andOr(startPosition, middlePosition, endPosition.and(negated)), NodePattern.N.form("rarely").andNot(beforeBe).andNot(beforeEnough).andOr(startPosition.andNot(beforeComma), middlePosition, endPosition.andNot(secondClauseAfter).andNot(clausalComplement).andNot(CommonPatterns.lastWord)), NodePattern.N.form("never").andNot(beforeIn).andNot(beforeTo).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("so"))).andNot(NodePattern.N.inFormSequence(0, "never", "you", "mind")).andOr(startPosition, middlePosition, endPosition), NodePattern.N.form("hardly").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("a|any.*"))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("advcl"))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("aux", NodePattern.N.pos("MD")))).andNot(NodePattern.N.withHead(negated)).andNot(NodePattern.N.withHead(NodePattern.N.lemma("speak").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("of"))))).andOr(startPosition, middlePosition, endPosition), NodePattern.N.form("ever").andNot(NodePattern.N.directlyBefore(NodePattern.N.lemma("since"))).andNot(NodePattern.N.directlyAfter(Questions.whWord)).and(startPosition), NodePattern.N.form("often").andNot(beforeEnough).andNot(negated).andNot(beforeIn).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("more"))).andOr(middlePosition, endPosition.andNot(clausalComplement).andNot(CommonPatterns.lastWord)).andNot(secondClauseAfter).andNot(beforeDependentObl), NodePattern.N.form("sometimes").andNot(negated).andOr(middlePosition, endPosition.withNextSibling(NodePattern.N.withHeadRelation("advcl|xcomp|obl"))), NodePattern.N.form("usually").andNot(beforeTo).andOr(middlePosition, endPosition)).andNot(NodePattern.N.withHead(EnglishTreePatterns.severalSubjects)).message(GENERAL_MSG).and(WordOrder.fixAdverbPosition());
    }

    private static NodePattern drunkDrive() {
        return NodePattern.N.form("drunk").andOr(NodePattern.N.directlyBeforeHead().withHead("advmod|amod", EnglishTreePatterns.clause.lemma("drive").markAs("Drive")), NodePattern.ROOT.withDependent("advcl", NodePattern.N.lemma("drive").directlyAfterHead().markAs("Drive"))).message("Did you mean '$Drive drunk'?").correct(NodeCorrector.replace("").join(NodeCorrector.insertAfter(NodePointer.neighbor(1), " drunk")));
    }

    private static NodePattern aBit() {
        return EnglishTreePatterns.aBit.markAs("Bit").reportEverythingTouched().directlyBefore(NodePattern.or(NodePattern.N.noPos("JJR.*|RBR.*|VBG|JJ"), NodePattern.N.form("other")).inPhrase(NodePattern.N.after("Bit").withHead("obj", NodePattern.N.before("Bit")).markAs("Obj"))).andNot(NodePattern.N.withHead("compound", NodePattern.N.potentialLemma("mask"))).message(A_BIT_MSG).and((bit, match) -> {
            Node a = Objects.requireNonNull(bit.prevNode());
            if (bit.phraseStart().isBefore(a)) {
                return null;
            }
            NodeCorrector remove = NodeCorrector.replaceNodes(a, bit, "");
            NodeCorrector insert = NodeCorrector.insertAfter(match.getMarkedNode("Obj").phraseEnd(), " " + a.form() + " " + bit.form());
            return match.withCorrector(insert.join(remove)).withCorrector(NodeCorrector.insertAfter(bit, " of"));
        });
    }

    private static NodePattern veryMuch() {
        return NodePattern.N.inFormSequence(1, "very", "much").reportEverythingTouched().andOr(NodePattern.N.beforeHead().withHead("amod|advmod", NodePattern.N.withHeadRelation("obj").markAs("Object")), NodePattern.N.afterHead().withNextSibling(NodePattern.N.withHeadRelation("obj").markAs("Object"))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "").join(NodeCorrector.insertAfter(NodePointer.marked("Object"), " very much"))).message("Consider placing 'very much' after the direct object");
    }

    private static NodePattern more() {
        NodePattern suggestMovingMore = NodePattern.N.pos("JJ").andNot(NodePattern.custom(node -> ComparativeSuperlative.hasSingleSyllable(node.lowForm()))).correct(NodeCorrector.replace(NodePointer.marked("More"), "").join(NodeCorrector.insertBefore("more ")));
        return NodePattern.N.form("more").markAs("More").afterHead().withHead("advmod|xcomp", NodePattern.N.withDependent("cop|aux|aux:pass").andOr(NegativePhrases.negativeClause.andOptionally(NodePattern.N.withDependent("aux").and(suggestMovingMore)).correct(NodeCorrector.replace(NodePointer.marked("More"), "anymore")).andOptionally(EnglishTreePatterns.negated.noDependents("aux").correct(NodeCorrector.replace(NodePointer.marked("More"), "").join(NodeCorrector.replace(NodePointer.marked("Negation"), "no longer")))), suggestMovingMore)).withOnlyDependents(NodePattern.N.form("right").directlyBeforeHead()).andNot(CommonPatterns.lastToken).message("The position of 'more' seems incorrect");
    }

    private static NodePattern adverbBeforeDirectObject() {
        NodePattern frequencyAdverb = Semantics.frequencyAdverb.andNot(NodePattern.N.inFormSequence(0, "always", "the", "truth|same")).andNot(NodePattern.N.form("always").withHead("advmod", NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?"))).and(WordOrder.fixAdverbPosition());
        NodePattern certaintyAdverb = NodePattern.N.form("definitely|surely|probably|certainly|possibly|already").and(WordOrder.fixAdverbPosition());
        NodePattern timePointsOverriding = NodePattern.N.form("later|once|yet").withPhraseEnd(NodePattern.N.markAs("Phrase End")).reportRangeTo("Phrase End").and(WordOrder.placeAdverbAfterObjectPhrase());
        NodePattern timePoints = Semantics.timePoints.and(WordOrder.placeAdverbAfterObjectPhrase()).andOptionally(WordOrder.placeAdverbBeforeSubject());
        NodePattern now = NodePattern.N.form("now").andOptionally(NodePattern.N.withHead("advmod", NodePattern.N.withDependent("nsubj")).and(WordOrder.fixAdverbPosition())).and(WordOrder.placeAdverbAfterObjectPhrase());
        NodePattern hardlyEver = NodePattern.N.inFormSequence(1, "hardly", "ever").withPhraseStart(NodePattern.N.markAs("Start")).reportRangeTo("Start").and(WordOrder.fixAdverbPosition());
        NodePattern modifiedAdverb = NodePattern.N.noDependents("case").andOr(NodePattern.N.withDependent("amod|advmod", NodePattern.not(NodePattern.N.directlyAfter(EnglishTreePatterns.anyPunct))), NodePattern.N.withDependent("det", NodePattern.N.form("every"))).withPhraseStart(NodePattern.N.markAs("Start")).reportRangeTo("Start").and(WordOrder.placeAdverbAfterObjectPhrase());
        NodePattern even = NodePattern.N.form("even").and(WordOrder.fixAdverbPosition());
        NodePattern general = NodePattern.N.form(".{3,}ly").noForm("literally").anyPos().andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("any.*"))).andOptionally(NodePattern.N.withNextSibling(NodePattern.N.directlyAfter("Adv").pos("NNS?")).and(AdverbAdjectiveConfusion.fixClauseAdjToAdverb)).andOptionally(WordOrder.fixAdverbPosition().andNot(NodePattern.N.form("seriously").withHead("advmod", NodePattern.N.lemma("take")))).andOptionally(NodePattern.N.withNextSibling(NodePattern.N.noDependents("nmod", NodePattern.N.withDependent("case"))).and(WordOrder.placeAdverbAfterObjectPhrase()));
        NodePattern simpleObject = CommonPatterns.letterWord.withHeadRelation("obj").withPhraseEnd(NodePattern.N.markAs("ObjectEnd")).noDependents("punct").noDependents("case", NodePattern.N.beforeHead()).andNot(EnglishTreePatterns.clause).andNot(CommonPatterns.possiblySkipDown("nmod", NodePattern.N.withDependent("(advcl|acl):relcl|acl|appos|conj").afterHead())).andNot(NodePattern.N.withDependent("amod").withDependent("det", NodePattern.N.form("the")));
        NodePattern verbalHead = EnglishTreePatterns.verbalClause.markAs("Verb").noDependents("aux:pass");
        NodePattern withRatherThanAmod = NodePattern.N.withDependent("amod", NodePattern.N.withDependent("conj", NodePattern.N.withDependent("cc", NodePattern.N.inFormSequence(0, "rather", "than"))));
        return NodePattern.or(NodePattern.N.markAs("Adv").withHead("advmod|obl:tmod", verbalHead.noDependents("parataxis", NodePattern.N.after("Adv"))).withNextSibling(simpleObject.andNot(withRatherThanAmod)).andOr(hardlyEver, modifiedAdverb, frequencyAdverb, certaintyAdverb, now, timePointsOverriding, timePoints, general, even), NodePattern.N.withHead("compound", simpleObject.noDependents("det").withHead(verbalHead)).and(timePoints), NodePattern.N.withHead("advmod", simpleObject.noPos("RP").withDependent("det").withHead(verbalHead.noDependents("aux", NodePattern.N.pos("MD")).andNot(EnglishTreePatterns.withToMark))).and(even)).after("Verb").includeIntoReport().message("An adverb may not occur between a verb and its direct object");
    }

    private static NodePattern fixAdverbPosition() {
        return NodePattern.custom((adverb, match) -> {
            Node predicate = Objects.requireNonNull(adverb.head());
            if (predicate.hasHeadRelation("obj")) {
                predicate = Objects.requireNonNull(predicate.head());
            }
            if (EnglishTreePatterns.startsWithApostrophe.matches(predicate)) {
                return null;
            }
            Node target = ((StreamEx)EnglishTreePatterns.copAuxDependents(predicate).skip(1L)).findFirst().orElse(predicate.findDependents("case|compound|det").stream().findFirst().orElse(predicate));
            if (target == adverb.nextNode()) {
                return null;
            }
            if (predicate.isBefore(adverb)) {
                if (predicate.nextUntil(adverb).anyMatch(CommonPatterns.ellipsis::matches)) {
                    return null;
                }
            }
            NodeCorrector remove = NodeCorrector.replaceNodes(adverb.phraseStart(), adverb.phraseEnd(), "");
            String adverbPhraseNoComma = adverb.phraseText().replaceAll(",", "");
            NodeCorrector insert = NodeCorrector.insertBefore(target, StringTools.lowercaseFirstChar((String)adverbPhraseNoComma) + " ");
            return match.withCorrector(insert.join(remove));
        });
    }

    private static NodePattern placeAdverbAfterObjectPhrase() {
        return NodePattern.custom((adverb, match) -> {
            Node predicate = match.findMarkedNode("Verb");
            if (predicate == null) {
                return null;
            }
            Node object = predicate.findSingleDependent("obj");
            if (object == null) {
                return null;
            }
            if (withNmodMisparsedAsObl.matches(predicate)) {
                return match;
            }
            NodeCorrector remove = NodeCorrector.replaceNodes(adverb.phraseStart(), adverb.phraseEnd(), "");
            NodeCorrector insert = NodeCorrector.insertAfter(object.phraseEnd(), StringTools.lowercaseFirstChar((String)(" " + adverb.phraseText())));
            return match.withCorrector(insert.join(remove));
        });
    }

    private static NodePattern placeAdverbBeforeSubject() {
        return NodePattern.custom((adverb, match) -> {
            Node predicate = match.findMarkedNode("Verb");
            if (predicate == null) {
                return null;
            }
            Node subject = predicate.findSingleDependent("nsubj");
            if (subject == null) {
                return null;
            }
            NodeCorrector remove = NodeCorrector.replaceNodes(adverb.phraseStart(), adverb.phraseEnd(), "");
            NodeCorrector insert = NodeCorrector.insertBefore(subject.phraseStart(), StringTools.lowercaseFirstChar((String)(adverb.phraseText() + " ")));
            return match.withCorrector(insert.join(remove));
        });
    }

    private static NodePattern unexpectedSubjectPosition() {
        NodePattern subjAfterAdjectivePredicate = EnglishTreePatterns.adjInPredicativePosition.markAs("Pred").withDependent("cop", NodePattern.N.beforeHead()).withDependent("nsubj", NodePattern.N.anyPos().noDependents("conj").afterHead().andNot(EnglishTreePatterns.unlikelyToBeNoun).markAs("Subj").and(WordOrder.placeSubjectBeforePredicate())).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.not(NodePattern.N.alreadyMarkedAs("Subj")));
        NodePattern subjAfterExist = NodePattern.N.lemma("exist").markAs("Pred").noDependents("expl").andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.tHere)).correct(NodeCorrector.insertBefore("there ")).withDependent("nsubj", NodePattern.N.anyPos().afterHead().andOptionally(NodePattern.N.noDependents("acl:relcl").noDependents("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.withDependent("acl:relcl")).and(WordOrder.placeSubjectBeforePredicate())));
        return NodePattern.or(subjAfterAdjectivePredicate, subjAfterExist).noHeadRelation("conj").message("Unexpected word order");
    }

    private static NodePattern placeSubjectBeforePredicate() {
        return NodePattern.custom((subj, match) -> {
            Node predicate = match.getMarkedNode("Pred");
            NodeCorrector removeSubject = NodeCorrector.replaceNodes(subj.phraseStart(), subj.phraseEnd(), "");
            Node anchor = Questions.question.matches(predicate) ? predicate : predicate.findDependents("cop|aux|aux:pass").stream().findFirst().orElse(predicate);
            NodeCorrector insertSubjectBeforePredicate = NodeCorrector.insertBefore(anchor, StringTools.lowercaseFirstChar((String)(subj.phraseText() + " ")));
            return match.withCorrector(insertSubjectBeforePredicate.join(removeSubject));
        });
    }

    static NodePattern fixMissingAux() {
        return NodePattern.custom((predicate, match) -> {
            boolean highlightWh;
            Node subj = match.getMarkedNode("Subj");
            Node subjStart = subj.phraseStart();
            Node wh = match.findMarkedNode("Wh");
            boolean bl = highlightWh = wh != null && wh.allDependents().stream().noneMatch(n -> n.isAfter(wh));
            if (predicate.hasPos("VBG")) {
                String beForm = VerbInflectionNumber.from(predicate, subj).past(false).inflectBe();
                return match.withCorrector(NodeCorrector.insertBefore(subjStart, beForm + " ")).withReportedNode(highlightWh ? wh : subj);
            }
            NodeCorrector corrector = NodeCorrector.insertBefore(subjStart, VerbInflectionNumber.from(predicate, subj).past(false).inflectDo() + " ");
            if (!predicate.hasPos("VBP?")) {
                corrector = corrector.join(NodeCorrector.inflect(predicate, "VB.*", "VB"));
            }
            return match.withCorrector(corrector).withReportedNode(highlightWh ? wh : subj);
        });
    }

    private static NodePattern inversion() {
        NodePattern possiblyIntro = EnglishTreePatterns.imperativeVB.withHeadRelation("root|acl").trace("possiblyIntro: listen, what did I say to you?");
        NodePattern embedded = Questions.question.markAs("Predicate").withDependent("cop|aux|aux:pass", NodePattern.N.markAs("Aux").reportRangeTo("Predicate")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.after("Aux").andNot(Questions.whPhrase).markAs("Subj")).andOr(headlessWhCopulaClause, Questions.whWord.withHead("ccomp", NodePattern.N.markAs("Head").andNot(CommonPatterns.withQuestionMark)), NodePattern.N.withDependent(".*", Questions.whPhrase).and(NodePattern.markedNodeMatches("Aux", NodePattern.N.beforeHead())).andOr(CommonPatterns.possiblyConj(NodePattern.N.afterHead().withHead("acl|ccomp", NodePattern.N.anyPos().andNot(possiblyIntro).markAs("Head"))), NodePattern.N.withHead("parataxis", NodePattern.N.withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").markAs("Head")).andNot(CommonPatterns.beforeSkipping(CommonPatterns.comma, NodePattern.N.withHead("cop|aux|aux:pass", CommonPatterns.withQuestionMark.alreadyMarkedAs("Head")))).andNot(CommonPatterns.possiblySkipUp("parataxis", NodePattern.N.withDependent("punct", NodePattern.N.before("Aux")))))).and((predicate, match) -> {
            Node aux;
            Node head = match.getMarkedNode("Head");
            StreamEx<Node> between = (head.isBefore(predicate) ? head : predicate).nextUntil(head.isBefore(predicate) ? predicate : head);
            if (between.anyMatch(n -> EnglishTreePatterns.quotations.matches((Node)n) || n.hasForm(":"))) {
                return null;
            }
            Node next = (aux = match.getMarkedNode("Aux")).nextNode();
            boolean negated = EnglishTreePatterns.negation.matches(next);
            NodeCorrector removeAux = NodeCorrector.replaceNodes(aux, negated ? next : aux, "");
            if (aux.hasLemma("do") && !negated) {
                if (predicate.tagIndependently().hasPos("VB")) {
                    String targetPos = aux.hasForm("does") ? "VBZ" : (aux.hasForm("do") ? "VBP" : "VBD");
                    return match.withCorrector(removeAux.join(NodeCorrector.inflect(predicate, "VB.*", targetPos)));
                }
                return match.withCorrector(removeAux);
            }
            Node subjEnd = match.getMarkedNode("Subj").phraseEnd();
            return match.withCorrectors(WordOrder.prepareAuxMovement(aux).stream().map(v -> removeAux.join(NodeCorrector.insertAfter(subjEnd, " " + v))).toList());
        }).message(INVERSION_MESSAGE);
        NodePattern topLevel = topLevelInvertedQuestion.and(NodePattern.markedNodeMatches("Wh", NodePattern.N.noDependents("cop|aux|aux:pass"))).message("In top-level questions, the verb should be placed before the subject").andOr(NodePattern.N.noDependents("cop|aux|aux:pass").andNot(NodePattern.N.alreadyMarkedAs("Wh")).and(WordOrder.fixMissingAux()).trace("missing aux"), NodePattern.custom((predicate, match) -> {
            Node subjStart = match.getMarkedNode("Subj").phraseStart();
            Node aux = match.findMarkedNode("Aux");
            if (aux == null) {
                return null;
            }
            Node next = aux.nextNode();
            NodeCorrector removeAux = NodeCorrector.replaceNodes(aux, EnglishTreePatterns.negation.matches(next) ? next : aux, "");
            return match.withCorrectors(WordOrder.prepareAuxMovement(aux).stream().map(a -> removeAux.join(NodeCorrector.insertBefore(subjStart, a + " "))).toList());
        }).trace("misplaced aux"));
        NodePattern incorrectHaveQuestion = NodePattern.ROOT.lemma("have").and(CommonPatterns.withQuestionMark).noDependents("mark", NodePattern.N.form("if").beforeHead()).noDependents("aux").noDependents("ccomp", NodePattern.N.pos("VBD")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl|iobj", NodePattern.N.noPos("W.*").markAs("Subj")).andOr(CommonPatterns.firstWord.directlyBefore(NodePattern.N.alreadyMarkedAs("Subj")), NodePattern.N.withDependent(".*", Questions.whWord.beforeHead().noDependents("case").markAs("Question Word"))).andNot(NodePattern.N.withDependent("obj", NodePattern.N.withDependent("det", NodePattern.N.form("no")))).message(INCORRECT_HAVE_QUESTION_MESSAGE).and((node, match) -> {
            Node subj = match.getMarkedNode("Subj");
            String auxVerb = VerbInflectionNumber.inflectDo(node, subj);
            Node questionWord = match.findMarkedNode("Question Word");
            if (questionWord == null) {
                return match.withCorrector(NodeCorrector.replace(node, auxVerb).join(NodeCorrector.insertAfter(subj, " have"))).withCorrector(NodeCorrector.insertAfter(subj, " got"));
            }
            return match.withCorrector(NodeCorrector.insertAfter(questionWord, " " + auxVerb).join(NodeCorrector.replace(node, "have")));
        });
        return NodePattern.or(embedded, topLevel, incorrectHaveQuestion);
    }

    private static List<String> prepareAuxMovement(Node aux) {
        if (EnglishTreePatterns.negation.matches(aux.nextNode())) {
            return List.of(aux.tree().text().substring(aux.startOffset(), aux.neighbor(1).endOffset()));
        }
        return ToggleContraction.decontractVerb(aux);
    }
}

