/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.ru.PunctuationRules;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.Objects;

class PrepositionForm {
    private static final NodePattern prepCaseWithoutAcc = NodePattern.N.pos(".*:P2?($|:.*)").andNot(NodePattern.N.pos(".*:V($|:.*)"));
    private static final String consonant = "[\u0431\u0432\u0433\u0434\u0436\u0437\u0439\u043a\u043b\u043c\u043d\u043f\u0440\u0441\u0442\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044c]";
    private static final String xoList = "\u043b\u0435\u0432|\u043b\u0451\u0434|\u043b\u043e\u0431|\u043b\u043e\u0436\u044c|\u043c\u043e\u0445|\u0440\u043e\u0432|\u0440\u043e\u0436\u044c|\u0440\u043e\u0442";

    PrepositionForm() {
    }

    static NodePattern pattern() {
        return NodePattern.or(NodePattern.N.form("\u0431\u0435\u0437\u043e").directlyBefore(PunctuationRules.possiblyStartQuoted(NodePattern.not(NodePattern.N.lemma("\u0432\u0435\u0441\u044c|\u0432\u0441\u044f\u043a\u0438\u0439")))).message("\u00ab\u0431\u0435\u0437\u043e\u00bb \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0435\u0440\u0435\u0434 \u0441\u043b\u043e\u0432\u0430\u043c\u0438 \u00ab\u0432\u0441\u0435\u0433\u043e\u00bb, \u00ab\u0432\u0441\u044f\u043a\u043e\u0433\u043e\u00bb \u0438 \u0442.\u043f.").correct(NodeCorrector.replace("\u0431\u0435\u0437")), PrepositionForm.x_xo("\u0432", NodePattern.or(NodePattern.N.form("[\u0432\u0444][\u0431\u0432\u0433\u0434\u0436\u0437\u0439\u043a\u043b\u043c\u043d\u043f\u0440\u0441\u0442\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044c]\\p{L}+").andNot(CommonPatterns.upperCase), NodePattern.N.form("\u043c\u043d\u0435|\u0447\u0442\u043e|\u0441\u043d\u0435|\u0447\u0440\u0435\u0432\u0435|\u0432\u0435\u0441\u044c|\u0434\u0432\u043e\u0440\u044f\u043d\u0441\u0442\u0432\u0435|\u043c\u043d\u0435\u043d\u0438\u0438|\u043f\u043b\u043e\u0442\u0438|\u0441[\u043a\u0442]\u043e\u043b\u044c\u043a\u043e|\u0441\u0442\u043e|\u0446\u0432\u0435\u0442\u0435|\u0445\u0440\u0438\u0441\u0442\u0435|\u0449\u0438|\u0431\u043b\u0430\u0433\u043e|\u0437\u043b\u043e|\u0438\u0437\u0431\u0435\u0436\u0430\u043d\u0438\u0435|\u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435|\u0441\u043b\u0430\u0432\u0443|\u0441\u043f\u0430\u0441\u0435\u043d\u0438\u0435|\u043b\u044c\u043d\u0435|\u043b\u044c\u043d\u0443"), NodePattern.N.inFormSequence(0, "\u0433\u043b\u0430\u0432[\u0435\u0443]", "\u0443\u0433\u043b\u0430|\u0441\u0442\u043e\u043b\u0430"), NodePattern.N.lemma("\u043c\u043d\u043e\u0433\u043e\u0435?|\u043c\u043d\u043e\u0433\u0438\u0435|\u0432\u0435\u0441\u044c|\u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432.*"), NodePattern.N.lemma("\u043b\u0435\u0432|\u043b\u0451\u0434|\u043b\u043e\u0431|\u043b\u043e\u0436\u044c|\u043c\u043e\u0445|\u0440\u043e\u0432|\u0440\u043e\u0436\u044c|\u0440\u043e\u0442|\u0434\u0432\u043e\u0440|\u0434\u0432\u043e\u0440\u0435\u0446|\u043c\u0433\u043b\u0430|\u043c\u0440\u0430\u043a|\u0442\u044c\u043c\u0430").noForm(xoList)), NodePattern.or(NodePattern.N.form("-|\u0432\u0442"), NodePattern.N.lemma("\u043b\u044c\u0432\u043e\u0432(\u0441\u043a\u0438\u0439)?"), NodePattern.N.form("\u0438\u043c\u044f"), NodePattern.N.form("\u0433\u043b\u0430\u0432[\u0435\u0443]").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u0441\u0442\u043e\u043b\u0430|\u0443\u0433\u043b\u0430"))), NodePattern.N.inFormSequence(0, "\u0434\u043d\u0438", "\u0441\u043a\u043e\u0440\u0431.*|\u0441\u043e\u043c\u043d\u0435\u043d\u0438.*|\u0442\u044f\u0433\u043e\u0441\u0442.*"))), PrepositionForm.x_xo("\u0438\u0437", NodePattern.or(NodePattern.N.lemma(xoList), NodePattern.N.form("\u043b\u044c\u043d\u0430"), NodePattern.N.inFormSequence(0, "\u0434\u043d\u044f", "\u0432", "\u0434\u0435\u043d\u044c"), NodePattern.N.inFormSequence(0, "\u0432\u0441\u0435\u0445", "\u0441\u0438\u043b")), NodePattern.N.lemma("\u0432\u0435\u0441\u044c").andNot(NodePattern.N.inFormSequence(0, "\u0432\u0441\u0435\u0445", "\u0441\u0438\u043b"))), PrepositionForm.x_xo("\u043a", NodePattern.or(NodePattern.N.form("\u0432\u0441\u0435\u043c\u0443?|\u0432\u0441\u0435\u0439|\u0432\u0441\u044f\u043a.*|\u0432\u0441\u044f\u0447\u0435\u0441\u043a.*|\u0432\u0442\u043e\u0440\u043d\u0438\u043a\u0443|\u0432\u0442\u043e\u0440\u043e.*|\u0434\u043d\u0443|\u043c\u043d\u0435|\u043c\u043d\u043e\u0433(\u0438\u043c|\u043e\u043c\u0443)|\u0441\u043d\u0443|\u043b\u044c\u043d\u0443"), NodePattern.N.lemma(xoList), NodePattern.N.inFormSequence(2, "\u043d\u0435", "\u043a\u043e?", "\u0432\u0440\u0435\u043c\u0435\u043d\u0438|\u0434\u0432\u043e\u0440\u0443")), NodePattern.or(NodePattern.N.lemma("\u0434\u0432\u043e\u0440|\u0432\u043a\u043b\u0430\u0434(\u043a\u0430)?|\u0432\u043b\u0430\u0441\u0442\u044c|\u0432\u0440\u0435\u043c\u044f|\u0432\u0445\u043e\u0434.*|\u0432\u0447\u0435\u0440\u0430\u0448\u043d\u0438\u0439|\u0434\u0435\u043d\u044c|\u043b\u044c\u0432\u043e\u0432|\u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e").andNot(NodePattern.N.inFormSequence(2, "\u043d\u0435", "\u043a\u043e?", "\u0432\u0440\u0435\u043c\u0435\u043d\u0438|\u0434\u0432\u043e\u0440\u0443")), NodePattern.N.form("\u0432[\u0437\u0441\u0442].*|\u0448\u0432(\u0430\u043c|\u0443)").noForm("\u0432\u0441\u0435\u043c\u0443?|\u0432\u0441\u0435\u0439|\u0432\u0441\u044f\u043a.*|\u0432\u0441\u044f\u0447\u0435\u0441\u043a.*|\u0432\u0442\u043e\u0440\u043d\u0438\u043a.*|\u0432\u0442\u043e\u0440\u043e.*"))), PrepositionForm.x_xo("\u043d\u0430\u0434", NodePattern.or(NodePattern.N.form("\u043c\u043d\u043e[\u0439\u044e]|\u043b\u044c\u043d\u043e\u043c"), NodePattern.N.lemma(xoList).noForm(xoList)), NodePattern.N.lemma("\u0432\u0435\u0441\u044c")), PrepositionForm.o_ob_obo(), PrepositionForm.ot_oto(), PrepositionForm.x_xo("\u043f\u0435\u0440\u0435\u0434", NodePattern.N.form("\u043c\u043d\u043e[\u0439\u044e]|\u043b\u044c\u043d\u043e\u043c"), NodePattern.N.lemma(xoList).noForm(xoList)), PrepositionForm.x_xo("\u043f\u043e\u0434", NodePattern.or(NodePattern.N.form("\u043c\u043d\u043e[\u0439\u044e]|\u0447\u0442\u043e|\u043b\u044c\u043d\u043e\u043c"), NodePattern.N.lemma(xoList).noForm(xoList)), NodePattern.N.lemma("\u0432\u0435\u0441\u044c")), PrepositionForm.x_xo("\u0441", NodePattern.or(NodePattern.N.form("[\u0441\u0437\u0448\u0436][\u0431\u0432\u0433\u0434\u0436\u0437\u0439\u043a\u043b\u043c\u043d\u043f\u0440\u0441\u0442\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044c].*").andNot(CommonPatterns.upperCase), NodePattern.N.form("\u0449.*"), NodePattern.N.form("\u0432\u043a\u0443\u0441\u043e\u043c|\u0432\u0441\u044f\u043a\u0438\u043c|\u0432\u0448\u043e\u0439|\u0434\u043d\u0430|\u043c\u043d\u043e[\u0439\u044e]|\u0442\u043e\u0432\u0430\u0440\u0438\u0449\u0438|\u043b\u044c\u043d\u043e\u043c"), NodePattern.N.lemma("\u043b\u0435\u0432|\u043b\u0451\u0434|\u043b\u043e\u0431|\u043b\u043e\u0436\u044c|\u043c\u043e\u0445|\u0440\u043e\u0432|\u0440\u043e\u0436\u044c|\u0440\u043e\u0442|\u0432\u043e\u0448\u044c|\u0432\u0435\u0441\u044c|\u043c\u043d\u043e\u0433\u0438\u0435|\u043c\u043d\u043e\u0433\u043e\u0435?|\u0432\u0442\u043e\u0440\u043e\u0439|\u0432\u0441\u044f(\u0447\u0435\u0441)?\u043a\u0438\u0439|\u0432\u0442\u043e\u0440\u043d\u0438\u043a"), NodePattern.N.inFormSequence(0, "\u0434\u043d\u044f", "\u043d\u0430", "\u0434\u0435\u043d\u044c")), NodePattern.or(NodePattern.N.lemma("\u0432\u0447\u0435\u0440\u0430.*|\u0434\u0432\u043e\u0440|\u0432\u043d\u0438\u043c\u0430\u043d\u0438\u0435|\u0434\u0435\u043d\u044c|\u0432\u0440\u0435\u043c\u044f|\u0432\u0445\u043e\u0434.*|\u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432.*").andNot(NodePattern.N.inFormSequence(0, "\u0434\u043d\u044f", "\u043d\u0430", "\u0434\u0435\u043d\u044c")), NodePattern.N.form("\u0432[\u0437\u0441\u0442].*").noForm("\u0432\u0441\u044f\u043a\u0438\u043c").noLemma("\u0432\u0435\u0441\u044c|\u0432\u0442\u043e\u0440\u043e\u0439|\u0432\u0441\u044f(\u0447\u0435\u0441)?\u043a\u0438\u0439|\u0432\u0442\u043e\u0440\u043d\u0438\u043a"), NodePattern.N.form("\u0441\u0440|\u0441\u0431|\u0432\u043a\u043b.*"), NodePattern.N.form("(\u043b|\u0440|\u043b\u044c)[\u0431\u0432\u0433\u0434\u0436\u0437\u0439\u043a\u043b\u043c\u043d\u043f\u0440\u0441\u0442\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044c].*").noLemma("\u043b\u0435\u0432|\u043b\u0451\u0434|\u043b\u043e\u0431|\u0440\u043e\u0432|\u0440\u043e\u0442"))));
    }

    private static NodePattern ot_oto() {
        NodePattern otoSna = NodePattern.N.inFormSequence(1, "\u043e\u0442\u043e?", "\u0441\u043d\u0430");
        return PrepositionForm.x_xo("\u043e\u0442", NodePattern.or(NodePattern.N.lemma(xoList).noForm(xoList), NodePattern.N.inFormSequence(2, "\u0434\u0435\u043d\u044c", "\u043e\u0442\u043e?", "\u0434\u043d\u044f"), NodePattern.N.form("\u043b\u044c\u043d\u0430"), otoSna), NodePattern.or(NodePattern.N.lemma("\u0432\u0435\u0441\u044c").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u0434\u0443\u0448\u0438"))), otoSna.withHead(NodePattern.N.noLemma("\u0432\u043e\u0441\u043f\u0440\u044f(\u043d\u0443)?\u0442\u044c"))));
    }

    private static NodePattern o_ob_obo() {
        NodePattern onlyObo = NodePattern.N.form("\u043c\u043d\u0435|\u0447\u0442\u043e|\u0432\u0441[\u0435\u044e\u0451]");
        NodePattern oObo = NodePattern.N.form("\u0432\u0441[\u0435\u0451]\u043c|\u0432\u0441\u0435[\u0439\u0445]");
        NodePattern onlyO = NodePattern.N.form("([\u0431\u0432\u0433\u0434\u0436\u0437\u0439\u043a\u043b\u043c\u043d\u043f\u0440\u0441\u0442\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044c]|[\u044f\u0435\u0451\u044e]).+").andNot(CommonPatterns.upperCase.formCaseSensitive("\u041b\u041c\u041d\u0420\u0421\u0424.*")).andNot(oObo).andNot(onlyObo).and(NodePattern.or(prepCaseWithoutAcc, NodePattern.N.withHead("amod", prepCaseWithoutAcc)));
        return NodePattern.or(NodePattern.N.form("\u043e\u0431?").directlyBefore(PunctuationRules.possiblyStartQuoted(onlyObo)).and(PrepositionForm.replaceBecauseOfNext("\u043e\u0431\u043e")), NodePattern.N.form("\u043e\u0431").directlyBefore(PunctuationRules.possiblyStartQuoted(oObo)).and(PrepositionForm.replaceBecauseOfNext("\u043e\u0431\u043e")), NodePattern.N.form("\u043e|\u043e\u0431\u043e").directlyBefore(PunctuationRules.possiblyStartQuoted(NodePattern.N.form("[\u0430\u0438\u043e\u0443\u044b\u044d].+"))).noHeadRelation("discourse").message("\u041f\u0435\u0440\u0435\u0434 \u0433\u043b\u0430\u0441\u043d\u044b\u043c\u0438 \u0437\u0432\u0443\u043a\u0430\u043c\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u043e\u0440\u043c\u0443 \u00ab\u043e\u0431\u00bb").correct(NodeCorrector.replace("\u043e\u0431")), NodePattern.N.form("\u043e\u0431\u043e?").directlyBefore(PunctuationRules.possiblyStartQuoted(onlyO)).message("\u041f\u0435\u0440\u0435\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u044b\u043c\u0438 \u0437\u0432\u0443\u043a\u0430\u043c\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u043e\u0440\u043c\u0443 \u00ab\u043e\u00bb").correct(NodeCorrector.replace("\u043e"))).and(CommonPatterns.highlightWithTrailingSpace());
    }

    private static NodePattern x_xo(String x, NodePattern xoNeeded, NodePattern bothPossible) {
        NodePattern ignore = NodePattern.or(bothPossible, CommonPatterns.upperCase, CommonPatterns.latinOrNumber, NodePattern.PUNCT);
        return NodePattern.or(NodePattern.N.form(x).directlyBefore(PunctuationRules.possiblyStartQuoted(xoNeeded.andNot(ignore).andNot(CommonPatterns.quotedWord.noHeadRelation("amod")))).and(PrepositionForm.replaceBecauseOfNext(x + "\u043e")), NodePattern.N.form(x + "\u043e").withHeadRelation("case").directlyBefore(PunctuationRules.possiblyStartQuoted(NodePattern.not(xoNeeded).andNot(ignore))).and(PrepositionForm.replaceBecauseOfNext(x))).and(CommonPatterns.highlightWithTrailingSpace());
    }

    private static NodePattern replaceBecauseOfNext(String replacement) {
        return NodePattern.custom((prep, match) -> {
            Node next = Objects.requireNonNull(prep.nextNode());
            String concat = prep.form() + next.form();
            if (prep.tree().treeSupport().tagToken(concat).hasPos(".*")) {
                match = match.withCorrector(NodeCorrector.replaceNodes(prep, next, concat));
            }
            return match.withMessage("\u041f\u0435\u0440\u0435\u0434 \u00ab" + PrepositionForm.nextWord(prep) + "\u00bb \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u043e\u0440\u043c\u0443 \u00ab" + replacement + "\u00bb").withCorrector(NodeCorrector.replace(prep, replacement));
        });
    }

    private static String nextWord(Node node) {
        Node next = Objects.requireNonNull(node.nextNode());
        if (RussianTreePatterns.openingQuotations.matches(next)) {
            next = Objects.requireNonNull(next.nextNode());
        }
        return next.form();
    }
}

