/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.tree.HeadRelations;
import ai.grazie.rules.tree.HintableFeature;
import ai.grazie.rules.tree.NodeFlags;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Node
extends Tree.Token {
    private final Tree tree;
    final short headRel;
    public final int index;
    final int headIndex;
    final List<Node> dependents;
    private volatile Tree.Token independently;
    private volatile Tree.Token independentlyLow;
    private volatile HintableFeature[] features;
    private int flags;

    Node(Tree tree, Tree.Token token, short headRel, int index, int headIndex, List<Node> dependents) {
        super(token);
        this.tree = tree;
        this.headRel = headRel;
        this.index = index;
        this.headIndex = headIndex;
        this.dependents = dependents;
    }

    @Nullable
    public Node skipForward(Predicate<Node> skipWhile) {
        return ((StreamEx)this.forward().dropWhile(skipWhile)).findFirst().orElse(null);
    }

    @Nullable
    public Node skipBack(Predicate<Node> skipWhile) {
        return ((StreamEx)this.back().dropWhile(skipWhile)).findFirst().orElse(null);
    }

    @NotNull
    public Node neighbor(int indexDelta) {
        return this.tree.nodes().get(this.index + indexDelta);
    }

    public StreamEx<Node> forward() {
        return StreamEx.iterate((Object)this, Objects::nonNull, Node::nextNode);
    }

    public StreamEx<Node> nextUntil(@NotNull Node end) {
        return end.isAfter(this) ? (StreamEx)((StreamEx)this.forward().skip(1L)).takeWhile(n -> n != end) : StreamEx.empty();
    }

    public StreamEx<Node> back() {
        return StreamEx.iterate((Object)this, Objects::nonNull, Node::prevNode);
    }

    public boolean hasLemma(@Language(value="RegExp") String regex) {
        Pattern pattern = Node.compileCSRegexp(regex);
        return this.lemmaReadings().stream().anyMatch(l -> pattern.matcher((CharSequence)l).matches());
    }

    public boolean hasForm(@Language(value="RegExp") String regex) {
        return Node.isNonRegex(regex) ? this.form().equalsIgnoreCase(regex) : Node.compileCSRegexp(regex).matcher(this.form()).matches();
    }

    @NotNull
    public Tree.Token tagIndependently() {
        Tree.Token result2 = this.independently;
        if (result2 == null) {
            this.independently = result2 = this.tree.treeSupport().tagToken(this.form());
        }
        return result2;
    }

    @NotNull
    public Tree.Token tagIndependentlyLowForm() {
        Tree.Token result2 = this.independentlyLow;
        if (result2 == null) {
            this.independentlyLow = result2 = this.tree.treeSupport().tagToken(this.lowForm());
        }
        return result2;
    }

    static Pattern compileCSRegexp(@Language(value="RegExp") String regex) {
        return Pattern.compile(regex, 66);
    }

    public List<Node> allDependents() {
        return this.dependents;
    }

    @Nullable
    public Node findSingleDependent(@Language(value="RegExp") String relations) {
        List<Node> matching = this.findDependents(relations);
        return matching.size() == 1 ? matching.get(0) : null;
    }

    @NotNull
    public List<Node> findDependents(@Language(value="RegExp") String relations) {
        if (this.dependents.isEmpty()) {
            return List.of();
        }
        HeadRelations.Matcher matcher = HeadRelations.matcher(relations);
        return this.dependents.stream().filter(matcher::matches).toList();
    }

    @NotNull
    public List<Node> findDependentsWithConj(@Language(value="RegExp") String relations) {
        ArrayList<Node> result2 = new ArrayList<Node>();
        result2.addAll(this.findDependents(relations));
        result2.addAll(StreamEx.of(result2).flatMap(dep -> StreamEx.of(dep.findDependentsWithConj("conj"))).toList());
        return result2;
    }

    public boolean hasDependent(@Language(value="RegExp") String relations) {
        return !this.findDependents(relations).isEmpty();
    }

    public StreamEx<Node> hierarchy() {
        return StreamEx.iterate((Object)this, Objects::nonNull, Node::head);
    }

    @Nullable
    public Node head() {
        return this.headIndex < 0 ? null : this.tree.nodes().get(this.headIndex);
    }

    public String headRelation() {
        return HeadRelations.byId(this.headRel);
    }

    public TextRange textRange() {
        return new TextRange(this.startOffset(), this.endOffset());
    }

    @NotNull
    public Node phraseStart() {
        Node start = this.subTreeStart();
        List<Node> nodes = this.tree.nodes();
        for (int i = this.index - 1; i > start.index; --i) {
            if (!this.breaksProjectivity(nodes.get(this.index))) continue;
            return nodes.get(i + 1);
        }
        return start;
    }

    @NotNull
    public Node phraseEnd() {
        Node end = this.subTreeEnd();
        List<Node> nodes = this.tree.nodes();
        for (int i = this.index + 1; i < end.index; ++i) {
            if (!this.breaksProjectivity(nodes.get(this.index))) continue;
            return nodes.get(i - 1);
        }
        return end;
    }

    private Node subTreeStart() {
        Node result2 = this;
        for (Node dependent : result2.dependents) {
            Node candidate = dependent.subTreeStart();
            if (!candidate.isBefore(result2)) continue;
            result2 = candidate;
        }
        return result2;
    }

    private Node subTreeEnd() {
        Node result2 = this;
        for (Node dependent : result2.dependents) {
            Node candidate = dependent.subTreeEnd();
            if (!candidate.isAfter(result2)) continue;
            result2 = candidate;
        }
        return result2;
    }

    private boolean breaksProjectivity(Node each) {
        return !each.hierarchy().has((Object)this) && !each.hasHeadRelation("punct") && this.hierarchy().has((Object)each);
    }

    public String phraseText() {
        return this.tree.text().substring(this.phraseStart().startOffset(), this.phraseEnd().endOffset());
    }

    public StreamEx<SentenceWithNERAnnotations.Annotation.Label> nerLabels() {
        return this.nerAnnotations().map(SentenceWithNERAnnotations.Annotation::getLabel);
    }

    public StreamEx<SentenceWithNERAnnotations.Annotation> nerAnnotations() {
        return (StreamEx)StreamEx.of(this.tree.namedEntities.stream()).filter(a -> a.getRange().getStart() <= this.startOffset() && a.getRange().getEndExclusive() >= this.endOffset());
    }

    boolean structureEquals(Node another) {
        return this.headIndex == another.headIndex && this.headRel == another.headRel && this.startOffset() == another.startOffset() && this.form().equals(another.form()) && this.tokenReadings().equals(another.tokenReadings());
    }

    @Override
    public String toString() {
        List ner = this.nerLabels().toList();
        return super.toString() + (String)(ner.isEmpty() ? "" : "; " + ner);
    }

    @Nullable
    @Contract(pure=true)
    public Node nextNode() {
        return this.index >= this.tree.nodes().size() - 1 ? null : this.tree.nodes().get(this.index + 1);
    }

    @Nullable
    @Contract(pure=true)
    public Node prevNode() {
        return this.index < 1 ? null : this.tree.nodes().get(this.index - 1);
    }

    public boolean isBefore(@NotNull Node another) {
        return this.index < another.index;
    }

    public boolean isAfter(@NotNull Node another) {
        return this.index > another.index;
    }

    public boolean isInPhraseOf(@NotNull Node another) {
        Node head = this.head();
        return this == another || head != null && head.isInPhraseOf(another);
    }

    public Tree tree() {
        return this.tree;
    }

    public org.languagetool.Language language() {
        return this.tree.language();
    }

    public boolean hasHeadRelation(String relations) {
        String rel = this.headRelation();
        return Node.isNonRegex(relations) ? rel.equals(relations) : rel.matches(relations);
    }

    private static boolean isNonRegex(String regex) {
        for (int i = 0; i < regex.length(); ++i) {
            char c = regex.charAt(i);
            if (c != '|' && c != '.' && c != '*' && c != '?' && c != '(' && c != '[' && c != '\\') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Node prevSibling() {
        Node prev = this.prevSiblingIncludingOtherSide();
        Node head = this.head();
        return prev != null && head != null && prev.isBefore(head) == this.isBefore(head) ? prev : null;
    }

    @Nullable
    public Node prevSiblingIncludingOtherSide() {
        Node head = this.head();
        if (head == null) {
            return null;
        }
        List<Node> dependents = head.dependents;
        int i = dependents.indexOf(this);
        return i == 0 ? null : dependents.get(i - 1);
    }

    @Nullable
    public Node nextSibling() {
        Node next = this.nextSiblingIncludingOtherSide();
        Node head = this.head();
        return next != null && head != null && next.isBefore(head) == this.isBefore(head) ? next : null;
    }

    @Nullable
    public Node nextSiblingIncludingOtherSide() {
        Node head = this.head();
        if (head == null) {
            return null;
        }
        List<Node> dependents = head.dependents;
        int i = dependents.indexOf(this);
        return i == dependents.size() - 1 ? null : dependents.get(i + 1);
    }

    public String presentableText() {
        return this.tree().treeSupport().isTrulyLowerCase(this) ? this.lowForm() : this.form();
    }

    public String quotedPresentableText() {
        return this.tree().treeSupport().quote(this.presentableText());
    }

    public StreamEx<String> similarWordsOfPos(@Language(value="RegExp") String pos) {
        TreeSupport support = this.tree().treeSupport();
        return (StreamEx)StreamEx.of(support.similarWords(this.form())).filter(s -> support.tagToken((String)s).hasPos(pos));
    }

    HintableFeature[] hintableFeatures() {
        HintableFeature[] result2 = this.features;
        if (result2 == null) {
            result2 = this.calcHintableFeatures();
            this.features = result2;
        }
        return result2;
    }

    private HintableFeature[] calcHintableFeatures() {
        List<String> lemmas = this.lemmaReadings();
        int estimatedSize = 2 + lemmas.size() + this.dependents.size();
        LinkedHashSet<HintableFeature> result2 = lemmas.size() > 1 || this.dependents.size() > 1 ? new LinkedHashSet<HintableFeature>(estimatedSize) : new ArrayList(estimatedSize);
        result2.add(HintableFeature.create(1, this.lowForm()));
        result2.add(HintableFeature.create(4, this.headRelation()));
        for (String lemma : lemmas) {
            result2.add(HintableFeature.create(2, lemma.toLowerCase(Locale.ROOT)));
        }
        for (Node dependent : this.dependents) {
            result2.add(HintableFeature.create(8, dependent.headRelation()));
        }
        return result2.toArray(new HintableFeature[0]);
    }

    int flags() {
        int result2 = this.flags;
        if (result2 == 0) {
            this.flags = result2 = NodeFlags.calcFlags(this);
        }
        return result2;
    }
}

