/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.tree.BatchTreeParser;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.LTTagger;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Tagger;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.util.BatchParser;
import ai.grazie.rules.util.CharUtil;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.languagetool.rules.patterns.CaseConversionHelper;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tools.StringTools;

@NotNullByDefault
public abstract class TreeSupport {
    public static final int CLOUD_BATCH_SIZE = Integer.getInteger("grazie.parsing.batch.size", 32);
    protected static final String JVM_CLOUD_MODEL_NAME = "gml-all-trf-v4";
    protected static final List<String> JVM_CLOUD_PARSER_OPTIONS = List.of("ensure_proj", "use_v2_tokenizer");
    protected static final String EXP_CLOUD_MODEL_NAME = "gml-all-trf-v4-exp";
    protected static final List<String> EXP_CLOUD_PARSER_OPTIONS = List.of("ensure_proj");
    protected static final List<String> EXP_CLOUD_PARSER_TOKENIZER_V2_OPTIONS = List.of("ensure_proj", "use_v2_tokenizer");
    public static final String CLOUD_NER_VERSION = "v2";
    final Tagger tagger;
    private final org.languagetool.Language ltLanguage;
    private final ai.grazie.nlp.langs.Language grazieLanguage;

    public TreeSupport(org.languagetool.Language ltLanguage) {
        this.ltLanguage = ltLanguage;
        this.tagger = this.createTagger();
        this.grazieLanguage = Objects.requireNonNull(ai.grazie.nlp.langs.Language.Companion.parse(ltLanguage.getShortCode()));
    }

    public ai.grazie.nlp.langs.Language getGrazieLanguage() {
        return this.grazieLanguage;
    }

    public String getCloudTreeModelName() {
        return JVM_CLOUD_MODEL_NAME;
    }

    public List<String> getCloudParserOptions() {
        return JVM_CLOUD_PARSER_OPTIONS;
    }

    public boolean needsNer() {
        return false;
    }

    protected Tagger createTagger() {
        return new LTTagger(this.ltLanguage);
    }

    public Tree buildTree(String text2, List<SentenceWithTreeDependencies.Node> conllu) {
        return Tree.build(this, text2, conllu);
    }

    public final Tree buildTree(SentenceWithTreeDependencies conllu, @Nullable SentenceWithNERAnnotations ner) {
        Tree result2 = this.buildTree(conllu.getText(), Arrays.asList(conllu.getTree()));
        if (ner != null) {
            assert (conllu.getText().equals(ner.getText()));
            return result2.withNamedEntities(Arrays.asList(ner.getAnnotations()));
        }
        return result2;
    }

    public abstract CrazyParseDetector crazyParseDetector();

    public abstract String quote(String var1);

    public abstract Quotes getAllQuotes();

    public boolean isInsideQuotes(Node node) {
        Quotes quotes = this.getAllQuotes();
        for (Node each : (StreamEx)node.back().skip(1L)) {
            if (!quotes.canBeAnyQuote(each.form())) continue;
            if (!quotes.canBeOpeningQuote(each.form()) || !Quotes.openingPosition.matches(each)) break;
            return true;
        }
        for (Node each : (StreamEx)node.forward().skip(1L)) {
            if (!quotes.canBeAnyQuote(each.form())) continue;
            if (!quotes.canBeClosingQuote(each.form()) || !Quotes.closingPosition.matches(each)) break;
            return true;
        }
        return false;
    }

    protected boolean shouldPreserveCase(TextChange.Replacement change, Tree tree, String prevText) {
        return StringTools.startsWithUppercase((String)prevText) || prevText.length() > 1 && StringTools.isAllUppercase((String)prevText);
    }

    public boolean hasAllCapitalizedStyle(Tree tree) {
        boolean hasTrulyLowerCase = false;
        for (Node node : tree.nodes()) {
            if (!CommonPatterns.letterWord.matches(node)) continue;
            if (!Character.isUpperCase(node.form().charAt(0))) {
                return false;
            }
            if (hasTrulyLowerCase) continue;
            hasTrulyLowerCase = this.isTrulyLowerCase(node) && !TreeSupport.hasOnlyPunctuationBefore(tree.text(), node.startOffset());
        }
        return hasTrulyLowerCase;
    }

    public boolean isTrulyLowerCase(Node node) {
        return false;
    }

    public final org.languagetool.Language language() {
        return this.ltLanguage;
    }

    public List<String> inflectNode(Node node, @Language(value="RegExp") String posRegex, String posReplacement) {
        Pattern posPattern = Pattern.compile(posRegex);
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (Tree.Reading reading : this.tagToken(node.form()).tokenReadings()) {
            Matcher matcher;
            String posTag = reading.pos();
            String lemma = reading.lemma();
            if (posTag == null || lemma == null || !(matcher = posPattern.matcher(posTag)).matches()) continue;
            String targetPos = matcher.replaceAll(posReplacement);
            result2.addAll(this.synthesize(node.form(), lemma, posTag, targetPos));
        }
        return new ArrayList<String>(result2);
    }

    public List<String> synthesize(String form, String lemma, String srcPos, String targetPos) {
        List<String> result2 = this.tagger.synthesize(form, lemma, srcPos, targetPos);
        if (result2.stream().anyMatch(StringTools::isAllUppercase)) {
            result2.removeIf(s1 -> StringTools.isAllUppercase((String)s1) && result2.stream().anyMatch(s2 -> s2.equalsIgnoreCase((String)s1) && !s2.equals(s1)));
        }
        return result2;
    }

    public boolean isAcceptedBySpellchecker(String word) {
        try {
            SpellingCheckRule rule = this.ltLanguage.getDefaultSpellingRule();
            return rule != null && !rule.isMisspelled(word);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> similarWords(String form) {
        return List.of();
    }

    public List<Tree.Token> tagTokens(List<String> tokens) {
        return this.tagger.tagTokens(tokens);
    }

    public Tree.Token tagToken(String form) {
        return this.tagger.tagSingleToken(form);
    }

    protected Tree disambiguateWithParameters(Tree tree) {
        return tree;
    }

    public static boolean hasOnlyPunctuationBefore(String sentence, int start) {
        for (int i = 0; i < start; ++i) {
            if (TreeSupport.isIgnorableStartPunctuation(sentence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isIgnorableStartPunctuation(char c) {
        return CharUtil.isAnyOf("-\u2013\u2014\"\u00ab\u201e\u201c\u00bb", c) || CharUtil.isAnySpace(c);
    }

    public static boolean isCapitalizedSentenceStart(Node node) {
        return TreeSupport.isCapitalizedSentenceStart(node.tree().text(), node.startOffset());
    }

    public static boolean isCapitalizedSentenceStart(String sentence, int offset) {
        return TreeSupport.hasOnlyPunctuationBefore(sentence, offset) && offset < sentence.length() && Character.isUpperCase(sentence.charAt(offset));
    }

    public static String preserveCase(String prevText, String replacement, @Nullable org.languagetool.Language language) {
        return CaseConversionHelper.convertCase((Match.CaseConversion)Match.CaseConversion.PRESERVE, (String)replacement, (String)prevText, (org.languagetool.Language)language);
    }

    public static BatchTreeParser toTreesFromCloud(final TreeSupport support, final BatchParser<List<SentenceWithTreeDependencies.Node>> treeParser) {
        return new BatchTreeParser(){

            @Override
            public TreeSupport support() {
                return support;
            }

            @Override
            public BatchTreeParser.TreeSource getSource() {
                return BatchTreeParser.TreeSource.Cloud;
            }

            @Override
            public LinkedHashMap<String, Tree> parse(List<String> sentences2) {
                return (LinkedHashMap)StreamEx.of(treeParser.parse(sentences2).entrySet()).mapToEntry(Map.Entry::getKey, e -> support.buildTree((String)e.getKey(), (List)e.getValue())).toCustomMap(LinkedHashMap::new);
            }
        };
    }

    public static BatchTreeParser toTreesLocal(final TreeSupport support, final BatchParser<List<SentenceWithTreeDependencies.Node>> treeParser) {
        return new BatchTreeParser(){

            @Override
            public TreeSupport support() {
                return support;
            }

            @Override
            public BatchTreeParser.TreeSource getSource() {
                return BatchTreeParser.TreeSource.Local;
            }

            @Override
            public LinkedHashMap<String, Tree> parse(List<String> sentences2) {
                return (LinkedHashMap)StreamEx.of(treeParser.parse(sentences2).entrySet()).mapToEntry(Map.Entry::getKey, e -> support.buildTree((String)e.getKey(), (List)e.getValue()).markLocal()).toCustomMap(LinkedHashMap::new);
            }
        };
    }
}

