/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.LTTagger;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tagger;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.uk.UkrainianCrazyParseDetector;
import ai.grazie.rules.uk.UkrainianTreeDisambiguator;
import ai.grazie.rules.uk.UkrainianTreePatterns;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import java.util.List;
import org.jetbrains.annotations.NotNullByDefault;
import org.languagetool.Language;

@NotNullByDefault
public class UkrainianTreeSupport
extends TreeSupport {
    private static final NodePattern lowerCase = NodePattern.N.anyPos().noPos(".*name.*");

    public UkrainianTreeSupport(Language language) {
        super(language);
        assert (language.getShortCode().equals("uk"));
    }

    @Override
    public String getCloudTreeModelName() {
        return "gml-all-trf-v4-exp";
    }

    @Override
    public List<String> getCloudParserOptions() {
        return EXP_CLOUD_PARSER_TOKENIZER_V2_OPTIONS;
    }

    @Override
    public boolean isTrulyLowerCase(Node node) {
        return lowerCase.matches(node);
    }

    @Override
    public Tree buildTree(String text2, List<SentenceWithTreeDependencies.Node> conllu) {
        return new UkrainianTreeDisambiguator(super.buildTree(text2, conllu)).disambiguateByTree();
    }

    @Override
    protected Tagger createTagger() {
        return UkrainianTreeSupport.createTagger(this.language());
    }

    static LTTagger createTagger(Language language) {
        return new LTTagger(language){

            @Override
            public String normalizeToken(String token) {
                return UkrainianTreeSupport.normalizeApostrophes(token);
            }
        };
    }

    static String normalizeApostrophes(String token) {
        return token.contains("\u2019") || token.contains("\u02bc") ? token.replaceAll("[\u2019\u02bc]", "'") : token;
    }

    @Override
    public List<String> inflectNode(Node node, String posRegex, String posReplacement) {
        List<String> result2 = super.inflectNode(node, posRegex, posReplacement);
        if (node.rawForm().contains("\u2019")) {
            return result2.stream().map(s -> s.replaceAll("'", "\u2019")).toList();
        }
        if (node.rawForm().contains("\u02bc")) {
            return result2.stream().map(s -> s.replaceAll("'", "\u02bc")).toList();
        }
        return result2;
    }

    @Override
    public List<String> synthesize(String form, String lemma, String srcPos, String targetPos) {
        List<String> result2 = super.synthesize(form, lemma, srcPos, targetPos);
        if (targetPos.startsWith("verb:rev:") && form.endsWith("\u044f")) {
            result2.removeIf(s -> s.endsWith("\u044c"));
        }
        if (targetPos.startsWith("verb:rev:") && form.endsWith("\u044c")) {
            result2.removeIf(s -> s.endsWith("\u044f"));
        }
        result2.remove("\u043b\u044e\u0434\u0438\u043d\u0430\u043c");
        return result2;
    }

    @Override
    public CrazyParseDetector crazyParseDetector() {
        return UkrainianCrazyParseDetector.INSTANCE;
    }

    @Override
    public String quote(String text2) {
        return "\u00ab" + text2 + "\u00bb";
    }

    @Override
    public Quotes getAllQuotes() {
        return UkrainianTreePatterns.quotes;
    }
}

