/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.util.regex;

import ai.grazie.rules.util.regex.RegexPath;
import ai.grazie.rules.util.regex.Term;
import ai.grazie.rules.util.regex.Unsupported;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

record Or(List<Term> components) implements Term
{
    Or {
        assert (components.size() > 1);
    }

    @Override
    @NotNull
    public Set<RegexPath> enumerate(int limit, boolean leanRight) {
        HashSet<RegexPath> result2 = new HashSet<RegexPath>();
        boolean hasUnsupported = false;
        for (Term component2 : this.components) {
            Set<RegexPath> inner = component2.enumerate(limit, leanRight);
            for (RegexPath path : inner) {
                hasUnsupported |= path.single() instanceof Unsupported;
                result2.add(path);
            }
        }
        if (result2.size() > limit | hasUnsupported) {
            return Set.of(RegexPath.toUnsupported(result2));
        }
        return result2;
    }

    @Override
    public boolean isFinite() {
        return this.components.stream().allMatch(Term::isFinite);
    }
}

