/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro;

import com.intellij.ml.grazie.pro.utils.TextUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NaturalTextDetector {
    public static boolean seemsNatural(String text2) {
        int spaceCount = 0;
        for (int i = 0; i < text2.length(); ++i) {
            char c2 = text2.charAt(i);
            if (c2 != ' ' || ++spaceCount <= 3) continue;
            return true;
        }
        if (spaceCount < 1) {
            return false;
        }
        if (spaceCount == 1) {
            return text2.chars().noneMatch(c -> TextUtils.INSTANCE.isPunctuation((char)c));
        }
        return text2.chars().allMatch(NaturalTextDetector::isExpectedInText);
    }

    private static boolean isExpectedInText(int c) {
        return Character.isWhitespace(c) || Character.isLetterOrDigit(c) || TextUtils.INSTANCE.isPunctuation((char)c);
    }
}

