/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro;

import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.text.exclusions.Exclusion;
import ai.grazie.text.exclusions.SentenceWithExclusions;
import com.intellij.grazie.text.TextContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kotlin.ranges.IntRange;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class SentenceTokenizer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ml.grazie.pro.SentenceTokenizer");
    private static final Key<List<Sentence>> tokenized = Key.create((String)"grazie pro sentence tokenization");
    private static final Method unknownOffsets = ReflectionUtil.getMethod(TextContent.class, (String)"unknownOffsets", (Class[])new Class[0]);

    public static List<Tokenizer.Token> tokenize(@NotNull CharSequence text2) {
        if (text2 == null) {
            SentenceTokenizer.$$$reportNull$$$0(0);
        }
        if (ProgressManager.getGlobalProgressIndicator() == null && Cancellation.currentJob() == null && !ApplicationManager.getApplication().isDispatchThread()) {
            LOG.error("Sentence tokenizer should be called with a cancellable indicator");
        }
        CharSequence bombed = SentenceTokenizer.bombed(text2);
        return ContainerUtil.map(StandardSentenceTokenizer.Companion.getDefault().tokenRanges(bombed), r -> new Tokenizer.Token(text2.subSequence(r.getStart(), r.getEndExclusive()).toString(), new IntRange(r.getStart(), r.getEndInclusive())));
    }

    private static CharSequence bombed(@NotNull CharSequence text2) {
        if (text2 == null) {
            SentenceTokenizer.$$$reportNull$$$0(1);
        }
        return new StringUtil.BombedCharSequence(text2){

            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
    }

    public static List<Sentence> tokenize(@NotNull TextContent content) {
        List result2;
        if (content == null) {
            SentenceTokenizer.$$$reportNull$$$0(2);
        }
        if ((result2 = (List)content.getUserData(tokenized)) == null) {
            result2 = ContainerUtil.map(SentenceTokenizer.tokenize(content.toString()), token -> SentenceTokenizer.toSentence(token, content));
            content.putUserData(tokenized, (Object)result2);
        }
        return result2;
    }

    private static Sentence toSentence(Tokenizer.Token token, TextContent textContent) {
        TextRange range = new TextRange(token.getRange().getFirst(), token.getRange().getLast() + 1);
        return new Sentence(range.getStartOffset(), token.getToken(), SentenceTokenizer.sentenceExclusions(textContent, range));
    }

    public static List<Exclusion> sentenceExclusions(TextContent textContent, TextRange range) {
        return ((StreamEx)StreamEx.of(SentenceTokenizer.exclusionsInRange(range, textContent.markupOffsets(), Exclusion.Kind.Markup)).append(SentenceTokenizer.unknownOffsets(textContent, range)).sortedBy(Exclusion::getOffset)).toList();
    }

    private static List<Exclusion> exclusionsInRange(TextRange range, int[] offsets, Exclusion.Kind kind) {
        return IntStreamEx.of((int[])offsets).filter(arg_0 -> ((TextRange)range).contains(arg_0)).mapToObj(offset -> new Exclusion(offset - range.getStartOffset(), kind)).toList();
    }

    private static List<Exclusion> unknownOffsets(final TextContent textContent, final TextRange range) {
        if (unknownOffsets != null) {
            try {
                return SentenceTokenizer.exclusionsInRange(range, (int[])unknownOffsets.invoke((Object)textContent, new Object[0]), Exclusion.Kind.Unknown);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        final ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
        new Object(){

            private void findUnknownOffsets(int start, int end) {
                if (textContent.hasUnknownFragmentsIn(new TextRange(start, end))) {
                    if (start == end) {
                        exclusions.add(new Exclusion(start - range.getStartOffset(), Exclusion.Kind.Unknown));
                    } else {
                        int middle = (start + end) / 2;
                        this.findUnknownOffsets(start, middle);
                        this.findUnknownOffsets(middle + 1, end);
                    }
                }
            }
        }.findUnknownOffsets(range.getStartOffset(), range.getEndOffset());
        return exclusions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ml/grazie/pro/SentenceTokenizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tokenize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "bombed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record Sentence(int start, String text, List<Exclusion> exclusions) {
        public int end() {
            return this.start + this.text.length();
        }

        public SentenceWithExclusions swe() {
            return new SentenceWithExclusions(this.text, this.exclusions);
        }
    }
}

