/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.auth;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.grazie.pro.cloud.BackgroundCloudService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.Topic;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u001e\u0010\f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "errors", "", "Lcom/intellij/ml/grazie/pro/cloud/BackgroundCloudService;", "mayRetryGecAt", "Ljava/util/concurrent/atomic/AtomicLong;", "dispose", "", "changeState", "change", "Lkotlin/Function1;", "ConnectionState", "Listener", "Companion", "intellij.ml.grazie.pro"})
public final class GrazieCloudConnectionState
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Set<? extends BackgroundCloudService> errors = SetsKt.emptySet();
    @NotNull
    private final AtomicLong mayRetryGecAt = new AtomicLong(0L);

    public GrazieCloudConnectionState() {
        ApplicationKt.getApplication().addApplicationListener(new ApplicationListener(){

            public void writeActionFinished(Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                mayRetryGecAt.set(0L);
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    private final synchronized Set<BackgroundCloudService> changeState(Function1<? super Set<? extends BackgroundCloudService>, ? extends Set<? extends BackgroundCloudService>> change) {
        this.errors = (Set)change.invoke(this.errors);
        return this.errors;
    }

    @JvmStatic
    public static final boolean isAfterRecentGecError() {
        return Companion.isAfterRecentGecError();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState$Companion;", "", "<init>", "()V", "stateChanged", "Lcom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState$ConnectionState;", "state", "cloudService", "Lcom/intellij/ml/grazie/pro/cloud/BackgroundCloudService;", "obtainCurrentState", "toState", "errors", "", "isAfterRecentGecError", "", "getInstance", "Lcom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState;", "intellij.ml.grazie.pro"})
    @SourceDebugExtension(value={"SMAP\nGrazieCloudConnectionState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieCloudConnectionState.kt\ncom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,78:1\n40#2,3:79\n*S KotlinDebug\n*F\n+ 1 GrazieCloudConnectionState.kt\ncom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState$Companion\n*L\n75#1:79,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConnectionState stateChanged(@NotNull ConnectionState state, @NotNull BackgroundCloudService cloudService) {
            ConnectionState after;
            ConnectionState before2;
            boolean error;
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)cloudService), (String)"cloudService");
            GrazieCloudConnectionState service = this.getInstance();
            boolean bl = error = state == ConnectionState.Error;
            if (error && cloudService == BackgroundCloudService.GEC) {
                service.mayRetryGecAt.set(System.nanoTime() + TimeUnit.SECONDS.toNanos(15L));
            }
            if ((before2 = this.toState(service.errors)) != (after = this.toState(service.changeState((Function1<? super Set<? extends BackgroundCloudService>, ? extends Set<? extends BackgroundCloudService>>)arg_0 -> Companion.stateChanged$lambda$0(error, cloudService, arg_0))))) {
                ((Listener)ApplicationKt.getApplication().getMessageBus().syncPublisher(Listener.Companion.getTOPIC())).cloudConnectionStateChanged(after);
            }
            return after;
        }

        @NotNull
        public final ConnectionState obtainCurrentState() {
            return this.toState(this.getInstance().errors);
        }

        private final ConnectionState toState(Set<? extends BackgroundCloudService> errors) {
            return errors.isEmpty() ? ConnectionState.Stable : ConnectionState.Error;
        }

        @JvmStatic
        public final boolean isAfterRecentGecError() {
            GrazieCloudConnectionState service = this.getInstance();
            return service.errors.contains((Object)BackgroundCloudService.GEC) && System.nanoTime() < service.mayRetryGecAt.get();
        }

        private final GrazieCloudConnectionState getInstance() {
            boolean $i$f$service = false;
            Class<GrazieCloudConnectionState> serviceClass$iv = GrazieCloudConnectionState.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GrazieCloudConnectionState)object;
        }

        private static final Set stateChanged$lambda$0(boolean $error, BackgroundCloudService $cloudService, Set it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $error ? SetsKt.plus((Set)it, (Iterable)SetsKt.setOf((Object)((Object)$cloudService))) : SetsKt.minus((Set)it, (Iterable)SetsKt.setOf((Object)((Object)$cloudService)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState$ConnectionState;", "", "<init>", "(Ljava/lang/String;I)V", "Stable", "Error", "intellij.ml.grazie.pro"})
    public static final class ConnectionState
    extends Enum<ConnectionState> {
        public static final /* enum */ ConnectionState Stable = new ConnectionState();
        public static final /* enum */ ConnectionState Error = new ConnectionState();
        private static final /* synthetic */ ConnectionState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConnectionState[] values() {
            return (ConnectionState[])$VALUES.clone();
        }

        public static ConnectionState valueOf(String value) {
            return Enum.valueOf(ConnectionState.class, value);
        }

        @NotNull
        public static EnumEntries<ConnectionState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = connectionStateArray = new ConnectionState[]{ConnectionState.Stable, ConnectionState.Error};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState$Listener;", "", "cloudConnectionStateChanged", "", "state", "Lcom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState$ConnectionState;", "Companion", "intellij.ml.grazie.pro"})
    public static interface Listener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public void cloudConnectionStateChanged(@NotNull ConnectionState var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState$Listener$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/ml/grazie/pro/auth/GrazieCloudConnectionState$Listener;", "kotlin.jvm.PlatformType", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "intellij.ml.grazie.pro"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @Topic.AppLevel
            @NotNull
            private static final Topic<Listener> TOPIC;

            private Companion() {
            }

            @NotNull
            public final Topic<Listener> getTOPIC() {
                return TOPIC;
            }

            static {
                $$INSTANCE = new Companion();
                TOPIC = new Topic(Listener.class);
            }
        }
    }
}

