/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.style;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Severity;
import ai.grazie.rules.vale.YamlBasedRule;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.grazie.grammar.LanguageToolChecker;
import com.intellij.grazie.ide.TextProblemSeverities;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieReplaceTypoQuickFix;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ml.grazie.pro.AsyncTreeRuleChecker;
import com.intellij.ml.grazie.pro.GrazieProBundle;
import com.intellij.ml.grazie.pro.HighlightingUtil;
import com.intellij.ml.grazie.pro.TreeRuleChecker;
import com.intellij.ml.grazie.pro.style.LTStyleProblemFilter;
import com.intellij.ml.grazie.pro.utils.GrazieUtilsKt;
import com.intellij.ml.grazie.pro.utils.IdeUtils;
import com.intellij.ml.grazie.pro.yaml.RuleEngineYamlChecker;
import com.intellij.ml.grazie.pro.yaml.YamlRuleWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleAnnotator
implements Annotator {
    private static final Key<Pair<Long, Map<PsiElement, List<Pair<TextRange, TextProblem>>>>> CACHE_KEY = Key.create((String)"grazie.pro.style.highlighting");
    private static final LanguageToolChecker ltChecker = (LanguageToolChecker)new ExtensionPointName("com.intellij.grazie.textChecker").findExtension(LanguageToolChecker.class);
    private static final String GRAZIE_INSPECTION_ID = "GrazieInspection";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            StyleAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            StyleAnnotator.$$$reportNull$$$0(1);
        }
        if (GrazieUtilsKt.isFunctionallyDisabled()) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (GrazieInspection.Companion.ignoreGrammarChecking(file) || !file.isPhysical() || !HighlightingUtil.shouldEnableHighlighting(file) || HighlightingUtil.skipExpensivePrecommitAnalysis(file)) {
            return;
        }
        if (element instanceof PsiWhiteSpace || ((Boolean)GrazieInspection.getDisabledChecker((PsiFile)file).invoke((Object)element)).booleanValue()) {
            return;
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        ToolsImpl tools = profile.getToolsOrNull(GRAZIE_INSPECTION_ID, file.getProject());
        if (tools == null || !tools.isEnabled((PsiElement)file) || tools.getTool().getTool().isSuppressedFor(element)) {
            return;
        }
        StyleAnnotator.checkSpecificTexts(element, holder);
        if (element == file) {
            StyleAnnotator.checkTextLevel(file, holder);
        }
    }

    private static void checkTextLevel(PsiFile file, AnnotationHolder holder) {
        for (TreeRuleChecker.TreeProblem problem : TreeRuleChecker.checkTextLevelProblems(file)) {
            for (TextRange range : HighlightingUtil.getFileHighlightRanges(problem)) {
                StyleAnnotator.reportProblem(holder, problem, range);
            }
        }
    }

    private static void checkSpecificTexts(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        List texts;
        if (element == null) {
            StyleAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            StyleAnnotator.$$$reportNull$$$0(3);
        }
        if (HighlightingUtil.isTooLargeText(texts = TextExtractor.findTextsAt((PsiElement)element, (Set)GrazieInspection.checkedDomains()))) {
            return;
        }
        for (TextContent text2 : texts) {
            for (Pair pair : StyleAnnotator.analyze(text2).getOrDefault(element, List.of())) {
                StyleAnnotator.reportProblem(holder, (TextProblem)pair.second, (TextRange)pair.first);
            }
        }
    }

    private static void reportProblem(AnnotationHolder holder, TextProblem problem, TextRange range) {
        List<LocalQuickFix> fixes;
        Rule rule = problem.getRule();
        if (problem instanceof YamlRuleWrapper.YamlProblem && rule instanceof YamlRuleWrapper && !((YamlRuleWrapper)rule).isBundled()) {
            fixes = StyleAnnotator.getReplacementFixes(problem);
            fixes.add((LocalQuickFix)new NavigateToRuleFile(((YamlRuleWrapper.YamlProblem)problem).rule));
        } else {
            List descriptors = new CheckerRunner(problem.getText()).toProblemDescriptors(problem, true);
            fixes = Arrays.asList((LocalQuickFix[])Objects.requireNonNull(((ProblemDescriptor)descriptors.get(0)).getFixes()));
        }
        HighlightSeverity severity = StyleAnnotator.getHighlightSeverity(problem);
        Project project = holder.getCurrentAnnotationSession().getFile().getProject();
        TextAttributesKey attributes = IdeUtils.obtainTextAttributes(severity, project);
        AnnotationBuilder annotation = holder.newAnnotation(severity, problem.getDescriptionTemplate(true)).tooltip(problem.getTooltipTemplate()).textAttributes(attributes).problemGroup(() -> GRAZIE_INSPECTION_ID).range(range);
        for (QuickFix quickFix : fixes) {
            annotation = annotation.withFix((IntentionAction)quickFix);
        }
        annotation.create();
    }

    private static HighlightSeverity getHighlightSeverity(TextProblem problem) {
        if (problem instanceof YamlRuleWrapper.YamlProblem) {
            YamlRuleWrapper.YamlProblem p = (YamlRuleWrapper.YamlProblem)problem;
            YamlBasedRule.Level yamlLevel = p.rule.meta.level;
            return YamlBasedRule.Level.error.equals((Object)yamlLevel) ? TextProblemSeverities.STYLE_ERROR : (YamlBasedRule.Level.warning.equals((Object)yamlLevel) ? TextProblemSeverities.STYLE_WARNING : TextProblemSeverities.STYLE_SUGGESTION);
        }
        if (problem instanceof TreeRuleChecker.TreeProblem) {
            TreeRuleChecker.TreeProblem p = (TreeRuleChecker.TreeProblem)problem;
            return switch (p.match.rule().getSeverity()) {
                case Severity.STYLE_WARNING -> TextProblemSeverities.STYLE_WARNING;
                case Severity.STYLE_ERROR -> TextProblemSeverities.STYLE_ERROR;
                default -> TextProblemSeverities.STYLE_SUGGESTION;
            };
        }
        if (problem instanceof LTStyleProblemWrapper) {
            return TextProblemSeverities.STYLE_WARNING;
        }
        return TextProblemSeverities.STYLE_SUGGESTION;
    }

    public static List<LocalQuickFix> getReplacementFixes(TextProblem problem) {
        return GrazieReplaceTypoQuickFix.getReplacementFixes((TextProblem)problem, StyleAnnotator.getUnderlineRanges(problem));
    }

    private static List<SmartPsiFileRange> getUnderlineRanges(TextProblem problem) {
        PsiFile file = problem.getText().getContainingFile();
        SmartPointerManager spm = SmartPointerManager.getInstance((Project)file.getProject());
        List<TextRange> ranges = HighlightingUtil.getFileHighlightRanges(problem);
        return ContainerUtil.map(ranges, r -> spm.createSmartPsiFileRangePointer(file, r));
    }

    public static Map<PsiElement, List<Pair<TextRange, TextProblem>>> analyze(final TextContent text2) {
        return HighlightingUtil.analyzeForAnnotator(text2, CACHE_KEY, () -> {
            Lang lang;
            Language language = HighlightingUtil.detectPreferringEnglish(text2.toString());
            Lang lang2 = lang = language == null ? null : HighlightingUtil.findInstalledLang(language);
            if (lang == null || lang.getJLanguage() == null) {
                return List.of();
            }
            TextChecker yamlChecker = new TextChecker(){

                @NotNull
                public Collection<? extends Rule> getRules(@NotNull Locale locale) {
                    if (locale == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    throw new UnsupportedOperationException();
                }

                @NotNull
                public Collection<? extends TextProblem> check(@NotNull TextContent extracted) {
                    List enabled;
                    if (extracted == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ArrayList<YamlRuleWrapper.YamlProblem> problems2 = new ArrayList<YamlRuleWrapper.YamlProblem>();
                    if (lang.isEnglish() && !(enabled = ((StreamEx)StreamEx.of(RuleEngineYamlChecker.enRules()).filter(r -> r.isCurrentlyEnabled() && r.matchesScope(text2))).toList()).isEmpty()) {
                        problems2.addAll(YamlRuleWrapper.checkRules(text2, lang, enabled, false));
                    }
                    ArrayList<YamlRuleWrapper.YamlProblem> arrayList = problems2;
                    if (arrayList == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return arrayList;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "locale";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extracted";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ml/grazie/pro/style/StyleAnnotator$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ml/grazie/pro/style/StyleAnnotator$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "check";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getRules";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "check";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            };
            TextChecker ltStyleChecker = new TextChecker(){

                @NotNull
                public Collection<? extends Rule> getRules(@NotNull Locale locale) {
                    if (locale == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    throw new UnsupportedOperationException();
                }

                @NotNull
                public Collection<? extends TextProblem> check(@NotNull TextContent extracted) {
                    if (extracted == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (ltChecker != null) {
                        List list = ((StreamEx)StreamEx.of((Collection)ltChecker.check(extracted)).filter(LTStyleProblemFilter::isStyleLike)).map(p -> new LTStyleProblemWrapper((LanguageToolChecker.Problem)p)).toList();
                        if (list == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return list;
                    }
                    List list = List.of();
                    if (list == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "locale";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extracted";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ml/grazie/pro/style/StyleAnnotator$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ml/grazie/pro/style/StyleAnnotator$2";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "check";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getRules";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "check";
                            break;
                        }
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2, 3 -> new IllegalStateException(string);
                    };
                }
            };
            ArrayList result2 = new ArrayList();
            new CheckerRunner(text2).run(List.of(yamlChecker, new AsyncTreeRuleChecker.Style(), ltStyleChecker), problem -> {
                for (TextRange range : HighlightingUtil.getFileHighlightRanges(problem)) {
                    result2.add(Pair.create((Object)range, (Object)problem));
                }
                return null;
            });
            return result2;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ml/grazie/pro/style/StyleAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSpecificTexts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NavigateToRuleFile
    extends IntentionAndQuickFixAction {
        private final String filePath;
        private final int line;
        private final int column;

        NavigateToRuleFile(YamlBasedRule rule) {
            this.filePath = rule.meta.filePath;
            this.line = rule.line;
            this.column = rule.column;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = GrazieProBundle.msg("adhoc.rule.navigate.fix.name", String.valueOf(this.line + 1), StringUtil.getShortName((String)this.filePath, (char)'/'));
            if (string == null) {
                NavigateToRuleFile.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                NavigateToRuleFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
            VirtualFile ruleFile;
            if (project == null) {
                NavigateToRuleFile.$$$reportNull$$$0(2);
            }
            if ((ruleFile = LocalFileSystem.getInstance().findFileByPath(this.filePath)) != null) {
                new OpenFileDescriptor(project, ruleFile, this.line, this.column).navigate(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ml/grazie/pro/style/StyleAnnotator$NavigateToRuleFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ml/grazie/pro/style/StyleAnnotator$NavigateToRuleFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class LTStyleProblemWrapper
    extends TextProblem {
        private final LanguageToolChecker.Problem delegate;

        LTStyleProblemWrapper(LanguageToolChecker.Problem delegate2) {
            super(delegate2.getRule(), delegate2.getText(), delegate2.getHighlightRanges());
            this.delegate = delegate2;
        }

        @NotNull
        public String getTooltipTemplate() {
            String string = this.delegate.getTooltipTemplate();
            if (string == null) {
                LTStyleProblemWrapper.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public TextRange getPatternRange() {
            return this.delegate.getPatternRange();
        }

        @NotNull
        public List<TextProblem.Suggestion> getSuggestions() {
            List list = this.delegate.getSuggestions();
            if (list == null) {
                LTStyleProblemWrapper.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<LocalQuickFix> getCustomFixes() {
            List list = this.delegate.getCustomFixes();
            if (list == null) {
                LTStyleProblemWrapper.$$$reportNull$$$0(2);
            }
            return list;
        }

        public boolean fitsGroup(@NotNull RuleGroup group) {
            if (group == null) {
                LTStyleProblemWrapper.$$$reportNull$$$0(3);
            }
            return this.delegate.fitsGroup(group);
        }

        @NotNull
        public String getShortMessage() {
            String string = this.delegate.getShortMessage();
            if (string == null) {
                LTStyleProblemWrapper.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        @InspectionMessage
        public String getDescriptionTemplate(boolean isOnTheFly) {
            String string = this.delegate.getDescriptionTemplate(isOnTheFly);
            if (string == null) {
                LTStyleProblemWrapper.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ml/grazie/pro/style/StyleAnnotator$LTStyleProblemWrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltipTemplate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuggestions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomFixes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ml/grazie/pro/style/StyleAnnotator$LTStyleProblemWrapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortMessage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fitsGroup";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

