/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.run.ExecutionPath;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/matterhorn/AgentSessionHistory;", "", "viewedFiles", "", "", "viewedImports", "createdFiles", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getCreatedFiles", "()Ljava/util/Set;", "hasViewedFile", "", "path", "Lcom/intellij/ml/llm/matterhorn/run/ExecutionPath;", "markViewedFile", "", "hasViewedImport", "markViewedImport", "Companion", "ej-core"})
public final class AgentSessionHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> viewedFiles;
    @NotNull
    private final Set<String> viewedImports;
    @NotNull
    private final Set<String> createdFiles;

    public AgentSessionHistory(@NotNull Set<String> viewedFiles, @NotNull Set<String> viewedImports, @NotNull Set<String> createdFiles) {
        Intrinsics.checkNotNullParameter(viewedFiles, (String)"viewedFiles");
        Intrinsics.checkNotNullParameter(viewedImports, (String)"viewedImports");
        Intrinsics.checkNotNullParameter(createdFiles, (String)"createdFiles");
        this.viewedFiles = viewedFiles;
        this.viewedImports = viewedImports;
        this.createdFiles = createdFiles;
    }

    @NotNull
    public final Set<String> getCreatedFiles() {
        return this.createdFiles;
    }

    public final boolean hasViewedFile(@NotNull ExecutionPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.viewedFiles.contains(path.getPath());
    }

    public final void markViewedFile(@NotNull ExecutionPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.viewedFiles.add(path.getPath());
    }

    public final boolean hasViewedImport(@NotNull ExecutionPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.viewedImports.contains(path.getPath());
    }

    public final void markViewedImport(@NotNull ExecutionPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.viewedImports.add(path.getPath());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/matterhorn/AgentSessionHistory$Companion;", "", "<init>", "()V", "initialHistoryContext", "Lcom/intellij/ml/llm/matterhorn/AgentSessionHistory;", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AgentSessionHistory initialHistoryContext() {
            return new AgentSessionHistory(new LinkedHashSet(), new LinkedHashSet(), new LinkedHashSet());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

