/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.CacheType;
import com.intellij.ml.llm.matterhorn.MatterhornCaches;
import com.intellij.util.io.Compressor;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J \u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/matterhorn/InMemoryCaches;", "Lcom/intellij/ml/llm/matterhorn/MatterhornCaches;", "<init>", "()V", "multiPathStorage", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/matterhorn/CacheType;", "", "binaryStorage", "", "singleStorage", "save", "", "type", "path", "content", "contains", "", "load", "loadAllPaths", "", "hasAnyOfType", "remove", "saveBinary", "loadBinary", "saveSingle", "loadSingle", "clear", "dumpToZip", "zip", "Lcom/intellij/util/io/Compressor$Zip;", "core"})
public final class InMemoryCaches
implements MatterhornCaches {
    @NotNull
    private final ConcurrentHashMap<CacheType, ConcurrentHashMap<String, String>> multiPathStorage = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<CacheType, ConcurrentHashMap<String, byte[]>> binaryStorage = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<CacheType, String> singleStorage = new ConcurrentHashMap();

    @Override
    public void save(@NotNull CacheType type, @NotNull String path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ConcurrentHashMap concurrentHashMap = this.multiPathStorage.computeIfAbsent(type, arg_0 -> InMemoryCaches.save$lambda$1(InMemoryCaches::save$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentHashMap, (String)"computeIfAbsent(...)");
        ((Map)concurrentHashMap).put(path, content);
    }

    @Override
    public boolean contains(@NotNull CacheType type, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ConcurrentHashMap<String, String> concurrentHashMap = this.multiPathStorage.get((Object)type);
        return concurrentHashMap != null ? concurrentHashMap.containsKey(path) : false;
    }

    @Override
    @Nullable
    public String load(@NotNull CacheType type, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ConcurrentHashMap<String, String> concurrentHashMap = this.multiPathStorage.get((Object)type);
        return concurrentHashMap != null ? concurrentHashMap.get(path) : null;
    }

    @Override
    @NotNull
    public Iterable<String> loadAllPaths(@NotNull CacheType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Serializable serializable = this.multiPathStorage.get((Object)type);
        return serializable != null && (serializable = (ConcurrentHashMap.KeySetView)serializable.keySet()) != null ? (Iterable)((Object)serializable) : (Iterable)SetsKt.emptySet();
    }

    @Override
    public boolean hasAnyOfType(@NotNull CacheType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        ConcurrentHashMap<String, String> concurrentHashMap = this.multiPathStorage.get((Object)type);
        return (concurrentHashMap != null ? !((Map)concurrentHashMap).isEmpty() : false) || this.singleStorage.containsKey((Object)type);
    }

    @Override
    public void remove(@NotNull CacheType type, @NotNull String path) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            ConcurrentHashMap<String, String> concurrentHashMap = this.multiPathStorage.get((Object)type);
            if (concurrentHashMap == null) break block0;
            concurrentHashMap.remove(path);
        }
    }

    @Override
    public void saveBinary(@NotNull CacheType type, @NotNull String path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ConcurrentHashMap concurrentHashMap = this.binaryStorage.computeIfAbsent(type, arg_0 -> InMemoryCaches.saveBinary$lambda$3(InMemoryCaches::saveBinary$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentHashMap, (String)"computeIfAbsent(...)");
        ((Map)concurrentHashMap).put(path, content);
    }

    @Override
    @Nullable
    public byte[] loadBinary(@NotNull CacheType type, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ConcurrentHashMap<String, byte[]> concurrentHashMap = this.binaryStorage.get((Object)type);
        return concurrentHashMap != null ? concurrentHashMap.get(path) : null;
    }

    @Override
    public void saveSingle(@NotNull CacheType type, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ((Map)this.singleStorage).put(type, content);
    }

    @Override
    @Nullable
    public String loadSingle(@NotNull CacheType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.singleStorage.get((Object)type);
    }

    @Override
    public void clear() {
        this.multiPathStorage.clear();
        this.binaryStorage.clear();
        this.singleStorage.clear();
    }

    @Override
    public void dumpToZip(@NotNull Compressor.Zip zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private static final ConcurrentHashMap save$lambda$0(CacheType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new ConcurrentHashMap();
    }

    private static final ConcurrentHashMap save$lambda$1(Function1 $tmp0, Object p0) {
        return (ConcurrentHashMap)$tmp0.invoke(p0);
    }

    private static final ConcurrentHashMap saveBinary$lambda$2(CacheType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new ConcurrentHashMap();
    }

    private static final ConcurrentHashMap saveBinary$lambda$3(Function1 $tmp0, Object p0) {
        return (ConcurrentHashMap)$tmp0.invoke(p0);
    }
}

