/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.Argument;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.FileWithLine;
import com.intellij.ml.llm.matterhorn.StepMetadataKt;
import com.intellij.ml.llm.matterhorn.StepType;
import com.intellij.ml.llm.matterhorn.actions.ActionRequest;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.llm.ParameterValue;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/ScrollUpAgentAction;", "Lcom/intellij/ml/llm/matterhorn/AgentAction;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "arguments", "", "Lcom/intellij/ml/llm/matterhorn/Argument;", "getArguments", "()Ljava/util/List;", "docstring", "getDocstring", "execute", "request", "Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ej-core"})
public final class ScrollUpAgentAction
implements AgentAction {
    @NotNull
    private final String name;
    @NotNull
    private final List<Argument> arguments = CollectionsKt.emptyList();
    @NotNull
    private final String docstring;

    public ScrollUpAgentAction() {
        this.name = "scroll_up";
        this.docstring = "moves the view window up to show previous 100 lines of currently open file";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public String getDocstring() {
        return this.docstring;
    }

    @Override
    @Nullable
    public Object execute(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        StepMetadataKt.emitMetadata("Scroll up", StepType.Info, context2);
        FileWithLine fileWithLine = context2.getCurrentScreenPosition();
        if (fileWithLine == null) {
            return "ERROR: No file open. Use open command first";
        }
        FileWithLine oldPosition = fileWithLine;
        int newLine = Math.max(oldPosition.getLine() - 100, 0);
        context2.setCurrentScreenPosition(new FileWithLine(oldPosition.getFile(), newLine));
        return AgentUtilsKt.printScreen$default(context2.getProject(), oldPosition.getFile(), Math.max(newLine - 10, 1), 120, context2.getExecutionEnvironment().getPathConverter(), null, $completion, 32, null);
    }

    @Override
    @NotNull
    public String getCustomSignature() {
        return AgentAction.DefaultImpls.getCustomSignature(this);
    }

    @Override
    @Nullable
    public Object getInputParams(@NotNull ActionRequest $this$getInputParams, @NotNull Continuation<? super Map<String, ParameterValue>> $completion) {
        return AgentAction.DefaultImpls.getInputParams(this, $this$getInputParams, $completion);
    }

    @Override
    @Nullable
    public Object reviewActionRequest(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return AgentAction.DefaultImpls.reviewActionRequest(this, request2, context2, $completion);
    }
}

