/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.Argument;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.Result;
import com.intellij.ml.llm.matterhorn.StepMetadataKt;
import com.intellij.ml.llm.matterhorn.StepType;
import com.intellij.ml.llm.matterhorn.actions.ActionRequest;
import com.intellij.ml.llm.matterhorn.actions.ActionUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.SearchInDirAction;
import com.intellij.ml.llm.matterhorn.llm.ArgumentType;
import com.intellij.ml.llm.matterhorn.llm.ParameterValue;
import com.intellij.ml.llm.matterhorn.run.ExecutionPath;
import com.intellij.ml.llm.matterhorn.run.LocalPath;
import com.intellij.ml.llm.matterhorn.run.PathConverter;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchInDirAction;", "Lcom/intellij/ml/llm/matterhorn/AgentAction;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "arguments", "", "Lcom/intellij/ml/llm/matterhorn/Argument;", "getArguments", "()Ljava/util/List;", "docstring", "getDocstring", "execute", "request", "Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "ej-core"})
public final class SearchInDirAction
implements AgentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Argument> arguments;
    @NotNull
    private final String docstring;
    @NotNull
    public static final String SEARCH_TERM_ARGUMENT = "search_term";
    @NotNull
    public static final String DIR_ARGUMENT = "dir";

    public SearchInDirAction() {
        this.name = "search_dir";
        Object[] objectArray = new Argument[]{new Argument(SEARCH_TERM_ARGUMENT, ArgumentType.STRING, "the term to search for", false, false, 24, null), new Argument(DIR_ARGUMENT, ArgumentType.STRING, "the directory to search in (if not provided, searches in the current directory)", true, false, 16, null)};
        this.arguments = CollectionsKt.listOf((Object[])objectArray);
        this.docstring = "searches for search_term in all files in dir. \n        If dir is not provided, searches in the current directory.";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public String getDocstring() {
        return this.docstring;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object execute(@NotNull ActionRequest var1_1, @NotNull ExecutionAgentContext var2_2, @NotNull Continuation<? super String> $completion) {
        block11: {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var9_4 = $completion;
            if ((var9_4.label & -2147483648) != 0) {
                var9_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ SearchInDirAction this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute(null, null, (Continuation<? super String>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = context;
                    $continuation.label = 1;
                    v0 = this.getInputParams((ActionRequest)request, (Continuation<? super Map<String, ParameterValue>>)$continuation);
                    if (v0 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    context = (ExecutionAgentContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    params = (Map)v0;
                    v1 = ActionUtilsKt.tryGetNonEmptyStringValue((ParameterValue)params.get("search_term"));
                    if (v1 == null) {
                        return "Search term is required.";
                    }
                    searchTerm = v1;
                    directoryPath = ActionUtilsKt.tryGetNonEmptyStringValue((ParameterValue)params.get("dir"));
                    StepMetadataKt.emitMetadata("Search in directory \"" + searchTerm + "\"", StepType.Info, context);
                    res = AgentUtilsKt.locateDirectory(directoryPath, context.getCurrentDir(), context.getExecutionEnvironment().getPathConverter());
                    if (res instanceof Result.Err) break block11;
                    if (!(res instanceof Result.Ok)) break;
                    if (!VfsUtilCore.isAncestor((VirtualFile)context.getProjectDir(), (VirtualFile)((VirtualFile)((Result.Ok)res).getValue()), (boolean)false)) {
                        return "ERROR: Target directory is outside of the project directory";
                    }
                    $continuation.L$0 = null;
                    $continuation.label = 2;
                    v2 = SearchInDirAction.Companion.findInFiles((VirtualFile)((Result.Ok)res).getValue(), searchTerm, 50, context.getExecutionEnvironment().getPathConverter(), (Continuation<? super String>)$continuation);
                    if (v2 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl43
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl43:
                    // 2 sources

                    return v2;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((Result.Err)res).getMessage();
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public String getCustomSignature() {
        return AgentAction.DefaultImpls.getCustomSignature(this);
    }

    @Override
    @Nullable
    public Object getInputParams(@NotNull ActionRequest $this$getInputParams, @NotNull Continuation<? super Map<String, ParameterValue>> $completion) {
        return AgentAction.DefaultImpls.getInputParams(this, $this$getInputParams, $completion);
    }

    @Override
    @Nullable
    public Object reviewActionRequest(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return AgentAction.DefaultImpls.reviewActionRequest(this, request2, context2, $completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fJ2\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J<\u0010\u0016\u001a\u00020\u00052\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchInDirAction$Companion;", "", "<init>", "()V", "SEARCH_TERM_ARGUMENT", "", "DIR_ARGUMENT", "findInFiles", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "searchTerm", "limit", "", "pathConverter", "Lcom/intellij/ml/llm/matterhorn/run/PathConverter;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;ILcom/intellij/ml/llm/matterhorn/run/PathConverter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "searchFilesInDirectory", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/ml/llm/matterhorn/run/PathConverter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "searchTermInContent", "", "content", "aggregateResults", "fileCountMap", "pathPresentation", "ej-core"})
    @SourceDebugExtension(value={"SMAP\nSearchInDirAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchInDirAction.kt\ncom/intellij/ml/llm/matterhorn/actions/SearchInDirAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1872#2,3:135\n1863#2,2:138\n*S KotlinDebug\n*F\n+ 1 SearchInDirAction.kt\ncom/intellij/ml/llm/matterhorn/actions/SearchInDirAction$Companion\n*L\n98#1:135,3\n126#1:138,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object findInFiles(@NotNull VirtualFile var1_1, @NotNull String var2_2, int var3_3, @NotNull PathConverter var4_4, @NotNull Continuation<? super String> $completion) {
            if (!($completion instanceof findInFiles.1)) ** GOTO lbl-1000
            var8_6 = $completion;
            if ((var8_6.label & -2147483648) != 0) {
                var8_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.findInFiles(null, null, 0, null, (Continuation<? super String>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.L$1 = directory;
                    $continuation.L$2 = searchTerm;
                    $continuation.L$3 = pathConverter;
                    $continuation.I$0 = limit;
                    $continuation.label = 1;
                    v0 = this.searchFilesInDirectory(directory, searchTerm, pathConverter, (Continuation<? super Map<String, Integer>>)$continuation);
                    if (v0 == var9_8) {
                        return var9_8;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    limit = $continuation.I$0;
                    pathConverter = (PathConverter)$continuation.L$3;
                    searchTerm = (String)$continuation.L$2;
                    directory = (VirtualFile)$continuation.L$1;
                    this = (Companion)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    fileCountMap = (Map)v0;
                    return this.aggregateResults(fileCountMap, searchTerm, directory, limit, pathConverter);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object searchFilesInDirectory(VirtualFile var1_1, String var2_2, PathConverter var3_3, Continuation<? super Map<String, Integer>> $completion) {
            if (!($completion instanceof searchFilesInDirectory.1)) ** GOTO lbl-1000
            var10_5 = $completion;
            if ((var10_5.label & -2147483648) != 0) {
                var10_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.ml.llm.matterhorn.actions.SearchInDirAction$Companion.access$searchFilesInDirectory(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    fileCountMap = new LinkedHashMap<K, V>();
                    $continuation.L$0 = searchTerm;
                    $continuation.L$1 = pathConverter;
                    $continuation.L$2 = fileCountMap;
                    $continuation.label = 1;
                    v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, searchFilesInDirectory$lambda$0(com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/openapi/vfs/VirtualFileSet;)((VirtualFile)directory), (Continuation)$continuation);
                    if (v0 == var11_7) {
                        return var11_7;
                    }
                    ** GOTO lbl27
                }
                case 1: {
                    fileCountMap = (Map)$continuation.L$2;
                    pathConverter = (PathConverter)$continuation.L$1;
                    searchTerm = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    fileSet = (VirtualFileSet)v0;
                    var7_10 = fileSet.iterator();
lbl29:
                    // 3 sources

                    while (var7_10.hasNext()) {
                        virtualFile = (VirtualFile)var7_10.next();
                        $continuation.L$0 = searchTerm;
                        $continuation.L$1 = pathConverter;
                        $continuation.L$2 = fileCountMap;
                        $continuation.L$3 = var7_10;
                        $continuation.label = 2;
                        v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, searchFilesInDirectory$lambda$1(com.intellij.openapi.vfs.VirtualFile java.lang.String com.intellij.ml.llm.matterhorn.run.PathConverter java.util.Map ), ()Lkotlin/Unit;)((VirtualFile)virtualFile, (String)searchTerm, (PathConverter)pathConverter, (Map)fileCountMap), (Continuation)$continuation);
                        if (v1 != var11_7) continue;
                        return var11_7;
                    }
                    break;
                }
                case 2: {
                    var7_10 = (Iterator)$continuation.L$3;
                    fileCountMap = (Map)$continuation.L$2;
                    pathConverter = (PathConverter)$continuation.L$1;
                    searchTerm = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl29
                }
            }
            return fileCountMap;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> searchTermInContent(String content, String searchTerm) {
            List lines = StringsKt.lines((CharSequence)content);
            List searchResults = new ArrayList();
            Iterable $this$forEachIndexed$iv = lines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void line;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)((CharSequence)line), (CharSequence)searchTerm, (boolean)false, (int)2, null)) continue;
                String before = index > 0 ? index + ": " + lines.get(index - 1) : "";
                String after = index < lines.size() - 1 ? index + 2 + ": " + lines.get(index + 1) : "";
                searchResults.add(before + "\n" + (index + 1) + ": " + (String)line + "\n" + after);
            }
            return searchResults;
        }

        /*
         * WARNING - void declaration
         */
        private final String aggregateResults(Map<String, Integer> fileCountMap, String searchTerm, VirtualFile directory, int limit, PathConverter pathPresentation) {
            Object object;
            Path path = directory.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            ExecutionPath dir = pathPresentation.convertLocalPathToExecutionPath(new LocalPath(path));
            if (fileCountMap.isEmpty()) {
                object = "No matches found for \"" + searchTerm + "\" in " + dir.getPath();
            } else if (fileCountMap.size() > limit) {
                object = "More than " + limit + " files matched for \"" + searchTerm + "\" in '" + dir.getPath() + "'. Please narrow your search.";
            } else {
                void $this$forEach$iv;
                StringBuilder stringBuilder;
                StringBuilder $this$aggregateResults_u24lambda_u246 = stringBuilder = new StringBuilder();
                boolean bl = false;
                StringBuilder stringBuilder2 = $this$aggregateResults_u24lambda_u246.append("Found " + CollectionsKt.sumOfInt((Iterable)fileCountMap.values()) + " matches for '" + searchTerm + "' in '" + dir.getPath() + "':");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                Object object2 = new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)b;
                        boolean bl = false;
                        Comparable comparable = (Comparable)it.getValue();
                        it = (Map.Entry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getValue()));
                    }
                };
                object2 = CollectionsKt.sortedWith((Iterable)fileCountMap.entrySet(), (Comparator)new Comparator((Comparator)object2){
                    final /* synthetic */ Comparator $this_thenBy;
                    {
                        this.$this_thenBy = $receiver;
                    }

                    public final int compare(T a, T b) {
                        int n;
                        int previousCompare = this.$this_thenBy.compare(a, b);
                        if (previousCompare != 0) {
                            n = previousCompare;
                        } else {
                            Map.Entry it = (Map.Entry)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)it.getKey();
                            it = (Map.Entry)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getKey()));
                        }
                        return n;
                    }
                });
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    String path2 = (String)entry.getKey();
                    int count = ((Number)entry.getValue()).intValue();
                    StringBuilder stringBuilder3 = $this$aggregateResults_u24lambda_u246.append(path2 + " (" + count + " matches)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                }
                StringBuilder stringBuilder4 = $this$aggregateResults_u24lambda_u246.append("End of matches for \"" + searchTerm + "\" in " + dir.getPath());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                String string = stringBuilder.toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            }
            return object;
        }

        private static final VirtualFileSet searchFilesInDirectory$lambda$0(VirtualFile $directory) {
            VirtualFileSet virtualFileSet = VfsUtilCore.createCompactVirtualFileSet();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileSet, (String)"createCompactVirtualFileSet(...)");
            VirtualFileSet fileSet2 = virtualFileSet;
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
            VfsUtil.visitChildrenRecursively((VirtualFile)$directory, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(fileSet2, optionArray){
                final /* synthetic */ VirtualFileSet $fileSet;
                {
                    this.$fileSet = $fileSet;
                    super($super_call_param$1);
                }

                public boolean visitFile(VirtualFile file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!file.isDirectory()) {
                        this.$fileSet.add((Object)file);
                    }
                    return true;
                }
            }));
            return fileSet2;
        }

        private static final Unit searchFilesInDirectory$lambda$1(VirtualFile $virtualFile, String $searchTerm, PathConverter $pathConverter, Map $fileCountMap) {
            Object object = FileDocumentManager.getInstance().getDocument($virtualFile);
            if (object == null || (object = object.getText()) == null) {
                return Unit.INSTANCE;
            }
            Object content = object;
            List<String> searchResults = Companion.searchTermInContent((String)content, $searchTerm);
            if (!((Collection)searchResults).isEmpty()) {
                Path path = $virtualFile.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                ExecutionPath path2 = $pathConverter.convertLocalPathToExecutionPath(new LocalPath(path));
                $fileCountMap.put(path2.getPath(), searchResults.size());
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Object access$searchFilesInDirectory(Companion $this, VirtualFile directory, String searchTerm, PathConverter pathConverter, Continuation $completion) {
            return $this.searchFilesInDirectory(directory, searchTerm, pathConverter, (Continuation<? super Map<String, Integer>>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

