/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.Argument;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.Result;
import com.intellij.ml.llm.matterhorn.StepMetadataKt;
import com.intellij.ml.llm.matterhorn.StepType;
import com.intellij.ml.llm.matterhorn.actions.ActionRequest;
import com.intellij.ml.llm.matterhorn.actions.ActionUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.SearchInFileAgentAction;
import com.intellij.ml.llm.matterhorn.actions.SearchInFileAgentActionKt;
import com.intellij.ml.llm.matterhorn.llm.ArgumentType;
import com.intellij.ml.llm.matterhorn.llm.ParameterValue;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchInFileAgentAction;", "Lcom/intellij/ml/llm/matterhorn/AgentAction;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "arguments", "", "Lcom/intellij/ml/llm/matterhorn/Argument;", "getArguments", "()Ljava/util/List;", "docstring", "getDocstring", "execute", "request", "Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "ej-core"})
public final class SearchInFileAgentAction
implements AgentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Argument> arguments;
    @NotNull
    private final String docstring;
    @NotNull
    public static final String SEARCH_TERM_ARGUMENT = "search_term";
    @NotNull
    public static final String FILE_ARGUMENT = "file";

    public SearchInFileAgentAction() {
        this.name = "search_file";
        Object[] objectArray = new Argument[]{new Argument(SEARCH_TERM_ARGUMENT, ArgumentType.STRING, "the term to search for", false, false, 24, null), new Argument(FILE_ARGUMENT, ArgumentType.STRING, "the file to search in (if not provided, searches in the current open file)", true, false, 16, null)};
        this.arguments = CollectionsKt.listOf((Object[])objectArray);
        this.docstring = "searches for search_term in file. If file is not provided, searches in the current open file";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public String getDocstring() {
        return this.docstring;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object execute(@NotNull ActionRequest var1_1, @NotNull ExecutionAgentContext var2_2, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SearchInFileAgentAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = context;
                $continuation.label = 1;
                v0 = this.getInputParams((ActionRequest)request, (Continuation<? super Map<String, ParameterValue>>)$continuation);
                if (v0 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl22
            }
            case 1: {
                context = (ExecutionAgentContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if ((v1 = ActionUtilsKt.tryGetNonEmptyStringValue((ParameterValue)(params = (Map)v0).get("search_term"))) == null) {
                    v1 = "ERROR: search_term is missing or invalid";
                }
                searchTerm = v1;
                fileName = ActionUtilsKt.tryGetNonEmptyStringValue((ParameterValue)params.get("file"));
                StepMetadataKt.emitMetadata("Search in file \"" + searchTerm + "\"", StepType.Info, context);
                if (fileName != null) ** GOTO lbl34
                v2 = context.getCurrentScreenPosition();
                if (v2 == null) {
                    return "ERROR: No file open. Use open command first";
                }
                screenPosition = v2;
                v3 = screenPosition.getFile();
                ** GOTO lbl50
lbl34:
                // 1 sources

                $continuation.L$0 = searchTerm;
                $continuation.label = 2;
                v4 = AgentUtilsKt.smartLocateFile$default(fileName, context, false, (Continuation)$continuation, 4, null);
                if (v4 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl44
            }
            case 2: {
                searchTerm = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl44:
                // 2 sources

                if ((res = (Result)v4) instanceof Result.Err) {
                    return ((Result.Err)res).getMessage();
                }
                if (res instanceof Result.Ok) {
                    v3 = (VirtualFile)((Result.Ok)res).getValue();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
lbl50:
                // 2 sources

                file = v3;
                $continuation.L$0 = searchTerm;
                $continuation.L$1 = file;
                $continuation.label = 3;
                v5 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$0(com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/openapi/editor/Document;)((VirtualFile)file), (Continuation)$continuation);
                if (v5 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl63
            }
            case 3: {
                file = (VirtualFile)$continuation.L$1;
                searchTerm = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl63:
                // 2 sources

                if ((document = (Document)v5) == null) {
                    return "ERROR: Unable to load document for file";
                }
                v6 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getPath(...)");
                return SearchInFileAgentActionKt.searchInDocument(document, searchTerm, v6, false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public String getCustomSignature() {
        return AgentAction.DefaultImpls.getCustomSignature(this);
    }

    @Override
    @Nullable
    public Object getInputParams(@NotNull ActionRequest $this$getInputParams, @NotNull Continuation<? super Map<String, ParameterValue>> $completion) {
        return AgentAction.DefaultImpls.getInputParams(this, $this$getInputParams, $completion);
    }

    @Override
    @Nullable
    public Object reviewActionRequest(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return AgentAction.DefaultImpls.reviewActionRequest(this, request2, context2, $completion);
    }

    private static final Document execute$lambda$0(VirtualFile $file) {
        return FileDocumentManager.getInstance().getDocument($file);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchInFileAgentAction$Companion;", "", "<init>", "()V", "SEARCH_TERM_ARGUMENT", "", "FILE_ARGUMENT", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

