/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions.edit;

import com.intellij.ml.llm.matterhorn.Argument;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.StepMetadataKt;
import com.intellij.ml.llm.matterhorn.StepType;
import com.intellij.ml.llm.matterhorn.actions.ActionRequest;
import com.intellij.ml.llm.matterhorn.actions.SimpleActionRequest;
import com.intellij.ml.llm.matterhorn.actions.edit.AbstractEditAction;
import com.intellij.ml.llm.matterhorn.actions.edit.EditAgentAction;
import com.intellij.ml.llm.matterhorn.actions.edit.checks.ErrorChecker;
import com.intellij.ml.llm.matterhorn.llm.ArgumentType;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J&\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bR\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction;", "Lcom/intellij/ml/llm/matterhorn/actions/edit/AbstractEditAction;", "errorCheckers", "", "Lcom/intellij/ml/llm/matterhorn/actions/edit/checks/ErrorChecker;", "<init>", "(Ljava/util/List;)V", "name", "", "getName", "()Ljava/lang/String;", "arguments", "Lcom/intellij/ml/llm/matterhorn/Argument;", "getArguments", "()Ljava/util/List;", "docstring", "getDocstring", "customSignature", "getCustomSignature", "execute", "request", "Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reviewActionRequest", "doExecute", "Lcom/intellij/ml/llm/matterhorn/actions/SimpleActionRequest;", "dryRun", "", "(Lcom/intellij/ml/llm/matterhorn/actions/SimpleActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseArgument", "Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction$ReplaceLinesParseResult;", "input", "Companion", "ReplaceLinesParseResult", "ej-core"})
public final class EditAgentAction
extends AbstractEditAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Argument> arguments;
    @NotNull
    private final String docstring;
    @NotNull
    private final String customSignature;
    @NotNull
    public static final String REPLACE_LINES_ACTION_NAME = "replace_lines";

    public EditAgentAction(@NotNull List<? extends ErrorChecker> errorCheckers) {
        Intrinsics.checkNotNullParameter(errorCheckers, (String)"errorCheckers");
        super(errorCheckers);
        this.name = REPLACE_LINES_ACTION_NAME;
        Object[] objectArray = new Argument[]{new Argument("start_line", ArgumentType.INTEGER, "the line number to start the edit at", false, false, 24, null), new Argument("end_line", ArgumentType.INTEGER, "the line number to end the edit at (inclusive)", false, false, 24, null), new Argument("replacement_text", ArgumentType.STRING, "the text to replace the current selection with", false, false, 24, null)};
        this.arguments = CollectionsKt.listOf((Object[])objectArray);
        this.docstring = "replaces lines <start_line> through <end_line> (inclusive) with the given text in the open file. All of the <replacement text> will be entered, so make sure your indentation is formatted properly. Source code files will be checked for syntax errors after the edit. If the system detects a syntax error, the edit will not be executed. Simply try to edit the file again, but make sure to read the error message and modify the edit command you issue accordingly. Issuing the same command a second time will just lead to the same error message again.";
        this.customSignature = "replace_lines <start_line>:<end_line>\n<replacement_text>";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public String getDocstring() {
        return this.docstring;
    }

    @Override
    @NotNull
    public String getCustomSignature() {
        return this.customSignature;
    }

    @Override
    @Nullable
    public Object execute(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        boolean bl = request2 instanceof SimpleActionRequest;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)request2, (String)"null cannot be cast to non-null type com.intellij.ml.llm.matterhorn.actions.SimpleActionRequest");
        return this.doExecute((SimpleActionRequest)request2, context2, false, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object reviewActionRequest(@NotNull ActionRequest var1_1, @NotNull ExecutionAgentContext var2_2, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof reviewActionRequest.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ EditAgentAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.reviewActionRequest(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = request instanceof SimpleActionRequest;
                if (_Assertions.ENABLED && !var4_7) {
                    var5_9 = "Assertion failed";
                    throw new AssertionError((Object)var5_9);
                }
                Intrinsics.checkNotNull((Object)request, (String)"null cannot be cast to non-null type com.intellij.ml.llm.matterhorn.actions.SimpleActionRequest");
                $continuation.label = 1;
                v0 = this.doExecute((SimpleActionRequest)request, (ExecutionAgentContext)context, true, (Continuation<? super String>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (StringsKt.contains$default((CharSequence)(dryRunResult = (String)v0), (CharSequence)StringsKt.trim((CharSequence)"File updated.").toString(), (boolean)false, (int)2, null)) {
                    return null;
                }
                return dryRunResult;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object doExecute(SimpleActionRequest var1_1, ExecutionAgentContext var2_2, boolean var3_3, Continuation<? super String> $completion) {
        if (!($completion instanceof doExecute.1)) ** GOTO lbl-1000
        var13_5 = $completion;
        if ((var13_5.label & -2147483648) != 0) {
            var13_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ EditAgentAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EditAgentAction.access$doExecute(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                StepMetadataKt.emitMetadata("Edit", StepType.Edit, context);
                result = this.parseArgument(request.getArguments());
                if (result instanceof ReplaceLinesParseResult.Error) {
                    return ((ReplaceLinesParseResult.Error)result).getMessage();
                }
                Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type com.intellij.ml.llm.matterhorn.actions.edit.EditAgentAction.ReplaceLinesParseResult.Success");
                (ReplaceLinesParseResult.Success)result;
                startLine = ((ReplaceLinesParseResult.Success)result).getStartLine();
                endLine = ((ReplaceLinesParseResult.Success)result).getEndLine();
                replacementText = ((ReplaceLinesParseResult.Success)result).getReplacementText();
                v0 = context.getCurrentScreenPosition();
                if (v0 == null) {
                    return "ERROR: No file open. Use open command first";
                }
                screenPosition = v0;
                file = screenPosition.getFile();
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = replacementText;
                $continuation.Z$0 = dryRun;
                $continuation.I$0 = startLine;
                $continuation.I$1 = endLine;
                $continuation.label = 1;
                v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doExecute$lambda$0(com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/openapi/editor/Document;)((VirtualFile)file), (Continuation)$continuation);
                if (v1 == var14_7) {
                    return var14_7;
                }
                ** GOTO lbl47
            }
            case 1: {
                endLine = $continuation.I$1;
                startLine = $continuation.I$0;
                dryRun = $continuation.Z$0;
                replacementText = (String)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (EditAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl47:
                // 2 sources

                v2 = (Document)v1;
                if (v2 == null) {
                    return "ERROR: Unable to load document for file";
                }
                document = v2;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v3 = this.changeText(context, document, startLine, endLine, replacementText, context.getProject(), 5, context.getExecutionEnvironment().getPathConverter(), 100, dryRun != false, (Continuation<? super String>)$continuation);
                if (v3 == var14_7) {
                    return var14_7;
                }
                ** GOTO lbl62
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl62:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final ReplaceLinesParseResult parseArgument(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String expectedFormat = StringsKt.trimMargin$default((String)("|```\n          |" + this.getName() + " <start_of_edit>:<end_of_edit>\n          |<new text>\n          |```"), null, (int)1, null);
        List lines = StringsKt.lines((CharSequence)input);
        if (lines.size() < 2) {
            return new ReplaceLinesParseResult.Error("ERROR: Your response does not have enough lines. Expected format:\n" + expectedFormat);
        }
        String rangeLine = ((Object)StringsKt.trim((CharSequence)((String)lines.get(0)))).toString();
        List replacementTextLines = lines.subList(1, lines.size());
        String[] stringArray = new String[]{":"};
        List rangeParts = StringsKt.split$default((CharSequence)rangeLine, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (rangeParts.size() != 2) {
            return new ReplaceLinesParseResult.Error("ERROR: wrong command format. Expected format:\n" + expectedFormat);
        }
        Integer startLine = StringsKt.toIntOrNull((String)((String)rangeParts.get(0)));
        Integer endLine = StringsKt.toIntOrNull((String)((String)rangeParts.get(1)));
        if (startLine == null) {
            return new ReplaceLinesParseResult.Error("ERROR: start_line must be a number. Expected format:\n" + expectedFormat);
        }
        if (endLine == null) {
            return new ReplaceLinesParseResult.Error("ERROR: end_line must be a number. Expected format:\n" + expectedFormat);
        }
        String replacementText = CollectionsKt.joinToString$default((Iterable)replacementTextLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return new ReplaceLinesParseResult.Success(startLine, endLine, replacementText);
    }

    private static final Document doExecute$lambda$0(VirtualFile $file) {
        return FileDocumentManager.getInstance().getDocument($file);
    }

    public static final /* synthetic */ Object access$doExecute(EditAgentAction $this, SimpleActionRequest request2, ExecutionAgentContext context2, boolean dryRun, Continuation $completion) {
        return $this.doExecute(request2, context2, dryRun, (Continuation<? super String>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction$Companion;", "", "<init>", "()V", "REPLACE_LINES_ACTION_NAME", "", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction$ReplaceLinesParseResult;", "", "<init>", "()V", "Success", "Error", "Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction$ReplaceLinesParseResult$Error;", "Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction$ReplaceLinesParseResult$Success;", "ej-core"})
    public static abstract class ReplaceLinesParseResult {
        private ReplaceLinesParseResult() {
        }

        public /* synthetic */ ReplaceLinesParseResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction$ReplaceLinesParseResult$Error;", "Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction$ReplaceLinesParseResult;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "ej-core"})
        public static final class Error
        extends ReplaceLinesParseResult {
            @NotNull
            private final String message;

            public Error(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Error(message);
            }

            public static /* synthetic */ Error copy$default(Error error, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = error.message;
                }
                return error.copy(string);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return Intrinsics.areEqual((Object)this.message, (Object)error.message);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction$ReplaceLinesParseResult$Success;", "Lcom/intellij/ml/llm/matterhorn/actions/edit/EditAgentAction$ReplaceLinesParseResult;", "startLine", "", "endLine", "replacementText", "", "<init>", "(IILjava/lang/String;)V", "getStartLine", "()I", "getEndLine", "getReplacementText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "ej-core"})
        public static final class Success
        extends ReplaceLinesParseResult {
            private final int startLine;
            private final int endLine;
            @NotNull
            private final String replacementText;

            public Success(int startLine, int endLine, @NotNull String replacementText) {
                Intrinsics.checkNotNullParameter((Object)replacementText, (String)"replacementText");
                super(null);
                this.startLine = startLine;
                this.endLine = endLine;
                this.replacementText = replacementText;
            }

            public final int getStartLine() {
                return this.startLine;
            }

            public final int getEndLine() {
                return this.endLine;
            }

            @NotNull
            public final String getReplacementText() {
                return this.replacementText;
            }

            public final int component1() {
                return this.startLine;
            }

            public final int component2() {
                return this.endLine;
            }

            @NotNull
            public final String component3() {
                return this.replacementText;
            }

            @NotNull
            public final Success copy(int startLine, int endLine, @NotNull String replacementText) {
                Intrinsics.checkNotNullParameter((Object)replacementText, (String)"replacementText");
                return new Success(startLine, endLine, replacementText);
            }

            public static /* synthetic */ Success copy$default(Success success2, int n, int n2, String string, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = success2.startLine;
                }
                if ((n3 & 2) != 0) {
                    n2 = success2.endLine;
                }
                if ((n3 & 4) != 0) {
                    string = success2.replacementText;
                }
                return success2.copy(n, n2, string);
            }

            @NotNull
            public String toString() {
                return "Success(startLine=" + this.startLine + ", endLine=" + this.endLine + ", replacementText=" + this.replacementText + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.startLine);
                result = result * 31 + Integer.hashCode(this.endLine);
                result = result * 31 + this.replacementText.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success2 = (Success)other;
                if (this.startLine != success2.startLine) {
                    return false;
                }
                if (this.endLine != success2.endLine) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.replacementText, (Object)success2.replacementText);
            }
        }
    }
}

