/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.run.docker;

import com.intellij.ml.llm.matterhorn.run.ExecutionPath;
import com.intellij.ml.llm.matterhorn.run.LocalPath;
import com.intellij.ml.llm.matterhorn.run.PathConverter;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/matterhorn/run/docker/DockerPathConverter;", "Lcom/intellij/ml/llm/matterhorn/run/PathConverter;", "absoluteProjectPathInContainer", "Lcom/intellij/ml/llm/matterhorn/run/ExecutionPath;", "absoluteProjectPathInHost", "Lcom/intellij/ml/llm/matterhorn/run/LocalPath;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/run/ExecutionPath;Lcom/intellij/ml/llm/matterhorn/run/LocalPath;)V", "convertLocalPathToExecutionPath", "path", "convertExecutionPathToLocalPath", "ej-core"})
@SourceDebugExtension(value={"SMAP\nDockerExecutionEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerExecutionEnvironment.kt\ncom/intellij/ml/llm/matterhorn/run/docker/DockerPathConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1#2:331\n*E\n"})
public final class DockerPathConverter
implements PathConverter {
    @NotNull
    private final LocalPath absoluteProjectPathInHost;
    @NotNull
    private final ExecutionPath absoluteProjectPathInContainer;

    public DockerPathConverter(@NotNull ExecutionPath absoluteProjectPathInContainer, @NotNull LocalPath absoluteProjectPathInHost) {
        Intrinsics.checkNotNullParameter((Object)absoluteProjectPathInContainer, (String)"absoluteProjectPathInContainer");
        Intrinsics.checkNotNullParameter((Object)absoluteProjectPathInHost, (String)"absoluteProjectPathInHost");
        this.absoluteProjectPathInHost = absoluteProjectPathInHost;
        char[] cArray = new char[]{'/'};
        this.absoluteProjectPathInContainer = new ExecutionPath(StringsKt.trimEnd((String)absoluteProjectPathInContainer.getPath(), (char[])cArray));
    }

    @Override
    @NotNull
    public ExecutionPath convertLocalPathToExecutionPath(@NotNull LocalPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!path.getPath().isAbsolute()) {
            boolean $i$a$-require-DockerPathConverter$convertLocalPathToExecutionPath$22 = false;
            String $i$a$-require-DockerPathConverter$convertLocalPathToExecutionPath$22 = "The provided path must be absolute: " + path;
            throw new IllegalArgumentException($i$a$-require-DockerPathConverter$convertLocalPathToExecutionPath$22.toString());
        }
        Path relativePath = this.absoluteProjectPathInHost.getPath().relativize(path.getPath());
        String relativeExecutionPath = StringsKt.replace$default((String)((Object)relativePath).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
        if (((CharSequence)relativeExecutionPath).length() == 0) {
            return this.absoluteProjectPathInContainer;
        }
        return new ExecutionPath(this.absoluteProjectPathInContainer + "/" + relativeExecutionPath);
    }

    @Override
    @NotNull
    public LocalPath convertExecutionPathToLocalPath(@NotNull ExecutionPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Intrinsics.areEqual((Object)path, (Object)this.absoluteProjectPathInContainer)) {
            return this.absoluteProjectPathInHost;
        }
        if (!StringsKt.startsWith$default((String)path.getPath(), (String)this.absoluteProjectPathInContainer.getPath(), (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "The provided path must be absolute: " + path;
            throw new IllegalArgumentException(string.toString());
        }
        String string = path.getPath().substring(this.absoluteProjectPathInContainer.getPath().length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String relativePath = string;
        Path path2 = this.absoluteProjectPathInHost.getPath().resolve(relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return new LocalPath(path2);
    }
}

