/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.services.search;

import com.intellij.ml.llm.matterhorn.services.search.SearchResultsFilter;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\f0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\t*\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/matterhorn/services/search/DirectoryFilter;", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultsFilter;", "directory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lcom/intellij/psi/PsiDirectory;)V", "getDirectory", "()Lcom/intellij/psi/PsiDirectory;", "checkFile", "", "candidate", "Lcom/intellij/psi/PsiFile;", "getFilterText", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "isAncestor", "subDir", "ej-core"})
public final class DirectoryFilter
implements SearchResultsFilter {
    @NotNull
    private final PsiDirectory directory;

    public DirectoryFilter(@NotNull PsiDirectory directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directory = directory;
    }

    @NotNull
    public final PsiDirectory getDirectory() {
        return this.directory;
    }

    @Override
    public boolean checkFile(@NotNull PsiFile candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return this.isAncestor(this.directory, candidate.getContainingDirectory());
    }

    @Override
    @NotNull
    public String getFilterText() {
        String string = this.directory.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private final boolean isAncestor(PsiDirectory $this$isAncestor, PsiDirectory subDir) {
        PsiDirectory psiDirectory = subDir;
        return psiDirectory == null ? false : (Intrinsics.areEqual((Object)psiDirectory, (Object)$this$isAncestor) ? true : this.isAncestor($this$isAncestor, subDir.getParent()));
    }
}

