/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.tasks;

import com.intellij.ml.llm.matterhorn.tasks.persistence.StepEntity;
import com.intellij.ml.llm.matterhorn.tasks.persistence.TaskChainId;
import com.intellij.ml.llm.matterhorn.tasks.persistence.TaskEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0000J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/matterhorn/tasks/LiveTaskSnapshot;", "", "taskChainId", "Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskChainId;", "task", "Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskEntity;", "steps", "Lkotlinx/collections/immutable/PersistentList;", "Lcom/intellij/ml/llm/matterhorn/tasks/persistence/StepEntity;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskChainId;Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskEntity;Lkotlinx/collections/immutable/PersistentList;)V", "getTaskChainId", "()Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskChainId;", "getTask", "()Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskEntity;", "getSteps", "()Lkotlinx/collections/immutable/PersistentList;", "isDeclined", "", "()Z", "withDeclined", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "ej-core"})
public final class LiveTaskSnapshot {
    @NotNull
    private final TaskChainId taskChainId;
    @NotNull
    private final TaskEntity task;
    @NotNull
    private final PersistentList<StepEntity> steps;

    public LiveTaskSnapshot(@NotNull TaskChainId taskChainId, @NotNull TaskEntity task, @NotNull PersistentList<StepEntity> steps) {
        Intrinsics.checkNotNullParameter((Object)taskChainId, (String)"taskChainId");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        this.taskChainId = taskChainId;
        this.task = task;
        this.steps = steps;
    }

    @NotNull
    public final TaskChainId getTaskChainId() {
        return this.taskChainId;
    }

    @NotNull
    public final TaskEntity getTask() {
        return this.task;
    }

    @NotNull
    public final PersistentList<StepEntity> getSteps() {
        return this.steps;
    }

    public final boolean isDeclined() {
        return this.task.isDeclined();
    }

    @NotNull
    public final LiveTaskSnapshot withDeclined() {
        LiveTaskSnapshot liveTaskSnapshot;
        if (this.task.isDeclined()) {
            liveTaskSnapshot = this;
        } else {
            TaskEntity declinedTask = TaskEntity.copy$default(this.task, null, null, null, null, null, null, true, null, 191, null);
            liveTaskSnapshot = LiveTaskSnapshot.copy$default(this, null, declinedTask, null, 5, null);
        }
        return liveTaskSnapshot;
    }

    @NotNull
    public final TaskChainId component1() {
        return this.taskChainId;
    }

    @NotNull
    public final TaskEntity component2() {
        return this.task;
    }

    @NotNull
    public final PersistentList<StepEntity> component3() {
        return this.steps;
    }

    @NotNull
    public final LiveTaskSnapshot copy(@NotNull TaskChainId taskChainId, @NotNull TaskEntity task, @NotNull PersistentList<StepEntity> steps) {
        Intrinsics.checkNotNullParameter((Object)taskChainId, (String)"taskChainId");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        return new LiveTaskSnapshot(taskChainId, task, steps);
    }

    public static /* synthetic */ LiveTaskSnapshot copy$default(LiveTaskSnapshot liveTaskSnapshot, TaskChainId taskChainId, TaskEntity taskEntity, PersistentList persistentList, int n, Object object) {
        if ((n & 1) != 0) {
            taskChainId = liveTaskSnapshot.taskChainId;
        }
        if ((n & 2) != 0) {
            taskEntity = liveTaskSnapshot.task;
        }
        if ((n & 4) != 0) {
            persistentList = liveTaskSnapshot.steps;
        }
        return liveTaskSnapshot.copy(taskChainId, taskEntity, persistentList);
    }

    @NotNull
    public String toString() {
        return "LiveTaskSnapshot(taskChainId=" + this.taskChainId + ", task=" + this.task + ", steps=" + this.steps + ")";
    }

    public int hashCode() {
        int result = this.taskChainId.hashCode();
        result = result * 31 + this.task.hashCode();
        result = result * 31 + this.steps.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LiveTaskSnapshot)) {
            return false;
        }
        LiveTaskSnapshot liveTaskSnapshot = (LiveTaskSnapshot)other;
        if (!Intrinsics.areEqual((Object)this.taskChainId, (Object)liveTaskSnapshot.taskChainId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.task, (Object)liveTaskSnapshot.task)) {
            return false;
        }
        return Intrinsics.areEqual(this.steps, liveTaskSnapshot.steps);
    }
}

