/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.DataRowKt;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.ParserOptions;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.columns.ValueColumn;
import org.jetbrains.kotlinx.dataframe.impl.ColumnNameGenerator;
import org.jetbrains.kotlinx.dataframe.impl.api.ParseKt;
import org.jetbrains.kotlinx.dataframe.impl.api.Parsers;
import org.jetbrains.kotlinx.dataframe.impl.api.StringParser;
import org.jetbrains.kotlinx.dataframe.io.CSVType;
import org.jetbrains.kotlinx.dataframe.io.ColType;
import org.jetbrains.kotlinx.dataframe.io.CommonKt;
import org.jetbrains.kotlinx.dataframe.io.JsonKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001as\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a*\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u0001\u00a2\u0006\u0002\u0010#\u001a\u0081\u0001\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001a*\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u00012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u0010'\u001a\u008b\u0001\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001a*\u00020\u001b2\u0006\u0010(\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00142\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u00012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u0010)\u001a\u0081\u0001\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001a*\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u00012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u0010*\u001a\u0081\u0001\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001a*\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u00012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u0010+\u001a\u0097\u0001\u0010,\u001a\n\u0012\u0002\b\u00030\u001aj\u0002`-*\u00020\u001b2\u0006\u0010.\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\n2\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u00012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u00100\u001aa\u0010,\u001a\n\u0012\u0002\b\u00030\u001aj\u0002`-*\u00020\u001b2\u0006\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u00020\r2\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u00104\u001aG\u00105\u001a\u0006\u0012\u0002\b\u00030\u001a*\u00020\u001b2\u0006\u00106\u001a\u00020\u00062\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u00107\u001a\u001c\u00108\u001a\u00020\u0006*\n\u0012\u0002\b\u00030\u001aj\u0002`-2\b\b\u0002\u00103\u001a\u00020\r\u001a\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020;0:*\u00020\u001e\u001a$\u0010<\u001a\u00020=*\n\u0012\u0002\b\u00030\u001aj\u0002`-2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u00103\u001a\u00020\r\u001a$\u0010<\u001a\u00020=*\n\u0012\u0002\b\u00030\u001aj\u0002`-2\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u00103\u001a\u00020\r\u001a(\u0010<\u001a\u00020=*\n\u0012\u0002\b\u00030\u001aj\u0002`-2\n\u0010>\u001a\u00060?j\u0002`@2\b\b\u0002\u00103\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"defaultCharset", "Ljava/nio/charset/Charset;", "asStream", "Ljava/io/InputStream;", "kotlin.jvm.PlatformType", "fileOrUrl", "", "asURL", "Ljava/net/URL;", "getCSVType", "Lorg/jetbrains/kotlinx/dataframe/io/CSVType;", "path", "getFormat", "Lorg/apache/commons/csv/CSVFormat;", "type", "delimiter", "", "header", "", "duplicate", "", "isCompressed", "file", "Ljava/io/File;", "url", "read", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;", "colTypes", "", "Lorg/jetbrains/kotlinx/dataframe/io/ColType;", "skipLines", "", "readLines", "charset", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/lang/String;CLjava/util/List;Ljava/util/Map;ILjava/lang/Integer;ZLjava/nio/charset/Charset;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "readCSV", "parserOptions", "Lorg/jetbrains/kotlinx/dataframe/api/ParserOptions;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/File;CLjava/util/List;Ljava/util/Map;ILjava/lang/Integer;ZLjava/nio/charset/Charset;Lorg/jetbrains/kotlinx/dataframe/api/ParserOptions;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "stream", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/InputStream;CLjava/util/List;ZLjava/util/Map;ILjava/lang/Integer;ZLjava/nio/charset/Charset;Lorg/jetbrains/kotlinx/dataframe/api/ParserOptions;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/net/URL;CLjava/util/List;Ljava/util/Map;ILjava/lang/Integer;ZLjava/nio/charset/Charset;Lorg/jetbrains/kotlinx/dataframe/api/ParserOptions;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/lang/String;CLjava/util/List;Ljava/util/Map;ILjava/lang/Integer;ZLjava/nio/charset/Charset;Lorg/jetbrains/kotlinx/dataframe/api/ParserOptions;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "readDelim", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "inStream", "csvType", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/InputStream;CLjava/util/List;ZLorg/jetbrains/kotlinx/dataframe/io/CSVType;Ljava/util/Map;ILjava/lang/Integer;ZLjava/nio/charset/Charset;Lorg/jetbrains/kotlinx/dataframe/api/ParserOptions;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "reader", "Ljava/io/Reader;", "format", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/Reader;Lorg/apache/commons/csv/CSVFormat;Ljava/util/Map;ILjava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/api/ParserOptions;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "readDelimStr", "text", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/lang/String;Ljava/util/Map;ILjava/lang/Integer;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "toCsv", "toType", "Lkotlin/reflect/KClass;", "", "writeCSV", "", "writer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "core"})
@SourceDebugExtension(value={"SMAP\ncsv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 csv.kt\norg/jetbrains/kotlinx/dataframe/io/CsvKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 forEach.kt\norg/jetbrains/kotlinx/dataframe/api/ForEachKt\n*L\n1#1,361:1\n1#2:362\n37#3,2:363\n1549#4:365\n1620#4,3:366\n1549#4:369\n1620#4,3:370\n1559#4:373\n1590#4,3:374\n1549#4:377\n1620#4,3:378\n1593#4:381\n1855#4:383\n1549#4:384\n1620#4,3:385\n1856#4:388\n18#5:382\n*S KotlinDebug\n*F\n+ 1 csv.kt\norg/jetbrains/kotlinx/dataframe/io/CsvKt\n*L\n208#1:363,2\n291#1:365\n291#1:366,3\n294#1:369\n294#1:370,3\n296#1:373\n296#1:374,3\n300#1:377\n300#1:378,3\n296#1:381\n343#1:383\n344#1:384\n344#1:385,3\n343#1:388\n343#1:382\n*E\n"})
public final class CsvKt {
    @NotNull
    private static final Charset defaultCharset = Charsets.UTF_8;

    public static final boolean isCompressed(@NotNull String fileOrUrl) {
        Intrinsics.checkNotNullParameter((Object)fileOrUrl, (String)"fileOrUrl");
        Object[] objectArray = new String[]{"gz", "zip"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"."};
        return list.contains(CollectionsKt.last((List)StringsKt.split$default((CharSequence)fileOrUrl, (String[])objectArray, (boolean)false, (int)0, (int)6, null)));
    }

    public static final boolean isCompressed(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object[] objectArray = new String[]{"gz", "zip"};
        return CollectionsKt.listOf((Object[])objectArray).contains(FilesKt.getExtension((File)file));
    }

    public static final boolean isCompressed(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return CsvKt.isCompressed(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readDelimStr(@NotNull DataFrame.Companion $this$readDelimStr, @NotNull String text, @NotNull Map<String, ? extends ColType> colTypes, int skipLines, @Nullable Integer readLines) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readDelimStr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Closeable closeable = new StringReader(text);
        Throwable throwable = null;
        try {
            StringReader it = (StringReader)closeable;
            boolean bl = false;
            Reader reader = it;
            CSVFormat cSVFormat = CSVType.DEFAULT.getFormat().withHeader(new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)cSVFormat, (String)"withHeader(...)");
            dataFrame = CsvKt.readDelim$default($this$readDelimStr, reader, cSVFormat, colTypes, skipLines, readLines, null, 32, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readDelimStr$default(DataFrame.Companion companion, String string, Map map2, int n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return CsvKt.readDelimStr(companion, string, map2, n, n2);
    }

    @NotNull
    public static final DataFrame<?> read(@NotNull DataFrame.Companion $this$read, @NotNull String fileOrUrl, char delimiter, @NotNull List<String> header, @NotNull Map<String, ? extends ColType> colTypes, int skipLines, @Nullable Integer readLines, boolean duplicate, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileOrUrl, (String)"fileOrUrl");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CommonKt.catchHttpResponse(CsvKt.asURL(fileOrUrl), (Function1)new Function1<InputStream, DataFrame<?>>($this$read, delimiter, header, fileOrUrl, colTypes, skipLines, readLines, duplicate, charset){
            final /* synthetic */ DataFrame.Companion $this_read;
            final /* synthetic */ char $delimiter;
            final /* synthetic */ List<String> $header;
            final /* synthetic */ String $fileOrUrl;
            final /* synthetic */ Map<String, ColType> $colTypes;
            final /* synthetic */ int $skipLines;
            final /* synthetic */ Integer $readLines;
            final /* synthetic */ boolean $duplicate;
            final /* synthetic */ Charset $charset;
            {
                this.$this_read = $receiver;
                this.$delimiter = $delimiter;
                this.$header = $header;
                this.$fileOrUrl = $fileOrUrl;
                this.$colTypes = $colTypes;
                this.$skipLines = $skipLines;
                this.$readLines = $readLines;
                this.$duplicate = $duplicate;
                this.$charset = $charset;
                super(1);
            }

            @NotNull
            public final DataFrame<?> invoke(@NotNull InputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CsvKt.readDelim$default(this.$this_read, it, this.$delimiter, this.$header, CsvKt.isCompressed(this.$fileOrUrl), CsvKt.access$getCSVType(this.$fileOrUrl), this.$colTypes, this.$skipLines, this.$readLines, this.$duplicate, this.$charset, null, 1024, null);
            }
        });
    }

    public static /* synthetic */ DataFrame read$default(DataFrame.Companion companion, String string, char c, List list, Map map2, int n, Integer n2, boolean bl, Charset charset, int n3, Object object) {
        if ((n3 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n3 & 0x10) != 0) {
            n = 0;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            bl = true;
        }
        if ((n3 & 0x80) != 0) {
            charset = Charsets.UTF_8;
        }
        return CsvKt.read(companion, string, c, list, map2, n, n2, bl, charset);
    }

    @NotNull
    public static final DataFrame<?> readCSV(@NotNull DataFrame.Companion $this$readCSV, @NotNull String fileOrUrl, char delimiter, @NotNull List<String> header, @NotNull Map<String, ? extends ColType> colTypes, int skipLines, @Nullable Integer readLines, boolean duplicate, @NotNull Charset charset, @Nullable ParserOptions parserOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$readCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileOrUrl, (String)"fileOrUrl");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CommonKt.catchHttpResponse(CsvKt.asURL(fileOrUrl), (Function1)new Function1<InputStream, DataFrame<?>>($this$readCSV, delimiter, header, fileOrUrl, colTypes, skipLines, readLines, duplicate, charset, parserOptions){
            final /* synthetic */ DataFrame.Companion $this_readCSV;
            final /* synthetic */ char $delimiter;
            final /* synthetic */ List<String> $header;
            final /* synthetic */ String $fileOrUrl;
            final /* synthetic */ Map<String, ColType> $colTypes;
            final /* synthetic */ int $skipLines;
            final /* synthetic */ Integer $readLines;
            final /* synthetic */ boolean $duplicate;
            final /* synthetic */ Charset $charset;
            final /* synthetic */ ParserOptions $parserOptions;
            {
                this.$this_readCSV = $receiver;
                this.$delimiter = $delimiter;
                this.$header = $header;
                this.$fileOrUrl = $fileOrUrl;
                this.$colTypes = $colTypes;
                this.$skipLines = $skipLines;
                this.$readLines = $readLines;
                this.$duplicate = $duplicate;
                this.$charset = $charset;
                this.$parserOptions = $parserOptions;
                super(1);
            }

            @NotNull
            public final DataFrame<?> invoke(@NotNull InputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CsvKt.readDelim(this.$this_readCSV, it, this.$delimiter, this.$header, CsvKt.isCompressed(this.$fileOrUrl), CSVType.DEFAULT, this.$colTypes, this.$skipLines, this.$readLines, this.$duplicate, this.$charset, this.$parserOptions);
            }
        });
    }

    public static /* synthetic */ DataFrame readCSV$default(DataFrame.Companion companion, String string, char c, List list, Map map2, int n, Integer n2, boolean bl, Charset charset, ParserOptions parserOptions, int n3, Object object) {
        if ((n3 & 2) != 0) {
            c = (char)44;
        }
        if ((n3 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n3 & 0x10) != 0) {
            n = 0;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            bl = true;
        }
        if ((n3 & 0x80) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n3 & 0x100) != 0) {
            parserOptions = null;
        }
        return CsvKt.readCSV(companion, string, c, (List<String>)list, (Map<String, ? extends ColType>)map2, n, n2, bl, charset, parserOptions);
    }

    @NotNull
    public static final DataFrame<?> readCSV(@NotNull DataFrame.Companion $this$readCSV, @NotNull File file, char delimiter, @NotNull List<String> header, @NotNull Map<String, ? extends ColType> colTypes, int skipLines, @Nullable Integer readLines, boolean duplicate, @NotNull Charset charset, @Nullable ParserOptions parserOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$readCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CsvKt.readDelim($this$readCSV, new FileInputStream(file), delimiter, header, CsvKt.isCompressed(file), CSVType.DEFAULT, colTypes, skipLines, readLines, duplicate, charset, parserOptions);
    }

    public static /* synthetic */ DataFrame readCSV$default(DataFrame.Companion companion, File file, char c, List list, Map map2, int n, Integer n2, boolean bl, Charset charset, ParserOptions parserOptions, int n3, Object object) {
        if ((n3 & 2) != 0) {
            c = (char)44;
        }
        if ((n3 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n3 & 0x10) != 0) {
            n = 0;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            bl = true;
        }
        if ((n3 & 0x80) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n3 & 0x100) != 0) {
            parserOptions = null;
        }
        return CsvKt.readCSV(companion, file, c, (List<String>)list, (Map<String, ? extends ColType>)map2, n, n2, bl, charset, parserOptions);
    }

    @NotNull
    public static final DataFrame<?> readCSV(@NotNull DataFrame.Companion $this$readCSV, @NotNull URL url, char delimiter, @NotNull List<String> header, @NotNull Map<String, ? extends ColType> colTypes, int skipLines, @Nullable Integer readLines, boolean duplicate, @NotNull Charset charset, @Nullable ParserOptions parserOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$readCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        InputStream inputStream = url.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
        return CsvKt.readCSV($this$readCSV, inputStream, delimiter, header, CsvKt.isCompressed(url), colTypes, skipLines, readLines, duplicate, charset, parserOptions);
    }

    public static /* synthetic */ DataFrame readCSV$default(DataFrame.Companion companion, URL uRL, char c, List list, Map map2, int n, Integer n2, boolean bl, Charset charset, ParserOptions parserOptions, int n3, Object object) {
        if ((n3 & 2) != 0) {
            c = (char)44;
        }
        if ((n3 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n3 & 0x10) != 0) {
            n = 0;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            bl = true;
        }
        if ((n3 & 0x80) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n3 & 0x100) != 0) {
            parserOptions = null;
        }
        return CsvKt.readCSV(companion, uRL, c, (List<String>)list, (Map<String, ? extends ColType>)map2, n, n2, bl, charset, parserOptions);
    }

    @NotNull
    public static final DataFrame<?> readCSV(@NotNull DataFrame.Companion $this$readCSV, @NotNull InputStream stream, char delimiter, @NotNull List<String> header, boolean isCompressed, @NotNull Map<String, ? extends ColType> colTypes, int skipLines, @Nullable Integer readLines, boolean duplicate, @NotNull Charset charset, @Nullable ParserOptions parserOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$readCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CsvKt.readDelim($this$readCSV, stream, delimiter, header, isCompressed, CSVType.DEFAULT, colTypes, skipLines, readLines, duplicate, charset, parserOptions);
    }

    public static /* synthetic */ DataFrame readCSV$default(DataFrame.Companion companion, InputStream inputStream, char c, List list, boolean bl, Map map2, int n, Integer n2, boolean bl2, Charset charset, ParserOptions parserOptions, int n3, Object object) {
        if ((n3 & 2) != 0) {
            c = (char)44;
        }
        if ((n3 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x10) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n3 & 0x20) != 0) {
            n = 0;
        }
        if ((n3 & 0x40) != 0) {
            n2 = null;
        }
        if ((n3 & 0x80) != 0) {
            bl2 = true;
        }
        if ((n3 & 0x100) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n3 & 0x200) != 0) {
            parserOptions = null;
        }
        return CsvKt.readCSV(companion, inputStream, c, list, bl, map2, n, n2, bl2, charset, parserOptions);
    }

    private static final CSVType getCSVType(String path) {
        CSVType cSVType;
        String string = StringsKt.substringAfterLast$default((String)path, (char)'.', null, (int)2, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = string;
        if (Intrinsics.areEqual((Object)string2, (Object)"csv")) {
            cSVType = CSVType.DEFAULT;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"tdf")) {
            cSVType = CSVType.TDF;
        } else {
            throw new IOException("Unknown file format");
        }
        return cSVType;
    }

    private static final InputStream asStream(String fileOrUrl) {
        return (CommonKt.isURL(fileOrUrl) ? new URL(fileOrUrl).toURI() : new File(fileOrUrl).toURI()).toURL().openStream();
    }

    @NotNull
    public static final URL asURL(@NotNull String fileOrUrl) {
        Intrinsics.checkNotNullParameter((Object)fileOrUrl, (String)"fileOrUrl");
        URL uRL = (CommonKt.isURL(fileOrUrl) ? new URL(fileOrUrl).toURI() : new File(fileOrUrl).toURI()).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    private static final CSVFormat getFormat(CSVType type, char delimiter, List<String> header, boolean duplicate) {
        Collection $this$toTypedArray$iv = header;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        CSVFormat cSVFormat = type.getFormat().withDelimiter(delimiter).withHeader(Arrays.copyOf(stringArray, stringArray.length)).withAllowDuplicateHeaderNames(duplicate);
        Intrinsics.checkNotNullExpressionValue((Object)cSVFormat, (String)"withAllowDuplicateHeaderNames(...)");
        return cSVFormat;
    }

    @NotNull
    public static final DataFrame<?> readDelim(@NotNull DataFrame.Companion $this$readDelim, @NotNull InputStream inStream, char delimiter, @NotNull List<String> header, boolean isCompressed, @NotNull CSVType csvType, @NotNull Map<String, ? extends ColType> colTypes, int skipLines, @Nullable Integer readLines, boolean duplicate, @NotNull Charset charset, @Nullable ParserOptions parserOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$readDelim, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inStream, (String)"inStream");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)((Object)csvType), (String)"csvType");
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Reader $this$readDelim_u24lambda_u241 = isCompressed ? (Reader)new InputStreamReader((InputStream)new GZIPInputStream(inStream), charset) : (Reader)new BufferedReader(new InputStreamReader(inStream, charset));
        boolean bl = false;
        return CsvKt.readDelim($this$readDelim, $this$readDelim_u24lambda_u241, CsvKt.getFormat(csvType, delimiter, header, duplicate), colTypes, skipLines, readLines, parserOptions);
    }

    public static /* synthetic */ DataFrame readDelim$default(DataFrame.Companion companion, InputStream inputStream, char c, List list, boolean bl, CSVType cSVType, Map map2, int n, Integer n2, boolean bl2, Charset charset, ParserOptions parserOptions, int n3, Object object) {
        if ((n3 & 2) != 0) {
            c = (char)44;
        }
        if ((n3 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x20) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n3 & 0x40) != 0) {
            n = 0;
        }
        if ((n3 & 0x80) != 0) {
            n2 = null;
        }
        if ((n3 & 0x100) != 0) {
            bl2 = true;
        }
        if ((n3 & 0x200) != 0) {
            charset = defaultCharset;
        }
        if ((n3 & 0x400) != 0) {
            parserOptions = null;
        }
        return CsvKt.readDelim(companion, inputStream, c, list, bl, cSVType, map2, n, n2, bl2, charset, parserOptions);
    }

    @NotNull
    public static final KClass<? extends Object> toType(@NotNull ColType $this$toType) {
        KClass kClass;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toType.ordinal()]) {
            case 1: {
                kClass = Reflection.getOrCreateKotlinClass(Integer.TYPE);
                break;
            }
            case 2: {
                kClass = Reflection.getOrCreateKotlinClass(Long.TYPE);
                break;
            }
            case 3: {
                kClass = Reflection.getOrCreateKotlinClass(Double.TYPE);
                break;
            }
            case 4: {
                kClass = Reflection.getOrCreateKotlinClass(Boolean.TYPE);
                break;
            }
            case 5: {
                kClass = Reflection.getOrCreateKotlinClass(BigDecimal.class);
                break;
            }
            case 6: {
                kClass = Reflection.getOrCreateKotlinClass(LocalDate.class);
                break;
            }
            case 7: {
                kClass = Reflection.getOrCreateKotlinClass(LocalTime.class);
                break;
            }
            case 8: {
                kClass = Reflection.getOrCreateKotlinClass(LocalDateTime.class);
                break;
            }
            case 9: {
                kClass = Reflection.getOrCreateKotlinClass(String.class);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return kClass;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataFrame<?> readDelim(@NotNull DataFrame.Companion $this$readDelim, @NotNull Reader reader, @NotNull CSVFormat format2, @NotNull Map<String, ? extends ColType> colTypes, int skipLines, @Nullable Integer readLines, @Nullable ParserOptions parserOptions) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable<String> iterable;
        Iterable destination$iv$iv;
        List count22;
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$readDelim, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Reader reader2 = null;
        reader2 = reader;
        if (skipLines > 0) {
            reader2 = new BufferedReader(reader2);
            int n = 0;
            while (n < skipLines) {
                int it = n++;
                boolean bl = false;
                ((BufferedReader)reader2).readLine();
            }
        }
        CSVParser csvParser = format2.parse(reader2);
        if (readLines == null) {
            list = csvParser.getRecords();
        } else {
            if (!(readLines >= 0)) {
                boolean $i$a$-require-CsvKt$readDelim$records$22 = false;
                String $i$a$-require-CsvKt$readDelim$records$22 = "`readLines` must not be negative";
                throw new IllegalArgumentException($i$a$-require-CsvKt$readDelim$records$22.toString());
            }
            ArrayList records = new ArrayList(readLines);
            Iterator iterator2 = csvParser.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
            Iterator iter = iterator2;
            int count22 = readLines;
            while (iter.hasNext() && 0 < count22--) {
                records.add(iter.next());
            }
            list = records;
        }
        List records = list;
        List it = count22 = csvParser.getHeaderNames();
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        List list2 = !((Collection)it).isEmpty() ? count22 : null;
        if (list2 == null) {
            void $this$mapTo$iv$iv2;
            Object e = records.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            Iterable $this$map$iv = (Iterable)new IntRange(1, CollectionsKt.count((Iterable)((Iterable)e)));
            boolean $i$f$map = false;
            Iterable bl2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                void index;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator3).nextInt();
                iterable = destination$iv$iv;
                boolean bl3 = false;
                iterable.add((String)("" + 'X' + (int)index));
            }
            list2 = (List)destination$iv$iv;
        }
        List columnNames = list2;
        ColumnNameGenerator generator = new ColumnNameGenerator(null, 1, null);
        Iterable $this$map$iv = columnNames;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String bl3 = (String)item$iv$iv;
            iterable = destination$iv$iv2;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it2);
            iterable.add(generator.addUnique((String)it2));
        }
        List uniqueNames = (List)destination$iv$iv2;
        Iterable $this$mapIndexed$iv = uniqueNames;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv2 = $this$mapIndexed$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            DataColumn<Object> dataColumn;
            void $this$mapTo$iv$iv3;
            void colName;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            iterable = destination$iv$iv3;
            boolean bl5 = false;
            ColType defaultColType = colTypes.get(".default");
            ColType colType = colTypes.get(colName);
            if (colType == null) {
                colType = defaultColType;
            }
            ColType colType2 = colType;
            boolean hasNulls = false;
            Intrinsics.checkNotNull((Object)records);
            Iterable $this$map$iv2 = records;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                String string2;
                void colIndex;
                void it3;
                CSVRecord cSVRecord = (CSVRecord)item$iv$iv2;
                Collection collection = destination$iv$iv4;
                boolean bl6 = false;
                if (it3.isSet((int)colIndex)) {
                    CharSequence charSequence;
                    CharSequence charSequence2 = it3.get((int)colIndex);
                    if (charSequence2.length() == 0) {
                        boolean bl7 = false;
                        hasNulls = true;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    string2 = (String)charSequence;
                } else {
                    hasNulls = true;
                    string2 = null;
                }
                collection.add(string2);
            }
            List values2 = (List)destination$iv$iv4;
            ValueColumn column2 = DataColumn.Companion.createValueColumn$default(DataColumn.Companion, (String)colName, values2, KTypes.withNullability((KType)Reflection.typeOf(String.class), (boolean)hasNulls), null, null, 24, null);
            ColType colType3 = colType2;
            if ((colType3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[colType3.ordinal()]) == -1) {
                dataColumn = org.jetbrains.kotlinx.dataframe.api.ParseKt.tryParse(column2, parserOptions);
            } else {
                StringParser<? extends Object> parser2;
                Intrinsics.checkNotNull(Parsers.INSTANCE.get(CsvKt.toType(colType2)));
                dataColumn = ParseKt.parse(column2, parser2, parserOptions);
            }
            iterable.add(dataColumn);
        }
        List cols2 = (List)destination$iv$iv3;
        return ToDataFrameKt.toDataFrameAnyColumn(cols2);
    }

    public static /* synthetic */ DataFrame readDelim$default(DataFrame.Companion companion, Reader reader, CSVFormat cSVFormat, Map map2, int n, Integer n2, ParserOptions parserOptions, int n3, Object object) {
        if ((n3 & 2) != 0) {
            CSVFormat cSVFormat2 = CSVFormat.DEFAULT.withHeader(new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)cSVFormat2, (String)"withHeader(...)");
            cSVFormat = cSVFormat2;
        }
        if ((n3 & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n3 & 8) != 0) {
            n = 0;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            parserOptions = null;
        }
        return CsvKt.readDelim(companion, reader, cSVFormat, map2, n, n2, parserOptions);
    }

    public static final void writeCSV(@NotNull DataFrame<?> $this$writeCSV, @NotNull File file, @NotNull CSVFormat format2) {
        Intrinsics.checkNotNullParameter($this$writeCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        CsvKt.writeCSV($this$writeCSV, new FileWriter(file), format2);
    }

    public static /* synthetic */ void writeCSV$default(DataFrame dataFrame, File file, CSVFormat cSVFormat, int n, Object object) {
        if ((n & 2) != 0) {
            CSVFormat cSVFormat2 = CSVFormat.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)cSVFormat2, (String)"DEFAULT");
            cSVFormat = cSVFormat2;
        }
        CsvKt.writeCSV(dataFrame, file, cSVFormat);
    }

    public static final void writeCSV(@NotNull DataFrame<?> $this$writeCSV, @NotNull String path, @NotNull CSVFormat format2) {
        Intrinsics.checkNotNullParameter($this$writeCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        CsvKt.writeCSV($this$writeCSV, new FileWriter(path), format2);
    }

    public static /* synthetic */ void writeCSV$default(DataFrame dataFrame, String string, CSVFormat cSVFormat, int n, Object object) {
        if ((n & 2) != 0) {
            CSVFormat cSVFormat2 = CSVFormat.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)cSVFormat2, (String)"DEFAULT");
            cSVFormat = cSVFormat2;
        }
        CsvKt.writeCSV(dataFrame, string, cSVFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void writeCSV(@NotNull DataFrame<?> $this$writeCSV, @NotNull Appendable writer, @NotNull CSVFormat format2) {
        Intrinsics.checkNotNullParameter($this$writeCSV, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Closeable closeable = (Closeable)format2.print(writer);
        Throwable throwable = null;
        try {
            CSVPrinter printer = (CSVPrinter)closeable;
            boolean bl = false;
            if (!format2.getSkipHeaderRecord()) {
                printer.printRecord((Iterable)$this$writeCSV.columnNames());
            }
            DataFrame<?> $this$forEach$iv = $this$writeCSV;
            boolean $i$f$forEach = false;
            Iterable<DataRow<?>> $this$forEach$iv$iv = DataFrameGetKt.rows($this$forEach$iv);
            boolean $i$f$forEach2 = false;
            Iterator<DataRow<?>> iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                void it;
                DataRow<?> element$iv$iv;
                DataRow<?> it$iv = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                DataRow<?> dataRow = it$iv;
                DataRow<?> $this$writeCSV_u24lambda_u2412_u24lambda_u2411 = it$iv;
                boolean bl3 = false;
                Iterable $this$map$iv = DataRowKt.getValues(it);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    void it2;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator3.next();
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    void var28_30 = it2;
                    collection.add(var28_30 instanceof DataRow ? JsonKt.toJson$default((DataRow)it2, false, false, 3, null) : (var28_30 instanceof DataFrame ? JsonKt.toJson$default((DataFrame)it2, false, false, 3, null) : it2));
                }
                List values2 = (List)destination$iv$iv;
                printer.printRecord((Iterable)values2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeCSV$default(DataFrame dataFrame, Appendable appendable, CSVFormat cSVFormat, int n, Object object) {
        if ((n & 2) != 0) {
            CSVFormat cSVFormat2 = CSVFormat.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)cSVFormat2, (String)"DEFAULT");
            cSVFormat = cSVFormat2;
        }
        CsvKt.writeCSV(dataFrame, appendable, cSVFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String toCsv(@NotNull DataFrame<?> $this$toCsv, @NotNull CSVFormat format2) {
        StringWriter stringWriter;
        Intrinsics.checkNotNullParameter($this$toCsv, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter it = (StringWriter)closeable;
            boolean bl = false;
            CsvKt.writeCSV($this$toCsv, it, format2);
            stringWriter = it;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String toCsv$default(DataFrame dataFrame, CSVFormat cSVFormat, int n, Object object) {
        if ((n & 1) != 0) {
            CSVFormat cSVFormat2 = CSVFormat.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)cSVFormat2, (String)"DEFAULT");
            cSVFormat = cSVFormat2;
        }
        return CsvKt.toCsv(dataFrame, cSVFormat);
    }

    public static final /* synthetic */ CSVType access$getCSVType(String path) {
        return CsvKt.getCSVType(path);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColType.values().length];
            try {
                nArray[ColType.Int.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.Long.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.Double.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.Boolean.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.BigDecimal.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.LocalDate.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.LocalTime.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.LocalDateTime.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColType.String.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

