/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.CellAttributes;
import org.jetbrains.kotlinx.dataframe.api.DataColumnTypeKt;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.FormattingDSL;
import org.jetbrains.kotlinx.dataframe.api.IsEmptyKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.impl.MathUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;
import org.jetbrains.kotlinx.dataframe.io.Border;
import org.jetbrains.kotlinx.dataframe.io.ColumnDataForJs;
import org.jetbrains.kotlinx.dataframe.io.ColumnWithPathWithBorder;
import org.jetbrains.kotlinx.dataframe.io.DataFrameFormatter;
import org.jetbrains.kotlinx.dataframe.io.DataFrameHtmlData;
import org.jetbrains.kotlinx.dataframe.io.DataFrameReference;
import org.jetbrains.kotlinx.dataframe.io.DisplayConfiguration;
import org.jetbrains.kotlinx.dataframe.io.HtmlContent;
import org.jetbrains.kotlinx.dataframe.io.HtmlKt;
import org.jetbrains.kotlinx.dataframe.io.RendererDecimalFormat;
import org.jetbrains.kotlinx.dataframe.io.StringKt;
import org.jetbrains.kotlinx.dataframe.jupyter.CellRenderer;
import org.jetbrains.kotlinx.dataframe.jupyter.DefaultCellRenderer;
import org.jetbrains.kotlinx.dataframe.jupyter.RenderedContent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001aA\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132*\u0010\u0016\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u00180\u0017\"\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\u00a2\u0006\u0002\u0010\u001a\u001a!\u0010\u001b\u001a\u00020\u00132\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0017\"\u00020\u0013H\u0000\u00a2\u0006\u0002\u0010\u001c\u001a\b\u0010\u001d\u001a\u00020\u0001H\u0000\u001a,\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%\u001a.\u0010&\u001a\u00020\u00132\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u0001H\u0000\u001a\f\u0010-\u001a\u00020\u0013*\u00020\u0013H\u0000\u001a\f\u0010.\u001a\u00020\u0013*\u00020\u0013H\u0000\u001a\f\u0010/\u001a\u00020\u0013*\u00020\u0013H\u0000\u001a$\u00100\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003010(0(*\n\u0012\u0002\b\u000302j\u0002`3H\u0002\u001a\u0018\u00104\u001a\u00020\u0013\"\u0004\b\u0000\u00105*\b\u0012\u0004\u0012\u0002H502H\u0007\u001a\u001e\u00106\u001a\u00020\u0001*\n\u0012\u0002\b\u000302j\u0002`32\b\b\u0002\u00107\u001a\u00020\u0001H\u0000\u001a\u0010\u00108\u001a\u00020\u0001*\u0006\u0012\u0002\b\u000309H\u0000\u001a\f\u0010:\u001a\u00020;*\u00020<H\u0000\u001a\f\u0010=\u001a\u00020\u0013*\u00020)H\u0000\u001a\u0012\u0010>\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020@0?H\u0002\u001aH\u0010A\u001a\u00020<\"\u0004\b\u0000\u00105*\b\u0012\u0004\u0012\u0002H5022\b\b\u0002\u0010B\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020E2\u001c\b\u0002\u0010F\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H502\u0012\u0006\u0012\u0004\u0018\u00010\u00130G\u001a&\u0010H\u001a\u00020<*\n\u0012\u0002\b\u000302j\u0002`32\b\b\u0002\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0000\u001aH\u0010I\u001a\u00020<\"\u0004\b\u0000\u00105*\b\u0012\u0004\u0012\u0002H5022\b\b\u0002\u0010B\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020E2\u001c\b\u0002\u0010F\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H502\u0012\u0006\u0012\u0004\u0018\u00010\u00130G\u001a:\u0010J\u001a\u00020<*\n\u0012\u0002\b\u000302j\u0002`32\b\b\u0002\u0010B\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020E2\b\b\u0002\u0010K\u001a\u00020\u00112\b\b\u0002\u0010L\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0006\u001a\u00020\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\"\u001a\u0010\u000b\u001a\u00020\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\"\u0014\u0010\u000e\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006M"}, d2={"defaultPrecision", "", "formatter", "Lorg/jetbrains/kotlinx/dataframe/io/DataFrameFormatter;", "getFormatter", "()Lorg/jetbrains/kotlinx/dataframe/io/DataFrameFormatter;", "sessionId", "getSessionId", "()I", "setSessionId", "(I)V", "tableInSessionId", "getTableInSessionId", "setTableInSessionId", "tooltipLimit", "getTooltipLimit", "flagFromEnv", "", "envName", "", "getResourceText", "resource", "replacement", "", "Lkotlin/Pair;", "", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "getResources", "([Ljava/lang/String;)Ljava/lang/String;", "nextTableId", "renderValueForHtml", "Lorg/jetbrains/kotlinx/dataframe/jupyter/RenderedContent;", "value", "truncate", "format", "Lorg/jetbrains/kotlinx/dataframe/io/RendererDecimalFormat;", "renderValueForHtml-uKGgf_E", "(Ljava/lang/Object;ILjava/lang/String;)Lorg/jetbrains/kotlinx/dataframe/jupyter/RenderedContent;", "tableJs", "columns", "", "Lorg/jetbrains/kotlinx/dataframe/io/ColumnDataForJs;", "id", "rootId", "nrow", "escapeForHtmlInJs", "escapeHTML", "escapeNewLines", "getColumnsHeaderGrid", "Lorg/jetbrains/kotlinx/dataframe/io/ColumnWithPathWithBorder;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "html", "T", "maxDepth", "startingAt", "maxWidth", "Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "print", "", "Lorg/jetbrains/kotlinx/dataframe/io/DataFrameHtmlData;", "renderHeader", "toClass", "", "Lorg/jetbrains/kotlinx/dataframe/io/Border;", "toHTML", "configuration", "Lorg/jetbrains/kotlinx/dataframe/io/DisplayConfiguration;", "cellRenderer", "Lorg/jetbrains/kotlinx/dataframe/jupyter/CellRenderer;", "getFooter", "Lkotlin/Function1;", "toHtmlData", "toStandaloneHTML", "toStaticHtml", "includeCss", "openNestedDfs", "core"})
@SourceDebugExtension(value={"SMAP\nhtml.kt\nKotlin\n*S Kotlin\n*F\n+ 1 html.kt\norg/jetbrains/kotlinx/dataframe/io/HtmlKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 DataColumnType.kt\norg/jetbrains/kotlinx/dataframe/api/DataColumnTypeKt\n*L\n1#1,821:1\n13309#2,2:822\n1855#3,2:824\n1549#3:826\n1620#3,3:827\n1549#3:830\n1620#3,3:831\n1549#3:835\n1620#3,3:836\n1549#3:839\n1620#3,3:840\n1549#3:843\n1620#3,3:844\n1#4:834\n21#5:847\n*S KotlinDebug\n*F\n+ 1 html.kt\norg/jetbrains/kotlinx/dataframe/io/HtmlKt\n*L\n72#1:822,2\n113#1:824,2\n176#1:826\n176#1:827,3\n210#1:830\n210#1:831,3\n88#1:835\n88#1:836,3\n146#1:839\n146#1:840,3\n165#1:843\n165#1:844,3\n166#1:847\n*E\n"})
public final class HtmlKt {
    private static final int tooltipLimit = 1000;
    @NotNull
    private static final DataFrameFormatter formatter = new DataFrameFormatter("formatted", "null", "structural", "numbers", "dataFrameCaption");
    private static int tableInSessionId;
    private static int sessionId;
    public static final int defaultPrecision = 6;

    public static final int getTooltipLimit() {
        return tooltipLimit;
    }

    @NotNull
    public static final DataFrameFormatter getFormatter() {
        return formatter;
    }

    @NotNull
    public static final String getResources(String ... resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return ArraysKt.joinToString$default((Object[])resource, (CharSequence)"\n", null, null, (int)0, null, (Function1)getResources.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String getResourceText(@NotNull String resource, Pair<String, ? extends Object> ... replacement) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter(replacement, (String)"replacement");
        InputStream inputStream = DataFrame.class.getResourceAsStream(resource);
        if (inputStream == null) {
            throw new IllegalStateException(("Resource '" + resource + "' not found").toString());
        }
        InputStream res2 = inputStream;
        String template = null;
        template = TextStreamsKt.readText((Reader)new InputStreamReader(res2));
        Pair<String, ? extends Object>[] $this$forEach$iv = replacement;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair<String, ? extends Object> element$iv;
            Pair<String, ? extends Object> it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            template = StringsKt.replace$default((String)template, (String)((String)it.getFirst()), (String)it.getSecond().toString(), (boolean)false, (int)4, null);
        }
        return template;
    }

    @NotNull
    public static final String renderHeader(@NotNull ColumnDataForJs $this$renderHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$renderHeader, (String)"<this>");
        String tooltip = DataColumnKt.getName($this$renderHeader.getColumn()) + ": " + RenderingKt.renderType($this$renderHeader.getColumn().type());
        return "<span title=\"" + tooltip + "\">" + $this$renderHeader.getColumn().name() + "</span>";
    }

    @NotNull
    public static final String tableJs(@NotNull List<ColumnDataForJs> columns2, int id2, int rootId, int nrow) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Ref.IntRef index = new Ref.IntRef();
        StringBuilder $this$tableJs_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$tableJs_u24lambda_u243.append("[");
        Iterable $this$forEach$iv = columns2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColumnDataForJs it = (ColumnDataForJs)element$iv;
            boolean bl2 = false;
            HtmlKt.tableJs$lambda$3$appendColWithChildren(index, $this$tableJs_u24lambda_u243, it);
        }
        $this$tableJs_u24lambda_u243.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String data2 = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"___COLUMNS___", (Object)data2), TuplesKt.to((Object)"___ID___", (Object)id2), TuplesKt.to((Object)"___ROOT___", (Object)rootId), TuplesKt.to((Object)"___NROW___", (Object)nrow)};
        String js = HtmlKt.getResourceText("/addTable.js", pairArray);
        return js;
    }

    public static final int getTableInSessionId() {
        return tableInSessionId;
    }

    public static final void setTableInSessionId(int n) {
        tableInSessionId = n;
    }

    public static final int getSessionId() {
        return sessionId;
    }

    public static final void setSessionId(int n) {
        sessionId = n;
    }

    public static final int nextTableId() {
        int n = tableInSessionId;
        tableInSessionId = n + 1;
        return sessionId + n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataFrameHtmlData toHtmlData(@NotNull DataFrame<?> $this$toHtmlData, @NotNull DisplayConfiguration configuration, @NotNull CellRenderer cellRenderer) {
        Object nextDf;
        Intrinsics.checkNotNullParameter($this$toHtmlData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"cellRenderer");
        List scripts = new ArrayList();
        LinkedList queue = new LinkedList();
        int rootId = HtmlKt.nextTableId();
        queue.add(TuplesKt.to($this$toHtmlData, (Object)rootId));
        while (!queue.isEmpty()) {
            void $this$mapTo$iv$iv;
            Pair pair = (Pair)queue.pop();
            nextDf = (DataFrame)pair.component1();
            int nextId = ((Number)pair.component2()).intValue();
            Integer rowsLimit = nextId == rootId ? configuration.getRowsLimit() : configuration.getNestedRowsLimit();
            Iterable $this$map$iv = nextDf.columns();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataColumn dataColumn = (DataColumn)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(HtmlKt.toHtmlData$columnToJs(nextDf, configuration, queue, cellRenderer, it, rowsLimit));
            }
            List preparedColumns = (List)destination$iv$iv;
            String js = HtmlKt.tableJs(preparedColumns, nextId, rootId, DataFrameKt.getNrow(nextDf));
            scripts.add(js);
        }
        nextDf = new Pair[]{TuplesKt.to((Object)"ID", (Object)rootId)};
        String body = HtmlKt.getResourceText("/table.html", nextDf);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"___ID___", (Object)rootId)};
        String script = CollectionsKt.joinToString$default((Iterable)scripts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + '\n' + HtmlKt.getResourceText("/renderTable.js", pairArray);
        return new DataFrameHtmlData("", body, script);
    }

    public static /* synthetic */ DataFrameHtmlData toHtmlData$default(DataFrame dataFrame, DisplayConfiguration displayConfiguration, CellRenderer cellRenderer, int n, Object object) {
        if ((n & 1) != 0) {
            displayConfiguration = DisplayConfiguration.Companion.getDEFAULT();
        }
        return HtmlKt.toHtmlData(dataFrame, displayConfiguration, cellRenderer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataFrameHtmlData toStaticHtml(@NotNull DataFrame<?> $this$toStaticHtml, @NotNull DisplayConfiguration configuration, @NotNull CellRenderer cellRenderer, boolean includeCss, boolean openNestedDfs) {
        void $this$toStaticHtml_u24lambda_u249;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toStaticHtml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"cellRenderer");
        DataFrame<?> df2 = $this$toStaticHtml;
        String id2 = "static_df_" + HtmlKt.nextTableId();
        List flattenedCols2 = DataFrameGetKt.getColumnsWithPaths($this$toStaticHtml, toStaticHtml.flattenedCols.1.INSTANCE);
        List<List<ColumnWithPathWithBorder<?>>> colGrid = HtmlKt.getColumnsHeaderGrid($this$toStaticHtml);
        Iterable $this$map$iv = (Iterable)CollectionsKt.last(colGrid);
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnWithPathWithBorder columnWithPathWithBorder = (ColumnWithPathWithBorder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SetsKt.minus(it.getBorders(), (Object)((Object)Border.BOTTOM)));
        }
        List borders = (List)destination$iv$iv;
        Integer nestedRowsLimit = configuration.getNestedRowsLimit();
        Integer rowsLimit = configuration.getRowsLimit();
        destination$iv$iv = object = new StringBuilder();
        String string = null;
        boolean bl = false;
        HtmlKt.toStaticHtml$emitTable((StringBuilder)$this$toStaticHtml_u24lambda_u249, id2, colGrid, $this$toStaticHtml, rowsLimit, df2, flattenedCols2, borders, openNestedDfs, cellRenderer, configuration, nestedRowsLimit);
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 1;
        String string3 = StringsKt.trimIndent((String)("\n            document.getElementById(\"" + id2 + "\").style.display = \"none\";\n        "));
        String string4 = string2;
        String string5 = string;
        return new DataFrameHtmlData(string5, string4, string3, n, defaultConstructorMarker).plus(DataFrameHtmlData.Companion.tableDefinitions(false, includeCss));
    }

    public static /* synthetic */ DataFrameHtmlData toStaticHtml$default(DataFrame dataFrame, DisplayConfiguration displayConfiguration, CellRenderer cellRenderer, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            displayConfiguration = DisplayConfiguration.Companion.getDEFAULT();
        }
        if ((n & 2) != 0) {
            cellRenderer = DefaultCellRenderer.INSTANCE;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return HtmlKt.toStaticHtml(dataFrame, displayConfiguration, cellRenderer, bl, bl2);
    }

    private static final String toClass(Set<? extends Border> $this$toClass) {
        return $this$toClass.isEmpty() ? "" : "class=\"" + CollectionsKt.joinToString$default((Iterable)$this$toClass, (CharSequence)" ", null, null, (int)0, null, (Function1)toClass.1.INSTANCE, (int)30, null) + '\"';
    }

    public static final int maxDepth(@NotNull DataFrame<?> $this$maxDepth, int startingAt) {
        Comparable comparable;
        Intrinsics.checkNotNullParameter($this$maxDepth, (String)"<this>");
        Iterator iterator2 = ((Iterable)$this$maxDepth.columns()).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            DataColumn it = (DataColumn)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it instanceof ColumnGroup ? HtmlKt.maxDepth((DataFrame)((Object)it), startingAt + 1) : startingAt);
            while (iterator2.hasNext()) {
                DataColumn it2 = (DataColumn)iterator2.next();
                $i$a$-maxOfOrNull-HtmlKt$maxDepth$1 = false;
                Comparable comparable3 = Integer.valueOf(it2 instanceof ColumnGroup ? HtmlKt.maxDepth((DataFrame)((Object)it2), startingAt + 1) : startingAt);
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : startingAt;
    }

    public static /* synthetic */ int maxDepth$default(DataFrame dataFrame, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return HtmlKt.maxDepth(dataFrame, n);
    }

    /*
     * WARNING - void declaration
     */
    public static final int maxWidth(@NotNull BaseColumn<?> $this$maxWidth) {
        int n;
        Intrinsics.checkNotNullParameter($this$maxWidth, (String)"<this>");
        if ($this$maxWidth instanceof ColumnGroup) {
            Iterable iterable = ((ColumnGroup)$this$maxWidth).columns();
            int n2 = 0;
            for (Object t : iterable) {
                void it;
                DataColumn dataColumn = (DataColumn)t;
                int n3 = n2;
                boolean bl = false;
                int n4 = HtmlKt.maxWidth((BaseColumn)it);
                n2 = n3 + n4;
            }
            n = RangesKt.coerceAtLeast((int)n2, (int)1);
        } else {
            n = 1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<ColumnWithPathWithBorder<?>>> getColumnsHeaderGrid(DataFrame<?> $this$getColumnsHeaderGrid) {
        ColumnGroup colGroup2 = TypeConversionsKt.asColumnGroup$default($this$getColumnsHeaderGrid, null, 1, null);
        int maxDepth = HtmlKt.maxDepth$default($this$getColumnsHeaderGrid, 0, 1, null);
        int maxWidth = HtmlKt.maxWidth(colGroup2);
        int n = maxDepth + 1;
        ArrayList<List> arrayList = new ArrayList<List>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = i;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            ArrayList arrayList3 = new ArrayList(maxWidth);
            for (int j = 0; j < maxWidth; ++j) {
                void depth;
                int n4;
                int n5 = n4 = j;
                ArrayList arrayList4 = arrayList3;
                boolean bl2 = false;
                Set borders = depth == maxDepth ? SetsKt.setOf((Object)((Object)Border.BOTTOM)) : SetsKt.emptySet();
                arrayList4.add(new ColumnWithPathWithBorder(null, borders, 1, null));
            }
            arrayList2.add(arrayList3);
        }
        List matrix = arrayList;
        HtmlKt.getColumnsHeaderGrid$addChildren$default(UtilsKt.addPath(colGroup2), matrix, maxWidth, maxDepth, 0, 0, 24, null);
        return matrix;
    }

    public static final void print(@NotNull DataFrameHtmlData $this$print) {
        Intrinsics.checkNotNullParameter((Object)$this$print, (String)"<this>");
        System.out.println($this$print);
    }

    @Deprecated(message="Deprecated to clarify difference with .toHTML(). Will be removed in 0.13.", replaceWith=@ReplaceWith(expression="this.toStandaloneHTML().toString()", imports={"org.jetbrains.kotlinx.dataframe.io.toStandaloneHTML"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final <T> String html(@NotNull DataFrame<? extends T> $this$html) {
        Intrinsics.checkNotNullParameter($this$html, (String)"<this>");
        return HtmlKt.toStandaloneHTML$default($this$html, null, null, null, 7, null).toString();
    }

    @NotNull
    public static final <T> DataFrameHtmlData toStandaloneHTML(@NotNull DataFrame<? extends T> $this$toStandaloneHTML, @NotNull DisplayConfiguration configuration, @NotNull CellRenderer cellRenderer, @NotNull Function1<? super DataFrame<? extends T>, String> getFooter) {
        Intrinsics.checkNotNullParameter($this$toStandaloneHTML, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"cellRenderer");
        Intrinsics.checkNotNullParameter(getFooter, (String)"getFooter");
        return HtmlKt.toHTML($this$toStandaloneHTML, configuration, cellRenderer, getFooter).withTableDefinitions();
    }

    public static /* synthetic */ DataFrameHtmlData toStandaloneHTML$default(DataFrame dataFrame, DisplayConfiguration displayConfiguration, CellRenderer cellRenderer, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            displayConfiguration = DisplayConfiguration.Companion.getDEFAULT();
        }
        if ((n & 2) != 0) {
            cellRenderer = DefaultCellRenderer.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = toStandaloneHTML.1.INSTANCE;
        }
        return HtmlKt.toStandaloneHTML(dataFrame, displayConfiguration, cellRenderer, function1);
    }

    @NotNull
    public static final <T> DataFrameHtmlData toHTML(@NotNull DataFrame<? extends T> $this$toHTML, @NotNull DisplayConfiguration configuration, @NotNull CellRenderer cellRenderer, @NotNull Function1<? super DataFrame<? extends T>, String> getFooter) {
        String string;
        String footer;
        Intrinsics.checkNotNullParameter($this$toHTML, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"cellRenderer");
        Intrinsics.checkNotNullParameter(getFooter, (String)"getFooter");
        Integer n = configuration.getRowsLimit();
        int limit = n != null ? n : Integer.MAX_VALUE;
        String string2 = footer = (String)getFooter.invoke($this$toHTML);
        if (string2 != null) {
            StringBuilder stringBuilder;
            String it = string2;
            boolean bl = false;
            StringBuilder $this$toHTML_u24lambda_u2416_u24lambda_u2415 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            String openPTag = "<p class=\"dataframe_description\">";
            if (limit < DataFrameKt.getNrow($this$toHTML)) {
                $this$toHTML_u24lambda_u2416_u24lambda_u2415.append(openPTag);
                $this$toHTML_u24lambda_u2416_u24lambda_u2415.append("... showing only top " + limit + " of " + DataFrameKt.getNrow($this$toHTML) + " rows</p>");
            }
            $this$toHTML_u24lambda_u2416_u24lambda_u2415.append(openPTag);
            $this$toHTML_u24lambda_u2416_u24lambda_u2415.append(footer);
            $this$toHTML_u24lambda_u2416_u24lambda_u2415.append("</p>");
            String string3 = stringBuilder.toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        } else {
            string = null;
        }
        String bodyFooter = string;
        DataFrameHtmlData tableHtml = HtmlKt.toHtmlData($this$toHTML, configuration, cellRenderer);
        if (configuration.getEnableFallbackStaticTables()) {
            tableHtml = tableHtml.plus(HtmlKt.toStaticHtml$default($this$toHTML, configuration, DefaultCellRenderer.INSTANCE, false, false, 12, null));
        }
        if (bodyFooter != null) {
            tableHtml = tableHtml.plus(new DataFrameHtmlData("", bodyFooter, ""));
        }
        return tableHtml;
    }

    public static /* synthetic */ DataFrameHtmlData toHTML$default(DataFrame dataFrame, DisplayConfiguration displayConfiguration, CellRenderer cellRenderer, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            displayConfiguration = DisplayConfiguration.Companion.getDEFAULT();
        }
        if ((n & 2) != 0) {
            cellRenderer = DefaultCellRenderer.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = toHTML.1.INSTANCE;
        }
        return HtmlKt.toHTML(dataFrame, displayConfiguration, cellRenderer, function1);
    }

    private static final boolean flagFromEnv(String envName) {
        Object object = System.getenv(envName);
        return object != null && (object = StringsKt.toBooleanStrictOrNull((String)object)) != null ? (Boolean)object : false;
    }

    @NotNull
    public static final String escapeNewLines(@NotNull String $this$escapeNewLines) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeNewLines, (String)"<this>");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeNewLines, (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String escapeForHtmlInJs(@NotNull String $this$escapeForHtmlInJs) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeForHtmlInJs, (String)"<this>");
        return HtmlKt.escapeNewLines(StringsKt.replace$default((String)$this$escapeForHtmlInJs, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null));
    }

    @NotNull
    public static final RenderedContent renderValueForHtml-uKGgf_E(@Nullable Object value, int truncate, @NotNull String format2) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        return formatter.truncate$core(StringKt.renderValueToString-r3xRT3o(value, format2), truncate);
    }

    @NotNull
    public static final String escapeHTML(@NotNull String $this$escapeHTML) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$escapeHTML, (String)"<this>");
        String str = $this$escapeHTML;
        StringBuilder $this$escapeHTML_u24lambda_u2417 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '\'' || c == '<' || c == '>' || c == '&' || c == '\\') {
                $this$escapeHTML_u24lambda_u2417.append("&#");
                $this$escapeHTML_u24lambda_u2417.append((int)c);
                $this$escapeHTML_u24lambda_u2417.append(';');
                continue;
            }
            $this$escapeHTML_u24lambda_u2417.append(c);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final int tableJs$lambda$3$appendColWithChildren(Ref.IntRef index, StringBuilder $this_buildString, ColumnDataForJs col2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = col2.getNested();
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnDataForJs columnDataForJs = (ColumnDataForJs)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HtmlKt.tableJs$lambda$3$appendColWithChildren(index, $this_buildString, (ColumnDataForJs)it));
        }
        List children2 = (List)destination$iv$iv;
        $i$f$map = index.element;
        index.element = $i$f$map + 1;
        int colIndex = $i$f$map;
        String values2 = CollectionsKt.joinToString$default((Iterable)col2.getValues(), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)tableJs.data.1.appendColWithChildren.values.1.INSTANCE, (int)24, null);
        String colName = HtmlKt.escapeForHtmlInJs(HtmlKt.renderHeader(col2));
        $this_buildString.append("{ name: \"" + colName + "\", children: " + children2 + ", rightAlign: " + col2.getRightAlign() + ", values: " + values2 + " }, \n");
        return colIndex;
    }

    /*
     * Unable to fully structure code
     */
    private static final ColumnDataForJs toHtmlData$columnToJs(DataFrame<?> $this$toHtmlData_u24columnToJs, DisplayConfiguration $configuration, LinkedList<Pair<DataFrame<?>, Integer>> queue, CellRenderer $cellRenderer, DataColumn<?> col, Integer rowsLimit) {
        values = rowsLimit != null ? (Iterable)CollectionsKt.take(DataFrameGetKt.rows($this$toHtmlData_u24columnToJs), (int)rowsLimit) : DataFrameGetKt.rows($this$toHtmlData_u24columnToJs);
        scale = DataColumnTypeKt.isNumber(col) != false ? MathUtilsKt.scale((DataColumn)TypeConversionsKt.asNumberAnyNullable(col)) : 1;
        format = scale > 0 ? RendererDecimalFormat.Companion.fromPrecision-VVLz-gw(scale) : RendererDecimalFormat.Companion.of-VVLz-gw("%e");
        renderConfig = DisplayConfiguration.copy-OhBYUck$default($configuration, null, null, 0, null, format, false, false, false, false, 495, null);
        $this$map$iv = values;
        $i$f$map = false;
        var13_12 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            block11: {
                block10: {
                    var18_17 = (DataRow)item$iv$iv;
                    var29_29 = destination$iv$iv;
                    $i$a$-map-HtmlKt$toHtmlData$columnToJs$contents$1 = false;
                    value = it.get((ColumnReference)col);
                    if (!(value instanceof DataFrame)) break block10;
                    if (IsEmptyKt.isEmpty((DataFrame)value)) {
                        v0 = new HtmlContent("", null);
                    } else {
                        id = HtmlKt.nextTableId();
                        queue.add(TuplesKt.to(value, (Object)id));
                        v0 = new DataFrameReference(id, DataFrameKt.getSize((DataFrame)value));
                    }
                    break block11;
                }
                html = HtmlKt.formatter.format(value, $cellRenderer, renderConfig);
                var22_22 = renderConfig.getCellFormatter();
                if (var22_22 == null || (var23_23 = (CellAttributes)var22_22.invoke((Object)FormattingDSL.INSTANCE, (Object)it, col)) == null || (var24_24 = var23_23.attributes()) == null) ** GOTO lbl-1000
                var25_25 = var24_24;
                if (var25_25.isEmpty()) {
                    $i$a$-ifEmpty-HtmlKt$toHtmlData$columnToJs$contents$1$style$1 = false;
                    v1 = null;
                } else {
                    v1 = var25_25;
                }
                var27_27 = (List)v1;
                if (var27_27 != null) {
                    v2 = CollectionsKt.joinToString$default((Iterable)var27_27, (CharSequence)";", null, null, (int)0, null, (Function1)toHtmlData.columnToJs.contents.1.style.2.INSTANCE, (int)30, null);
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                style = v2;
                v0 = new HtmlContent(html, style);
            }
            var29_29.add(v0);
        }
        contents = (List)destination$iv$iv;
        v3 = col;
        if (col instanceof ColumnGroup) {
            $this$map$iv = ((ColumnGroup)col).columns();
            var30_31 = v3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (DataColumn)item$iv$iv;
                var31_32 = destination$iv$iv;
                $i$a$-map-HtmlKt$toHtmlData$columnToJs$1 = false;
                var31_32.add(HtmlKt.toHtmlData$columnToJs((DataFrame)col, $configuration, queue, $cellRenderer, it, rowsLimit));
            }
            v4 = (List)destination$iv$iv;
            v3 = var30_31;
        } else {
            v4 = CollectionsKt.emptyList();
        }
        $this$isSubtypeOf$iv = col;
        $i$f$isSubtypeOf = false;
        var32_33 = contents;
        var33_34 = DataColumnTypeKt.isSubtypeOf($this$isSubtypeOf$iv, Reflection.nullableTypeOf(Number.class));
        var34_35 = v4;
        var35_36 = v3;
        return new ColumnDataForJs(var35_36, var34_35, var33_34, var32_33);
    }

    private static final void toStaticHtml$emitTag(StringBuilder $this$toStaticHtml_u24emitTag, String tag, String attributes, Function1<? super StringBuilder, Unit> tagContents) {
        $this$toStaticHtml_u24emitTag.append('<' + tag);
        if (((CharSequence)attributes).length() > 0) {
            $this$toStaticHtml_u24emitTag.append(" ");
            $this$toStaticHtml_u24emitTag.append(attributes);
        }
        $this$toStaticHtml_u24emitTag.append(">");
        tagContents.invoke((Object)$this$toStaticHtml_u24emitTag);
        $this$toStaticHtml_u24emitTag.append("</" + tag + '>');
    }

    static /* synthetic */ void toStaticHtml$emitTag$default(StringBuilder stringBuilder, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        HtmlKt.toStaticHtml$emitTag(stringBuilder, string, string2, (Function1<? super StringBuilder, Unit>)function1);
    }

    private static final void toStaticHtml$emitHeader(StringBuilder $this$toStaticHtml_u24emitHeader, List<? extends List<? extends ColumnWithPathWithBorder<?>>> colGrid) {
        HtmlKt.toStaticHtml$emitTag$default($this$toStaticHtml_u24emitHeader, "thead", null, (Function1)new Function1<StringBuilder, Unit>(colGrid){
            final /* synthetic */ List<List<ColumnWithPathWithBorder<?>>> $colGrid;
            {
                this.$colGrid = $colGrid;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$emitTag) {
                Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                for (List<ColumnWithPathWithBorder<?>> row : this.$colGrid) {
                    HtmlKt.toStaticHtml$emitTag$default($this$emitTag, "tr", null, (Function1)new Function1<StringBuilder, Unit>(row){
                        final /* synthetic */ List<ColumnWithPathWithBorder<?>> $row;
                        {
                            this.$row = $row;
                            super(1);
                        }

                        public final void invoke(@NotNull StringBuilder $this$emitTag) {
                            Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                            Iterator<ColumnWithPathWithBorder<?>> iterator2 = this.$row.iterator();
                            int n = 0;
                            while (iterator2.hasNext()) {
                                int j = n++;
                                ColumnWithPathWithBorder<?> col2 = iterator2.next();
                                Set colBorders = CollectionsKt.toMutableSet((Iterable)col2.getBorders());
                                Object object = (ColumnWithPathWithBorder)CollectionsKt.getOrNull(this.$row, (int)(j + 1));
                                boolean bl = object != null && (object = ((ColumnWithPathWithBorder)object).getBorders()) != null ? object.contains((Object)((Object)Border.LEFT)) : false;
                                if (bl) {
                                    ((Collection)colBorders).add(Border.RIGHT);
                                }
                                HtmlKt.access$toStaticHtml$emitTag($this$emitTag, "th", HtmlKt.access$toClass(colBorders) + " style=\"text-align:left\"", (Function1)new Function1<StringBuilder, Unit>(col2){
                                    final /* synthetic */ ColumnWithPathWithBorder<?> $col;
                                    {
                                        this.$col = $col;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull StringBuilder $this$emitTag) {
                                        Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                                        ColumnWithPath<?> columnWithPath = this.$col.getColumnWithPath();
                                        if (columnWithPath == null || (columnWithPath = columnWithPath.getName()) == null) {
                                            columnWithPath = "";
                                        }
                                        $this$emitTag.append((String)((Object)columnWithPath));
                                    }
                                });
                            }
                        }
                    }, 2, null);
                }
            }
        }, 2, null);
    }

    private static final void toStaticHtml$emitCell(StringBuilder $this$toStaticHtml_u24emitCell, boolean $openNestedDfs, CellRenderer $cellRenderer, DisplayConfiguration $configuration, Integer nestedRowsLimit, Object cellValue, DataRow<?> row, ColumnWithPath<?> col2, Set<? extends Border> borders) {
        HtmlKt.toStaticHtml$emitTag($this$toStaticHtml_u24emitCell, "td", HtmlKt.toClass(borders) + " style=\"vertical-align:top\"", (Function1<? super StringBuilder, Unit>)((Function1)new Function1<StringBuilder, Unit>(col2, cellValue, $openNestedDfs, $cellRenderer, $configuration, nestedRowsLimit){
            final /* synthetic */ ColumnWithPath<?> $col;
            final /* synthetic */ Object $cellValue;
            final /* synthetic */ boolean $openNestedDfs;
            final /* synthetic */ CellRenderer $cellRenderer;
            final /* synthetic */ DisplayConfiguration $configuration;
            final /* synthetic */ Integer $nestedRowsLimit;
            {
                this.$col = $col;
                this.$cellValue = $cellValue;
                this.$openNestedDfs = $openNestedDfs;
                this.$cellRenderer = $cellRenderer;
                this.$configuration = $configuration;
                this.$nestedRowsLimit = $nestedRowsLimit;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$emitTag) {
                Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                if (this.$col instanceof FrameColumn) {
                    Object object = this.$cellValue;
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataFrame<*>{ org.jetbrains.kotlinx.dataframe.AliasesKt.AnyFrame }");
                    DataFrame cfr_ignored_0 = (DataFrame)object;
                    HtmlKt.access$toStaticHtml$emitTag($this$emitTag, "details", this.$openNestedDfs ? "open" : "", (Function1)new Function1<StringBuilder, Unit>(this.$nestedRowsLimit, this.$cellValue, this.$configuration, this.$cellRenderer, this.$openNestedDfs){
                        final /* synthetic */ Integer $nestedRowsLimit;
                        final /* synthetic */ Object $cellValue;
                        final /* synthetic */ DisplayConfiguration $configuration;
                        final /* synthetic */ CellRenderer $cellRenderer;
                        final /* synthetic */ boolean $openNestedDfs;
                        {
                            this.$nestedRowsLimit = $nestedRowsLimit;
                            this.$cellValue = $cellValue;
                            this.$configuration = $configuration;
                            this.$cellRenderer = $cellRenderer;
                            this.$openNestedDfs = $openNestedDfs;
                            super(1);
                        }

                        public final void invoke(@NotNull StringBuilder $this$emitTag) {
                            Integer n;
                            Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                            HtmlKt.toStaticHtml$emitTag$default($this$emitTag, "summary", null, (Function1)new Function1<StringBuilder, Unit>(this.$cellValue){
                                final /* synthetic */ Object $cellValue;
                                {
                                    this.$cellValue = $cellValue;
                                    super(1);
                                }

                                public final void invoke(@NotNull StringBuilder $this$emitTag) {
                                    Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                                    $this$emitTag.append("DataFrame [" + DataFrameKt.getSize((DataFrame)this.$cellValue) + ']');
                                }
                            }, 2, null);
                            Integer newRowsLimit = this.$nestedRowsLimit;
                            Integer n2 = this.$nestedRowsLimit;
                            if (n2 != null) {
                                int it = ((Number)n2).intValue();
                                boolean bl = false;
                                n = (int)Math.ceil((double)it / 2.0);
                            } else {
                                n = null;
                            }
                            Integer newNestedRowsLimit = n;
                            DataFrameHtmlData it = HtmlKt.toStaticHtml((DataFrame)this.$cellValue, DisplayConfiguration.copy-OhBYUck$default(this.$configuration, newRowsLimit, newNestedRowsLimit, 0, null, null, false, false, false, false, 508, null), this.$cellRenderer, false, this.$openNestedDfs);
                            boolean bl = false;
                            $this$emitTag.append(it.getBody());
                            int size = ((DataFrame)this.$cellValue).rowsCount();
                            Integer n3 = newRowsLimit;
                            if (size > (n3 != null ? n3 : Integer.MAX_VALUE)) {
                                HtmlKt.toStaticHtml$emitTag$default($this$emitTag, "p", null, (Function1)new Function1<StringBuilder, Unit>(newRowsLimit, size){
                                    final /* synthetic */ Integer $newRowsLimit;
                                    final /* synthetic */ int $size;
                                    {
                                        this.$newRowsLimit = $newRowsLimit;
                                        this.$size = $size;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull StringBuilder $this$emitTag) {
                                        Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                                        $this$emitTag.append("... showing only top " + this.$newRowsLimit + " of " + this.$size + " rows");
                                    }
                                }, 2, null);
                            }
                        }
                    });
                } else {
                    $this$emitTag.append(this.$cellRenderer.content(this.$cellValue, this.$configuration).getTruncatedContent());
                }
            }
        }));
    }

    private static final void toStaticHtml$emitRow(StringBuilder $this$toStaticHtml_u24emitRow, List<? extends ColumnWithPath<? extends Object>> flattenedCols2, List<? extends Set<? extends Border>> borders, boolean $openNestedDfs, CellRenderer $cellRenderer, DisplayConfiguration $configuration, Integer nestedRowsLimit, DataRow<?> row) {
        HtmlKt.toStaticHtml$emitTag$default($this$toStaticHtml_u24emitRow, "tr", null, (Function1)new Function1<StringBuilder, Unit>(flattenedCols2, borders, row, $openNestedDfs, $cellRenderer, $configuration, nestedRowsLimit){
            final /* synthetic */ List<ColumnWithPath<Object>> $flattenedCols;
            final /* synthetic */ List<Set<Border>> $borders;
            final /* synthetic */ DataRow<?> $row;
            final /* synthetic */ boolean $openNestedDfs;
            final /* synthetic */ CellRenderer $cellRenderer;
            final /* synthetic */ DisplayConfiguration $configuration;
            final /* synthetic */ Integer $nestedRowsLimit;
            {
                this.$flattenedCols = $flattenedCols;
                this.$borders = $borders;
                this.$row = $row;
                this.$openNestedDfs = $openNestedDfs;
                this.$cellRenderer = $cellRenderer;
                this.$configuration = $configuration;
                this.$nestedRowsLimit = $nestedRowsLimit;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$emitTag) {
                Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                Iterator<ColumnWithPath<Object>> iterator2 = this.$flattenedCols.iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int i = n++;
                    ColumnWithPath<Object> col2 = iterator2.next();
                    Set border = CollectionsKt.toMutableSet((Iterable)this.$borders.get(i));
                    Set set = (Set)CollectionsKt.getOrNull(this.$borders, (int)(i + 1));
                    boolean bl = set != null ? set.contains((Object)((Object)Border.LEFT)) : false;
                    if (bl) {
                        ((Collection)border).add(Border.RIGHT);
                    }
                    Object cell = this.$row.get(col2.path());
                    HtmlKt.access$toStaticHtml$emitCell($this$emitTag, this.$openNestedDfs, this.$cellRenderer, this.$configuration, this.$nestedRowsLimit, cell, this.$row, col2, border);
                }
            }
        }, 2, null);
    }

    private static final void toStaticHtml$emitBody(StringBuilder $this$toStaticHtml_u24emitBody, DataFrame<?> $this_toStaticHtml, Integer rowsLimit, DataFrame<?> df2, List<? extends ColumnWithPath<? extends Object>> flattenedCols2, List<? extends Set<? extends Border>> borders, boolean $openNestedDfs, CellRenderer $cellRenderer, DisplayConfiguration $configuration, Integer nestedRowsLimit) {
        HtmlKt.toStaticHtml$emitTag$default($this$toStaticHtml_u24emitBody, "tbody", null, (Function1)new Function1<StringBuilder, Unit>($this_toStaticHtml, rowsLimit, df2, flattenedCols2, borders, $openNestedDfs, $cellRenderer, $configuration, nestedRowsLimit){
            final /* synthetic */ DataFrame<?> $this_toStaticHtml;
            final /* synthetic */ Integer $rowsLimit;
            final /* synthetic */ DataFrame<?> $df;
            final /* synthetic */ List<ColumnWithPath<Object>> $flattenedCols;
            final /* synthetic */ List<Set<Border>> $borders;
            final /* synthetic */ boolean $openNestedDfs;
            final /* synthetic */ CellRenderer $cellRenderer;
            final /* synthetic */ DisplayConfiguration $configuration;
            final /* synthetic */ Integer $nestedRowsLimit;
            {
                this.$this_toStaticHtml = $receiver;
                this.$rowsLimit = $rowsLimit;
                this.$df = $df;
                this.$flattenedCols = $flattenedCols;
                this.$borders = $borders;
                this.$openNestedDfs = $openNestedDfs;
                this.$cellRenderer = $cellRenderer;
                this.$configuration = $configuration;
                this.$nestedRowsLimit = $nestedRowsLimit;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$emitTag) {
                Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                int n = this.$this_toStaticHtml.rowsCount();
                Integer n2 = this.$rowsLimit;
                int n3 = n2 != null ? n2 : Integer.MAX_VALUE;
                int rowsCountToRender = Math.min(n, n3);
                for (int rowIndex = 0; rowIndex < rowsCountToRender; ++rowIndex) {
                    HtmlKt.access$toStaticHtml$emitRow($this$emitTag, this.$flattenedCols, this.$borders, this.$openNestedDfs, this.$cellRenderer, this.$configuration, this.$nestedRowsLimit, this.$df.get(rowIndex));
                }
            }
        }, 2, null);
    }

    private static final void toStaticHtml$emitTable(StringBuilder $this$toStaticHtml_u24emitTable, String id2, List<? extends List<? extends ColumnWithPathWithBorder<?>>> colGrid, DataFrame<?> $this_toStaticHtml, Integer rowsLimit, DataFrame<?> df2, List<? extends ColumnWithPath<? extends Object>> flattenedCols2, List<? extends Set<? extends Border>> borders, boolean $openNestedDfs, CellRenderer $cellRenderer, DisplayConfiguration $configuration, Integer nestedRowsLimit) {
        HtmlKt.toStaticHtml$emitTag($this$toStaticHtml_u24emitTable, "table", "class=\"dataframe\" id=\"" + id2 + '\"', (Function1<? super StringBuilder, Unit>)((Function1)new Function1<StringBuilder, Unit>(colGrid, $this_toStaticHtml, rowsLimit, df2, flattenedCols2, borders, $openNestedDfs, $cellRenderer, $configuration, nestedRowsLimit){
            final /* synthetic */ List<List<ColumnWithPathWithBorder<?>>> $colGrid;
            final /* synthetic */ DataFrame<?> $this_toStaticHtml;
            final /* synthetic */ Integer $rowsLimit;
            final /* synthetic */ DataFrame<?> $df;
            final /* synthetic */ List<ColumnWithPath<Object>> $flattenedCols;
            final /* synthetic */ List<Set<Border>> $borders;
            final /* synthetic */ boolean $openNestedDfs;
            final /* synthetic */ CellRenderer $cellRenderer;
            final /* synthetic */ DisplayConfiguration $configuration;
            final /* synthetic */ Integer $nestedRowsLimit;
            {
                this.$colGrid = $colGrid;
                this.$this_toStaticHtml = $receiver;
                this.$rowsLimit = $rowsLimit;
                this.$df = $df;
                this.$flattenedCols = $flattenedCols;
                this.$borders = $borders;
                this.$openNestedDfs = $openNestedDfs;
                this.$cellRenderer = $cellRenderer;
                this.$configuration = $configuration;
                this.$nestedRowsLimit = $nestedRowsLimit;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$emitTag) {
                Intrinsics.checkNotNullParameter((Object)$this$emitTag, (String)"$this$emitTag");
                HtmlKt.access$toStaticHtml$emitHeader($this$emitTag, this.$colGrid);
                HtmlKt.access$toStaticHtml$emitBody($this$emitTag, this.$this_toStaticHtml, this.$rowsLimit, this.$df, this.$flattenedCols, this.$borders, this.$openNestedDfs, this.$cellRenderer, this.$configuration, this.$nestedRowsLimit);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final void getColumnsHeaderGrid$addChildren(ColumnWithPath<?> $this$getColumnsHeaderGrid_u24addChildren, List<List<ColumnWithPathWithBorder<Object>>> matrix, int maxWidth, int maxDepth, int depth, int breadth) {
        int breadth2 = breadth;
        List<ColumnWithPath<Object>> children2 = $this$getColumnsHeaderGrid_u24addChildren.children();
        int lastIndex = CollectionsKt.getLastIndex(children2);
        Iterator<ColumnWithPath<Object>> iterator2 = $this$getColumnsHeaderGrid_u24addChildren.children().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int j;
            int i = n++;
            ColumnWithPath<Object> child = iterator2.next();
            matrix.get(depth).set(breadth2, ColumnWithPathWithBorder.copy$default(matrix.get(depth).get(breadth2), child, null, 2, null));
            Set borders = new LinkedHashSet();
            if (i == 0 && breadth2 != 0) {
                ((Collection)borders).add(Border.LEFT);
            }
            if (i == lastIndex && breadth2 != maxWidth - 1) {
                ((Collection)borders).add(Border.RIGHT);
            }
            if (!((Collection)borders).isEmpty() && (j = RangesKt.coerceAtLeast((int)(depth - 1), (int)0)) <= maxDepth) {
                while (true) {
                    void it;
                    ColumnWithPathWithBorder<Object> columnWithPathWithBorder = matrix.get(j).get(breadth2);
                    int n2 = breadth2;
                    List<ColumnWithPathWithBorder<Object>> list = matrix.get(j);
                    boolean bl = false;
                    ColumnWithPathWithBorder columnWithPathWithBorder2 = ColumnWithPathWithBorder.copy$default((ColumnWithPathWithBorder)it, null, SetsKt.plus(it.getBorders(), (Iterable)borders), 1, null);
                    list.set(n2, columnWithPathWithBorder2);
                    if (j == maxDepth) break;
                    ++j;
                }
            }
            if (child instanceof ColumnGroup) {
                HtmlKt.getColumnsHeaderGrid$addChildren(child, matrix, maxWidth, maxDepth, depth + 1, breadth2);
            }
            breadth2 += HtmlKt.maxWidth((BaseColumn)child);
        }
    }

    static /* synthetic */ void getColumnsHeaderGrid$addChildren$default(ColumnWithPath columnWithPath, List list, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        HtmlKt.getColumnsHeaderGrid$addChildren(columnWithPath, list, n, n2, n3, n4);
    }

    public static final /* synthetic */ boolean access$flagFromEnv(String envName) {
        return HtmlKt.flagFromEnv(envName);
    }

    public static final /* synthetic */ void access$toStaticHtml$emitTag(StringBuilder $receiver, String tag, String attributes, Function1 tagContents) {
        HtmlKt.toStaticHtml$emitTag($receiver, tag, attributes, (Function1<? super StringBuilder, Unit>)tagContents);
    }

    public static final /* synthetic */ String access$toClass(Set $receiver) {
        return HtmlKt.toClass($receiver);
    }

    public static final /* synthetic */ void access$toStaticHtml$emitCell(StringBuilder $receiver, boolean $openNestedDfs, CellRenderer $cellRenderer, DisplayConfiguration $configuration, Integer nestedRowsLimit, Object cellValue, DataRow row, ColumnWithPath col2, Set borders) {
        HtmlKt.toStaticHtml$emitCell($receiver, $openNestedDfs, $cellRenderer, $configuration, nestedRowsLimit, cellValue, row, col2, borders);
    }

    public static final /* synthetic */ void access$toStaticHtml$emitRow(StringBuilder $receiver, List flattenedCols2, List borders, boolean $openNestedDfs, CellRenderer $cellRenderer, DisplayConfiguration $configuration, Integer nestedRowsLimit, DataRow row) {
        HtmlKt.toStaticHtml$emitRow($receiver, flattenedCols2, borders, $openNestedDfs, $cellRenderer, $configuration, nestedRowsLimit, row);
    }

    public static final /* synthetic */ void access$toStaticHtml$emitHeader(StringBuilder $receiver, List colGrid) {
        HtmlKt.toStaticHtml$emitHeader($receiver, colGrid);
    }

    public static final /* synthetic */ void access$toStaticHtml$emitBody(StringBuilder $receiver, DataFrame $this_toStaticHtml, Integer rowsLimit, DataFrame df2, List flattenedCols2, List borders, boolean $openNestedDfs, CellRenderer $cellRenderer, DisplayConfiguration $configuration, Integer nestedRowsLimit) {
        HtmlKt.toStaticHtml$emitBody($receiver, $this_toStaticHtml, rowsLimit, df2, flattenedCols2, borders, $openNestedDfs, $cellRenderer, $configuration, nestedRowsLimit);
    }

    static {
        sessionId = new Random().nextInt() % 128 << 24;
    }
}

