/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.chunks;

import com.intellij.lang.Language;
import com.intellij.ml.llm.context.SimilarChunkContext;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.vfs.VfsUtilCoreKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J*\u0010\u0015\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0002J*\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f0\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/context/chunks/SimilarChunksWithPaths;", "", "<init>", "()V", "CHUNK_SIZE", "", "MAX_RELEVANT_FILES", "similarChunksWithPaths", "Lcom/intellij/ml/llm/context/SimilarChunkContext;", "element", "Lcom/intellij/psi/PsiElement;", "relativePathTo", "Lcom/intellij/ml/llm/privacy/PSString;", "Lcom/intellij/openapi/vfs/VirtualFile;", "tokenLevelJaccardSimilarity", "", "", "chunks", "", "tokenize", "chunk", "jaccardSimilarity", "T", "set1", "", "set2", "extractChunks", "mostRecentFiles", "getMostRecentFiles", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nSimilarChunksWithPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimilarChunksWithPaths.kt\ncom/intellij/ml/llm/context/chunks/SimilarChunksWithPaths\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1563#2:99\n1634#2,3:100\n1563#2:103\n1634#2,2:104\n1563#2:106\n1634#2,3:107\n1573#2:110\n1604#2,4:111\n1563#2:115\n1634#2,2:116\n1563#2:118\n1634#2,3:119\n1636#2:122\n774#2:123\n865#2,2:124\n1617#2,9:126\n1869#2:135\n1870#2:137\n1626#2:138\n1563#2:139\n1634#2,2:140\n1563#2:142\n1634#2,3:143\n1636#2:146\n774#2:147\n865#2,2:148\n1#3:136\n*S KotlinDebug\n*F\n+ 1 SimilarChunksWithPaths.kt\ncom/intellij/ml/llm/context/chunks/SimilarChunksWithPaths\n*L\n23#1:99\n23#1:100,3\n26#1:103\n26#1:104,2\n26#1:106\n26#1:107,3\n31#1:110\n31#1:111,4\n58#1:115\n58#1:116,2\n59#1:118\n59#1:119,3\n58#1:122\n67#1:123\n67#1:124,2\n77#1:126,9\n77#1:135\n77#1:137\n77#1:138\n79#1:139\n79#1:140,2\n80#1:142\n80#1:143,3\n79#1:146\n89#1:147\n89#1:148,2\n77#1:136\n*E\n"})
public final class SimilarChunksWithPaths {
    @NotNull
    public static final SimilarChunksWithPaths INSTANCE = new SimilarChunksWithPaths();
    private static final int CHUNK_SIZE = 60;
    private static final int MAX_RELEVANT_FILES = 20;

    private SimilarChunksWithPaths() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimilarChunkContext similarChunksWithPaths(@NotNull PsiElement element) {
        void $this$mapIndexedTo$iv$iv;
        List $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Object object;
        Iterable $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<VirtualFile> mostRecentFiles = this.getMostRecentFiles(element);
        Iterable $this$map$iv2 = mostRecentFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Iterator it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            PSString pSString = INSTANCE.relativePathTo((VirtualFile)it, element);
            Intrinsics.checkNotNull((Object)pSString);
            object.add(pSString);
        }
        List mostRecentFilesRelativePaths = (List)destination$iv$iv;
        List<List<PSString>> chunks = this.extractChunks(element, mostRecentFiles);
        $this$mapTo$iv$iv3 = chunks;
        object = this;
        boolean $i$f$map2 = false;
        void $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo32 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void psStrings;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            Iterable $this$map$iv3 = (Iterable)psStrings;
            boolean $i$f$map3 = false;
            Iterable iterable2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                PSString pSString = (PSString)item$iv$iv2;
                Collection collection2 = destination$iv$iv3;
                boolean bl2 = false;
                collection2.add((String)it.unwrap());
            }
            collection.add((List)destination$iv$iv3);
        }
        List<List<Double>> jaccardSimilarities = super.tokenLevelJaccardSimilarity((List)destination$iv$iv2, element);
        List paths = new ArrayList();
        List chunksList = new ArrayList();
        Iterable $this$mapIndexed$iv = jaccardSimilarities;
        boolean $i$f$mapIndexed = false;
        Iterable $i$f$mapTo32 = $this$mapIndexed$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void fileIndex;
            void jaccardList;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            $this$mapTo$iv$iv = (List)item$iv$iv;
            int destination$iv$iv3 = n;
            object = destination$iv$iv4;
            boolean bl = false;
            int maxIndex = jaccardList.indexOf(CollectionsKt.maxOrThrow((Iterable)((Iterable)jaccardList)));
            paths.add(mostRecentFilesRelativePaths.get((int)fileIndex));
            object.add(chunksList.add(chunks.get((int)fileIndex).get(maxIndex)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv4;
        Language language = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return new SimilarChunkContext(language, paths, chunksList);
    }

    private final PSString relativePathTo(VirtualFile $this$relativePathTo, PsiElement element) {
        PSString relativePath;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        VirtualFile contentRoot = fileIndex.getContentRootForFile($this$relativePathTo);
        if (contentRoot == null) {
            contentRoot = fileIndex.getClassRootForFile($this$relativePathTo);
        }
        if (contentRoot != null && (relativePath = VfsUtilCoreKt.vfsUtilCoreGetRelativePathPrivacySafe((VirtualFile)$this$relativePathTo, (VirtualFile)contentRoot, (char)File.separatorChar)) != null) {
            return relativePath;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Double>> tokenLevelJaccardSimilarity(List<? extends List<String>> chunks, PsiElement element) {
        void $this$mapTo$iv$iv;
        Set currentFileTokens;
        String string = element.getContainingFile().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Set tokenizedFile = currentFileTokens = CollectionsKt.toSet((Iterable)this.tokenize(string));
        boolean bl = false;
        Iterable $this$map$iv = chunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void chunkList;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Iterable $this$map$iv2 = (Iterable)chunkList;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void chunk;
                String string2 = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                Set chunkTokens = CollectionsKt.toSet((Iterable)INSTANCE.tokenize((String)chunk));
                collection2.add(INSTANCE.jaccardSimilarity(chunkTokens, tokenizedFile));
            }
            collection.add((List)destination$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tokenize(String chunk) {
        void $this$filterTo$iv$iv;
        CharSequence charSequence = chunk;
        Regex regex = new Regex("[^a-zA-Z0-9]");
        int n = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final <T> double jaccardSimilarity(Set<? extends T> set1, Set<? extends T> set2) {
        int intersectionSize = CollectionsKt.intersect((Iterable)set1, (Iterable)set2).size();
        int unionSize = CollectionsKt.union((Iterable)set1, (Iterable)set2).size();
        return (double)intersectionSize / (double)unionSize;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<PSString>> extractChunks(PsiElement element, List<? extends VirtualFile> mostRecentFiles) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        PsiManager psiManager = PsiManager.getInstance((Project)element.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        Iterable $this$mapNotNull$iv = mostRecentFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<PSString> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PSString it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl4 = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            PsiFile psiFile = psiManager2.findFile(it);
            if ((psiFile != null && (psiFile = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)((PsiNamedElement)psiFile))) != null ? psiFile.getText() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List lastFilesContent = (List)destination$iv$iv;
        Iterable $this$map$iv = lastFilesContent;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void content2;
            element$iv$iv$iv = (PSString)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            String[] bl4 = new String[]{"\n"};
            Iterable $this$map$iv2 = CollectionsKt.chunked((Iterable)PrivacySafe.split$default((PrivacySafe)((PrivacySafe)content2), (String[])bl4, (boolean)false, (int)0, (int)6, null), (int)60);
            boolean $i$f$map2 = false;
            Iterable bl2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void chunk;
                List list = (List)item$iv$iv2;
                Collection collection2 = destination$iv$iv3;
                boolean bl5 = false;
                collection2.add(PSStringKt.joinToString$default((Iterable)((Iterable)chunk), (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n")), null, null, (int)0, null, (int)30, null));
            }
            collection.add((List)destination$iv$iv3);
        }
        List chunks = (List)destination$iv$iv2;
        return chunks;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> getMostRecentFiles(PsiElement element) {
        void $this$filterTo$iv$iv;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getFileType()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile fileType = psiFile;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable $this$filter$iv = EditorHistoryManager.Companion.getInstance(project).getFileList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(it.isValid() && Intrinsics.areEqual((Object)it.getFileType(), (Object)fileType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List recentFiles = (List)destination$iv$iv;
        int start = RangesKt.coerceAtLeast((int)(recentFiles.size() - 20 + 1), (int)0);
        int end = RangesKt.coerceAtLeast((int)(recentFiles.size() - 1), (int)0);
        return CollectionsKt.toList((Iterable)recentFiles.subList(start, end));
    }
}

