/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui;

import ai.grazie.model.llm.prompt.LLMPromptID;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.BrowserUtil;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.llmInstaller.UtilsKt;
import com.intellij.ml.llm.AiPluginConstants;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.activation.presentation.AiaScreenManager;
import com.intellij.ml.llm.activation.presentation.navigation.AiaNavDestination;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.activation.state.model.AiProJbaActivation;
import com.intellij.ml.llm.activation.state.model.AiaActivation;
import com.intellij.ml.llm.activation.state.model.Outcome;
import com.intellij.ml.llm.core.AIAssistantAllowedLevelService;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.AIAssistantKillSwitch;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.chat.ui.ExpiryTimeDisplayData;
import com.intellij.ml.llm.core.chat.ui.LicenseType;
import com.intellij.ml.llm.core.chat.ui.NotificationUI;
import com.intellij.ml.llm.core.chat.ui.QuotaAvailableInfo;
import com.intellij.ml.llm.core.chat.ui.QuotaExpiryData;
import com.intellij.ml.llm.core.chat.ui.QuotaRefillData;
import com.intellij.ml.llm.core.chat.ui.QuotaTimeData;
import com.intellij.ml.llm.core.chat.ui.QuotaTimeDisplayData;
import com.intellij.ml.llm.core.chat.ui.RefillTimeDisplayData;
import com.intellij.ml.llm.core.chat.ui.RemainedQuotasInfo;
import com.intellij.ml.llm.core.chat.ui.UnknownQuotaTimeData;
import com.intellij.ml.llm.core.error.ErrorManager;
import com.intellij.ml.llm.core.error.ErrorState;
import com.intellij.ml.llm.core.models.LlmProfileService;
import com.intellij.ml.llm.core.providers.LlmCustomModelsSettingsManager;
import com.intellij.ml.llm.core.providers.LlmLocalModeManager;
import com.intellij.ml.llm.core.quota.QuotaInfo;
import com.intellij.ml.llm.core.quota.QuotaManager2;
import com.intellij.ml.llm.core.quota.QuotaRefillInfo;
import com.intellij.ml.llm.core.settings.LLMConfigurable;
import com.intellij.ml.llm.core.settings.LLMProjectSettingsManager;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.ml.llm.core.settings.LLMThirdPartyAiProvidersConfigurable;
import com.intellij.ml.llm.grazie.auth.GrazieAuthFacade;
import com.intellij.ml.llm.grazie.auth.GrazieAuthState;
import com.intellij.ml.llm.hub.AIHubNotificationManager;
import com.intellij.ml.llm.hub.AIHubNotificationManagerKt;
import com.intellij.ml.llm.updates.AIAssistantUpdateChecker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ApplicationKt;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u001f\u001a\u00020\u0011J\u0010\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0010\u0010$\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010#J\u000e\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0011J\u0006\u0010)\u001a\u00020\u0011J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110+2\u0006\u0010\"\u001a\u00020#2\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010#J\n\u0010/\u001a\u000200*\u000200J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204J\u0010\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106J\r\u00107\u001a\u0004\u0018\u000102\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010:\u001a\u00020\u0011J\u000e\u0010;\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0015\u0010<\u001a\u00070\u0007\u00a2\u0006\u0002\b=2\b\u0010>\u001a\u0004\u0018\u00010?J\u0010\u0010@\u001a\u00020\u00072\b\u00105\u001a\u0004\u0018\u00010AJ\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020C2\u0006\u0010G\u001a\u00020HJ\u0010\u0010I\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010J\u001a\u000202J\u000b\u0010K\u001a\u00070\u0007\u00a2\u0006\u0002\bLJ\u0018\u0010M\u001a\u00020N2\u0006\u0010\"\u001a\u00020#2\u0006\u0010O\u001a\u00020PH\u0007J\n\u0010Q\u001a\u0004\u0018\u00010RH\u0007J\u0012\u0010S\u001a\u00020\u00072\b\u0010T\u001a\u0004\u0018\u00010RH\u0007J\u0015\u0010U\u001a\u00070\u0007\u00a2\u0006\u0002\b=2\u0006\u0010V\u001a\u000202H\u0002J'\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0X2\u0012\u0010Z\u001a\n\u0012\u0006\b\u0001\u0012\u00020Y0[\"\u00020YH\u0002\u00a2\u0006\u0002\u0010\\J\b\u0010]\u001a\u000202H\u0002J\u0017\u0010^\u001a\u0004\u0018\u0001022\u0006\u0010_\u001a\u00020?H\u0002\u00a2\u0006\u0002\u0010`J\b\u0010j\u001a\u00020kH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010a\u001a\u0004\u0018\u00010b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR\"\u0010g\u001a\u0004\u0018\u00010\u00118\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\bh\u0010\u0013\"\u0004\bi\u0010\u0015R\u0011\u0010l\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR\u0011\u0010n\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\bn\u0010m\u00a8\u0006o"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/AIAssistantUIUtil;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "AI_ASSISTANT_SNIPPET_FILE_BASE_NAME", "", "AI_ASSISTANT_INPUT_FILE_NAME_PREFIX", "EDITOR_EX_PROPERTY", "MANAGE_ACCOUNT_HREF", "AVAILABLE_SUBSCRIPTION_WITH_ORGANIZATION_HREF", "ADD_PERSONAL_TOP_UP_CREDITS_HREF", "AI_HUB_GROUP", "AI_HUB_REFRESH_LICENSE_ACTION", "DO_NOT_UPDATE_FONT", "ultimateAvailableTest", "", "getUltimateAvailableTest", "()Ljava/lang/Boolean;", "setUltimateAvailableTest", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "creditsFormatter", "Ljava/text/DecimalFormat;", "isAIAssistantChatSnippet", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAIAssistantInputFile", "isAIAssistantFile", "isAIAssistantTurnOnOffApplicable", "isAIAssistantActivationIncomplete", "openLlmSettingsDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "isAssistantActive", "hasAvailableLlmProfileId", "promptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "hasAvailableChatProfileId", "isUltimateAvailable", "getAssistantActiveState", "Lkotlinx/coroutines/flow/StateFlow;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "isActiveButMaybeOutOfPrompts", "trialRemainedPanel", "Lcom/intellij/ui/dsl/builder/Panel;", "getEndsInQuotaDays", "", "getRemainedTariffQuotasPercent", "Lcom/intellij/ml/llm/core/chat/ui/RemainedQuotasInfo;", "quota", "Lcom/intellij/ml/llm/core/quota/QuotaInfo$SuccessfulQuotaInfo;", "getLicenseEndsInDays", "()Ljava/lang/Integer;", "setAIEnabled", "turnedOn", "showLicensePickerView", "getRefillInDays", "Lorg/jetbrains/annotations/Nls;", "quotaRefill", "Lkotlinx/datetime/Instant;", "quotaToCreditString", "Ljava/math/BigDecimal;", "getScaledAIAssistantIcon", "Ljavax/swing/Icon;", "scaleFactor", "", "getMessageDialogIcon", "component", "Ljavax/swing/JComponent;", "isAuthedAndAllowed", "getToolwindowScaledFontSize", "getSendingRequestBackgroundTitle", "Lcom/intellij/openapi/util/NlsSafe;", "getNotificationUI", "Lcom/intellij/ml/llm/core/chat/ui/NotificationUI;", "notification", "Lcom/intellij/ml/llm/hub/AIHubNotificationManager$Notification;", "getQuotaTimeData", "Lcom/intellij/ml/llm/core/chat/ui/QuotaTimeData;", "formatQuotaInfoLabel", "quotaTimeData", "getQuotaExceedComment", "refillInDays", "getAvailableActions", "", "Lcom/intellij/ml/llm/core/chat/ui/NotificationUI$Action;", "actions", "", "([Lcom/intellij/ml/llm/core/chat/ui/NotificationUI$Action;)Ljava/util/List;", "getLicenseEndsInDaysAndLog", "getRemainedHours", "instant", "(Lkotlinx/datetime/Instant;)Ljava/lang/Integer;", "testLicenseType", "Lcom/intellij/ml/llm/core/chat/ui/LicenseType;", "getTestLicenseType$intellij_ml_llm_core", "()Lcom/intellij/ml/llm/core/chat/ui/LicenseType;", "setTestLicenseType$intellij_ml_llm_core", "(Lcom/intellij/ml/llm/core/chat/ui/LicenseType;)V", "testLicensePersonal", "getTestLicensePersonal$intellij_ml_llm_core", "setTestLicensePersonal$intellij_ml_llm_core", "getQuotaTimeDisplayData", "Lcom/intellij/ml/llm/core/chat/ui/QuotaTimeDisplayData;", "isSupportLlm18910", "()Z", "isSupportLlm18911", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAIAssistantUIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantUIUtil.kt\ncom/intellij/ml/llm/core/chat/ui/AIAssistantUIUtil\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,815:1\n40#2,3:816\n40#2,3:819\n40#2,3:822\n40#2,3:831\n40#2,3:838\n30#3,2:825\n30#3,2:827\n30#3,2:829\n3829#4:834\n4344#4,2:835\n1#5:837\n14#6:841\n*S KotlinDebug\n*F\n+ 1 AIAssistantUIUtil.kt\ncom/intellij/ml/llm/core/chat/ui/AIAssistantUIUtil\n*L\n146#1:816,3\n154#1:819,3\n162#1:822,3\n323#1:831,3\n460#1:838,3\n174#1:825,2\n278#1:827,2\n319#1:829,2\n522#1:834\n522#1:835,2\n94#1:841\n*E\n"})
public final class AIAssistantUIUtil {
    @NotNull
    public static final AIAssistantUIUtil INSTANCE = new AIAssistantUIUtil();
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String AI_ASSISTANT_SNIPPET_FILE_BASE_NAME = "AIAssistantSnippet";
    @NotNull
    public static final String AI_ASSISTANT_INPUT_FILE_NAME_PREFIX = "AIAssistantInput";
    @NotNull
    public static final String EDITOR_EX_PROPERTY = "EditorEx";
    @NotNull
    public static final String MANAGE_ACCOUNT_HREF = "https://jb.gg/aimanage";
    @NotNull
    public static final String AVAILABLE_SUBSCRIPTION_WITH_ORGANIZATION_HREF = "https://jb.gg/available-subscription-options-with-organizational-jetbrains-account";
    @NotNull
    public static final String ADD_PERSONAL_TOP_UP_CREDITS_HREF = "https://jetbrains.com/shop/buy?item=P:N:AIGC";
    @NotNull
    public static final String AI_HUB_GROUP = "AIHub.Installed";
    @NotNull
    public static final String AI_HUB_REFRESH_LICENSE_ACTION = "AIHub.RefreshLicense";
    @NotNull
    public static final String DO_NOT_UPDATE_FONT = "AIAssistant.DoNotUpdateFont";
    @Nullable
    private static Boolean ultimateAvailableTest;
    @NotNull
    private static final DecimalFormat creditsFormatter;
    @ApiStatus.Internal
    @Nullable
    private static LicenseType testLicenseType;
    @ApiStatus.Internal
    @Nullable
    private static Boolean testLicensePersonal;

    private AIAssistantUIUtil() {
    }

    @Nullable
    public final Boolean getUltimateAvailableTest() {
        return ultimateAvailableTest;
    }

    public final void setUltimateAvailableTest(@Nullable Boolean bl) {
        ultimateAvailableTest = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAIAssistantChatSnippet(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof LightVirtualFile)) return false;
        String string = ((LightVirtualFile)file).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)AI_ASSISTANT_SNIPPET_FILE_BASE_NAME, (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAIAssistantInputFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof LightVirtualFile)) return false;
        String string = ((LightVirtualFile)file).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)AI_ASSISTANT_INPUT_FILE_NAME_PREFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isAIAssistantFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.isAIAssistantChatSnippet(file) || this.isAIAssistantInputFile(file);
    }

    public final boolean isAIAssistantTurnOnOffApplicable() {
        AiaActivation activation2 = AiaActivationManager.Companion.currentActivation();
        return activation2 instanceof AiProJbaActivation && Outcome.isComplete-impl((Object)((AiProJbaActivation)activation2).getOutcome-X8CKn68());
    }

    public final boolean isAIAssistantActivationIncomplete() {
        AiaActivation activation2 = AiaActivationManager.Companion.currentActivation();
        return Outcome.isIncomplete-impl((Object)activation2.getOutcome-X8CKn68());
    }

    public final void openLlmSettingsDialog(@Nullable Project project) {
        ShowSettingsUtil.getInstance().showSettingsDialog(project, LLMConfigurable.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAssistantActive(@Nullable Project project) {
        if (!this.isAuthedAndAllowed(project)) return false;
        if ((Boolean)QuotaManager2.Companion.getInstance().getHasEnoughQuota().getValue() == false) return false;
        if (ErrorManager.Companion.getInstance().isAssistantInErrorState()) return false;
        boolean $i$f$service = false;
        Class<LlmProfileService> serviceClass$iv = LlmProfileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (!((LlmProfileService)object).areRulesAndProfilesLoaded()) return false;
        return true;
    }

    public final boolean hasAvailableLlmProfileId(@NotNull LLMPromptID promptId) {
        Intrinsics.checkNotNullParameter((Object)promptId, (String)"promptId");
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return true;
        }
        boolean $i$f$service = false;
        Class<LlmProfileService> serviceClass$iv = LlmProfileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((LlmProfileService)object).getLlmProfileIdIfLoaded(promptId) != null;
    }

    public final boolean hasAvailableChatProfileId() {
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return true;
        }
        boolean $i$f$service = false;
        Class<LlmProfileService> serviceClass$iv = LlmProfileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((LlmProfileService)object).getChatLlmProfileIdIfLoaded() != null;
    }

    public final boolean isUltimateAvailable() {
        Boolean bl = ultimateAvailableTest;
        return bl != null ? bl : !UtilsKt.isChinaRegion();
    }

    @NotNull
    public final StateFlow<Boolean> getAssistantActiveState(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AIAssistantAllowedLevelService> serviceClass$iv = AIAssistantAllowedLevelService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return FlowKt.stateIn((Flow)FlowKt.combine((Flow)((Flow)GrazieAuthFacade.Companion.getInstance().getAuthState()), (Flow)((Flow)((AIAssistantAllowedLevelService)object).getLevel()), (Flow)((Flow)QuotaManager2.Companion.getInstance().getQuotaInfo()), (Flow)((Flow)ErrorManager.Companion.getInstance().getErrorState()), (Function5)((Function5)new Function5<GrazieAuthState, AIAssistantKillSwitch.Level, QuotaInfo, ErrorState, Continuation<? super Boolean>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            /* synthetic */ Object L$2;
            /* synthetic */ Object L$3;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                GrazieAuthState grazieAuthState = (GrazieAuthState)this.L$0;
                AIAssistantKillSwitch.Level level = (AIAssistantKillSwitch.Level)((Object)this.L$1);
                QuotaInfo quotaInfo = (QuotaInfo)this.L$2;
                ErrorState errorState = (ErrorState)((Object)this.L$3);
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void errorState2;
                        void quotaState;
                        void allowState;
                        void authState;
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxBoolean((authState instanceof GrazieAuthState.Authenticated && allowState == AIAssistantKillSwitch.Level.Allowed && quotaState instanceof QuotaInfo.Available && errorState2 == ErrorState.None ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(GrazieAuthState p1, AIAssistantKillSwitch.Level p2, QuotaInfo p3, ErrorState p4, Continuation<? super Boolean> p5) {
                var var6_6 = new /* invalid duplicate definition of identical inner class */;
                var6_6.L$0 = p1;
                var6_6.L$1 = p2;
                var6_6.L$2 = p3;
                var6_6.L$3 = p4;
                return var6_6.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)cs, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)false);
    }

    public final boolean isActiveButMaybeOutOfPrompts(@Nullable Project project) {
        return this.isAuthedAndAllowed(project);
    }

    @NotNull
    public final Panel trialRemainedPanel(@NotNull Panel $this$trialRemainedPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$trialRemainedPanel, (String)"<this>");
        RemainedQuotasInfo quotasInfo = this.getRemainedTariffQuotasPercent();
        return $this$trialRemainedPanel.panel(arg_0 -> AIAssistantUIUtil.trialRemainedPanel$lambda$4(quotasInfo, arg_0));
    }

    public final int getEndsInQuotaDays() {
        return this.getQuotaTimeDisplayData().getEndsInHours() / 24;
    }

    @NotNull
    public final RemainedQuotasInfo getRemainedTariffQuotasPercent() {
        return this.getRemainedTariffQuotasPercent((QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue());
    }

    @NotNull
    public final RemainedQuotasInfo getRemainedTariffQuotasPercent(@Nullable QuotaInfo.SuccessfulQuotaInfo quota) {
        QuotaTimeDisplayData quotaTimeDisplayData = this.getQuotaTimeDisplayData();
        int totalEndsInHours = quotaTimeDisplayData.getEndsInHours();
        int endsInDays = totalEndsInHours / 24;
        int endsInHours = totalEndsInHours % 24;
        Double available = null;
        Double maximum = null;
        if (this.isSupportLlm18910() && AIAssistantUIUtilKt.getLicenseType() != LicenseType.ENTERPRISE) {
            Double d;
            var8_8 = quota;
            if (var8_8 instanceof QuotaInfo.Available) {
                Object object = ((QuotaInfo.Available)quota).getTariffQuota();
                d = object != null && (object = ((QuotaInfo.QuotaDetails)object).getAvailable()) != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
            } else if (var8_8 instanceof QuotaInfo.Reached) {
                d = 0.0;
            } else {
                if (var8_8 == null) {
                    return new RemainedQuotasInfo(0, 0, 100);
                }
                throw new NoWhenBranchMatchedException();
            }
            available = d;
            Object object = quota.getTariffQuota();
            maximum = object != null && (object = ((QuotaInfo.QuotaDetails)object).getMaximum()) != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
        } else {
            double d;
            var8_8 = quota;
            if (var8_8 instanceof QuotaInfo.Available) {
                d = Math.max(0.0, ((QuotaInfo.Available)quota).getMaximum().doubleValue() - ((QuotaInfo.Available)quota).getCurrent().doubleValue());
            } else if (var8_8 instanceof QuotaInfo.Reached) {
                d = 0.0;
            } else {
                if (var8_8 == null) {
                    return new RemainedQuotasInfo(0, 0, 100);
                }
                throw new NoWhenBranchMatchedException();
            }
            available = d;
            maximum = quota.getMaximum().doubleValue();
        }
        if (available == null || maximum == null || Intrinsics.areEqual((Double)maximum, (double)0.0)) {
            return new RemainedQuotasInfo(endsInDays, endsInHours, 0);
        }
        int remainedPercents = (int)Math.ceil((double)100 * available / maximum);
        return new RemainedQuotasInfo(endsInDays, endsInHours, remainedPercents);
    }

    @Nullable
    public final Integer getLicenseEndsInDays() {
        AiaActivation aiaActivation = AiaActivationManager.Companion.currentActivation();
        AiProJbaActivation aiProJbaActivation = aiaActivation instanceof AiProJbaActivation ? (AiProJbaActivation)aiaActivation : null;
        if (aiProJbaActivation == null || (aiProJbaActivation = aiProJbaActivation.getActiveLicense()) == null) {
            return null;
        }
        AiProJbaActivation activeLicense = aiProJbaActivation;
        Integer n = this.getRemainedHours(activeLicense.getExpiresOn().plus-LRDsOJo(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS)));
        if (n == null) {
            return 0;
        }
        int remainedHours = n;
        return remainedHours / 24 + 1;
    }

    public final void setAIEnabled(@NotNull Project project, boolean turnedOn) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LLMProjectSettingsManager.Companion.getInstance(project).setTurnedOn(turnedOn);
        LLMProjectSettingsManager.Companion.fireSettingsChanged(project);
    }

    public final void showLicensePickerView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AiaScreenManager> serviceClass$iv = AiaScreenManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        AiaScreenManager screenManager = (AiaScreenManager)object;
        screenManager.navigateTo(AiaNavDestination.AiaNavAipLicensePicker);
    }

    @NotNull
    public final String getRefillInDays(@Nullable Instant quotaRefill2) {
        if (quotaRefill2 == null) {
            log.info("quotaRefill is null");
            return LLMBundle.message("panel.chat.out.of.prompts.unknown", new Object[0]);
        }
        long remainedDays = Duration.getInWholeDays-impl((long)quotaRefill2.minus-5sfh64U(Clock.System.INSTANCE.now()));
        return String.valueOf(Math.max(0L, remainedDays));
    }

    @NotNull
    public final String quotaToCreditString(@Nullable BigDecimal quota) {
        String string;
        BigDecimal bigDecimal = quota;
        if (bigDecimal == null) {
            string = "-";
        } else if (Intrinsics.areEqual((Object)bigDecimal, (Object)BigDecimal.ZERO)) {
            string = "0";
        } else {
            BigDecimal bigDecimal2 = quota.multiply(new BigDecimal(100));
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"multiply(...)");
            BigDecimal bigDecimal3 = bigDecimal2;
            BigDecimal bigDecimal4 = bigDecimal3.divide(new BigDecimal(100000), RoundingMode.HALF_EVEN);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"divide(...)");
            BigDecimal credits = bigDecimal4;
            String result2 = creditsFormatter.format(credits.movePointLeft(2));
            if (Intrinsics.areEqual((Object)result2, (Object)"0.00")) {
                string = "0.01";
            } else {
                Intrinsics.checkNotNull((Object)result2);
                string = result2;
            }
        }
        return string;
    }

    @NotNull
    public final Icon getScaledAIAssistantIcon(float scaleFactor) {
        return IconUtil.scale((Icon)AIAssistantBranding.Logo16Colored, null, (float)JBUIScale.scale((float)(scaleFactor / (float)AIAssistantBranding.Logo16Colored.getIconWidth())));
    }

    @NotNull
    public final Icon getMessageDialogIcon(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return IconUtil.scale((Icon)AIAssistantBranding.Logo16Colored, (Component)component, (float)JBUIScale.scale((float)(28.0f / (float)AIAssistantBranding.Logo16Colored.getIconWidth())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAuthedAndAllowed(@Nullable Project project) {
        if (!(GrazieAuthFacade.Companion.getInstance().getAuthState().getValue() instanceof GrazieAuthState.Authenticated)) return false;
        if (project == null) return false;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AIAssistantAllowedLevelService> serviceClass$iv = AIAssistantAllowedLevelService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (((AIAssistantAllowedLevelService)object).getLevel().getValue() != AIAssistantKillSwitch.Level.Allowed) return false;
        return true;
    }

    public final int getToolwindowScaledFontSize() {
        boolean $i$f$service = false;
        Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return MathKt.roundToInt((float)(JBFont.label().getSize2D() * ((LLMSettingsManager)object).getToolwindowFontScale()));
    }

    @NotNull
    public final String getSendingRequestBackgroundTitle() {
        return !LlmLocalModeManager.Companion.isLocalMode() ? LLMBundle.message("sending.request.background.process.title", new Object[0]) : LLMBundle.message("sending.local.request.background.process.title", new Object[0]);
    }

    @ApiStatus.Internal
    @NotNull
    public final NotificationUI getNotificationUI(@NotNull Project project, @NotNull AIHubNotificationManager.Notification notification) {
        QuotaAvailableInfo quotaAvailableInfo;
        QuotaInfo.SuccessfulQuotaInfo quota;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)notification), (String)"notification");
        CoroutineScope scope = AIAssistantServiceScope.Companion.getScope(project);
        EditorNotificationPanel.Status status = AIHubNotificationManagerKt.isWarning(notification) ? EditorNotificationPanel.Status.Warning : EditorNotificationPanel.Status.Info;
        Runnable landingPlansAugmented2 = () -> AIAssistantUIUtil.getNotificationUI$lambda$5(scope);
        NotificationUI.Action upgradeNow = new NotificationUI.Action(NotificationUI.ActionType.UPGRADE_NOW, landingPlansAugmented2);
        NotificationUI.Action renewNow = new NotificationUI.Action(NotificationUI.ActionType.RENEW_NOW, landingPlansAugmented2);
        NotificationUI.Action upgradeToUltimate = new NotificationUI.Action(NotificationUI.ActionType.UPGRADE_TO_ULTIMATE, landingPlansAugmented2);
        NotificationUI.Action topUpCredits = new NotificationUI.Action(NotificationUI.ActionType.TOP_UP_CREDITS, AIAssistantUIUtil::getNotificationUI$lambda$6);
        QuotaInfo.SuccessfulQuotaInfo successfulQuotaInfo = quota = (QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue();
        QuotaAvailableInfo quotaAvailableInfo2 = quotaAvailableInfo = successfulQuotaInfo != null ? AIAssistantUIUtilKt.getQuotaAvailableInfo(successfulQuotaInfo) : null;
        String topUpQuotaAvailable = this.quotaToCreditString(quotaAvailableInfo2 != null ? quotaAvailableInfo2.getTopUpQuotaAvailable() : null);
        RemainedQuotasInfo quotasInfo = this.getRemainedTariffQuotasPercent(quota);
        int refillInDays = quotasInfo.getEndsInDays() + MathKt.getSign((int)quotasInfo.getEndsInHours());
        return switch (WhenMappings.$EnumSwitchMapping$0[notification.ordinal()]) {
            case 1 -> {
                Object[] var15_15 = new Object[]{this.getLicenseEndsInDaysAndLog()};
                NotificationUI v2 = new NotificationUI(LLMBundle.message("ai.hub.notification.pro.trial.expiring", var15_15), status, CollectionsKt.listOf((Object)upgradeNow), null, 8, null);
                yield v2;
            }
            case 2 -> {
                Object[] var15_16 = new Object[]{this.getLicenseEndsInDaysAndLog()};
                NotificationUI v4 = new NotificationUI(LLMBundle.message("ai.hub.notification.pro.expiring", var15_16), status, CollectionsKt.listOf((Object)renewNow), null, 8, null);
                yield v4;
            }
            case 3 -> {
                Object[] var15_17 = new Object[]{this.getLicenseEndsInDaysAndLog()};
                NotificationUI v5 = new NotificationUI(LLMBundle.message("ai.hub.notification.business.trial.expiring", var15_17), status, CollectionsKt.listOf((Object)upgradeNow), null, 8, null);
                yield v5;
            }
            case 4 -> {
                Object[] var15_18 = new Object[]{this.getLicenseEndsInDaysAndLog()};
                NotificationUI v6 = new NotificationUI(LLMBundle.message("ai.hub.notification.business.expiring", var15_18), status, CollectionsKt.listOf((Object)renewNow), null, 8, null);
                yield v6;
            }
            case 5, 6 -> {
                String title = notification == AIHubNotificationManager.Notification.FREE_ENABLED ? LLMBundle.message("ai.hub.notification.free.enabled.title", new Object[0]) : LLMBundle.message("ai.hub.notification.license.expired.and.free.enabled.title", new Object[0]);
                yield new NotificationUI(title + LLMBundle.message("ai.hub.notification.free.enabled.message", new Object[0]), status, CollectionsKt.listOf((Object)upgradeNow), null, 8, null);
            }
            case 7 -> {
                Object[] var16_33 = new Object[]{topUpQuotaAvailable};
                String comment = LLMBundle.message("ai.hub.notification.subscription.expired.top.up.switched.free", var16_33);
                var16_33 = new Object[]{comment};
                NotificationUI v7 = new NotificationUI(LLMBundle.message("ai.hub.notification.subscription.expired", var16_33), status, CollectionsKt.listOf((Object)renewNow), null, 8, null);
                yield v7;
            }
            case 8, 9 -> new NotificationUI(LLMBundle.message("ai.hub.notification.trial.expired", new Object[0]), status, CollectionsKt.listOf((Object)upgradeNow), null, 8, null);
            case 10 -> new NotificationUI(LLMBundle.message("ai.hub.notification.pro.expired", new Object[0]), status, CollectionsKt.listOf((Object)renewNow), null, 8, null);
            case 11, 12 -> {
                Object[] var16_34 = new Object[]{topUpQuotaAvailable};
                String comment = LLMBundle.message("ai.hub.notification.subscription.expired.top.up", var16_34);
                var16_34 = new Object[]{comment};
                NotificationUI v8 = new NotificationUI(LLMBundle.message("ai.hub.notification.subscription.expired", var16_34), status, CollectionsKt.listOf((Object)renewNow), null, 8, null);
                yield v8;
            }
            case 13 -> new NotificationUI(LLMBundle.message("ai.hub.notification.business.expired", new Object[0]), status, CollectionsKt.listOf((Object)renewNow), null, 8, null);
            case 14 -> new NotificationUI(LLMBundle.message("ai.hub.notification.free.quota.exceeded", new Object[0]), status, CollectionsKt.listOf((Object)upgradeNow), null, 8, null);
            case 15 -> {
                Object[] var15_22 = new Object[]{this.getQuotaExceedComment(refillInDays)};
                String v9 = LLMBundle.message("ai.hub.notification.business.quota.exceeded", var15_22);
                var15_22 = new NotificationUI.Action[]{upgradeToUltimate};
                NotificationUI v10 = new NotificationUI(v9, status, this.getAvailableActions((NotificationUI.Action[])var15_22), null, 8, null);
                yield v10;
            }
            case 16 -> {
                Object[] var15_23 = new Object[]{this.getQuotaExceedComment(refillInDays)};
                String v11 = LLMBundle.message("ai.hub.notification.business.trial.quota.exceeded", var15_23);
                var15_23 = new NotificationUI.Action[]{upgradeToUltimate};
                NotificationUI v12 = new NotificationUI(v11, status, this.getAvailableActions((NotificationUI.Action[])var15_23), null, 8, null);
                yield v12;
            }
            case 17 -> {
                if (this.isSupportLlm18911()) {
                    Object[] var15_24 = new Object[]{LLMBundle.message("ai.hub.notification.quota.exceeded.upgrade.to.ultimate.or.top.up", new Object[0])};
                    String v13 = LLMBundle.message("ai.hub.notification.pro.quota.exceeded.monthly", var15_24);
                    var15_24 = new NotificationUI.Action[]{upgradeToUltimate, topUpCredits};
                    NotificationUI v14 = new NotificationUI(v13, status, this.getAvailableActions((NotificationUI.Action[])var15_24), null, 8, null);
                    yield v14;
                }
                Object[] var15_25 = new Object[]{this.getQuotaExceedComment(refillInDays)};
                String v15 = LLMBundle.message("ai.hub.notification.pro.quota.exceeded", var15_25);
                var15_25 = new NotificationUI.Action[]{upgradeToUltimate};
                NotificationUI v16 = new NotificationUI(v15, status, this.getAvailableActions((NotificationUI.Action[])var15_25), null, 8, null);
                yield v16;
            }
            case 18, 19 -> {
                NotificationUI.Action[] var15_26 = new NotificationUI.Action[]{topUpCredits};
                NotificationUI v17 = new NotificationUI(LLMBundle.message("ai.hub.notification.pro.quota.exceeded.top.up", new Object[0]), status, this.getAvailableActions(var15_26), null, 8, null);
                yield v17;
            }
            case 20 -> {
                Object[] var15_27 = new Object[]{this.getQuotaExceedComment(refillInDays)};
                String v18 = LLMBundle.message("ai.hub.notification.pro.trial.quota.exceeded", var15_27);
                var15_27 = new NotificationUI.Action[]{upgradeToUltimate};
                NotificationUI v19 = new NotificationUI(v18, status, this.getAvailableActions((NotificationUI.Action[])var15_27), null, 8, null);
                yield v19;
            }
            case 21 -> {
                if (this.isSupportLlm18911()) {
                    NotificationUI.Action[] var15_28 = new NotificationUI.Action[]{topUpCredits};
                    NotificationUI v20 = new NotificationUI(LLMBundle.message("ai.hub.notification.ultimate.quota.exceeded.top.up", new Object[0]), status, this.getAvailableActions(var15_28), null, 8, null);
                    yield v20;
                }
                Object[] var15_29 = new Object[1];
                Object[] var16_35 = new Object[]{refillInDays};
                var15_29[0] = LLMBundle.message("ai.hub.notification.quota.exceeded.contact.support", var16_35);
                NotificationUI v21 = new NotificationUI(LLMBundle.message("ai.hub.notification.ultimate.quota.exceeded", var15_29), status, CollectionsKt.emptyList(), null, 8, null);
                yield v21;
            }
            case 22 -> {
                Object[] var15_30 = new Object[1];
                Object[] var16_36 = new Object[]{refillInDays};
                var15_30[0] = LLMBundle.message("ai.hub.notification.quota.exceeded.contact.support", var16_36);
                NotificationUI v22 = new NotificationUI(LLMBundle.message("ai.hub.notification.enterprise.quota.exceeded", var15_30), status, CollectionsKt.emptyList(), null, 8, null);
                yield v22;
            }
            case 23 -> new NotificationUI(LLMBundle.message("ai.hub.notification.third.party.providers.blocked", new Object[0]), status, CollectionsKt.emptyList(), null, 8, null);
            case 24 -> {
                Object[] var15_31 = new NotificationUI.Action[]{new NotificationUI.Action(NotificationUI.ActionType.LOCAL_MODELS_SETUP, () -> AIAssistantUIUtil.getNotificationUI$lambda$7(project)), new NotificationUI.Action(NotificationUI.ActionType.LOCAL_MODELS_TURN_OFF, AIAssistantUIUtil::getNotificationUI$lambda$8)};
                NotificationUI v23 = new NotificationUI(LLMBundle.message("ai.hub.notification.no.local.models", new Object[0]), status, CollectionsKt.listOf((Object[])var15_31), null, 8, null);
                yield v23;
            }
            case 25 -> new NotificationUI(LLMBundle.message("ai.hub.notification.update.available", new Object[0]), status, CollectionsKt.listOf((Object)new NotificationUI.Action(NotificationUI.ActionType.UPDATE, () -> AIAssistantUIUtil.getNotificationUI$lambda$9(project))), null, 8, null);
            case 26 -> {
                Object[] var15_32 = new Object[]{85};
                NotificationUI v24 = new NotificationUI(LLMBundle.message("ai.hub.notification.quota.expiring", var15_32), status, CollectionsKt.emptyList(), null, 8, null);
                yield v24;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @ApiStatus.Internal
    @Nullable
    public final QuotaTimeData getQuotaTimeData() {
        QuotaInfo.SuccessfulQuotaInfo quota = (QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue();
        QuotaRefillInfo.Known refill = (QuotaRefillInfo.Known)QuotaManager2.Companion.getInstance().getLastAvailableNextRefill().getValue();
        QuotaRefillInfo.Known known = refill;
        if (known != null && (known = known.getNext()) != null) {
            QuotaRefillInfo.Known it = known;
            boolean bl = false;
            log.info("returning next refill " + (Instant)it);
            return new QuotaRefillData(refill.getNext());
        }
        QuotaInfo.SuccessfulQuotaInfo successfulQuotaInfo = quota;
        if (successfulQuotaInfo != null && (successfulQuotaInfo = successfulQuotaInfo.getUntil()) != null) {
            QuotaInfo.SuccessfulQuotaInfo it = successfulQuotaInfo;
            boolean bl = false;
            log.info("returning quota " + (Instant)it + ", because refill: " + refill);
            return new QuotaExpiryData((Instant)it);
        }
        log.warn("quota and refill values are returned as null by platform, refill: " + refill + ", quota: " + quota);
        return null;
    }

    @Nls
    @NotNull
    public final String formatQuotaInfoLabel(@Nullable QuotaTimeData quotaTimeData) {
        String string;
        if (quotaTimeData == null) {
            return LLMBundle.message("ai.hub.quota.info.not.available", new Object[0]);
        }
        String endsInQuotaString = DateTimeFormatter.ofPattern("MMMM, d", LocalizationUtil.getLocale$default((LocalizationUtil)LocalizationUtil.INSTANCE, (boolean)false, (int)1, null)).format(ConvertersKt.toJavaInstant((Instant)quotaTimeData.getEndsIn()).atZone(ZoneId.systemDefault()));
        QuotaTimeData quotaTimeData2 = quotaTimeData;
        if (quotaTimeData2 instanceof QuotaRefillData) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)endsInQuotaString);
            objectArray[0] = endsInQuotaString;
            string = LLMBundle.message("ai.hub.quota.renew", objectArray);
        } else if (quotaTimeData2 instanceof QuotaExpiryData) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)endsInQuotaString);
            objectArray[0] = endsInQuotaString;
            string = LLMBundle.message("ai.hub.quota.expires", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String getQuotaExceedComment(int refillInDays) {
        String string;
        if (this.isUltimateAvailable()) {
            string = LLMBundle.message("ai.hub.notification.quota.exceeded.upgrade.to.ultimate", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{refillInDays};
            string = LLMBundle.message("ai.hub.notification.quota.exceeded.contact.support", objectArray);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<NotificationUI.Action> getAvailableActions(NotificationUI.Action ... actions) {
        void $this$filterTo$iv$iv;
        boolean isUltimateAvailable = this.isUltimateAvailable();
        NotificationUI.Action[] $this$filter$iv = actions;
        boolean $i$f$filter = false;
        NotificationUI.Action[] actionArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$1[it.getType().ordinal()]) {
                case 1: {
                    bl = isUltimateAvailable;
                    break;
                }
                case 2: {
                    bl = INSTANCE.isSupportLlm18910();
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final int getLicenseEndsInDaysAndLog() {
        int n;
        Integer n2 = this.getLicenseEndsInDays();
        if (n2 != null) {
            n = n2;
        } else {
            AIAssistantUIUtil it = this;
            boolean bl = false;
            log.info("getLicenseEndsInDays is null");
            n = 0;
        }
        return n;
    }

    private final Integer getRemainedHours(Instant instant) {
        long delta = instant.minus-5sfh64U(Clock.System.INSTANCE.now());
        return Duration.isNegative-impl((long)delta) ? null : Integer.valueOf((int)Duration.getInWholeHours-impl((long)delta));
    }

    @Nullable
    public final LicenseType getTestLicenseType$intellij_ml_llm_core() {
        return testLicenseType;
    }

    public final void setTestLicenseType$intellij_ml_llm_core(@Nullable LicenseType licenseType) {
        testLicenseType = licenseType;
    }

    @Nullable
    public final Boolean getTestLicensePersonal$intellij_ml_llm_core() {
        return testLicensePersonal;
    }

    public final void setTestLicensePersonal$intellij_ml_llm_core(@Nullable Boolean bl) {
        testLicensePersonal = bl;
    }

    private final QuotaTimeDisplayData getQuotaTimeDisplayData() {
        QuotaTimeDisplayData quotaTimeDisplayData;
        QuotaTimeData quotaTimeData = this.getQuotaTimeData();
        if (quotaTimeData == null) {
            UnknownQuotaTimeData unknownQuotaTimeData;
            UnknownQuotaTimeData it = unknownQuotaTimeData = new UnknownQuotaTimeData();
            boolean bl = false;
            log.warn("getQuotaUiLabelData returning unknown");
            return unknownQuotaTimeData;
        }
        QuotaTimeData labelData = quotaTimeData;
        Integer n = this.getRemainedHours(labelData.getEndsIn());
        if (n == null) {
            UnknownQuotaTimeData unknownQuotaTimeData;
            UnknownQuotaTimeData it = unknownQuotaTimeData = new UnknownQuotaTimeData();
            boolean bl = false;
            log.warn("getQuotaUiLabelData returning unknown");
            return unknownQuotaTimeData;
        }
        int remainedHours = n;
        int endsIn = remainedHours + 1;
        QuotaTimeData quotaTimeData2 = labelData;
        if (quotaTimeData2 instanceof QuotaRefillData) {
            RefillTimeDisplayData refillTimeDisplayData;
            RefillTimeDisplayData it = refillTimeDisplayData = new RefillTimeDisplayData(endsIn);
            boolean bl = false;
            log.info("getQuotaUiLabelData returning refill");
            quotaTimeDisplayData = refillTimeDisplayData;
        } else if (quotaTimeData2 instanceof QuotaExpiryData) {
            ExpiryTimeDisplayData expiryTimeDisplayData;
            ExpiryTimeDisplayData it = expiryTimeDisplayData = new ExpiryTimeDisplayData(endsIn);
            boolean bl = false;
            log.info("getQuotaUiLabelData returning quota");
            quotaTimeDisplayData = expiryTimeDisplayData;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return quotaTimeDisplayData;
    }

    public final boolean isSupportLlm18910() {
        return Registry.Companion.is("llm.support.llm.18910", false);
    }

    public final boolean isSupportLlm18911() {
        return this.isSupportLlm18910() && Registry.Companion.is("llm.support.llm.18911", false);
    }

    private static final Unit trialRemainedPanel$lambda$4$lambda$0(RemainedQuotasInfo $quotasInfo, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$quotasInfo.getRemainedPercents()};
        $this$row.label(LLMBundle.message("statusbar.balloon.trial.tokensLeft", objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit trialRemainedPanel$lambda$4$lambda$2$lambda$1(RemainedQuotasInfo $quotasInfo, JProgressBar $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setValue($quotasInfo.getRemainedPercents());
        $this$applyToComponent.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, new VerticalComponentGap(Boolean.valueOf(false), Boolean.valueOf(false)));
        return Unit.INSTANCE;
    }

    private static final Unit trialRemainedPanel$lambda$4$lambda$2(RemainedQuotasInfo $quotasInfo, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)new JProgressBar(0, 100)).align((Align)AlignX.FILL.INSTANCE).applyToComponent(arg_0 -> AIAssistantUIUtil.trialRemainedPanel$lambda$4$lambda$2$lambda$1($quotasInfo, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit trialRemainedPanel$lambda$4$lambda$3(RemainedQuotasInfo $quotasInfo, Row $this$row) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if ($quotasInfo.getEndsInDays() == 1 && $quotasInfo.getEndsInHours() == 0) {
            var3_2 = new Object[]{24};
            string = LLMBundle.message("statusbar.balloon.trial.endsInHours", var3_2);
        } else if ($quotasInfo.getEndsInDays() > 0) {
            var3_2 = new Object[]{$quotasInfo.getEndsInDays() + MathKt.getSign((int)$quotasInfo.getEndsInHours())};
            string = LLMBundle.message("statusbar.balloon.trial.endsInDays", var3_2);
        } else if ($quotasInfo.getEndsInHours() == 1) {
            string = LLMBundle.message("statusbar.balloon.trial.endsInOneHour", new Object[0]);
        } else {
            var3_2 = new Object[]{$quotasInfo.getEndsInHours()};
            string = LLMBundle.message("statusbar.balloon.trial.endsInHours", var3_2);
        }
        String message = string;
        Row.comment$default((Row)$this$row, (String)message, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit trialRemainedPanel$lambda$4(RemainedQuotasInfo $quotasInfo, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AIAssistantUIUtil.trialRemainedPanel$lambda$4$lambda$0($quotasInfo, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AIAssistantUIUtil.trialRemainedPanel$lambda$4$lambda$2($quotasInfo, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AIAssistantUIUtil.trialRemainedPanel$lambda$4$lambda$3($quotasInfo, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void getNotificationUI$lambda$5(CoroutineScope $scope) {
        BuildersKt.launch$default((CoroutineScope)$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = AiPluginConstants.INSTANCE.getRegionalLandingUrl((Continuation<? super String>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        BrowserUtil.open((String)((String)v0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void getNotificationUI$lambda$6() {
        BrowserUtil.browse((String)ADD_PERSONAL_TOP_UP_CREDITS_HREF);
    }

    private static final void getNotificationUI$lambda$7(Project $project) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, LLMThirdPartyAiProvidersConfigurable.class);
    }

    private static final void getNotificationUI$lambda$8() {
        boolean $i$f$service = false;
        Class<LlmCustomModelsSettingsManager> serviceClass$iv = LlmCustomModelsSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((LlmCustomModelsSettingsManager)object).setLocalModeEnabled(false);
        AIHubNotificationManager.Companion.getInstance().markGotIt(SetsKt.setOf((Object)((Object)AIHubNotificationManager.Notification.NO_LOCAL_MODELS)));
    }

    private static final void getNotificationUI$lambda$9(Project $project) {
        AIAssistantUpdateChecker.Companion.getInstance().showUpdateDialog($project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AIAssistantUIUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        creditsFormatter = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AIHubNotificationManager.Notification.values().length];
            try {
                nArray[AIHubNotificationManager.Notification.PRO_TRIAL_EXPIRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_EXPIRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_TRIAL_EXPIRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_EXPIRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.FREE_ENABLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.LICENSE_EXPIRED_AND_FREE_ENABLED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.LICENSE_EXPIRED_AND_TOP_UP_REMAINED_AND_FREE_ENABLED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_TRIAL_EXPIRED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_TRIAL_EXPIRED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_EXPIRED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_EXPIRED_AND_TOP_UP_REMAINED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_EXPIRED_AND_TOP_UP_REMAINED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_EXPIRED.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.FREE_QUOTA_EXCEEDED.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_QUOTA_EXCEEDED.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_TRIAL_QUOTA_EXCEEDED.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_QUOTA_EXCEEDED.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_TOP_UP_QUOTA_EXCEEDED.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.ULTIMATE_TOP_UP_QUOTA_EXCEEDED.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_TRIAL_QUOTA_EXCEEDED.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.ULTIMATE_QUOTA_EXCEEDED.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.ENTERPRISE_QUOTA_EXCEEDED.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.THIRD_PARTY_PROVIDERS_BLOCKED.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.NO_LOCAL_MODELS.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.UPDATE_AVAILABLE.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.QUOTA_ALMOST_REACHED.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[NotificationUI.ActionType.values().length];
            try {
                nArray[NotificationUI.ActionType.UPGRADE_TO_ULTIMATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.TOP_UP_CREDITS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

