/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptLibrary;

import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.promptLibrary.AIAssistantPromptLibraryStorage;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariable;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariablesResolver;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010BT\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000b\u0010\u001e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u001fJ\b\u0010 \u001a\u00020!H\u0007J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010#\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\t\u0010(\u001a\u00020\tH\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003J\t\u0010*\u001a\u00020\u000fH\u00c6\u0003Jh\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\u000fH\u00d6\u0001J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00061"}, d2={"Lcom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPrompt;", "", "id", "", "name", "Lorg/jetbrains/annotations/Nls;", "content", "Lcom/intellij/ml/llm/privacy/PSString;", "waitForInput", "", "showInPopup", "showInInput", "hasCustomTitle", "isBuiltIn", "priority", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/privacy/PSString;ZZZZZI)V", "getId", "()Ljava/lang/String;", "getName", "getContent", "()Lcom/intellij/ml/llm/privacy/PSString;", "getWaitForInput", "()Z", "getShowInPopup", "getShowInInput", "getHasCustomTitle", "getPriority", "()I", "getFormattedName", "Lcom/intellij/openapi/util/NlsSafe;", "getStatId", "Lcom/intellij/ml/llm/core/chat/session/ChatSourceAction;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "Companion", "intellij.ml.llm.core"})
public final class AIChatLibraryPrompt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final PSString content;
    private final boolean waitForInput;
    private final boolean showInPopup;
    private final boolean showInInput;
    private final boolean hasCustomTitle;
    private final boolean isBuiltIn;
    private final int priority;
    public static final int MAX_PRIORITY = 100500;

    public AIChatLibraryPrompt(@NotNull String id, @NotNull String name, @NotNull PSString content2, boolean waitForInput, boolean showInPopup, boolean showInInput, boolean hasCustomTitle, boolean isBuiltIn, int priority) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.id = id;
        this.name = name;
        this.content = content2;
        this.waitForInput = waitForInput;
        this.showInPopup = showInPopup;
        this.showInInput = showInInput;
        this.hasCustomTitle = hasCustomTitle;
        this.isBuiltIn = isBuiltIn;
        this.priority = priority;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final PSString getContent() {
        return this.content;
    }

    public final boolean getWaitForInput() {
        return this.waitForInput;
    }

    public final boolean getShowInPopup() {
        return this.showInPopup;
    }

    public final boolean getShowInInput() {
        return this.showInInput;
    }

    public final boolean getHasCustomTitle() {
        return this.hasCustomTitle;
    }

    public final boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final String getFormattedName() {
        String string = StringUtil.first((String)this.name, (int)30, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"first(...)");
        return StringsKt.replace$default((String)string, (String)"_", (String)"__", (boolean)false, (int)4, null);
    }

    @ApiStatus.Internal
    @NotNull
    public final ChatSourceAction getStatId() {
        String string = this.id;
        return Intrinsics.areEqual((Object)string, (Object)AIAssistantPromptLibraryStorage.Companion.getFIND_PROBLEMS_ID()) ? ChatSourceAction.FIND_PROBLEMS_INTENTION : (Intrinsics.areEqual((Object)string, (Object)AIAssistantPromptLibraryStorage.Companion.getNEW_CHAT_ID()) ? ChatSourceAction.CUSTOM_CHAT : ChatSourceAction.PROMPT_LIBRARY);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final PSString component3() {
        return this.content;
    }

    public final boolean component4() {
        return this.waitForInput;
    }

    public final boolean component5() {
        return this.showInPopup;
    }

    public final boolean component6() {
        return this.showInInput;
    }

    public final boolean component7() {
        return this.hasCustomTitle;
    }

    public final boolean component8() {
        return this.isBuiltIn;
    }

    public final int component9() {
        return this.priority;
    }

    @NotNull
    public final AIChatLibraryPrompt copy(@NotNull String id, @NotNull String name, @NotNull PSString content2, boolean waitForInput, boolean showInPopup, boolean showInInput, boolean hasCustomTitle, boolean isBuiltIn, int priority) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        return new AIChatLibraryPrompt(id, name, content2, waitForInput, showInPopup, showInInput, hasCustomTitle, isBuiltIn, priority);
    }

    public static /* synthetic */ AIChatLibraryPrompt copy$default(AIChatLibraryPrompt aIChatLibraryPrompt, String string, String string2, PSString pSString, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = aIChatLibraryPrompt.id;
        }
        if ((n2 & 2) != 0) {
            string2 = aIChatLibraryPrompt.name;
        }
        if ((n2 & 4) != 0) {
            pSString = aIChatLibraryPrompt.content;
        }
        if ((n2 & 8) != 0) {
            bl = aIChatLibraryPrompt.waitForInput;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = aIChatLibraryPrompt.showInPopup;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = aIChatLibraryPrompt.showInInput;
        }
        if ((n2 & 0x40) != 0) {
            bl4 = aIChatLibraryPrompt.hasCustomTitle;
        }
        if ((n2 & 0x80) != 0) {
            bl5 = aIChatLibraryPrompt.isBuiltIn;
        }
        if ((n2 & 0x100) != 0) {
            n = aIChatLibraryPrompt.priority;
        }
        return aIChatLibraryPrompt.copy(string, string2, pSString, bl, bl2, bl3, bl4, bl5, n);
    }

    @NotNull
    public String toString() {
        return "AIChatLibraryPrompt(id=" + this.id + ", name=" + this.name + ", content=" + this.content + ", waitForInput=" + this.waitForInput + ", showInPopup=" + this.showInPopup + ", showInInput=" + this.showInInput + ", hasCustomTitle=" + this.hasCustomTitle + ", isBuiltIn=" + this.isBuiltIn + ", priority=" + this.priority + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.content.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.waitForInput);
        result2 = result2 * 31 + Boolean.hashCode(this.showInPopup);
        result2 = result2 * 31 + Boolean.hashCode(this.showInInput);
        result2 = result2 * 31 + Boolean.hashCode(this.hasCustomTitle);
        result2 = result2 * 31 + Boolean.hashCode(this.isBuiltIn);
        result2 = result2 * 31 + Integer.hashCode(this.priority);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AIChatLibraryPrompt)) {
            return false;
        }
        AIChatLibraryPrompt aIChatLibraryPrompt = (AIChatLibraryPrompt)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)aIChatLibraryPrompt.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)aIChatLibraryPrompt.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.content, (Object)aIChatLibraryPrompt.content)) {
            return false;
        }
        if (this.waitForInput != aIChatLibraryPrompt.waitForInput) {
            return false;
        }
        if (this.showInPopup != aIChatLibraryPrompt.showInPopup) {
            return false;
        }
        if (this.showInInput != aIChatLibraryPrompt.showInInput) {
            return false;
        }
        if (this.hasCustomTitle != aIChatLibraryPrompt.hasCustomTitle) {
            return false;
        }
        if (this.isBuiltIn != aIChatLibraryPrompt.isBuiltIn) {
            return false;
        }
        return this.priority == aIChatLibraryPrompt.priority;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0002J\u0013\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPrompt$Companion;", "", "<init>", "()V", "MAX_PRIORITY", "", "getDefaultName", "", "Lorg/jetbrains/annotations/Nls;", "generateNameFromContent", "content", "Lcom/intellij/ml/llm/privacy/PSString;", "empty", "Lcom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPrompt;", "fromContent", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getDefaultName() {
            return LLMBundle.message("promptlibrary.settings.chat.prompt.defaultName", new Object[0]);
        }

        @NotNull
        public final String generateNameFromContent(@NotNull PSString content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (StringsKt.isBlank((CharSequence)((CharSequence)content2))) {
                return this.getDefaultName();
            }
            PSString cropped = content2.take(140).trim();
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"getInstance(...)");
            PSString productName = SharedExtensionsKtKt.getPrivacySafe((ApplicationNamesInfo)applicationNamesInfo).getFullProductName();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)AIAssistantPromptLibraryVariable.PRODUCT), (Object)productName), TuplesKt.to((Object)((Object)AIAssistantPromptLibraryVariable.PRODUCT_NAME), (Object)productName), TuplesKt.to((Object)((Object)AIAssistantPromptLibraryVariable.LANGUAGE), (Object)ConstantsKt.getPrivacyConst((String)"language")), TuplesKt.to((Object)((Object)AIAssistantPromptLibraryVariable.SELECTION_LANG), (Object)ConstantsKt.getPrivacyConst((String)"language")), TuplesKt.to((Object)((Object)AIAssistantPromptLibraryVariable.SELECTION_RAW), (Object)ConstantsKt.getPrivacyConst((String)"selection")), TuplesKt.to((Object)((Object)AIAssistantPromptLibraryVariable.SELECTION), (Object)ConstantsKt.getPrivacyConst((String)"selection"))};
            Map variables = MapsKt.mapOf((Pair[])pairArray);
            return (String)new AIAssistantPromptLibraryVariablesResolver(cropped).resolve(variables).unwrap();
        }

        @NotNull
        public final AIChatLibraryPrompt empty() {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            String string3 = this.getDefaultName();
            PSString pSString = ConstantsKt.getPrivacyConst((String)"");
            return new AIChatLibraryPrompt(string2, string3, pSString, false, true, true, false, false, 0);
        }

        @NotNull
        public final AIChatLibraryPrompt fromContent(@NotNull PSString content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            AIChatLibraryPrompt aIChatLibraryPrompt = this.empty();
            String string = this.generateNameFromContent(content2);
            return AIChatLibraryPrompt.copy$default(aIChatLibraryPrompt, null, string, content2, false, false, false, false, false, 0, 505, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

